/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ExportedPackage;
import com.sygate.scm.common.configobject.schema.AppProtectionRuleSystem;
import com.sygate.scm.common.configobject.schema.AppProtectionSetting;
import com.sygate.scm.common.configobject.schema.EnforcedAppProtectionBlockArray;
import com.sygate.scm.common.configobject.schema.OpAppProtBlockEntity;
import com.sygate.scm.common.configobject.schema.OpAppProtTemplate;
import com.sygate.scm.common.configobject.schema.OpAppProtectionBlock;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.OpTrojanProtection;
import com.sygate.scm.common.configobject.schema.OpTrojanProtectionNotification;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AppProtectionPolicyObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.AdditionalTextDialog;
import com.sygate.scm.console.ui.policy.explorer.osp.OpAppProtectionPolicyHandler;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionTablePopupMenu;
import com.sygate.scm.console.ui.policy.osprotect.dialog.RuleEditorDlg;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpAppProtBlockEntityObject;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpAppProtectionBlockObject;
import com.sygate.scm.console.ui.util.CustomTableModel;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.CheckBoxEditor;
import com.sygate.scm.console.ui.util.renderer.CheckBoxRenderer;
import com.sygate.scm.console.ui.util.renderer.ComboBoxRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class OSProtectionPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -2535000620133985090L;
    private static final String USE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.Use");
    private static final String AVAILABLE_PROTECTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.AvailableProtections");
    private static final String MODE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.Mode");
    private static final float[] COL_SIZE = new float[]{0.1f, 0.65f, 0.25f};
    private JButton jBAdd = new JButton(UIText.get(5));
    private JButton jBEdit = new JButton(UIText.get(1024));
    private JButton jBUp = new JButton(UIText.get(3075));
    private JButton jBTemplate = new JButton(UIText.get(4864));
    private JButton jBDelete = new JButton(UIText.get(769));
    private JButton jBDown = new JButton(UIText.get(3074));
    private JCheckBox jCbxTrojan = new JCheckBox(UIText.get(3842));
    private JCheckBox jCbxNotify = new JCheckBox(UIText.get(3331));
    private JButton jBNotify = new JButton(UIText.get(4616));
    private CustomTableModel tableModel;
    private JTable jTPolicy;
    private AppProtectionPolicyObject opObj;
    private EnforcedAppProtectionBlockArray ospBlockArray;
    private Vector<String> compoundRuleNames = new Vector();
    private String additionalText = "";
    private boolean isReadonly;

    public OSProtectionPanel() {
        this.initialize();
        this.updateButtons();
    }

    public void updatePanel(AppProtectionPolicyObject _opObj) {
        OpTrojanProtection trojan;
        AppProtectionSetting ospSetting;
        this.opObj = _opObj.getClone();
        AppProtectionRuleSystem ospRuleSystem = this.opObj.getOptAppProtectionRuleSystem();
        if (ospRuleSystem != null) {
            this.ospBlockArray = ospRuleSystem.getOptEnforcedAppProtectionBlockArray();
            if (this.ospBlockArray == null) {
                this.ospBlockArray = new EnforcedAppProtectionBlockArray();
            } else {
                for (int i = 0; i < this.ospBlockArray.getOpAppProtBlockEntityCount(); ++i) {
                    OpAppProtBlockEntityObject ospBlockEntityObj = new OpAppProtBlockEntityObject(this.ospBlockArray.getOpAppProtBlockEntity(i));
                    this.tableModel.addRow(ospBlockEntityObj);
                    this.compoundRuleNames.add(ospBlockEntityObj.getName());
                }
            }
        }
        if ((ospSetting = this.opObj.getOptAppProtectionSetting()) == null) {
            ospSetting = new AppProtectionSetting();
            this.opObj.setOptAppProtectionSetting(ospSetting);
        }
        if ((trojan = ospSetting.getOptOpTrojanProtection()) != null) {
            this.jCbxTrojan.setSelected(trojan.getOptEnable());
            OpTrojanProtectionNotification trojanNotify = trojan.getOptOpTrojanProtectionNotification();
            if (trojanNotify != null) {
                this.jCbxNotify.setSelected(trojanNotify.getOptEnable());
                this.additionalText = trojanNotify.getOptAdditionalText();
            } else {
                this.jCbxNotify.setSelected(false);
            }
        } else {
            this.jCbxTrojan.setSelected(false);
            this.jCbxNotify.setSelected(false);
        }
        this.trojanChanged();
    }

    public void save(AppProtectionPolicyObject _opObj) {
        OpTrojanProtectionNotification trojanNotify;
        AppProtectionRuleSystem opRuleSystem = _opObj.getOptAppProtectionRuleSystem();
        if (opRuleSystem == null) {
            opRuleSystem = new AppProtectionRuleSystem();
            _opObj.setOptAppProtectionRuleSystem(opRuleSystem);
        }
        opRuleSystem.setOptEnforcedAppProtectionBlockArray(this.ospBlockArray);
        AppProtectionSetting ospSetting = _opObj.getOptAppProtectionSetting();
        OpTrojanProtection trojan = ospSetting.getOptOpTrojanProtection();
        if (trojan == null) {
            trojan = new OpTrojanProtection();
            ospSetting.setOptOpTrojanProtection(trojan);
        }
        if ((trojanNotify = trojan.getOptOpTrojanProtectionNotification()) == null) {
            trojanNotify = new OpTrojanProtectionNotification();
            trojan.setOptOpTrojanProtectionNotification(trojanNotify);
        }
        trojan.setOptEnable(Boolean.valueOf(this.jCbxTrojan.isSelected()));
        trojanNotify.setOptEnable(Boolean.valueOf(this.jCbxTrojan.isSelected() && this.jCbxNotify.isSelected()));
        trojanNotify.setOptAdditionalText(this.additionalText);
    }

    public void addRule() {
        String title;
        OpAppProtectionBlock ospBlock = OpAppProtectionBlockObject.createOpAppProtectionBlock(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.OSProtection"), this.compoundRuleNames);
        RuleEditorDlg dlg = new RuleEditorDlg(ospBlock, this.compoundRuleNames, title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.title.add.CustomRuleEditor"), false);
        if (dlg.isOk()) {
            OpAppProtBlockEntityObject ospBlockObj = new OpAppProtBlockEntityObject(ospBlock);
            this.tableModel.addRow(ospBlockObj);
            this.compoundRuleNames.add(ospBlock.getName());
            this.ospBlockArray.addOpAppProtBlockEntity(ospBlockObj.getOpAppProtBlockEntity());
        }
        dlg.dispose();
    }

    public void editRule() {
        int selIndex = this.jTPolicy.getSelectedRow();
        if (selIndex == -1) {
            return;
        }
        OpAppProtBlockEntityObject ospBlockEntityObj = (OpAppProtBlockEntityObject)this.tableModel.getRow(selIndex);
        try {
            OpAppProtectionBlock ospBlock = (OpAppProtectionBlock)PolicyHandler.getCopyOfObj((ConfigObject)ospBlockEntityObj.getOpAppProtectionBlock());
            String oldName = ospBlock.getName();
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "RuleEditorDlg.title.edit.CustomRuleEditor");
            RuleEditorDlg dlg = new RuleEditorDlg(ospBlock, this.compoundRuleNames, title, this.isReadonly);
            if (dlg.isOk()) {
                ospBlockEntityObj.setOpAppProtectionBlock(ospBlock);
                this.tableModel.fireTableRowsUpdated(selIndex, selIndex);
                if (!oldName.equalsIgnoreCase(ospBlock.getName())) {
                    this.compoundRuleNames.remove(oldName);
                    this.compoundRuleNames.add(ospBlock.getName());
                }
            }
            dlg.dispose();
        }
        catch (ConsoleException ex) {
            System.err.println("OSProtectionPanel.eidtRule: Can't get Copy of OpAppProtectionBlock");
        }
    }

    public void deleteRule() {
        if (JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.ConfirmDelCompRule"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.title.CompRuleDel"), 0) == 0) {
            int[] selRows = this.jTPolicy.getSelectedRows();
            int i = selRows.length;
            while (--i >= 0) {
                OpAppProtBlockEntityObject ospBlockEntityObj = (OpAppProtBlockEntityObject)this.tableModel.getRow(selRows[i]);
                this.ospBlockArray.removeOpAppProtBlockEntity(ospBlockEntityObj.getOpAppProtBlockEntity());
                this.compoundRuleNames.remove(ospBlockEntityObj.getName());
                this.tableModel.removeRow(selRows[i]);
            }
        }
    }

    public void moveUpRule() {
        int selIndex = this.jTPolicy.getSelectedRow();
        OpAppProtBlockEntityObject curEntityObj = (OpAppProtBlockEntityObject)this.tableModel.getRow(selIndex);
        OpAppProtBlockEntityObject upperEntityObj = (OpAppProtBlockEntityObject)this.tableModel.getRow(selIndex - 1);
        this.ospBlockArray.setOpAppProtBlockEntity(selIndex, upperEntityObj.getOpAppProtBlockEntity());
        this.ospBlockArray.setOpAppProtBlockEntity(selIndex - 1, curEntityObj.getOpAppProtBlockEntity());
        this.tableModel.moveRow(selIndex, selIndex, selIndex - 1);
        this.jTPolicy.getSelectionModel().setSelectionInterval(selIndex - 1, selIndex - 1);
    }

    public void moveDownRule() {
        int selIndex = this.jTPolicy.getSelectedRow();
        OpAppProtBlockEntityObject curEntityObj = (OpAppProtBlockEntityObject)this.tableModel.getRow(selIndex);
        OpAppProtBlockEntityObject lowerEntityObj = (OpAppProtBlockEntityObject)this.tableModel.getRow(selIndex + 1);
        this.ospBlockArray.setOpAppProtBlockEntity(selIndex, lowerEntityObj.getOpAppProtBlockEntity());
        this.ospBlockArray.setOpAppProtBlockEntity(selIndex + 1, curEntityObj.getOpAppProtBlockEntity());
        this.tableModel.moveRow(selIndex, selIndex, selIndex + 1);
        this.jTPolicy.getSelectionModel().setSelectionInterval(selIndex + 1, selIndex + 1);
    }

    public void copyRule() {
        OpAppProtBlockEntityObject ospBlockEntityObj = (OpAppProtBlockEntityObject)this.tableModel.getRow(this.jTPolicy.getSelectedRow());
        PolicyHandler.copyObject(ospBlockEntityObj);
    }

    public void pasteRule(int rowIndex) {
        if (PolicyHandler.getCopiedObject() == null) {
            return;
        }
        try {
            OpAppProtBlockEntityObject ospBlockEntityObj = (OpAppProtBlockEntityObject)PolicyHandler.getPastedObject(OpAppProtBlockEntityObject.class);
            if (ospBlockEntityObj != null) {
                if (this.jTPolicy.getRowCount() > 0) {
                    ospBlockEntityObj.setName(this.getPasteRuleName(ospBlockEntityObj.getName()));
                }
                this.compoundRuleNames.add(ospBlockEntityObj.getName());
                this.ospBlockArray.addOpAppProtBlockEntity(ospBlockEntityObj.getOpAppProtBlockEntity());
                if (rowIndex != -1) {
                    this.tableModel.insertRow(rowIndex, ospBlockEntityObj);
                } else {
                    this.tableModel.addRow(ospBlockEntityObj);
                }
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.title.ErrorMessage"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    public void importCompoundRule() {
        String errMsg = null;
        try {
            OpAppProtectionPolicyHandler handler = OpAppProtectionPolicyHandler.getInstance();
            AppProtectionPolicyObject importedObj = handler.importFile();
            if (importedObj == null) {
                return;
            }
            OpAppProtectionPolicy policy = (OpAppProtectionPolicy)importedObj.getSchemaObj();
            if (policy == null) {
                return;
            }
            AppProtectionRuleSystem ospRuleSystem = policy.getOptAppProtectionRuleSystem();
            if (ospRuleSystem == null) {
                return;
            }
            EnforcedAppProtectionBlockArray blockArray = ospRuleSystem.getOptEnforcedAppProtectionBlockArray();
            if (blockArray == null || blockArray.getOpAppProtBlockEntityCount() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.error.NoCompRulesInFile"));
                return;
            }
            for (int i = 0; i < blockArray.getOpAppProtBlockEntityCount(); ++i) {
                OpAppProtBlockEntity oneEntity = blockArray.getOpAppProtBlockEntity(i);
                OpAppProtBlockEntityObject ospBlockEntityObj = new OpAppProtBlockEntityObject(oneEntity);
                if (this.compoundRuleNames.size() != 0) {
                    String newName = this.validateRuleName(ospBlockEntityObj.getName());
                    if (newName == null || newName.length() == 0) {
                        return;
                    }
                    ospBlockEntityObj.setName(newName);
                }
                this.ospBlockArray.addOpAppProtBlockEntity(oneEntity);
                this.tableModel.addRow(ospBlockEntityObj);
                this.compoundRuleNames.add(ospBlockEntityObj.getName());
            }
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        if (errMsg != null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.error.ImportingCompRules"), errMsg), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.title.ImportCompRules"), 0);
        }
    }

    public void exportCompoundRule() {
        EnforcedAppProtectionBlockArray blockArray = new EnforcedAppProtectionBlockArray();
        OpAppProtectionPolicy policy = null;
        try {
            policy = (OpAppProtectionPolicy)this.opObj.getCopyOfPolicyObject();
            AppProtectionRuleSystem ruleSys = policy.getOptAppProtectionRuleSystem();
            ruleSys.setOptEnforcedAppProtectionBlockArray(blockArray);
            int[] selRows = this.jTPolicy.getSelectedRows();
            for (int i = 0; i < selRows.length; ++i) {
                blockArray.addOpAppProtBlockEntity(((OpAppProtBlockEntityObject)this.tableModel.getRow(selRows[i])).getOpAppProtBlockEntity());
            }
            if (policy.getName() == null || policy.getName().trim().length() == 0) {
                return;
            }
            ExportedPackage exportedPackage = new ExportedPackage("sygate.spm.osp.policy", "1.0");
            PolicyHandler.exportPolicy((ConfigObject)policy, policy.getName(), exportedPackage);
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    public void ruleTemplate() {
    }

    public void updateTemplate(List<OpAppProtTemplate> templates) {
        if (templates.size() == 0) {
            return;
        }
        boolean isFound = false;
        for (int j = 0; j < templates.size(); ++j) {
            isFound = false;
            OpAppProtTemplate ospTemplate = templates.get(j);
            String ruleName = ospTemplate.getName();
            for (int i = 0; i < this.jTPolicy.getRowCount(); ++i) {
                OpAppProtBlockEntityObject ospBlockEntityObj = (OpAppProtBlockEntityObject)this.tableModel.getRow(i);
                if (!ruleName.equalsIgnoreCase(ospBlockEntityObj.getName())) continue;
                if (0 == JOptionPane.showConfirmDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.ConfirmReplaceRule"), ruleName))) {
                    ospBlockEntityObj.setOpAppProtectionBlock(ospTemplate);
                    this.tableModel.fireTableRowsUpdated(i, i);
                }
                isFound = true;
                break;
            }
            if (isFound) continue;
            OpAppProtBlockEntityObject ospBlockEntityObj = new OpAppProtBlockEntityObject(ospTemplate);
            this.tableModel.addRow(ospBlockEntityObj);
            this.ospBlockArray.addOpAppProtBlockEntity(ospBlockEntityObj.getOpAppProtBlockEntity());
            this.compoundRuleNames.add(ospTemplate.getName());
        }
    }

    private void initialize() {
        this.jCbxTrojan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionPanel.this.trojanChanged();
            }
        });
        this.jCbxNotify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionPanel.this.notifyChanged();
            }
        });
        this.jBNotify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestrictedPlainDocument doc = new RestrictedPlainDocument(1000);
                doc.setValidator("\"/\\*?<>|:", false);
                AdditionalTextDialog dlg = new AdditionalTextDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.title.SetAdditionalText"), OSProtectionPanel.this.additionalText, doc);
                if (dlg.isOk()) {
                    OSProtectionPanel.this.additionalText = dlg.getAdditionalText();
                }
                dlg.dispose();
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.title.rule"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.desc.rule"), false), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getRuleTablePane(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 0, 20), 0, 0));
        this.add((Component)this.getRuleButtonPanel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 20), 0, 0));
    }

    private JScrollPane getRuleTablePane() {
        this.initPolicyTable();
        JScrollPane pane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)pane, (JTable)this.jTPolicy);
        pane.addMouseListener(this.getMouseListener());
        return pane;
    }

    private JPanel getRuleButtonPanel() {
        this.jBTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionPanel.this.ruleTemplate();
            }
        });
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionPanel.this.addRule();
            }
        });
        this.jBEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionPanel.this.editRule();
            }
        });
        this.jBDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionPanel.this.deleteRule();
            }
        });
        this.jBUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionPanel.this.moveUpRule();
            }
        });
        this.jBDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSProtectionPanel.this.moveDownRule();
            }
        });
        JPanel buttonPanel = new JPanel();
        UIUtilities.layoutButtonPanel(buttonPanel, new JButton[]{this.jBAdd, this.jBEdit, this.jBDelete, this.jBUp, this.jBDown}, 0, 4, true, false);
        return buttonPanel;
    }

    private void initPolicyTable() {
        String[] colNames = new String[]{USE, AVAILABLE_PROTECTION, MODE};
        int[] colMapping = new int[]{0, 1, 2};
        this.tableModel = new CustomTableModel(colNames, colMapping){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                if (OSProtectionPanel.this.isReadonly) {
                    return false;
                }
                return column == 0 || column == 2;
            }
        };
        this.jTPolicy = new StripesTable(this.tableModel);
        this.jTPolicy.setRowHeight(20);
        this.jTPolicy.addMouseListener(this.getMouseListener());
        this.jTPolicy.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                OSProtectionPanel.this.updateButtons();
            }
        });
        this.jTPolicy.getSelectionModel().setSelectionMode(2);
        Dimension size = this.jTPolicy.getPreferredScrollableViewportSize();
        this.jTPolicy.setPreferredScrollableViewportSize(new Dimension(size.width, (this.jTPolicy.getRowHeight() + this.jTPolicy.getRowMargin()) * 5 * 3));
        TableColumnModel colModel = this.jTPolicy.getColumnModel();
        TableColumn useCol = colModel.getColumn(colModel.getColumnIndex(USE));
        useCol.setCellRenderer(new CheckBoxRenderer(false));
        useCol.setCellEditor(new CheckBoxEditor(this.jTPolicy){
            private static final long serialVersionUID = 1L;

            @Override
            protected void updateModel(TableModel tableModel, int selIndex) {
            }
        });
        TableColumn modeCol = colModel.getColumn(colModel.getColumnIndex(MODE));
        modeCol.setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value.toString().equals(OpAppProtBlockEntityObject.MODE_TEST_ONLY)) {
                    this.setForeground(Color.RED);
                    this.setFont(this.getFont().deriveFont(1));
                } else {
                    this.setForeground(Color.GREEN.darker());
                }
                return comp;
            }
        });
        modeCol.setCellEditor(new DefaultCellEditor(new JComboBox<String>(new String[]{OpAppProtBlockEntityObject.MODE_TEST_ONLY, OpAppProtBlockEntityObject.MODE_NORMAL})));
        TableColumn theCol = this.jTPolicy.getColumnModel().getColumn(2);
        theCol.setCellRenderer(new ComboBoxRenderer());
        UIUtilities.setTableColumnWidth(this.jTPolicy, COL_SIZE, (int)this.jTPolicy.getPreferredScrollableViewportSize().getWidth());
    }

    private MouseListener getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (OSProtectionPanel.this.jTPolicy.isEnabled()) {
                    OSProtectionPanel.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (OSProtectionPanel.this.jTPolicy.isEnabled()) {
                    OSProtectionPanel.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    OSProtectionPanel.this.editRule();
                }
            }
        };
    }

    private void updateButtons() {
        int selCount = this.jTPolicy.getSelectedRowCount();
        int selIndex = this.jTPolicy.getSelectedRow();
        this.jBDelete.setEnabled(selCount > 0 && !this.isReadonly);
        this.jBEdit.setEnabled(selCount == 1);
        this.jBUp.setEnabled(selCount == 1 && selIndex > 0 && !this.isReadonly);
        this.jBDown.setEnabled(selCount == 1 && selIndex < this.tableModel.getRowCount() - 1 && !this.isReadonly);
    }

    private void trojanChanged() {
        this.jCbxNotify.setEnabled(this.jCbxTrojan.isSelected());
        this.notifyChanged();
    }

    private void notifyChanged() {
        this.jBNotify.setEnabled(this.jCbxNotify.isEnabled() && this.jCbxNotify.isSelected());
    }

    private String getPasteRuleName(String copiedRuleName) {
        int i;
        int copyNum = 1;
        ArrayList<String> numList = new ArrayList<String>();
        String copyStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.CopyUsedInPolicyName");
        String firstCopyStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.FirstCopyUsedInPolicyName");
        String copyFmtStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.CopyPolicyNameFormat");
        String firstCopyFmtStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.FirstCopyPolicyNameFormat");
        String copyFmtSeparatorStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.SeparatorUsedInCopyPolicyNameFormat");
        String firstCopyFmtSeparatorStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.FirstSeparatorUsedInCopyPolicyNameFormat");
        for (i = 0; i < this.jTPolicy.getRowCount(); ++i) {
            String numStr;
            int pos;
            String nameStr = ((OpAppProtBlockEntityObject)this.tableModel.getRow(i)).getName();
            if (nameStr.startsWith(copyStr)) {
                pos = nameStr.indexOf(copyFmtSeparatorStr);
                if (pos == -1) continue;
                numStr = nameStr.substring(copyStr.length(), pos);
                try {
                    Integer.parseInt(numStr);
                    if (copiedRuleName.length() == 255) {
                        if (!nameStr.substring(pos + copyFmtSeparatorStr.length() + 1, nameStr.length()).equals(copiedRuleName.substring(0, 255 - (pos + 1)))) continue;
                        numList.add(numStr);
                        continue;
                    }
                    if (!nameStr.substring(pos + copyFmtSeparatorStr.length() + 1, nameStr.length()).equals(copiedRuleName)) continue;
                    numList.add(numStr);
                }
                catch (Exception e) {
                    LoggerUtilities.logException((Throwable)e);
                }
                continue;
            }
            if (!nameStr.startsWith(firstCopyStr) || (pos = nameStr.indexOf(firstCopyFmtSeparatorStr)) == -1) continue;
            numStr = "1";
            try {
                if (copiedRuleName.length() == 255) {
                    if (!nameStr.substring(pos + firstCopyFmtSeparatorStr.length() + 1, nameStr.length()).equals(copiedRuleName.substring(0, 255 - (pos + 1)))) continue;
                    numList.add(numStr);
                    continue;
                }
                if (!nameStr.substring(pos + firstCopyFmtSeparatorStr.length() + 1, nameStr.length()).equals(copiedRuleName)) continue;
                numList.add(numStr);
                continue;
            }
            catch (Exception e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }
        if (numList.size() != 0) {
            int[] num = new int[numList.size()];
            for (i = 0; i < numList.size(); ++i) {
                num[i] = Integer.parseInt((String)numList.get(i));
            }
            Arrays.sort(num);
            boolean isFound = true;
            int n = -1;
            for (int i2 = 0; i2 < num.length; ++i2) {
                n = i2 + 1;
                if (n == num[i2]) continue;
                isFound = false;
                break;
            }
            copyNum = isFound ? n + 1 : n;
        }
        if ((copiedRuleName = copyNum == 1 ? MessageFormat.format(firstCopyFmtStr, copiedRuleName) : MessageFormat.format(copyFmtStr, copyNum, copiedRuleName)).length() > 255) {
            copiedRuleName = copiedRuleName.substring(0, 255);
        }
        return copiedRuleName;
    }

    private void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int rowIndex = this.jTPolicy.rowAtPoint(e.getPoint());
            if (rowIndex != -1) {
                this.jTPolicy.setRowSelectionInterval(rowIndex, rowIndex);
            }
            OSProtectionTablePopupMenu menu = new OSProtectionTablePopupMenu(this, this.jTPolicy, this.isReadonly);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private String validateRuleName(String oldName) {
        String newName = PolicyHandler.adjustName(oldName, this.compoundRuleNames, 255);
        if (!newName.equals(oldName)) {
            String enteredName = JOptionPane.showInputDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "OSProtectionPanel.error.RuleExists"), oldName), newName);
            if (enteredName == null || enteredName.length() == 0) {
                return null;
            }
            return this.validateRuleName(enteredName);
        }
        return newName;
    }

    public void setReadOnly() {
        this.isReadonly = true;
        this.jBAdd.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hdp_hardware_device_protection";
    }
}

