/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpAction;
import com.sygate.scm.common.configobject.schema.OpAppliedOS;
import com.sygate.scm.common.configobject.schema.OpFileChecksumMatchEntity;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpLoadModule;
import com.sygate.scm.common.configobject.schema.OpModuleAccess;
import com.sygate.scm.common.configobject.schema.OpModuleMatchEntity;
import com.sygate.scm.common.configobject.schema.TargetModuleMatch;
import com.sygate.scm.common.configobject.schema.TargetModuleNoMatch;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.osprotect.ModuleDefinitionPanel;
import com.sygate.scm.console.ui.policy.osprotect.PermissionPanelBase;
import com.sygate.scm.console.ui.policy.osprotect.ProcessRestrictionPane;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ModulePanel
extends PermissionPanelBase
implements ChangeListener {
    private static final long serialVersionUID = -1903699332415328468L;
    private static final String NO_APPLY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.module.noApplies");
    private ModuleDefinitionPanel definitionPanel;
    private ProcessRestrictionPane accessPanel;
    private JTabbedPane jTbPane = new JTabbedPane();
    private OpModuleAccess opModuleAccess;

    public ModulePanel(boolean isReadonly) {
        this.definitionPanel = new ModuleDefinitionPanel(this, isReadonly);
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ModulePanel.action.description");
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ModulePanel.title.ModuleAccess");
        this.accessPanel = new ProcessRestrictionPane(description, this, title, isReadonly);
        this.initialize(isReadonly);
    }

    @Override
    public void initData(ConfigObject opModuleAccess) {
        this.opModuleAccess = (OpModuleAccess)opModuleAccess;
        this.checkSchma((OpModuleAccess)opModuleAccess);
        this.definitionPanel.initData(opModuleAccess);
        this.accessPanel.initData(((OpModuleAccess)opModuleAccess).getOptOpLoadModule().getOpAction());
        this.jTASummary.setText(this.getSummary((OpModuleAccess)opModuleAccess));
    }

    @Override
    public void commitData() {
        this.definitionPanel.commitData();
        this.accessPanel.commitData();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateSummary();
    }

    private void initialize(boolean isReadonly) {
        this.jTbPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ModulePanel.title.DLLDefinition"), this.definitionPanel);
        this.jTbPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ModulePanel.title.Restriction"), this.accessPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jTbPane, "Center");
        this.add((Component)this.getSummaryPanel(isReadonly), "South");
    }

    private void checkSchma(OpModuleAccess opModuleAccess) {
        if (opModuleAccess.getOptOpLoadModule() == null) {
            OpLoadModule load = new OpLoadModule();
            load.setOpAction(this.createOpAction());
            opModuleAccess.setOptOpLoadModule(load);
        }
        if (opModuleAccess.getOptOpAppliedOS() == null) {
            opModuleAccess.setOptOpAppliedOS(new OpAppliedOS());
        }
    }

    private String getSummary(OpModuleAccess opModuleAccess) {
        String fileMatchStr = "";
        String fileNoMatchStr = "";
        String loadStr = "";
        Object fileMatchCombinedStr = "";
        String name = this.definitionPanel.getNameText();
        String listSeparator = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ModulePanel.ListSeparator");
        String formatApplies = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ModulePanel.FormatForAppliesCriteria");
        String formatExcludes = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ModulePanel.FormatForExcludesCriteria");
        TargetModuleMatch fileMatch = opModuleAccess.getOpTargetModule().getOptTargetModuleMatch();
        if (fileMatch != null && fileMatch.getOpModuleMatchEntityCount() > 0) {
            StringBuilder fileMatchBuf = new StringBuilder();
            for (int i = 0; i < fileMatch.getOpModuleMatchEntityCount(); ++i) {
                fileMatchBuf.append(this.getKeyString(fileMatch.getOpModuleMatchEntity(i)));
                fileMatchBuf.append(listSeparator);
            }
            fileMatchStr = fileMatchBuf.toString();
            if (fileMatchStr != null && fileMatchStr.length() > 0) {
                fileMatchStr = fileMatchStr.substring(0, fileMatchStr.length() - 1);
            }
        } else {
            return NO_APPLY;
        }
        TargetModuleNoMatch fileNameNoMatch = opModuleAccess.getOpTargetModule().getOptTargetModuleNoMatch();
        if (fileNameNoMatch != null) {
            StringBuilder fileNoMatchBuf = new StringBuilder();
            for (int i = 0; i < fileNameNoMatch.getOpModuleMatchEntityCount(); ++i) {
                fileNoMatchBuf.append(this.getKeyString(fileNameNoMatch.getOpModuleMatchEntity(i)));
                fileNoMatchBuf.append(listSeparator);
            }
            fileNoMatchStr = fileNoMatchBuf.toString();
            if (fileNoMatchStr != null && fileNoMatchStr.length() > 0) {
                fileNoMatchStr = fileNoMatchStr.substring(0, fileNoMatchStr.length() - 1);
            }
        }
        String fileMatchAppliesStr = null;
        if (fileMatchStr.length() > 0) {
            fileMatchAppliesStr = MessageFormat.format(formatApplies, name, fileMatchStr);
            fileMatchCombinedStr = (String)fileMatchCombinedStr + fileMatchAppliesStr + " ";
        }
        String fileMatchExcludesStr = null;
        if (fileNoMatchStr.length() > 0) {
            fileMatchExcludesStr = MessageFormat.format(formatExcludes, fileNoMatchStr);
            fileMatchCombinedStr = (String)fileMatchCombinedStr + fileMatchExcludesStr + " ";
        }
        OpAction actionLoad = null;
        OpLoadModule loadModule = opModuleAccess.getOptOpLoadModule();
        if (loadModule != null) {
            actionLoad = loadModule.getOpAction();
        }
        if (actionLoad != null) {
            loadStr = this.getOpActionSummary(actionLoad, null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ModulePanel.Module"), null);
        }
        return (String)fileMatchCombinedStr + loadStr;
    }

    private String getKeyString(OpModuleMatchEntity entry) {
        OpFileNameMatchEntity fileEntry = entry.getOptOpFileNameMatchEntity();
        if (Utility.getBooleanValue((Boolean)fileEntry.getOptEnable(), (Boolean)fileEntry.getDefEnable())) {
            return fileEntry.getKeyString();
        }
        OpFileChecksumMatchEntity csEntry = entry.getOptOpFileChecksumMatchEntity();
        if (Utility.getBooleanValue((Boolean)csEntry.getOptEnable(), (Boolean)csEntry.getDefEnable())) {
            return csEntry.getFileChecksum();
        }
        return "";
    }

    private void updateSummary() {
        this.jTASummary.setText(this.getSummary(this.opModuleAccess));
    }

    @Override
    public boolean isValidate(List<String> existNames) {
        return this.definitionPanel.isValidate(existNames);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return ((ContentSensitiveHelpPage)((Object)this.jTbPane.getSelectedComponent())).getContentSensitiveHelpToken();
    }
}

