/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpFileChecksumMatchEntity;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpModuleAccess;
import com.sygate.scm.common.configobject.schema.OpModuleMatchEntity;
import com.sygate.scm.common.configobject.schema.OpTargetModule;
import com.sygate.scm.common.configobject.schema.TargetModuleMatch;
import com.sygate.scm.common.configobject.schema.TargetModuleNoMatch;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.osprotect.DefinitionPanel;
import com.sygate.scm.console.ui.policy.osprotect.dialog.StringConditionEditorDlg;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ChangeListener;

public class ModuleDefinitionPanel
extends DefinitionPanel {
    private static final long serialVersionUID = -1735889552230547238L;
    private OpModuleAccess opModuleAccess;
    private OpTargetModule opTargetModule;
    private boolean isReadonly;

    public ModuleDefinitionPanel(ChangeListener summaryListener, boolean isReadonly) {
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.module.description");
        this.isReadonly = isReadonly;
        this.initialize(99, summaryListener, description, isReadonly);
    }

    public void initData(ConfigObject configuObj) {
        this.opModuleAccess = (OpModuleAccess)configuObj;
        this.opTargetModule = this.opModuleAccess.getOpTargetModule();
        this.jTFName.setText(this.opModuleAccess.getName());
        this.setTADesc(this.opModuleAccess.getOptDescription());
        this.jCbxEnable.setSelected(Utility.getBooleanValue((Boolean)this.opModuleAccess.getOptEnable(), (Boolean)true));
        this.initMatchList();
        this.initNoMatchList();
    }

    public void commitData() {
        this.opModuleAccess.setName(this.jTFName.getText().trim());
        this.opModuleAccess.setOptDescription(this.jTADesc.getText().trim());
        this.opModuleAccess.setOptEnable(Boolean.valueOf(this.jCbxEnable.isSelected()));
    }

    @Override
    protected void addMatch() {
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(4);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            TargetModuleMatch mMatch = this.opTargetModule.getOptTargetModuleMatch();
            if (mMatch == null) {
                mMatch = new TargetModuleMatch();
            }
            OpModuleMatchEntity moduleEntity = new OpModuleMatchEntity();
            moduleEntity.setOptOpFileNameMatchEntity(fileEntity);
            moduleEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
            mMatch.addOpModuleMatchEntity(moduleEntity);
            this.opTargetModule.setOptTargetModuleMatch(mMatch);
            DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
            model.addElement(this.getDisplayString(fileEntity, checksumEntity, null));
        }
        dlg.dispose();
    }

    @Override
    protected void editMatch() {
        TargetModuleMatch mMatch;
        int selIndex = this.jLMatch.getMinSelectionIndex();
        try {
            mMatch = (TargetModuleMatch)PolicyHandler.getCopyOfObj((ConfigObject)this.opTargetModule.getOptTargetModuleMatch());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return;
        }
        OpModuleMatchEntity mEntity = mMatch.getOpModuleMatchEntity(selIndex);
        OpFileNameMatchEntity file = mEntity.getOptOpFileNameMatchEntity();
        OpFileChecksumMatchEntity checksum = mEntity.getOptOpFileChecksumMatchEntity();
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(4, file, checksum, null, this.isReadonly);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            mMatch = this.opTargetModule.getOptTargetModuleMatch();
            mEntity = mMatch.getOpModuleMatchEntity(selIndex);
            mEntity.setOptOpFileNameMatchEntity(fileEntity);
            mEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
            DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
            model.setElementAt(this.getDisplayString(fileEntity, checksumEntity, null), selIndex);
        }
        dlg.dispose();
    }

    @Override
    protected void deleteMatch() {
        int i;
        if (!this.canDelete(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ModuleDefinitionPanel.title.DelMatchingDLLDefn"))) {
            return;
        }
        ArrayList itemList = new ArrayList();
        ArrayList<OpModuleMatchEntity> sEntityList = new ArrayList<OpModuleMatchEntity>();
        TargetModuleMatch tMatch = this.opTargetModule.getOptTargetModuleMatch();
        for (i = this.jLMatch.getMinSelectionIndex(); i <= this.jLMatch.getMaxSelectionIndex(); ++i) {
            if (!this.jLMatch.isSelectedIndex(i)) continue;
            itemList.add(this.jLMatch.getModel().getElementAt(i));
            sEntityList.add(tMatch.getOpModuleMatchEntity(i));
        }
        for (i = 0; i < itemList.size(); ++i) {
            ((DefaultListModel)this.jLMatch.getModel()).removeElement(itemList.get(i));
            tMatch.removeOpModuleMatchEntity((OpModuleMatchEntity)sEntityList.get(i));
        }
        this.matchListSelected();
    }

    @Override
    protected void addNoMatch() {
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(4);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            TargetModuleNoMatch mNoMatch = this.opTargetModule.getOptTargetModuleNoMatch();
            if (mNoMatch == null) {
                mNoMatch = new TargetModuleNoMatch();
            }
            OpModuleMatchEntity moduleEntity = new OpModuleMatchEntity();
            moduleEntity.setOptOpFileNameMatchEntity(fileEntity);
            moduleEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
            mNoMatch.addOpModuleMatchEntity(moduleEntity);
            this.opTargetModule.setOptTargetModuleNoMatch(mNoMatch);
            DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
            model.addElement(this.getDisplayString(fileEntity, checksumEntity, null));
        }
        dlg.dispose();
    }

    @Override
    protected void editNoMatch() {
        TargetModuleNoMatch mNoMatch;
        int selIndex = this.jLNoMatch.getMinSelectionIndex();
        try {
            mNoMatch = (TargetModuleNoMatch)PolicyHandler.getCopyOfObj((ConfigObject)this.opTargetModule.getOptTargetModuleNoMatch());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return;
        }
        OpModuleMatchEntity mEntity = mNoMatch.getOpModuleMatchEntity(selIndex);
        OpFileNameMatchEntity file = mEntity.getOptOpFileNameMatchEntity();
        OpFileChecksumMatchEntity checksum = mEntity.getOptOpFileChecksumMatchEntity();
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(4, file, checksum, null, this.isReadonly);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            OpFileChecksumMatchEntity checksumEntity = dlg.getFileChecksumMatchEntity();
            mNoMatch = this.opTargetModule.getOptTargetModuleNoMatch();
            mEntity = mNoMatch.getOpModuleMatchEntity(selIndex);
            mEntity.setOptOpFileNameMatchEntity(fileEntity);
            mEntity.setOptOpFileChecksumMatchEntity(checksumEntity);
            DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
            model.setElementAt(this.getDisplayString(fileEntity, checksumEntity, null), selIndex);
        }
        dlg.dispose();
    }

    @Override
    protected void deleteNoMatch() {
        int i;
        if (!this.canDelete(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ModuleDefinitionPanel.title.DelNonMatchingDLLDefn"))) {
            return;
        }
        ArrayList itemList = new ArrayList();
        ArrayList<OpModuleMatchEntity> sEntityList = new ArrayList<OpModuleMatchEntity>();
        TargetModuleNoMatch mNoMatch = this.opTargetModule.getOptTargetModuleNoMatch();
        for (i = this.jLNoMatch.getMinSelectionIndex(); i <= this.jLNoMatch.getMaxSelectionIndex(); ++i) {
            if (!this.jLNoMatch.isSelectedIndex(i)) continue;
            itemList.add(this.jLNoMatch.getModel().getElementAt(i));
            sEntityList.add(mNoMatch.getOpModuleMatchEntity(i));
        }
        for (i = 0; i < itemList.size(); ++i) {
            ((DefaultListModel)this.jLNoMatch.getModel()).removeElement(itemList.get(i));
            mNoMatch.removeOpModuleMatchEntity((OpModuleMatchEntity)sEntityList.get(i));
        }
        this.noMatchListSelected();
    }

    private void initMatchList() {
        DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
        model.clear();
        TargetModuleMatch tMatch = this.opTargetModule.getOptTargetModuleMatch();
        if (tMatch != null) {
            for (int i = 0; i < tMatch.getOpModuleMatchEntityCount(); ++i) {
                OpModuleMatchEntity mEntity = tMatch.getOpModuleMatchEntity(i);
                OpFileNameMatchEntity fEntity = mEntity.getOptOpFileNameMatchEntity();
                if (fEntity == null) continue;
                model.addElement(this.getDisplayString(fEntity, mEntity.getOptOpFileChecksumMatchEntity(), null));
            }
        }
        this.matchListSelected();
    }

    private void initNoMatchList() {
        DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
        model.clear();
        TargetModuleNoMatch tNoMatch = this.opTargetModule.getOptTargetModuleNoMatch();
        if (tNoMatch != null) {
            for (int i = 0; i < tNoMatch.getOpModuleMatchEntityCount(); ++i) {
                OpModuleMatchEntity mEntity = tNoMatch.getOpModuleMatchEntity(i);
                OpFileNameMatchEntity fEntity = mEntity.getOptOpFileNameMatchEntity();
                if (fEntity == null) continue;
                model.addElement(this.getDisplayString(fEntity, mEntity.getOptOpFileChecksumMatchEntity(), null));
            }
        }
        this.noMatchListSelected();
    }

    public boolean isValidate(List<String> existNames) {
        existNames.remove(this.opModuleAccess.getName());
        return this.isValidName(existNames, false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hdp_hardware_device_protection_add_dll_definition";
    }
}

