/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.ExtendedOpDevice;
import com.sygate.scm.common.configobject.schema.MacAppProtectionSetting;
import com.sygate.scm.common.configobject.schema.MacOpBlockedDeviceList;
import com.sygate.scm.common.configobject.schema.MacOpDeviceBlocker;
import com.sygate.scm.common.configobject.schema.MacOpExcludedDeviceList;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.OpDeviceBlockerNotification;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.UsbDeviceHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AppProtectionPolicyObject;
import com.sygate.scm.console.logicobject.DeviceObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.MacDeviceSelectDialog;
import com.sygate.scm.console.ui.policy.osprotect.MacDeviceBlockTablePopupMenu;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class MacDeviceBlockPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 7436820909214019335L;
    private static final float[] BLOCK_COL_SIZE = new float[]{0.25f, 0.25f, 0.25f, 0.25f};
    private static final float[] NOBLOCK_COL_SIZE = new float[]{0.2f, 0.2f, 0.2f, 0.2f, 0.2f};
    private static final String[] BLOCK_COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.column.DeviceName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.column.Vendor"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.column.Model"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.column.SerialNumber")};
    private static final String[] NOBLOCK_COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.column.DeviceName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.column.Vendor"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.column.Model"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.column.SerialNumber"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.column.Permission")};
    private static final int[] BLOCK_COLUMN_MAP = new int[]{0, 4, 5, 7};
    private static final int[] NOBLOCK_COLUMN_MAP = new int[]{0, 4, 5, 7, 3};
    private static final String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.description");
    private static final String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.title");
    private SortableTableModel blockModel = new SortableTableModel();
    private JTable jTBlock = new StripesTable(this.blockModel);
    private SortableTableModel noBlockModel = new SortableTableModel();
    private JTable jTNoBlock = new StripesTable(this.noBlockModel);
    private JButton jBAddBlock = new JButton(UIText.get(5));
    private JButton jBDeleteBlock = new JButton(UIText.get(769));
    private JButton jBAddNoBlock = new JButton(UIText.get(5));
    private JButton jBDeleteNoBlock = new JButton(UIText.get(769));
    private JButton jBEditNoBlock = new JButton(UIText.get(1024));
    private JButton jBEditBlock = new JButton(UIText.get(1024));
    private JCheckBox jCbxLog = new JCheckBox(UIText.get(2820));
    private JCheckBox jCbxNotify = new JCheckBox(UIText.get(3330));

    public MacDeviceBlockPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
        this.add((Component)this.getDescriptionPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getDevicesPanel(true, this.jTBlock, this.jBAddBlock, this.jBDeleteBlock, this.jBEditBlock), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getDevicesPanel(false, this.jTNoBlock, this.jBAddNoBlock, this.jBDeleteNoBlock, this.jBEditNoBlock), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.getNotifyPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(15, 0, 0, 0), 0, 0));
    }

    public void initDeviceData(AppProtectionPolicyObject opObj) {
        MacOpDeviceBlocker deviceBlocker;
        MacAppProtectionSetting opSetting;
        if (opObj != null && (opSetting = opObj.getOptMacAppProtectionSetting()) != null && (deviceBlocker = opSetting.getOptMacOpDeviceBlocker()) != null) {
            boolean log = deviceBlocker.getOptLogIt() == null ? deviceBlocker.getDefLogIt() : deviceBlocker.getOptLogIt();
            this.jCbxLog.setSelected(log);
            OpDeviceBlockerNotification notification = deviceBlocker.getOptOpDeviceBlockerNotification();
            if (notification != null) {
                boolean enabledNotification = notification.getOptEnable() == null ? notification.getDefEnable() : notification.getOptEnable();
                this.jCbxNotify.setSelected(enabledNotification);
            }
            this.blockModel.removeAll();
            this.noBlockModel.removeAll();
            try {
                List<DeviceObject> listDevices = UsbDeviceHandler.getMacBlockList(opSetting);
                if (listDevices != null) {
                    for (DeviceObject o : listDevices) {
                        this.blockModel.addRow(o);
                    }
                }
                if ((listDevices = UsbDeviceHandler.getMacBlockExceptionList(opSetting)) != null) {
                    for (DeviceObject o : listDevices) {
                        this.noBlockModel.addRow(o);
                    }
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        this.tableSelected(this.jTBlock, this.jBDeleteBlock, this.jBEditBlock);
        this.tableSelected(this.jTNoBlock, this.jBDeleteNoBlock, this.jBEditNoBlock);
    }

    public void updateOpDeviceBlocker(OpAppProtectionPolicy policy) {
        List listAllowedDevices;
        boolean hasAllowedDevices;
        MacOpExcludedDeviceList allowedDevices;
        MacOpDeviceBlocker deviceBlocker;
        if (policy == null) {
            return;
        }
        List listBlockedDevices = (List)Cast.cast(this.blockModel.getAllRows());
        boolean hasBlockedDevices = listBlockedDevices.size() > 0;
        MacAppProtectionSetting setting = policy.getOptMacAppProtectionSetting();
        if (setting == null) {
            setting = new MacAppProtectionSetting();
            policy.setOptMacAppProtectionSetting(setting);
        }
        if ((deviceBlocker = setting.getOptMacOpDeviceBlocker()) == null) {
            deviceBlocker = new MacOpDeviceBlocker();
            setting.setOptMacOpDeviceBlocker(deviceBlocker);
        }
        deviceBlocker.setOptEnable(Boolean.TRUE);
        deviceBlocker.setOptLogIt(Boolean.valueOf(this.jCbxLog.isSelected()));
        OpDeviceBlockerNotification notification = deviceBlocker.getOptOpDeviceBlockerNotification();
        if (notification == null) {
            notification = new OpDeviceBlockerNotification();
            deviceBlocker.setOptOpDeviceBlockerNotification(notification);
        }
        notification.setOptEnable(Boolean.valueOf(this.jCbxNotify.isSelected()));
        MacOpBlockedDeviceList blockedDevices = deviceBlocker.getOptMacOpBlockedDeviceList();
        if (blockedDevices != null) {
            deviceBlocker.removeChild((AbstractSchema)blockedDevices);
        }
        if (hasBlockedDevices) {
            blockedDevices = new MacOpBlockedDeviceList();
            blockedDevices.setOptEnable(Boolean.TRUE);
            deviceBlocker.setOptMacOpBlockedDeviceList(blockedDevices);
            for (DeviceObject device : listBlockedDevices) {
                ObjReference ref = new ObjReference();
                ref.setName("DeviceToBeBlocked");
                ref.setTargetType("OpDevice");
                ref.setTargetId(device.getId());
                ExtendedOpDevice item = new ExtendedOpDevice();
                item.setObjReference(ref);
                item.setOptPermission(device.getPermission());
                item.setOptModel(device.getDeviceModel());
                item.setOptVendor(device.getDeviceVendor());
                item.setOptSerialNumber(device.getSerialNumber());
                blockedDevices.addExtendedOpDevice(item);
            }
        }
        if ((allowedDevices = deviceBlocker.getOptMacOpExcludedDeviceList()) != null) {
            deviceBlocker.removeChild((AbstractSchema)allowedDevices);
        }
        boolean bl = hasAllowedDevices = (listAllowedDevices = (List)Cast.cast(this.noBlockModel.getAllRows())).size() > 0;
        if (hasAllowedDevices) {
            allowedDevices = new MacOpExcludedDeviceList();
            allowedDevices.setOptEnable(Boolean.TRUE);
            deviceBlocker.setOptMacOpExcludedDeviceList(allowedDevices);
            for (DeviceObject device : listAllowedDevices) {
                ObjReference ref = new ObjReference();
                ref.setName("DeviceToBeAllowed");
                ref.setTargetType("OpDevice");
                ref.setTargetId(device.getId());
                ExtendedOpDevice item = new ExtendedOpDevice();
                item.setObjReference(ref);
                item.setOptPermission(device.getPermission());
                item.setOptModel(device.getDeviceModel());
                item.setOptVendor(device.getDeviceVendor());
                item.setOptSerialNumber(device.getSerialNumber());
                allowedDevices.addExtendedOpDevice(item);
            }
        }
    }

    protected void addDevice(boolean isBlock) {
        List<DeviceObject> resultListFromDlg;
        SortableTableModel model2;
        List selectedDevices2;
        SortableTableModel model = isBlock ? this.blockModel : this.noBlockModel;
        List selectedDevices = (List)Cast.cast(model.getAllRows());
        MacDeviceSelectDialog dlg = new MacDeviceSelectDialog(selectedDevices, selectedDevices2 = (List)Cast.cast((model2 = isBlock ? this.noBlockModel : this.blockModel).getAllRows()), isBlock);
        if (!dlg.isCancel() && (resultListFromDlg = dlg.getSelection()) != null) {
            for (DeviceObject selectedObject : resultListFromDlg) {
                if (selectedObject == null) continue;
                model.addRow(selectedObject);
            }
        }
    }

    protected void deleteDevice(boolean blocked) {
        SortableTableModel model;
        if (JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.ConfirmDeleteDeviceID"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.title.DelDeviceID"), 0) != 0) {
            return;
        }
        JTable table = blocked ? this.jTBlock : this.jTNoBlock;
        SortableTableModel sortableTableModel = model = blocked ? this.blockModel : this.noBlockModel;
        while (table.getSelectedRow() > -1) {
            model.removeRow(table.getSelectedRow());
        }
    }

    protected void editDevice(JTable table, boolean isBlock) {
        List<DeviceObject> resultListFromDlg;
        SortableTableModel model = isBlock ? this.blockModel : this.noBlockModel;
        List selectedDevices = (List)Cast.cast(model.getAllRows());
        DeviceObject editDevice = (DeviceObject)Cast.cast((Object)model.getRow(table.getSelectedRow()));
        SortableTableModel model2 = isBlock ? this.noBlockModel : this.blockModel;
        List selectedDevices2 = (List)Cast.cast(model2.getAllRows());
        MacDeviceSelectDialog dlg = new MacDeviceSelectDialog(selectedDevices, selectedDevices2, isBlock, true, editDevice);
        if (!dlg.isCancel() && (resultListFromDlg = dlg.getSelection()) != null) {
            for (DeviceObject updatedObj : resultListFromDlg) {
                if (updatedObj.isEqualsWithExtraFields(editDevice)) continue;
                model.removeRow(table.getSelectedRow());
                model.addRow(updatedObj);
            }
        }
    }

    private JPanel getDescriptionPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new AvTemplatePane(title, description, false), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getDevicesPanel(final boolean isBlock, final JTable table, JButton add, JButton delete, JButton edit) {
        this.initializeTable(table, table.getModel(), delete, edit, isBlock);
        table.addMouseListener(this.getMouseListener(isBlock));
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacDeviceBlockPanel.this.addDevice(e.getSource() == MacDeviceBlockPanel.this.jBAddBlock);
            }
        });
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacDeviceBlockPanel.this.deleteDevice(isBlock);
            }
        });
        if (edit != null) {
            edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacDeviceBlockPanel.this.editDevice(table, isBlock);
                }
            });
        }
        JPanel buttonPanel = new JPanel();
        UIUtilities.layoutButtonPanel(buttonPanel, new JButton[]{add, edit, delete}, 0, 4, true, false);
        String title = isBlock ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.label.BlockedDevices") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.label.DevicesExcludedromBlocking");
        String message = isBlock ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.label.BlockedDevicesMess") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.label.DevicesExcludedromBlockingMess");
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTable)table);
        scrollPane.addMouseListener(this.getMouseListener(isBlock));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new AvTemplatePane(title, message, false), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 0, 20), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 20), 0, 0));
        return panel;
    }

    private JPanel getNotifyPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jCbxLog, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxNotify, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private void initializeTable(final JTable table, TableModel model, final JButton delete, final JButton edit, boolean isBlock) {
        ((SortableTableModel)model).setColumnNames(isBlock ? BLOCK_COL_NAMES : NOBLOCK_COL_NAMES);
        ((SortableTableModel)model).setColumnMapping(isBlock ? BLOCK_COLUMN_MAP : NOBLOCK_COLUMN_MAP);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MacDeviceBlockPanel.this.tableSelected(table, delete, edit);
            }
        });
        table.getSelectionModel().setSelectionMode(2);
        Dimension size = table.getPreferredScrollableViewportSize();
        table.setPreferredScrollableViewportSize(new Dimension(size.width * 2 / 3, (table.getRowHeight() + table.getRowMargin()) * 5));
        UIUtilities.setTableColumnWidth(table, isBlock ? BLOCK_COL_SIZE : NOBLOCK_COL_SIZE, (int)table.getPreferredScrollableViewportSize().getWidth());
    }

    private void tableSelected(JTable table, JButton delete, JButton edit) {
        delete.setEnabled(table.getSelectedRowCount() > 0);
        if (edit != null) {
            edit.setEnabled(table.getSelectedRowCount() == 1);
        }
    }

    private MouseListener getMouseListener(final boolean isBlock) {
        return new MouseAdapter(){
            final JTable jtable;
            {
                this.jtable = isBlock ? MacDeviceBlockPanel.this.jTBlock : MacDeviceBlockPanel.this.jTNoBlock;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.jtable.isEnabled()) {
                    MacDeviceBlockPanel.this.showPopupMenu(e, isBlock);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.jtable.isEnabled()) {
                    MacDeviceBlockPanel.this.showPopupMenu(e, isBlock);
                }
            }
        };
    }

    private void showPopupMenu(MouseEvent e, boolean isBlock) {
        JTable jtable;
        JTable jTable = jtable = isBlock ? this.jTBlock : this.jTNoBlock;
        if (e.isPopupTrigger()) {
            int rowIndex = jtable.rowAtPoint(e.getPoint());
            if (rowIndex != -1) {
                jtable.setRowSelectionInterval(rowIndex, rowIndex);
            }
            MacDeviceBlockTablePopupMenu menu = new MacDeviceBlockTablePopupMenu(this, jtable, isBlock);
            menu.show(e.getComponent(), e.getX(), e.getY());
        } else if (e.getSource() == jtable && jtable.getSelectedRowCount() > 0 && e.getClickCount() == 2) {
            this.editDevice(jtable, isBlock);
        }
    }

    public void setReadOnly() {
        this.jTBlock.setEnabled(false);
        this.jBAddBlock.setEnabled(false);
        this.jBDeleteBlock.setEnabled(false);
        this.jTNoBlock.setEnabled(false);
        this.jBAddNoBlock.setEnabled(false);
        this.jBDeleteNoBlock.setEnabled(false);
        this.jCbxLog.setEnabled(false);
        this.jCbxNotify.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_mac_hdp_device_block";
    }
}

