/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpAction;
import com.sygate.scm.common.configobject.schema.OpAppliedOS;
import com.sygate.scm.common.configobject.schema.OpCreateProcess;
import com.sygate.scm.common.configobject.schema.OpFileChecksumMatchEntity;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpProcessAccess;
import com.sygate.scm.common.configobject.schema.OpProcessMatchEntity;
import com.sygate.scm.common.configobject.schema.OpTerminateProcess;
import com.sygate.scm.common.configobject.schema.TargetProcessMatch;
import com.sygate.scm.common.configobject.schema.TargetProcessNoMatch;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.osprotect.PermissionPanelBase;
import com.sygate.scm.console.ui.policy.osprotect.ProcessDefinitionPanel;
import com.sygate.scm.console.ui.policy.osprotect.ProcessRestrictionPane;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LaunchProcessPanel
extends PermissionPanelBase
implements ChangeListener {
    private static final long serialVersionUID = 91179526829149203L;
    private ProcessDefinitionPanel definitionPanel;
    private ProcessRestrictionPane accessPanel;
    private JTabbedPane jTbPane = new JTabbedPane();
    private OpProcessAccess opProcessAccess;
    private String tabTitle;
    private String NO_APPLY;

    public LaunchProcessPanel(boolean isReadonly) {
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "LaunchProcessPanel.action.description");
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ProcessRestrictionPane.title.ProcessAccess");
        this.accessPanel = new ProcessRestrictionPane(description, this, title, isReadonly);
        this.NO_APPLY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.launch.noApplies");
        this.initialize(isReadonly);
    }

    protected LaunchProcessPanel(boolean dummy, boolean isReadonly) {
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "LaunchProcessPanel.action.descriptionTerm");
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "ProcessRestrictionPane.title.TerminateAccess");
        this.tabTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "LaunchProcessPanel.title.ProcessDefTerm");
        this.accessPanel = new ProcessRestrictionPane(description, this, title, isReadonly);
        this.NO_APPLY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.terminate.noApplies");
    }

    @Override
    public void initData(ConfigObject opProcessAccess) {
        this.opProcessAccess = (OpProcessAccess)opProcessAccess;
        this.checkSchma((OpProcessAccess)opProcessAccess);
        this.definitionPanel.initData(opProcessAccess);
        this.accessPanel.initData(this.getProcessAction(opProcessAccess));
        this.jTASummary.setText(this.getSummary((OpProcessAccess)opProcessAccess));
    }

    @Override
    public void commitData() {
        this.definitionPanel.commitData();
        this.accessPanel.commitData();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateSummary();
    }

    protected OpAction getProcessAction(ConfigObject opProcessAccess) {
        return ((OpProcessAccess)opProcessAccess).getOptOpCreateProcess().getOpAction();
    }

    protected void checkProcessAction(OpProcessAccess opProcessAccess) {
        if (opProcessAccess.getOptOpCreateProcess() == null) {
            OpCreateProcess create = new OpCreateProcess();
            create.setOpAction(this.createOpAction());
            opProcessAccess.setOptOpCreateProcess(create);
        }
    }

    protected ProcessDefinitionPanel initializeDefinitionPanel(boolean isReadonly) {
        return new ProcessDefinitionPanel(true, this, isReadonly);
    }

    protected void initialize(boolean isReadonly) {
        this.definitionPanel = this.initializeDefinitionPanel(isReadonly);
        if (this.tabTitle == null) {
            this.tabTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "LaunchProcessPanel.title.ProcessDef");
        }
        this.jTbPane.addTab(this.tabTitle, this.definitionPanel);
        this.jTbPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "LaunchProcessPanel.title.Restriction"), this.accessPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jTbPane, "Center");
        this.add((Component)this.getSummaryPanel(isReadonly), "South");
    }

    private void checkSchma(OpProcessAccess opProcessAccess) {
        this.checkProcessAction(opProcessAccess);
        if (opProcessAccess.getOptOpAppliedOS() == null) {
            opProcessAccess.setOptOpAppliedOS(new OpAppliedOS());
        }
    }

    private String getSummary(OpProcessAccess opProcessAccess) {
        OpTerminateProcess terminateProcess;
        String fileMatchStr = "";
        String fileNoMatchStr = "";
        Object fileMatchCombinedStr = "";
        String launchStr = "";
        String name = this.definitionPanel.getNameText();
        String listSeparator = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "LaunchProcessPanel.ListSeparator");
        String formatApplies = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "LaunchProcessPanel.FormatForAppliesCriteria");
        String formatExcludes = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "LaunchProcessPanel.FormatForExcludesCriteria");
        TargetProcessMatch fileMatch = opProcessAccess.getOpTargetProcess().getOptTargetProcessMatch();
        if (fileMatch != null && fileMatch.getOpProcessMatchEntityCount() > 0) {
            StringBuilder fileMatchBuf = new StringBuilder();
            for (int i = 0; i < fileMatch.getOpProcessMatchEntityCount(); ++i) {
                fileMatchBuf.append(this.getKeyString(fileMatch.getOpProcessMatchEntity(i)));
                fileMatchBuf.append(listSeparator);
            }
            fileMatchStr = fileMatchBuf.toString();
            if (fileMatchStr != null && fileMatchStr.length() > 0) {
                fileMatchStr = fileMatchStr.substring(0, fileMatchStr.length() - 1);
            }
        } else {
            return this.NO_APPLY;
        }
        TargetProcessNoMatch fileNoMatch = opProcessAccess.getOpTargetProcess().getOptTargetProcessNoMatch();
        if (fileNoMatch != null) {
            StringBuilder fileNoMatchBuf = new StringBuilder();
            for (int i = 0; i < fileNoMatch.getOpProcessMatchEntityCount(); ++i) {
                fileNoMatchBuf.append(this.getKeyString(fileNoMatch.getOpProcessMatchEntity(i)));
                fileNoMatchBuf.append(listSeparator);
            }
            fileNoMatchStr = fileNoMatchBuf.toString();
            if (fileNoMatchStr != null && fileNoMatchStr.length() > 0) {
                fileNoMatchStr = fileNoMatchStr.substring(0, fileNoMatchStr.length() - 1);
            }
        }
        String fileMatchAppliesStr = null;
        if (fileMatchStr.length() > 0) {
            fileMatchAppliesStr = MessageFormat.format(formatApplies, name, fileMatchStr);
            fileMatchCombinedStr = (String)fileMatchCombinedStr + fileMatchAppliesStr + " ";
        }
        String fileMatchExcludesStr = null;
        if (fileNoMatchStr.length() > 0) {
            fileMatchExcludesStr = MessageFormat.format(formatExcludes, fileNoMatchStr);
            fileMatchCombinedStr = (String)fileMatchCombinedStr + fileMatchExcludesStr + " ";
        }
        OpAction actionRead = null;
        String resourceStr = "";
        OpCreateProcess creatProcess = opProcessAccess.getOptOpCreateProcess();
        if (creatProcess != null) {
            resourceStr = "LaunchProcessPanel.LaunchProcess";
            actionRead = creatProcess.getOpAction();
        }
        if ((terminateProcess = opProcessAccess.getOptOpTerminateProcess()) != null) {
            resourceStr = "LaunchProcessPanel.TermProcess";
            actionRead = terminateProcess.getOpAction();
        }
        launchStr = this.getOpActionSummary(actionRead, null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", resourceStr), null);
        return (String)fileMatchCombinedStr + launchStr;
    }

    private String getKeyString(OpProcessMatchEntity entry) {
        OpFileNameMatchEntity fileEntry = entry.getOptOpFileNameMatchEntity();
        if (Utility.getBooleanValue((Boolean)fileEntry.getOptEnable(), (Boolean)fileEntry.getDefEnable())) {
            return fileEntry.getKeyString();
        }
        OpFileChecksumMatchEntity csEntry = entry.getOptOpFileChecksumMatchEntity();
        if (Utility.getBooleanValue((Boolean)csEntry.getOptEnable(), (Boolean)csEntry.getDefEnable())) {
            return csEntry.getFileChecksum();
        }
        return "";
    }

    private void updateSummary() {
        this.jTASummary.setText(this.getSummary(this.opProcessAccess));
    }

    @Override
    public boolean isValidate(List<String> existNames) {
        return this.definitionPanel.isValidate(existNames);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return ((ContentSensitiveHelpPage)((Object)this.jTbPane.getSelectedComponent())).getContentSensitiveHelpToken();
    }
}

