/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpAction;
import com.sygate.scm.common.configobject.schema.OpAppliedOS;
import com.sygate.scm.common.configobject.schema.OpFileAccess;
import com.sygate.scm.common.configobject.schema.OpFileRead;
import com.sygate.scm.common.configobject.schema.OpFileWrite;
import com.sygate.scm.common.configobject.schema.TargetFileMatch;
import com.sygate.scm.common.configobject.schema.TargetFileNoMatch;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.osprotect.AccessRightsPanel;
import com.sygate.scm.console.ui.policy.osprotect.FileDefinitionPanel;
import com.sygate.scm.console.ui.policy.osprotect.PermissionPanelBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FilePanel
extends PermissionPanelBase
implements ChangeListener {
    private static final long serialVersionUID = 2239920062839896545L;
    private static final String NO_APPLY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.file.noApplies");
    private FileDefinitionPanel definitionPanel;
    private AccessRightsPanel accessPanel;
    private JTabbedPane jTbPane = new JTabbedPane();
    private OpFileAccess opFileAccess;

    public FilePanel(boolean isReadonly) {
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "FilePanel.action.description");
        String descriptionWrite = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "FilePanel.action.description.write");
        this.definitionPanel = new FileDefinitionPanel(this, isReadonly);
        this.accessPanel = new AccessRightsPanel(description, descriptionWrite, this, false, isReadonly);
        this.initialize(isReadonly);
    }

    @Override
    public void initData(ConfigObject opFileAccess) {
        this.opFileAccess = (OpFileAccess)opFileAccess;
        this.checkSchema((OpFileAccess)opFileAccess);
        this.definitionPanel.initData(opFileAccess);
        this.accessPanel.initData(((OpFileAccess)opFileAccess).getOptOpFileRead().getOpAction(), ((OpFileAccess)opFileAccess).getOptOpFileWrite().getOpAction());
        this.jTASummary.setText(this.getSummary((OpFileAccess)opFileAccess));
    }

    @Override
    public void commitData() {
        this.definitionPanel.commitData();
        this.accessPanel.commitData();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateSummary();
    }

    private void initialize(boolean isReadonly) {
        this.jTbPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "FilePanel.title.FileDef"), this.definitionPanel);
        this.jTbPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "FilePanel.title.AccessRightsAndRestrictions"), new JScrollPane(this.accessPanel));
        this.setLayout(new BorderLayout());
        this.add((Component)this.jTbPane, "Center");
        this.add((Component)this.getSummaryPanel(isReadonly), "South");
    }

    private void checkSchema(OpFileAccess opFileAccess) {
        if (opFileAccess.getOptOpFileRead() == null) {
            OpFileRead read = new OpFileRead();
            read.setOpAction(this.createOpAction());
            opFileAccess.setOptOpFileRead(read);
        }
        if (opFileAccess.getOptOpFileWrite() == null) {
            OpFileWrite write = new OpFileWrite();
            write.setOpAction(this.createOpAction());
            opFileAccess.setOptOpFileWrite(write);
        }
        if (opFileAccess.getOptOpAppliedOS() == null) {
            opFileAccess.setOptOpAppliedOS(new OpAppliedOS());
        }
    }

    private String getSummary(OpFileAccess opFileAccess) {
        String fileMatchStr = "";
        String fileNoMatchStr = "";
        Object fileMatchCombinedStr = "";
        String readStr = "";
        String name = this.definitionPanel.getNameText();
        String listSeparator = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "FilePanel.ListSeparator");
        String formatApplies = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "FilePanel.FormatForAppliesCriteria");
        String formatExcludes = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "FilePanel.FormatForExcludesCriteria");
        TargetFileMatch fileMatch = opFileAccess.getOpTargetFile().getOptTargetFileMatch();
        if (fileMatch != null && fileMatch.getOpFileMatchEntityCount() > 0) {
            StringBuilder fileMatchBuf = new StringBuilder();
            for (int i = 0; i < fileMatch.getOpFileMatchEntityCount(); ++i) {
                fileMatchBuf.append(fileMatch.getOpFileMatchEntity(i).getOptOpFileNameMatchEntity().getKeyString());
                fileMatchBuf.append(listSeparator);
            }
            fileMatchStr = fileMatchBuf.toString();
            if (fileMatchStr != null && fileMatchStr.length() > 0) {
                fileMatchStr = fileMatchStr.substring(0, fileMatchStr.length() - 1);
            }
        } else {
            return NO_APPLY;
        }
        TargetFileNoMatch fileNoMatch = opFileAccess.getOpTargetFile().getOptTargetFileNoMatch();
        if (fileNoMatch != null) {
            StringBuilder fileNoMatchBuf = new StringBuilder();
            for (int i = 0; i < fileNoMatch.getOpFileMatchEntityCount(); ++i) {
                fileNoMatchBuf.append(fileNoMatch.getOpFileMatchEntity(i).getOptOpFileNameMatchEntity().getKeyString());
                fileNoMatchBuf.append(listSeparator);
            }
            fileNoMatchStr = fileNoMatchBuf.toString();
            if (fileNoMatchStr != null && fileNoMatchStr.length() > 0) {
                fileNoMatchStr = fileNoMatchStr.substring(0, fileNoMatchStr.length() - 1);
            }
        }
        String fileMatchAppliesStr = null;
        if (fileMatchStr.length() > 0) {
            fileMatchAppliesStr = MessageFormat.format(formatApplies, name, fileMatchStr);
            fileMatchCombinedStr = (String)fileMatchCombinedStr + fileMatchAppliesStr + " ";
        }
        String fileMatchExcludesStr = null;
        if (fileNoMatchStr.length() > 0) {
            fileMatchExcludesStr = MessageFormat.format(formatExcludes, fileNoMatchStr);
            fileMatchCombinedStr = (String)fileMatchCombinedStr + fileMatchExcludesStr + " ";
        }
        OpAction actionRead = null;
        OpFileRead fileRead = opFileAccess.getOptOpFileRead();
        if (fileRead != null) {
            actionRead = fileRead.getOpAction();
        }
        OpAction actionWrite = null;
        OpFileWrite fileWrite = opFileAccess.getOptOpFileWrite();
        if (fileWrite != null) {
            actionWrite = fileWrite.getOpAction();
        }
        if (actionRead != null && actionWrite != null) {
            readStr = this.getOpActionSummary(actionRead, actionWrite, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "FilePanel.ReadAccess"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "FilePanel.WriteAccess"));
        }
        return (String)fileMatchCombinedStr + readStr;
    }

    private void updateSummary() {
        this.jTASummary.setText(this.getSummary(this.opFileAccess));
    }

    @Override
    public boolean isValidate(List<String> existNames) {
        return this.definitionPanel.isValidate(existNames);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        Component comp = this.jTbPane.getSelectedComponent();
        if (comp instanceof JScrollPane) {
            comp = ((JScrollPane)comp).getViewport().getComponent(0);
        }
        return ((ContentSensitiveHelpPage)((Object)comp)).getContentSensitiveHelpToken();
    }
}

