/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpFileAccess;
import com.sygate.scm.common.configobject.schema.OpFileMatchEntity;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpTargetFile;
import com.sygate.scm.common.configobject.schema.TargetFileMatch;
import com.sygate.scm.common.configobject.schema.TargetFileNoMatch;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.osprotect.DefinitionPanel;
import com.sygate.scm.console.ui.policy.osprotect.dialog.StringConditionEditorDlg;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ChangeListener;

public class FileDefinitionPanel
extends DefinitionPanel {
    private static final long serialVersionUID = 1959985218911387158L;
    private OpFileAccess opFileAccess;
    private OpTargetFile opTargetFile;
    private boolean isReadonly;

    public FileDefinitionPanel(ChangeListener summaryListener, boolean isReadonly) {
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.file.description");
        this.isReadonly = isReadonly;
        this.initialize(96, summaryListener, description, isReadonly);
    }

    public void initData(ConfigObject configuObj) {
        this.opFileAccess = (OpFileAccess)configuObj;
        this.opTargetFile = this.opFileAccess.getOpTargetFile();
        this.jTFName.setText(this.opFileAccess.getName());
        this.setTADesc(this.opFileAccess.getOptDescription());
        this.jCbxEnable.setSelected(Utility.getBooleanValue((Boolean)this.opFileAccess.getOptEnable(), (Boolean)this.opFileAccess.getDefEnable()));
        this.initMatchList();
        this.initNoMatchList();
    }

    public void commitData() {
        this.opFileAccess.setName(this.jTFName.getText().trim());
        this.opFileAccess.setOptDescription(this.jTADesc.getText().trim());
        this.opFileAccess.setOptEnable(Boolean.valueOf(this.jCbxEnable.isSelected()));
    }

    @Override
    protected void addMatch() {
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(1);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            TargetFileMatch tMatch = this.opTargetFile.getOptTargetFileMatch();
            if (tMatch == null) {
                tMatch = new TargetFileMatch();
            }
            OpFileMatchEntity fEntity = new OpFileMatchEntity();
            fEntity.setOptOpFileNameMatchEntity(fileEntity);
            tMatch.addOpFileMatchEntity(fEntity);
            this.opTargetFile.setOptTargetFileMatch(tMatch);
            DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
            model.addElement(this.getDisplayString(fileEntity, null, null));
        }
        dlg.dispose();
    }

    @Override
    protected void editMatch() {
        TargetFileMatch tMatch;
        int selIndex = this.jLMatch.getMinSelectionIndex();
        try {
            tMatch = (TargetFileMatch)PolicyHandler.getCopyOfObj((ConfigObject)this.opTargetFile.getOptTargetFileMatch());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return;
        }
        OpFileMatchEntity fEntity = tMatch.getOpFileMatchEntity(selIndex);
        OpFileNameMatchEntity file = fEntity.getOptOpFileNameMatchEntity();
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(1, file, null, null, this.isReadonly);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            tMatch = this.opTargetFile.getOptTargetFileMatch();
            fEntity = tMatch.getOpFileMatchEntity(selIndex);
            fEntity.setOptOpFileNameMatchEntity(fileEntity);
            DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
            model.setElementAt(this.getDisplayString(fileEntity, null, null), selIndex);
        }
        dlg.dispose();
    }

    @Override
    protected void deleteMatch() {
        int i;
        if (!this.canDelete(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "FileDefinitionPanel.title.DelMatchingFileDef"))) {
            return;
        }
        ArrayList itemList = new ArrayList();
        ArrayList<OpFileMatchEntity> sEntityList = new ArrayList<OpFileMatchEntity>();
        TargetFileMatch tMatch = this.opTargetFile.getOptTargetFileMatch();
        for (i = this.jLMatch.getMinSelectionIndex(); i <= this.jLMatch.getMaxSelectionIndex(); ++i) {
            if (!this.jLMatch.isSelectedIndex(i)) continue;
            itemList.add(this.jLMatch.getModel().getElementAt(i));
            sEntityList.add(tMatch.getOpFileMatchEntity(i));
        }
        i = itemList.size();
        while (--i >= 0) {
            ((DefaultListModel)this.jLMatch.getModel()).removeElement(itemList.get(i));
            tMatch.removeOpFileMatchEntity((OpFileMatchEntity)sEntityList.get(i));
        }
        this.matchListSelected();
    }

    @Override
    protected void addNoMatch() {
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(1);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            TargetFileNoMatch tNoMatch = this.opTargetFile.getOptTargetFileNoMatch();
            if (tNoMatch == null) {
                tNoMatch = new TargetFileNoMatch();
            }
            OpFileMatchEntity fEntity = new OpFileMatchEntity();
            fEntity.setOptOpFileNameMatchEntity(fileEntity);
            tNoMatch.addOpFileMatchEntity(fEntity);
            this.opTargetFile.setOptTargetFileNoMatch(tNoMatch);
            DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
            model.addElement(this.getDisplayString(fileEntity, null, null));
        }
        dlg.dispose();
    }

    @Override
    protected void editNoMatch() {
        TargetFileNoMatch tNoMatch;
        int selIndex = this.jLNoMatch.getMinSelectionIndex();
        try {
            tNoMatch = (TargetFileNoMatch)PolicyHandler.getCopyOfObj((ConfigObject)this.opTargetFile.getOptTargetFileNoMatch());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return;
        }
        OpFileMatchEntity fEntity = tNoMatch.getOpFileMatchEntity(selIndex);
        OpFileNameMatchEntity file = fEntity.getOptOpFileNameMatchEntity();
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(1, file, null, null, this.isReadonly);
        if (dlg.isOk()) {
            OpFileNameMatchEntity fileEntity = dlg.getFileNameMatchEntity();
            tNoMatch = this.opTargetFile.getOptTargetFileNoMatch();
            fEntity = tNoMatch.getOpFileMatchEntity(selIndex);
            fEntity.setOptOpFileNameMatchEntity(fileEntity);
            DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
            model.setElementAt(this.getDisplayString(fileEntity, null, null), selIndex);
        }
        dlg.dispose();
    }

    @Override
    protected void deleteNoMatch() {
        int i;
        if (!this.canDelete(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "FileDefinitionPanel.title.DelNonMatchingFileDef"))) {
            return;
        }
        ArrayList itemList = new ArrayList();
        ArrayList<OpFileMatchEntity> sEntityList = new ArrayList<OpFileMatchEntity>();
        TargetFileNoMatch tNoMatch = this.opTargetFile.getOptTargetFileNoMatch();
        for (i = this.jLNoMatch.getMinSelectionIndex(); i <= this.jLNoMatch.getMaxSelectionIndex(); ++i) {
            if (!this.jLNoMatch.isSelectedIndex(i)) continue;
            itemList.add(this.jLNoMatch.getModel().getElementAt(i));
            sEntityList.add(tNoMatch.getOpFileMatchEntity(i));
        }
        for (i = 0; i < itemList.size(); ++i) {
            ((DefaultListModel)this.jLNoMatch.getModel()).removeElement(itemList.get(i));
            tNoMatch.removeOpFileMatchEntity((OpFileMatchEntity)sEntityList.get(i));
        }
        this.noMatchListSelected();
    }

    private void initMatchList() {
        DefaultListModel model = (DefaultListModel)this.jLMatch.getModel();
        model.clear();
        TargetFileMatch tMatch = this.opTargetFile.getOptTargetFileMatch();
        if (tMatch != null) {
            for (int i = 0; i < tMatch.getOpFileMatchEntityCount(); ++i) {
                OpFileMatchEntity fEntity = tMatch.getOpFileMatchEntity(i);
                OpFileNameMatchEntity fnEntity = fEntity.getOptOpFileNameMatchEntity();
                model.addElement(this.getDisplayString(fnEntity, null, null));
            }
        }
        this.matchListSelected();
    }

    private void initNoMatchList() {
        DefaultListModel model = (DefaultListModel)this.jLNoMatch.getModel();
        model.clear();
        TargetFileNoMatch tNoMatch = this.opTargetFile.getOptTargetFileNoMatch();
        if (tNoMatch != null) {
            for (int i = 0; i < tNoMatch.getOpFileMatchEntityCount(); ++i) {
                OpFileMatchEntity fEntity = tNoMatch.getOpFileMatchEntity(i);
                OpFileNameMatchEntity fnEntity = fEntity.getOptOpFileNameMatchEntity();
                model.addElement(this.getDisplayString(fnEntity, null, null));
            }
        }
        this.noMatchListSelected();
    }

    public boolean isValidate(List<String> existNames) {
        existNames.remove(this.opFileAccess.getName());
        return this.isValidName(existNames, false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hdp_hardware_device_protection_add_file_definition";
    }
}

