/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.AppProtectionSetting;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.OpBlockedDeviceClassArray;
import com.sygate.scm.common.configobject.schema.OpDeviceBlocker;
import com.sygate.scm.common.configobject.schema.OpDeviceBlockerNotification;
import com.sygate.scm.common.configobject.schema.OpExcludedDeviceArray;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.UsbDeviceHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AppProtectionPolicyObject;
import com.sygate.scm.console.logicobject.DeviceObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.DeviceSelectDlg;
import com.sygate.scm.console.ui.policy.osprotect.DeviceBlockTablePopupMenu;
import com.sygate.scm.console.ui.policy.osprotect.dialog.DeviceManagerNotificationMsgDlg;
import com.sygate.scm.console.ui.util.CustomTableModel;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class DeviceBlockPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -4401175411576031043L;
    private static final float[] COL_SIZE = new float[]{0.1f, 0.5f, 0.2f, 0.2f};
    private static final String[] DEVICEMANAGER_COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.column.DeviceName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.column.Identification")};
    public static final int INDEX_NAME = 0;
    public static final int INDEX_ID = 1;
    public static final int INDEX_INDEFICATION = 2;
    private static final int[] TABLE_COLUMN_MAP = new int[]{0, 2};
    private static final String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.description");
    private static final String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.title");
    private SortableTableModel blockModel = new SortableTableModel();
    private JTable jTBlock = new StripesTable(this.blockModel);
    private SortableTableModel noBlockModel = new SortableTableModel();
    private JTable jTNoBlock = new StripesTable(this.noBlockModel);
    private JButton jBAddBlock = new JButton(UIText.get(5));
    private JButton jBDeleteBlock = new JButton(UIText.get(769));
    private JButton jBAddNoBlock = new JButton(UIText.get(5));
    private JButton jBDeleteNoBlock = new JButton(UIText.get(769));
    private JCheckBox jCbxLog = new JCheckBox(UIText.get(2820));
    private JCheckBox jCbxNotify = new JCheckBox(UIText.get(3330));
    private JButton jBNotify = new JButton(UIText.get(4619));
    private String notifyMessage = "";

    public DeviceBlockPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 0));
        this.add((Component)this.getDescriptionPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getDevicesPanel(true, this.jTBlock, this.jBAddBlock, this.jBDeleteBlock), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getDevicesPanel(false, this.jTNoBlock, this.jBAddNoBlock, this.jBDeleteNoBlock), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.getNotifyPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(30, 0, 0, 0), 0, 0));
    }

    public void initDeviceData(AppProtectionPolicyObject opObj) {
        OpDeviceBlocker deviceBlocker;
        AppProtectionSetting opSetting;
        if (opObj != null && (opSetting = opObj.getOptAppProtectionSetting()) != null && (deviceBlocker = opSetting.getOptOpDeviceBlocker()) != null) {
            boolean log = deviceBlocker.getOptLogIt() == null ? deviceBlocker.getDefLogIt() : deviceBlocker.getOptLogIt();
            this.jCbxLog.setSelected(log);
            OpDeviceBlockerNotification notification = deviceBlocker.getOptOpDeviceBlockerNotification();
            if (notification != null) {
                boolean enabledNotification = notification.getOptEnable() == null ? notification.getDefEnable() : notification.getOptEnable();
                this.jCbxNotify.setSelected(enabledNotification);
                this.notifyMessage = notification.getOptAdditionalText();
                if (this.notifyMessage == null) {
                    this.notifyMessage = "";
                }
            }
            this.blockModel.removeAll();
            this.noBlockModel.removeAll();
            try {
                Hashtable<String, ArrayList<DeviceObject>> lists = UsbDeviceHandler.getDevicesFromOSProtecteionPolicy((OpAppProtectionPolicy)opObj.getSchemaObj(), 0);
                if (lists != null) {
                    DeviceObject o;
                    int i;
                    ArrayList<DeviceObject> listDevices = lists.get("BLOCK");
                    if (listDevices != null) {
                        for (i = 0; i < listDevices.size(); ++i) {
                            o = listDevices.get(i);
                            this.blockModel.addRow(o);
                        }
                    }
                    if ((listDevices = lists.get("ALLOW")) != null) {
                        for (i = 0; i < listDevices.size(); ++i) {
                            o = listDevices.get(i);
                            this.noBlockModel.addRow(o);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        this.tableSelected(this.jTBlock, this.jBDeleteBlock);
        this.tableSelected(this.jTNoBlock, this.jBDeleteNoBlock);
        this.notifyTypeChanged();
    }

    public void updateOpDeviceBlocker(OpAppProtectionPolicy policy) {
        OpExcludedDeviceArray allowedDevices;
        if (policy == null) {
            return;
        }
        List listBlockedDevices = (List)Cast.cast(this.blockModel.getAllRows());
        boolean hasBlockedDevices = listBlockedDevices.size() > 0;
        List listAllowedDevices = (List)Cast.cast(this.noBlockModel.getAllRows());
        boolean hasAllowedDevices = listAllowedDevices.size() > 0;
        AppProtectionSetting setting = policy.getAppProtectionSetting();
        OpDeviceBlocker deviceBlocker = setting.getOptOpDeviceBlocker();
        if (deviceBlocker == null) {
            deviceBlocker = new OpDeviceBlocker();
            setting.setOptOpDeviceBlocker(deviceBlocker);
        }
        deviceBlocker.setOptEnable(Boolean.TRUE);
        deviceBlocker.setOptLogIt(Boolean.valueOf(this.jCbxLog.isSelected()));
        OpDeviceBlockerNotification notification = deviceBlocker.getOptOpDeviceBlockerNotification();
        if (notification == null) {
            notification = new OpDeviceBlockerNotification();
            deviceBlocker.setOptOpDeviceBlockerNotification(notification);
        }
        notification.setOptEnable(Boolean.valueOf(this.jCbxNotify.isSelected()));
        notification.setOptAdditionalText(this.notifyMessage);
        OpBlockedDeviceClassArray blockedDevices = deviceBlocker.getOptOpBlockedDeviceClassArray();
        if (blockedDevices != null) {
            deviceBlocker.removeChild((AbstractSchema)blockedDevices);
        }
        if (hasBlockedDevices) {
            blockedDevices = new OpBlockedDeviceClassArray();
            blockedDevices.setOptEnable(Boolean.TRUE);
            deviceBlocker.setOptOpBlockedDeviceClassArray(blockedDevices);
            for (int i = 0; i < listBlockedDevices.size(); ++i) {
                DeviceObject device = (DeviceObject)listBlockedDevices.get(i);
                ObjReference ref = new ObjReference();
                ref.setName("DeviceToBeBlocked");
                ref.setTargetType("OpDevice");
                ref.setTargetId(device.getId());
                blockedDevices.addObjReference(ref);
            }
        }
        if ((allowedDevices = deviceBlocker.getOptOpExcludedDeviceArray()) != null) {
            deviceBlocker.removeChild((AbstractSchema)allowedDevices);
        }
        if (hasAllowedDevices) {
            allowedDevices = new OpExcludedDeviceArray();
            allowedDevices.setOptEnable(Boolean.TRUE);
            deviceBlocker.setOptOpExcludedDeviceArray(allowedDevices);
            for (int i = 0; i < listAllowedDevices.size(); ++i) {
                DeviceObject device = (DeviceObject)listAllowedDevices.get(i);
                ObjReference ref = new ObjReference();
                ref.setName("DeviceToBeExcluded");
                ref.setTargetType("OpDevice");
                ref.setTargetId(device.getId());
                allowedDevices.addObjReference(ref);
            }
        }
    }

    protected void addDevice(TableModel model, boolean isBlock) {
        List selectedBlockedDevices = (List)Cast.cast(this.blockModel.getAllRows());
        List selectedAllowedDevices = (List)Cast.cast(this.noBlockModel.getAllRows());
        ArrayList<DeviceObject> selectedDevices = new ArrayList<DeviceObject>(selectedBlockedDevices);
        selectedDevices.addAll(selectedAllowedDevices);
        String[] tableColumnName = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.column.DeviceName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.column.Identification")};
        int[] tableColumnMap = new int[]{0, 2};
        float[] tableColumnWidth = new float[]{1.0f, 1.0f};
        String sTile = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.DeviceSelectionDlg.title");
        DeviceSelectDlg dlg = new DeviceSelectDlg(sTile, tableColumnName, tableColumnMap, tableColumnWidth, selectedDevices, "ALL", 2);
        if (!dlg.isCancel()) {
            ArrayList<DeviceObject> resultListFromDlg = dlg.getSelection();
            for (int iResult = 0; iResult < resultListFromDlg.size(); ++iResult) {
                DeviceObject selectedObject = resultListFromDlg.get(iResult);
                if (selectedObject == null) continue;
                int count = selectedDevices.size();
                boolean found = false;
                for (int i = 0; i < count; ++i) {
                    DeviceObject row = selectedDevices.get(i);
                    if (!row.equals(selectedObject)) continue;
                    String strPropertyName = "";
                    strPropertyName = selectedBlockedDevices.contains(row) ? "DeviceBlockPanel.label.BlockedDevices" : "DeviceBlockPanel.label.DevicesExcludedromBlocking";
                    String strListName = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", strPropertyName);
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.warning.DeviceAlreadyInList"), row.getName(), strListName), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.title.Warning"), 0);
                    found = true;
                    break;
                }
                if (found) continue;
                ((SortableTableModel)model).addRow(selectedObject);
            }
        }
        this.refreshDeviceInfo(this.blockModel);
        this.refreshDeviceInfo(this.noBlockModel);
    }

    protected void deleteDevice(boolean blocked) {
        SortableTableModel model;
        if (JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.ConfirmDeleteDeviceID"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.title.DelDeviceID"), 0) != 0) {
            return;
        }
        JTable table = blocked ? this.jTBlock : this.jTNoBlock;
        SortableTableModel sortableTableModel = model = blocked ? this.blockModel : this.noBlockModel;
        while (table.getSelectedRow() > -1) {
            model.removeRow(table.getSelectedRow());
        }
    }

    private JPanel getDescriptionPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new AvTemplatePane(title, description, false), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getDevicesPanel(final boolean isBlock, final JTable table, JButton add, JButton delete) {
        this.initializeTable(table, table.getModel(), delete);
        table.addMouseListener(this.getMouseListener(isBlock));
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceBlockPanel.this.addDevice(table.getModel(), e.getSource() != DeviceBlockPanel.this.jBAddBlock);
            }
        });
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceBlockPanel.this.deleteDevice(isBlock);
            }
        });
        JPanel buttonPanel = new JPanel();
        UIUtilities.layoutButtonPanel(buttonPanel, new JButton[]{add, delete}, 0, 4, true, false);
        String title = isBlock ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.label.BlockedDevices") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.label.DevicesExcludedromBlocking");
        String message = isBlock ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.label.BlockedDevicesMess") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceBlockPanel.label.DevicesExcludedromBlockingMess");
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTable)table);
        scrollPane.addMouseListener(this.getMouseListener(isBlock));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new AvTemplatePane(title, message, false), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 0, 20), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 20), 0, 0));
        return panel;
    }

    private JPanel getNotifyPanel() {
        this.jCbxNotify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceBlockPanel.this.notifyTypeChanged();
            }
        });
        this.jBNotify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceBlockPanel.this.addDeviceNotificationMessage();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jCbxLog, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxNotify, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jBNotify, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private void initializeTable(final JTable table, TableModel model, final JButton delete) {
        ((SortableTableModel)model).setColumnNames(DEVICEMANAGER_COL_NAMES);
        ((SortableTableModel)model).setColumnMapping(TABLE_COLUMN_MAP);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DeviceBlockPanel.this.tableSelected(table, delete);
            }
        });
        table.getSelectionModel().setSelectionMode(2);
        Dimension size = table.getPreferredScrollableViewportSize();
        table.setPreferredScrollableViewportSize(new Dimension(size.width * 2 / 3, (table.getRowHeight() + table.getRowMargin()) * 5));
        UIUtilities.setTableColumnWidth(table, COL_SIZE, (int)table.getPreferredScrollableViewportSize().getWidth());
    }

    private void tableSelected(JTable table, JButton delete) {
        delete.setEnabled(table.getSelectedRowCount() > 0);
    }

    private void notifyTypeChanged() {
        this.jBNotify.setEnabled(this.jCbxNotify.isSelected());
    }

    private void addDeviceNotificationMessage() {
        DeviceManagerNotificationMsgDlg dlg = new DeviceManagerNotificationMsgDlg(this.notifyMessage);
        if (dlg.isOk()) {
            this.notifyMessage = dlg.getMessage();
        }
        dlg.dispose();
    }

    private void refreshDeviceInfo(CustomTableModel model) {
        List selectedDevices = (List)Cast.cast(model.getAllRows());
        try {
            ArrayList<DeviceObject> newDevices = UsbDeviceHandler.refreshDevices(selectedDevices);
            model.removeAll();
            if (newDevices == null || newDevices.size() < 1) {
                return;
            }
            for (DeviceObject o : newDevices) {
                model.addRow(o);
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private MouseListener getMouseListener(boolean isBlock) {
        if (isBlock) {
            return new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (DeviceBlockPanel.this.jTBlock.isEnabled()) {
                        DeviceBlockPanel.this.showPopupMenu(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (DeviceBlockPanel.this.jTBlock.isEnabled()) {
                        DeviceBlockPanel.this.showPopupMenu(e);
                    }
                }
            };
        }
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DeviceBlockPanel.this.jTNoBlock.isEnabled()) {
                    DeviceBlockPanel.this.showNoBlockPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DeviceBlockPanel.this.jTNoBlock.isEnabled()) {
                    DeviceBlockPanel.this.showNoBlockPopupMenu(e);
                }
            }
        };
    }

    private void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int rowIndex = this.jTBlock.rowAtPoint(e.getPoint());
            if (rowIndex != -1) {
                this.jTBlock.setRowSelectionInterval(rowIndex, rowIndex);
            }
            DeviceBlockTablePopupMenu menu = new DeviceBlockTablePopupMenu(this, this.jTBlock, true);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void showNoBlockPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int rowIndex = this.jTNoBlock.rowAtPoint(e.getPoint());
            if (rowIndex != -1) {
                this.jTNoBlock.setRowSelectionInterval(rowIndex, rowIndex);
            }
            DeviceBlockTablePopupMenu menu = new DeviceBlockTablePopupMenu(this, this.jTNoBlock, false);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void setReadOnly() {
        this.jTBlock.setEnabled(false);
        this.jBAddBlock.setEnabled(false);
        this.jBDeleteBlock.setEnabled(false);
        this.jTNoBlock.setEnabled(false);
        this.jBAddNoBlock.setEnabled(false);
        this.jBDeleteNoBlock.setEnabled(false);
        this.jCbxLog.setEnabled(false);
        this.jCbxNotify.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hdp_device_block";
    }
}

