/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.schema.OpFileChecksumMatchEntity;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpProcessArgumentMatchEntity;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.osprotect.DefinitionPanelListPopupMenu;
import com.sygate.scm.console.ui.policy.osprotect.DefinitionPanelNoListPopupMenu;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class DefinitionPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 5491328724518966668L;
    private static final int LIST_VISIBLE_ROW_COUNT = 4;
    protected MultiLineLabel jLabelDesc;
    protected JList<String> jLMatch = new JList(new DefaultListModel());
    protected JList<String> jLNoMatch = new JList(new DefaultListModel());
    protected JTextField jTFName = new JTextField();
    protected JTextArea jTADesc = new JTextArea(4, 50);
    protected JCheckBox jCbxEnable = new JCheckBox("", true);
    protected JLabel warnLabel = new JLabel("");
    private JButton jBAddMatch = new JButton(UIText.get(5));
    private JButton jBEditMatch = new JButton(UIText.get(1024));
    private JButton jBDeleteMatch = new JButton(UIText.get(769));
    private JButton jBAddNoMatch = new JButton(UIText.get(5));
    private JButton jBEditNoMatch = new JButton(UIText.get(1024));
    private JButton jBDeleteNoMatch = new JButton(UIText.get(769));
    protected ChangeListener summaryListener;
    private boolean isReadonly;

    protected abstract void addMatch();

    protected abstract void editMatch();

    protected abstract void deleteMatch();

    protected abstract void addNoMatch();

    protected abstract void editNoMatch();

    protected abstract void deleteNoMatch();

    protected void initialize(int type, ChangeListener summaryListener, String description, boolean isReadonly) {
        this.summaryListener = summaryListener;
        this.jLabelDesc = new MultiLineLabel(description);
        this.isReadonly = isReadonly;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel top = this.getTopPanel(type);
        this.add((Component)top, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getMatchPanel(type), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getNoMatchPanel(type), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (isReadonly) {
            isReadonly = true;
            UIUtilities.setContainerStatus(top, false);
            this.jBAddMatch.setEnabled(false);
            this.jBAddNoMatch.setEnabled(false);
        }
    }

    protected String getNameText() {
        return this.jTFName.getText();
    }

    protected void matchListSelected() {
        boolean isSelected = this.jLMatch.getSelectedIndex() != -1;
        this.jBEditMatch.setEnabled(isSelected);
        this.jBDeleteMatch.setEnabled(isSelected && !this.isReadonly);
    }

    protected void noMatchListSelected() {
        boolean isSelected = this.jLNoMatch.getSelectedIndex() != -1;
        this.jBEditNoMatch.setEnabled(isSelected);
        this.jBDeleteNoMatch.setEnabled(isSelected && !this.isReadonly);
    }

    protected String getDisplayString(OpFileNameMatchEntity fileEntity, OpFileChecksumMatchEntity checksumEntity, OpProcessArgumentMatchEntity arguEntity) {
        String key = "";
        String checksum = "";
        String procArg = "";
        if (Utility.getBooleanValue((Boolean)fileEntity.getOptEnable(), (Boolean)fileEntity.getDefEnable())) {
            key = Utility.getBooleanValue((Boolean)fileEntity.getOptEnableDriveTypes(), (Boolean)fileEntity.getDefEnableDriveTypes()) ? MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.FileAndEnableDrvTypesFormat"), fileEntity.getKeyString()) : fileEntity.getKeyString();
        }
        if (checksumEntity != null && Utility.getBooleanValue((Boolean)checksumEntity.getOptEnable(), (Boolean)checksumEntity.getDefEnable())) {
            checksum = checksumEntity.getFileChecksum();
        }
        if (arguEntity != null && Utility.getBooleanValue((Boolean)arguEntity.getOptEnable(), (Boolean)arguEntity.getDefEnable())) {
            procArg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.HasProcArg");
        }
        return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.FileThenChecksumThenHasProcArgFormat"), key, checksum, procArg);
    }

    protected boolean isValidName(List<String> existNames, boolean isRule) {
        String name = this.jTFName.getText().trim();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.error.EmptyName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.title.Error"), 0);
            this.jTFName.requestFocusInWindow();
            return false;
        }
        for (int i = 0; i < existNames.size(); ++i) {
            if (!name.equalsIgnoreCase(existNames.get(i))) continue;
            String message = "";
            message = isRule ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.error.RuleNameInUse") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.error.CriterionNameInUse");
            JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.title.Error"), 0);
            this.jTFName.requestFocusInWindow();
            return false;
        }
        return true;
    }

    protected boolean canDelete(String title) {
        int retCode = JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.ConfirmDeleteSelected"), title, 0, 3);
        return retCode == 0;
    }

    protected void setTADesc(String desc) {
        if (desc != null) {
            desc = desc.length() > 1024 ? desc.substring(0, 1024) : desc;
        }
        this.jTADesc.setText(desc);
    }

    private JPanel getTopPanel(int type) {
        String labelText = "";
        int yIndex = 0;
        int ruleGridWidth = 2;
        int ruleGridConstraint = 2;
        double ruleWeight = 1.0;
        RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(255);
        nameDoc.setValidator("\"/\\*?<>|:", false);
        this.jTFName.setDocument(nameDoc);
        nameDoc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DefinitionPanel.this.summaryChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DefinitionPanel.this.summaryChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DefinitionPanel.this.summaryChange();
            }
        });
        RestrictedPlainDocument descDoc = new RestrictedPlainDocument(1024);
        descDoc.setValidator("\"`", false);
        this.jTADesc.setDocument(descDoc);
        this.jTADesc.setWrapStyleWord(true);
        this.jTADesc.setLineWrap(true);
        String enable = "";
        if (type == 94) {
            enable = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.checkbox.EnableProcRule");
            yIndex = 0;
            ruleGridWidth = 2;
            ruleGridConstraint = 2;
            ruleWeight = 1.0;
        } else {
            enable = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.checkbox.EnableCriterion");
            yIndex = 0;
            ruleGridWidth = 2;
            ruleGridConstraint = 0;
            ruleWeight = 0.0;
        }
        this.jCbxEnable.setText(enable);
        switch (type) {
            case 94: {
                labelText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.label.SpecifyRuleProcess");
                break;
            }
            case 96: {
                labelText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.label.SpecifyOneFile");
                break;
            }
            case 95: {
                labelText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.label.SpecifyOneRegistry");
                break;
            }
            case 97: {
                labelText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.label.SpecifyOneSystemProcess");
                break;
            }
            case 99: {
                labelText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.label.SpecifyOneModule");
                break;
            }
            case 98: {
                labelText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.label.SpecifyTerminateProcess");
                break;
            }
        }
        this.warnLabel = new JLabel(labelText);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jLabelDesc, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(type == 94 ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.label.RuleName") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.label.Comments")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.label.Description")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        JScrollPane scroll = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scroll, (JTextArea)this.jTADesc);
        panel.add((Component)scroll, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxEnable, new GridBagConstraints(yIndex, 3, ruleGridWidth, 1, ruleWeight, 0.0, 17, ruleGridConstraint, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getMatchPanel(int type) {
        this.jLMatch.setVisibleRowCount(4);
        this.jLMatch.setSelectionMode(2);
        this.jLMatch.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DefinitionPanel.this.matchListSelected();
                }
            }
        });
        MouseListener listener = this.getMouseListener();
        this.jLMatch.addMouseListener(listener);
        this.jBAddMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefinitionPanel.this.addMatch();
                DefinitionPanel.this.summaryChange();
            }
        });
        this.jBEditMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefinitionPanel.this.editMatch();
                DefinitionPanel.this.summaryChange();
            }
        });
        this.jBDeleteMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefinitionPanel.this.deleteMatch();
                DefinitionPanel.this.summaryChange();
            }
        });
        JPanel buttonPanel = new JPanel();
        UIUtilities.layoutButtonPanel(buttonPanel, new JButton[]{this.jBAddMatch, this.jBEditMatch, this.jBDeleteMatch}, 1, 1, true, false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.getMatchPanelLabel(type)), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        JScrollPane matchScrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)matchScrollPane, this.jLMatch);
        matchScrollPane.addMouseListener(listener);
        panel.add((Component)matchScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getNoMatchPanel(int type) {
        this.jLNoMatch.setVisibleRowCount(4);
        this.jLNoMatch.setSelectionMode(2);
        this.jLNoMatch.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DefinitionPanel.this.noMatchListSelected();
                }
            }
        });
        MouseListener listener = this.getMouseListenerNo();
        this.jLNoMatch.addMouseListener(listener);
        this.jBAddNoMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefinitionPanel.this.addNoMatch();
                DefinitionPanel.this.summaryChange();
            }
        });
        this.jBEditNoMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefinitionPanel.this.editNoMatch();
                DefinitionPanel.this.summaryChange();
            }
        });
        this.jBDeleteNoMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefinitionPanel.this.deleteNoMatch();
                DefinitionPanel.this.summaryChange();
            }
        });
        JPanel buttonPanel = new JPanel();
        UIUtilities.layoutButtonPanel(buttonPanel, new JButton[]{this.jBAddNoMatch, this.jBEditNoMatch, this.jBDeleteNoMatch}, 1, 1, true, false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.getNoMatchPanelLabel(type)), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, this.jLNoMatch);
        scrollPane.addMouseListener(listener);
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private String getMatchPanelLabel(int type) {
        switch (type) {
            case 94: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.ApplyRulesToProcs_1");
            }
            case 97: 
            case 98: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.ApplyRulesToProcs");
            }
            case 95: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.ApplyRulesToRegs");
            }
            case 96: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.ApplyRulesToFiles");
            }
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.ApplyRulesToModules");
    }

    private String getNoMatchPanelLabel(int type) {
        switch (type) {
            case 94: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.NoApplyRulesToProcs_1");
            }
            case 97: 
            case 98: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.NoApplyRulesToProcs");
            }
            case 95: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.NoApplyRulesToRegs");
            }
            case 96: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.NoApplyRulesToFiles");
            }
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DefinitionPanel.NoApplyRulesToModules");
    }

    private MouseListener getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DefinitionPanel.this.showPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DefinitionPanel.this.showPopupMenu(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (DefinitionPanel.this.jLMatch.getSelectedIndex() == -1) {
                        return;
                    }
                    DefinitionPanel.this.editMatch();
                    DefinitionPanel.this.summaryChange();
                }
            }
        };
    }

    private MouseListener getMouseListenerNo() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DefinitionPanel.this.showPopupMenuNo(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DefinitionPanel.this.showPopupMenuNo(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (DefinitionPanel.this.jLNoMatch.getSelectedIndex() == -1) {
                        return;
                    }
                    DefinitionPanel.this.editNoMatch();
                    DefinitionPanel.this.summaryChange();
                }
            }
        };
    }

    private void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            DefinitionPanelListPopupMenu menu = new DefinitionPanelListPopupMenu(this, this.jLMatch, this.isReadonly);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void showPopupMenuNo(MouseEvent e) {
        if (e.isPopupTrigger()) {
            DefinitionPanelNoListPopupMenu menu = new DefinitionPanelNoListPopupMenu(this, this.jLNoMatch, this.isReadonly);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void summaryChange() {
        if (this.summaryListener != null) {
            this.summaryListener.stateChanged(new ChangeEvent(this));
        }
    }
}

