/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.OpAppRule;
import com.sygate.scm.common.configobject.schema.OpFileAccess;
import com.sygate.scm.common.configobject.schema.OpModuleAccess;
import com.sygate.scm.common.configobject.schema.OpPermissionList;
import com.sygate.scm.common.configobject.schema.OpProcess;
import com.sygate.scm.common.configobject.schema.OpProcessAccess;
import com.sygate.scm.common.configobject.schema.OpRegistryAccess;
import com.sygate.scm.common.configobject.schema.OpTargetFile;
import com.sygate.scm.common.configobject.schema.OpTargetModule;
import com.sygate.scm.common.configobject.schema.OpTargetProcess;
import com.sygate.scm.common.configobject.schema.OpTargetRegistry;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionTreeModel;
import com.sygate.scm.console.ui.policy.osprotect.OSProtectionTreeUserObject;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpAppProtectionBlockObject;
import com.sygate.scm.console.ui.policy.osprotect.logicobject.OpPermissionListObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.GUIDGenerator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class AddRulePermissionMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1224228898232763714L;
    private static final String DEFAULT_RULE_NAME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.defaultRuleName");
    private static final String DEFAULT_REGISTRY_ACCESS_NAME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.defaultAccessRegistryName");
    private static final String DEFAULT_FILE_ACCESS_NAME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.defaultAccessFileName");
    private static final String DEFAULT_LAUNCH_PROCESS_ACCESS_NAME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.defaultLaunchProcessName");
    private static final String DEFAULT_TERMINATE_PROCESS_ACCESS_NAME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.defaultPreventProcessTerminationName");
    private static final String DEFAULT_MODULE_ACCESS_NAME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.defaultLoadDLLName");
    protected JMenuItem jMIRule = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.menu.AppRule"));
    protected JMenuItem jMIFile = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.menu.FileAccess"));
    protected JMenuItem jMIRegistry = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.menu.RegAccess"));
    protected JMenuItem jMILaunch = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.menu.LaunchProcess"));
    protected JMenuItem jMITerminate = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.menu.TermProcess"));
    protected JMenuItem jMIModule = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.menu.LoadDLL"));
    protected JMenu jMCondition = new JMenu(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AddRulePermissionMenu.menu.Permission"));
    protected JTree tree;
    protected OSProtectionTreeModel model;

    public AddRulePermissionMenu(JTree tree) {
        this.tree = tree;
        this.model = (OSProtectionTreeModel)tree.getModel();
        this.initialize();
    }

    protected AddRulePermissionMenu(JTree tree, boolean dummy) {
        this.tree = tree;
        this.model = (OSProtectionTreeModel)tree.getModel();
    }

    protected void setupMenuItemListener() {
        this.jMIRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRulePermissionMenu.this.addRule();
            }
        });
        this.jMIFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRulePermissionMenu.this.addFileAccess();
            }
        });
        this.jMIRegistry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRulePermissionMenu.this.addRegistry();
            }
        });
        this.jMILaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRulePermissionMenu.this.addProcess(true);
            }
        });
        this.jMITerminate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRulePermissionMenu.this.addProcess(false);
            }
        });
        this.jMIModule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRulePermissionMenu.this.addModule();
            }
        });
    }

    protected void setupMenuItems() {
        if (this.tree.getSelectionPath() == null || ((DefaultMutableTreeNode)this.model.getRoot()).getChildCount() == 0) {
            this.add(this.jMIRule);
            return;
        }
        this.jMCondition.add(this.jMIRegistry);
        this.jMCondition.add(this.jMIFile);
        this.jMCondition.add(this.jMILaunch);
        this.jMCondition.add(this.jMITerminate);
        this.jMCondition.add(this.jMIModule);
        this.add(this.jMIRule);
        this.add(this.jMCondition);
    }

    protected void nodeAdded(TreePath path) {
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
        UIUtilities.expandNodeAndChildrenInTree(this.tree, (DefaultMutableTreeNode)path.getLastPathComponent());
        this.model.nodeChanged((DefaultMutableTreeNode)path.getLastPathComponent());
    }

    protected DefaultMutableTreeNode getRuleNode() {
        DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (!((OSProtectionTreeUserObject)ruleNode.getUserObject()).isOpAppRule()) {
            ruleNode = (DefaultMutableTreeNode)ruleNode.getParent();
        }
        return ruleNode;
    }

    protected List<String> getAllPermissionName(DefaultMutableTreeNode ruleNode) {
        OSProtectionTreeUserObject userObject = (OSProtectionTreeUserObject)ruleNode.getUserObject();
        return OpPermissionListObject.getAllPermissionNames(((OpAppRule)userObject.getUserObject()).getOpPermissionList());
    }

    private void initialize() {
        this.setupMenuItemListener();
        this.setupMenuItems();
    }

    private void addRule() {
        OpAppRule rule = new OpAppRule();
        rule.setId(new GUIDGenerator().getGUIDString());
        rule.setName(PolicyHandler.adjustName(DEFAULT_RULE_NAME, new OpAppProtectionBlockObject(this.model.getOpAppProtectionBlock()).getAllRuleNames(), 255));
        rule.setOpProcess(new OpProcess());
        rule.setOpPermissionList(new OpPermissionList());
        this.nodeAdded(this.model.addNode(94, (ConfigObject)rule, null));
    }

    private void addRegistry() {
        DefaultMutableTreeNode ruleNode = this.getRuleNode();
        OpRegistryAccess reg = new OpRegistryAccess();
        reg.setName(PolicyHandler.adjustName(DEFAULT_REGISTRY_ACCESS_NAME, this.getAllPermissionName(ruleNode), 255));
        reg.setOpTargetRegistry(new OpTargetRegistry());
        this.nodeAdded(this.model.addNode(95, (ConfigObject)reg, ruleNode));
    }

    private void addFileAccess() {
        DefaultMutableTreeNode ruleNode = this.getRuleNode();
        OpFileAccess file = new OpFileAccess();
        file.setName(PolicyHandler.adjustName(DEFAULT_FILE_ACCESS_NAME, this.getAllPermissionName(ruleNode), 255));
        file.setOpTargetFile(new OpTargetFile());
        this.nodeAdded(this.model.addNode(96, (ConfigObject)file, ruleNode));
    }

    private void addProcess(boolean isLaunchProcess) {
        DefaultMutableTreeNode ruleNode = this.getRuleNode();
        OpProcessAccess process = new OpProcessAccess();
        String name = isLaunchProcess ? DEFAULT_LAUNCH_PROCESS_ACCESS_NAME : DEFAULT_TERMINATE_PROCESS_ACCESS_NAME;
        process.setName(PolicyHandler.adjustName(name, this.getAllPermissionName(ruleNode), 255));
        process.setOpTargetProcess(new OpTargetProcess());
        this.nodeAdded(this.model.addNode(isLaunchProcess ? 97 : 98, (ConfigObject)process, ruleNode));
    }

    private void addModule() {
        DefaultMutableTreeNode ruleNode = this.getRuleNode();
        OpModuleAccess module = new OpModuleAccess();
        module.setName(PolicyHandler.adjustName(DEFAULT_MODULE_ACCESS_NAME, this.getAllPermissionName(ruleNode), 255));
        module.setOpTargetModule(new OpTargetModule());
        this.nodeAdded(this.model.addNode(99, (ConfigObject)module, ruleNode));
    }
}

