/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.osprotect;

import com.sygate.scm.common.configobject.schema.OpAction;
import com.sygate.scm.common.configobject.schema.OpNotification;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AccessPane
extends JPanel {
    private static final long serialVersionUID = 1713058833794310860L;
    private static final String[] severities = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityCritical.0"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityCritical.1"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityCritical.2"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityCritical.3"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityMajor.4"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityMajor.5"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityMajor.6"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityMajor.7"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityMinor.8"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityMinor.9"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityMinor.10"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityMinor.11"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityInfo.12"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityInfo.13"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityInfo.14"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.combo.SeverityInfo.15")};
    private JRadioButton jRBIgnore = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.radio.Ignore"), true);
    private JRadioButton jRBAllow = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.radio.Allow"));
    private JRadioButton jRBBlock = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.radio.Block"));
    private JRadioButton jRBTerminate = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.radio.TerminateProcess"));
    private JCheckBox jCbxLog = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.checkbox.Log"));
    private JCheckBox jCbxAlert = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.checkbox.Alert"));
    private JCheckBox jCbxNotify = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.checkbox.NotifyUser"));
    private JComboBox<String> severityCombo = new JComboBox<String>(severities);
    private JTextArea jTANote = new JTextArea(4, 20);
    private JLabel jLSeverity = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "AccessPane.label.Severity"));
    private OpAction opAction;
    private OpNotification opNote;
    private String description;
    private HtmlEnabledJLabel jTADesc = new HtmlEnabledJLabel();
    ChangeListener summaryListener;
    boolean doCommitChanges = false;
    private boolean isReadonly;

    public AccessPane(String description, ChangeListener summaryListener, boolean isReadonly) {
        this.description = "<html>" + description + "</html>";
        this.summaryListener = summaryListener;
        this.isReadonly = isReadonly;
        this.initialize();
    }

    public AccessPane(String description, ChangeListener summaryListener, boolean dummy, boolean isReadonly) {
        this.description = "<html><font color=black>" + description + "</font></html>";
        this.summaryListener = summaryListener;
        this.isReadonly = isReadonly;
        this.initialize();
    }

    protected AccessPane() {
    }

    public void initData(OpAction opAction) {
        this.commitData();
        this.doCommitChanges = false;
        this.opAction = opAction;
        this.opNote = opAction.getOptOpNotification();
        if (this.opNote == null) {
            this.opNote = new OpNotification();
            opAction.setOptOpNotification(this.opNote);
        }
        this.jRBIgnore.setSelected(opAction.getAction().equals(OpAction.DONOTHING));
        this.jRBAllow.setSelected(opAction.getAction().equals(OpAction.ALLOW));
        this.jRBBlock.setSelected(opAction.getAction().equals(OpAction.BLOCK));
        this.jRBTerminate.setSelected(opAction.getAction().equals(OpAction.TERMINATE));
        this.jCbxLog.setSelected(Utility.getBooleanValue((Boolean)opAction.getOptLogEvent(), null));
        this.jCbxAlert.setSelected(Utility.getBooleanValue((Boolean)opAction.getOptAlert(), null));
        this.severityCombo.setSelectedIndex(opAction.getSeverity().intValue());
        this.jCbxNotify.setSelected(Utility.getBooleanValue((Boolean)this.opNote.getOptEnable(), null));
        this.jTANote.setText(this.opNote.getOptAdditionalText());
        this.logChanged();
        this.notifyChanged();
        this.doCommitChanges = true;
    }

    public void commitData() {
        if (this.opAction != null) {
            this.opAction.setAction(this.getAction());
            this.opAction.setOptLogEvent(Boolean.valueOf(this.jCbxLog.isSelected()));
            this.opAction.setSeverity(Long.valueOf(this.severityCombo.getSelectedIndex()));
            this.opAction.setOptAlert(Boolean.valueOf(this.jCbxAlert.isSelected()));
        }
        if (this.opNote != null) {
            this.opNote.setOptEnable(Boolean.valueOf(this.jCbxNotify.isSelected()));
            this.opNote.setOptAdditionalText(this.jTANote.getText());
        }
    }

    private void initialize() {
        this.jTADesc.setText(this.description);
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AccessPane.this.summaryChange();
                }
            }
        };
        this.jRBIgnore.addItemListener(listener);
        this.jRBAllow.addItemListener(listener);
        this.jRBBlock.addItemListener(listener);
        this.jRBTerminate.addItemListener(listener);
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBIgnore);
        group.add(this.jRBAllow);
        group.add(this.jRBBlock);
        group.add(this.jRBTerminate);
        this.jTANote.setDocument(new RestrictedPlainDocument(1000));
        this.jTANote.setWrapStyleWord(true);
        this.jTANote.setLineWrap(true);
        this.jCbxLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPane.this.logChanged();
                AccessPane.this.summaryChange();
            }
        });
        this.jCbxAlert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPane.this.summaryChange();
            }
        });
        this.jCbxNotify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPane.this.notifyChanged();
                AccessPane.this.summaryChange();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jTADesc, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.jRBIgnore, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jRBAllow, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jRBBlock, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jRBTerminate, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jCbxLog, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(25, 0, 0, 0), 0, 0));
        this.add((Component)this.jLSeverity, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.add(this.severityCombo, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jCbxAlert, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0));
        this.add((Component)this.jCbxNotify, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scroll = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scroll, (JTextArea)this.jTANote);
        this.add((Component)scroll, new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        if (this.isReadonly) {
            UIUtilities.setContainerStatus(this, false);
        }
    }

    private void logChanged() {
        if (this.isReadonly) {
            return;
        }
        boolean isSelected = this.jCbxLog.isSelected();
        this.jCbxAlert.setEnabled(isSelected);
        this.jLSeverity.setEnabled(isSelected);
        this.severityCombo.setEnabled(isSelected);
    }

    private void notifyChanged() {
        if (this.isReadonly) {
            return;
        }
        this.jTANote.setEnabled(this.jCbxNotify.isSelected());
    }

    private Integer getAction() {
        if (this.jRBIgnore.isSelected()) {
            return OpAction.DONOTHING;
        }
        if (this.jRBAllow.isSelected()) {
            return OpAction.ALLOW;
        }
        if (this.jRBBlock.isSelected()) {
            return OpAction.BLOCK;
        }
        return OpAction.TERMINATE;
    }

    private void summaryChange() {
        if (this.doCommitChanges) {
            this.commitData();
        }
        this.summaryListener.stateChanged(new ChangeEvent(this));
    }
}

