/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ntr;

import com.sygate.scm.common.configobject.schema.NtrPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.NtrPolicyObject;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.NTRPolicyUtility;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.query.DropdownItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class NtrPolicyPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String NTR_POLICY_PANEL = "ntr_policy_panel";
    private static final String NTR_DESC = NtrPolicyPanel.getString("NTRSettingsPanel.NTRDescription");
    private final LockCheckBox enableNtrLock = new LockCheckBox(Boolean.FALSE);
    private final JCheckBox enableNtrCheckBox = new JCheckBox(NtrPolicyPanel.getString("NTRSettingsPanel.checkbox.NTREnable"));
    private final HtmlEnabledJLabel labelNtrInstallCertHelp = new HtmlEnabledJLabel(NtrPolicyPanel.getString("NTRSettingsPanel.checkbox.InstallCertificate.full.TunnelCertificatesInstalled"), true);
    private JTextField tokenStringInput;
    private JLabel tokenLabel = new JLabel(NtrPolicyPanel.getString("NTRSettingsPanel.clientAuth.tokenLabel"));
    private final JLabel trafficIdentificationLabel = new JLabel(NtrPolicyPanel.getString("NTRSettingsPanel.trafficIdentification"));
    private static final DropdownItem CONSOLE_USER_IDENTIFICATION = new DropdownItem(NtrPolicyPanel.getString("NTRSettingsPanel.trafficIdentification.Console"), (Object)NtrPolicy.CONSOLE);
    public static final String CONSOLE_USER_IDENTIFICATION_INFO = NtrPolicyPanel.getString("NTRSettingsPanel.trafficIdentification.Console.Info");
    private static final DropdownItem ASSIGNED_IDENTIFICATION = new DropdownItem(NtrPolicyPanel.getString("NTRSettingsPanel.trafficIdentification.Assigned"), (Object)NtrPolicy.ASSIGNED);
    public static final String ASSIGNED_IDENTIFICATION_INFO = NtrPolicyPanel.getString("NTRSettingsPanel.trafficIdentification.Assigned.Info") + "\n" + NtrPolicyPanel.getString("NTRSettingsPanel.trafficIdentification.Assigned.Prerequisite");
    private static final DropdownItem PROCESS_IDENTIFICATION = new DropdownItem(NtrPolicyPanel.getString("NTRSettingsPanel.trafficIdentification.Process"), (Object)NtrPolicy.PROCESS);
    public static final String PROCESS_IDENTIFICATION_INFO = NtrPolicyPanel.getString("NTRSettingsPanel.trafficIdentification.Process.Info");
    private final JComboBox<DropdownItem> trafficIdentificationCombobox = new JComboBox<DropdownItem>(new DropdownItem[]{CONSOLE_USER_IDENTIFICATION, ASSIGNED_IDENTIFICATION, PROCESS_IDENTIFICATION});
    private final JTextArea trafficIdentificationInfo = this.createTextArea(CONSOLE_USER_IDENTIFICATION_INFO);
    private File customPacFileObj;
    private final String osWarningFull = NtrPolicyPanel.getString("NTRSettingsPanel.osWarning.full");
    private NtrPolicyObject ntrPolicyObject;

    public NtrPolicyPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.add(this.getWtrPanel());
    }

    protected JTextArea createTextArea(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setEditable(false);
        textArea.setBorder(null);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setOpaque(false);
        return textArea;
    }

    public boolean isNtrEnabled() {
        return this.enableNtrCheckBox.isSelected();
    }

    public String getCiaTokenString() {
        return this.tokenStringInput.getText() == null ? null : this.tokenStringInput.getText().trim();
    }

    private JPanel getWtrPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        int gridy = 0;
        panel.add((Component)new AvTemplatePane(NtrPolicyPanel.getString("NTRSettingsPanel.title"), NTR_DESC, false), new GridBagConstraints(0, gridy, 5, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.enableNtrLock.setSelectedIcon(AvConstants.lockIcon);
        panel.add((Component)this.enableNtrLock, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.enableNtrCheckBox, new GridBagConstraints(1, gridy, 5, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.enableNtrCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                NtrPolicyPanel.this.setEnabledForNtrDependents();
            }
        });
        String strWtrHelpText = NtrPolicyPanel.getString("NTRSettingsPanel.WhatIsWtr");
        HtmlEnabledJLabel labelWtrHelp = new HtmlEnabledJLabel(strWtrHelpText, true);
        labelWtrHelp.setIcon((Icon)ConsoleMain.whatsThisIcon);
        labelWtrHelp.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                HelpUtil.showHelpOrErrDlg("sesm_policies_dialog_WSS_NTR");
            }
        });
        panel.add((Component)labelWtrHelp, new GridBagConstraints(0, gridy, 5, 1, 0.0, 0.0, 17, 2, new Insets(20, 350, 0, 0), 0, 0));
        JPanel trafficIdentificationPanel = new JPanel(new GridBagLayout());
        trafficIdentificationPanel.add((Component)this.trafficIdentificationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        UIUtilities.setName(this.trafficIdentificationCombobox, NTR_POLICY_PANEL, UIUtilities.ComponentType.COMBOBOX, "identify_traffic");
        trafficIdentificationPanel.add(this.trafficIdentificationCombobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
        this.trafficIdentificationCombobox.addActionListener(e -> {
            DropdownItem item = (DropdownItem)this.trafficIdentificationCombobox.getSelectedItem();
            this.setTrafficIdentificationInfo((Integer)item.getValue());
        });
        trafficIdentificationPanel.add((Component)this.trafficIdentificationInfo, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        panel.add((Component)trafficIdentificationPanel, new GridBagConstraints(1, ++gridy, 4, 1, 0.0, 0.0, 17, 2, new Insets(5, 25, 0, 0), 0, 0));
        Insets insets = new Insets(5, 40, 0, 0);
        panel.add((Component)this.tokenLabel, new GridBagConstraints(1, ++gridy, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        panel.add((Component)this.getCiaTokenField(), new GridBagConstraints(2, gridy, 3, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.labelNtrInstallCertHelp.setIcon((Icon)ConsoleMain.whatsThisIcon);
        this.labelNtrInstallCertHelp.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                HelpUtil.showURL(HelpUtil.HELP_UTIL_URL_WSSEntrustInstallCertHelpUrl);
            }
        });
        panel.add((Component)this.labelNtrInstallCertHelp, new GridBagConstraints(0, ++gridy, 5, 1, 0.0, 0.0, 17, 0, new Insets(10, 40, 0, 0), 0, 0));
        return panel;
    }

    private void setSelectedTrafficIdentification(Integer mode) {
        if (mode == null || NtrPolicy.CONSOLE.equals(mode)) {
            this.trafficIdentificationCombobox.setSelectedItem(CONSOLE_USER_IDENTIFICATION);
        } else if (NtrPolicy.ASSIGNED.equals(mode)) {
            this.trafficIdentificationCombobox.setSelectedItem(ASSIGNED_IDENTIFICATION);
        } else if (NtrPolicy.PROCESS.equals(mode)) {
            this.trafficIdentificationCombobox.setSelectedItem(PROCESS_IDENTIFICATION);
        }
        this.setTrafficIdentificationInfo(mode);
    }

    private void setTrafficIdentificationInfo(Integer mode) {
        if (null == mode || NtrPolicy.CONSOLE.equals(mode)) {
            this.trafficIdentificationInfo.setText(CONSOLE_USER_IDENTIFICATION_INFO);
        } else if (NtrPolicy.ASSIGNED.equals(mode)) {
            this.trafficIdentificationInfo.setText(ASSIGNED_IDENTIFICATION_INFO);
        } else if (NtrPolicy.PROCESS.equals(mode)) {
            this.trafficIdentificationInfo.setText(PROCESS_IDENTIFICATION_INFO);
        }
    }

    public Integer getSelectedTrafficIdentification() {
        DropdownItem item = (DropdownItem)this.trafficIdentificationCombobox.getSelectedItem();
        return (Integer)item.getValue();
    }

    public String getTrafficIdentificationInfo() {
        return this.trafficIdentificationInfo.getText();
    }

    private void setVisibleForFullRedirectionMethod() {
        this.labelNtrInstallCertHelp.setVisible(true);
        this.trafficIdentificationLabel.setVisible(true);
        this.trafficIdentificationCombobox.setVisible(true);
        this.trafficIdentificationInfo.setVisible(true);
    }

    private JTextField getCiaTokenField() {
        if (this.tokenStringInput == null) {
            this.tokenStringInput = new JTextField(50);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(127);
            this.tokenStringInput.setDocument(doc);
        }
        return this.tokenStringInput;
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ntr.ntr", key);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_ntr_settings";
    }

    protected void updatePolicy(NTRPolicyUtility.TokenFormat tokenFormat) {
        NtrPolicy ntrPolicy;
        if (this.ntrPolicyObject != null && (ntrPolicy = this.ntrPolicyObject.getNtrPolicy()) != null) {
            ntrPolicy.setOptLocked(Boolean.valueOf(this.enableNtrLock.isSelected()));
            boolean ntrSelected = this.enableNtrCheckBox.isSelected();
            ntrPolicy.setOptEnableNTR(Boolean.valueOf(ntrSelected));
            ntrPolicy.setOptEnableLps(Boolean.valueOf(false));
            ntrPolicy.setOptRedirectionMethod(NtrPolicy.FULL);
            ntrPolicy.setOptEnableCia(Boolean.valueOf(false));
            if (ntrSelected) {
                String tokenString = this.getCiaTokenString();
                boolean ciaEnabled = !StringUtilities.isEmpty((String)tokenString);
                ntrPolicy.setOptEnableCia(Boolean.valueOf(ciaEnabled));
                this.updatePolicy(ciaEnabled, ntrPolicy, tokenFormat, tokenString);
            }
            ntrPolicy.setOptTrafficIdentification(this.getSelectedTrafficIdentification());
        }
    }

    public void updatePolicy(boolean ciaEnabled, NtrPolicy ntrPolicy, NTRPolicyUtility.TokenFormat tokenformat, String tokenString) {
        if (ciaEnabled) {
            if (tokenformat == NTRPolicyUtility.TokenFormat.CTCV2) {
                ntrPolicy.setOptCiaCustomerToken(tokenString);
                ntrPolicy.setOptCiaPsk(ntrPolicy.getDefCiaPsk());
                ntrPolicy.setOptCiaPskVersion(ntrPolicy.getDefCiaPskVersion());
            } else {
                String[] parts = tokenString.split("-");
                ntrPolicy.setOptCiaCustomerToken(parts[0]);
                if (parts.length > 1) {
                    ntrPolicy.setOptCiaPsk(parts[1]);
                    ntrPolicy.setOptCiaPskVersion(Integer.valueOf(Integer.parseInt(parts[2])));
                } else {
                    ntrPolicy.setOptCiaPsk(ntrPolicy.getDefCiaPsk());
                    ntrPolicy.setOptCiaPskVersion(ntrPolicy.getDefCiaPskVersion());
                }
            }
        } else {
            ntrPolicy.setOptCiaCustomerToken(ntrPolicy.getDefCiaCustomerToken());
            ntrPolicy.setOptCiaPsk(ntrPolicy.getDefCiaPsk());
            ntrPolicy.setOptCiaPskVersion(ntrPolicy.getDefCiaPskVersion());
        }
    }

    public void setValue(NtrPolicyObject ntrPolicyObject) {
        this.ntrPolicyObject = ntrPolicyObject;
        this.enableNtrLock.setSelected(false);
        this.enableNtrCheckBox.setSelected(false);
        NtrPolicy ntrPolicy = ntrPolicyObject.getNtrPolicy();
        if (ntrPolicy != null) {
            this.enableNtrLock.setSelected(Utility.getBooleanValue((Boolean)ntrPolicy.getOptLocked(), (Boolean)ntrPolicy.getDefLocked()));
            this.enableNtrCheckBox.setSelected(Utility.getBooleanValue((Boolean)ntrPolicy.getOptEnableNTR(), (Boolean)ntrPolicy.getDefEnableNTR()));
            this.setVisibleForFullRedirectionMethod();
            this.setSelectedTrafficIdentification(ntrPolicy.getOptTrafficIdentification());
            if (ntrPolicy.getOptCiaCustomerToken() != null && !ntrPolicy.getOptCiaCustomerToken().equals(ntrPolicy.getDefCiaCustomerToken())) {
                if (ntrPolicy.getOptCiaPskVersion() != null && !ntrPolicy.getOptCiaPskVersion().equals(ntrPolicy.getDefCiaPskVersion()) && ntrPolicy.getOptCiaPsk() != null && !ntrPolicy.getOptCiaPsk().equals(ntrPolicy.getDefCiaPsk())) {
                    this.tokenStringInput.setText(ntrPolicy.getOptCiaCustomerToken() + "-" + ntrPolicy.getOptCiaPsk() + "-" + ntrPolicy.getOptCiaPskVersion());
                } else {
                    this.tokenStringInput.setText(ntrPolicy.getOptCiaCustomerToken());
                }
            }
        }
        this.setEnabledForNtrDependents();
    }

    private void setEnabledForNtrDependents() {
        boolean enabled = this.enableNtrCheckBox.isSelected();
        this.tokenLabel.setEnabled(enabled);
        this.getCiaTokenField().setEnabled(enabled);
        this.trafficIdentificationLabel.setEnabled(enabled);
        this.trafficIdentificationCombobox.setEnabled(enabled);
        this.trafficIdentificationInfo.setEnabled(enabled);
    }
}

