/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ntr;

import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.NtrPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.NtrPolicyObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.ntr.NtrPolicyPanel;
import com.sygate.scm.console.ui.policy.ntr.NtrPolicyTabPanel;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.NTRPolicyUtility;
import java.awt.Component;
import java.awt.Cursor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class NtrPolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSG_DIALOG = new MessageResourcesFile("com.sygate.scm.console.ui.policy.ntr.ntr");
    private NtrPolicyObject ntrPolicyObject;
    private Map<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
    private NtrPolicyPanel ntrPolicyPanel;
    private NTRPolicyUtility.TokenFormat tokenFormat;

    public NtrPolicyDialog(AbstractUIObject pool) {
        this(pool, false);
    }

    public NtrPolicyDialog(String name, GroupPolicyObject gpObj, Boolean ... isLocal) {
        super(171, name, gpObj, MSG_DIALOG.getString("NtrPolicyDialog.title"), true, isLocal);
    }

    public NtrPolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(171, pool, MSG_DIALOG.getString("NtrPolicyDialog.title"), isCheckPolicyEnforcement, true);
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        mainPanel.add((Component)this.getNTRPanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ntr.ntr", "NtrPolicyDialog.title"));
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        NtrPolicyTabPanel panel = new NtrPolicyTabPanel(this, "<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ntr.ntr", "NtrPolicy") + "</html>", "firewall_policy_32.png");
        panel.putClientProperty("cssClass", "fwPolicyDialogPanel");
        return panel;
    }

    private NtrPolicyPanel getNTRPanel() {
        if (this.ntrPolicyPanel == null) {
            this.ntrPolicyPanel = new NtrPolicyPanel();
        }
        return this.ntrPolicyPanel;
    }

    @Override
    protected void commit() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.ntrPolicyObject.setName(this.getOverviewPanel().getPolicyName());
        this.ntrPolicyObject.setDesc(this.getOverviewPanel().getPolicyDesc());
        this.ntrPolicyObject.setEnabled(this.getOverviewPanel().isPolicyEnabled());
        this.ntrPolicyPanel.updatePolicy(this.tokenFormat);
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    protected boolean isValidate() {
        String tokenString;
        if (!this.isValidName(this.ntrPolicyObject.getSchemaObj(), MSG_DIALOG.getString("NtrPolicyDialog.nameIsARequirementFiled"), MSG_DIALOG.getString("NtrPolicyDialog.theNameHasBeenUsed"), MSG_DIALOG.getString("NtrPolicyDialog.invalidName"))) {
            return false;
        }
        if (this.ntrPolicyPanel.isNtrEnabled() && !this.isValidCiaIntegrationTokenFormat(tokenString = this.ntrPolicyPanel.getCiaTokenString())) {
            this.showErrorMessage(MSG_DIALOG.getString("NTRSettingsPanel.cia.error.invalidToken"));
            return false;
        }
        return true;
    }

    private boolean isValidCiaIntegrationTokenFormat(String token) {
        this.tokenFormat = NTRPolicyUtility.getCiaIntegrationTokenFormat((String)token);
        return this.tokenFormat != NTRPolicyUtility.TokenFormat.BAD;
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject schema) {
        NtrPolicy policy = (NtrPolicy)schema;
        this.ntrPolicyObject = new NtrPolicyObject((TopLevelObject)policy);
        this.setValue();
        this.ntrPolicyPanel.setValue(this.ntrPolicyObject);
        return this.ntrPolicyObject;
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        String newName;
        this.setNewPolicy(true);
        NtrPolicy policy = this.createNtrPolicy();
        this.ntrPolicyObject = new NtrPolicyObject((TopLevelObject)policy);
        if (this.ntrPolicyObject.getName() != null && (newName = PolicyHandler.adjustName(this.ntrPolicyObject.getName(), pool.getAllName(), 512)) != null) {
            this.ntrPolicyObject.setName(newName);
        }
        this.ntrPolicyObject.addNewObj((TopLevelObject)policy);
        this.ntrPolicyObject.addNewObj(this.newObjList);
        this.newObjList.clear();
        this.setValue();
        this.ntrPolicyPanel.setValue(this.ntrPolicyObject);
        return this.ntrPolicyObject;
    }

    private NtrPolicy createNtrPolicy() {
        NtrPolicy ntrPolicy = null;
        try {
            ntrPolicy = PolicyHandler.getDefaultNtrPolicy(this.newObjList);
            if (ntrPolicy == null) {
                ntrPolicy = new NtrPolicy();
                String guidString = new GUIDGenerator().getGUIDString();
                ntrPolicy.setId(guidString);
                MetadataAttributes metadataAtrribute = new MetadataAttributes();
                ntrPolicy.setMetadataAttributes(metadataAtrribute);
                ntrPolicy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
            }
        }
        catch (Exception exception) {
            LoggerUtilities.logException((Throwable)exception);
            JOptionPane.showMessageDialog(Manager.getFrame(), exception.getMessage(), MSG_DIALOG.getString("NtrPolicyDialog.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return ntrPolicy;
    }

    private void setValue() {
        this.getOverviewPanel().setObject(this.ntrPolicyObject);
        this.getOverviewPanel().setPolicyEnabled(this.ntrPolicyObject.getEnabled());
    }

    private void showErrorMessage(String errorMsg) {
        String errorTitle = MSG_DIALOG.getString("NtrPolicyDialog.Error");
        JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, errorTitle, 0);
    }
}

