/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.mem.logicobject;

import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.LuDownloadedContent;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PEPThreatRule;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.ids.handler.IdsLuHandler;
import com.sygate.scm.console.ui.policy.mem.logicobject.MemApplicationMetadataEvent;
import com.sygate.scm.console.ui.policy.mem.logicobject.MemApplicationPerProtectionMetadataEvent;
import com.sygate.scm.console.ui.policy.mem.logicobject.MemProtectionTechniquesMetadata;
import com.sygate.scm.console.ui.policy.util.PolicyUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WinMemMetadataObject {
    private static WinMemMetadataObject curMetadata;
    private static Set<MemApplicationMetadataEvent> memApplicationRules;
    private static ArrayList<MemProtectionTechniquesMetadata> memProtectionTechniues;
    protected static final String PEP_METADATA_XML_FILENAME = "IPSMetadata3.xml";
    private static Set<String> processedSequencesIds;
    private static Map<String, MemAttributeHolder> memAttributeHolderMap;

    public static Map<String, MemAttributeHolder> getMemAttributeHolderMap() {
        return memAttributeHolderMap;
    }

    public static void setMemAttributeHolderMap(Map<String, MemAttributeHolder> memAttributeHolderMap) {
        WinMemMetadataObject.memAttributeHolderMap = memAttributeHolderMap;
    }

    public WinMemMetadataObject() throws ConsoleException {
        this.initializePepData();
    }

    public static void refreshNewInstance() {
        curMetadata = null;
    }

    protected String getPepFileName(LuDownloadedContent content) {
        this.msg("getPEPFileName", "moniker is " + content.getOptClientMoniker());
        return PEP_METADATA_XML_FILENAME;
    }

    public static void clearMap() {
        memAttributeHolderMap.clear();
        memProtectionTechniues.clear();
        memApplicationRules.clear();
        WinMemMetadataObject.clearPepRules();
    }

    public static Set<MemApplicationMetadataEvent> getMemApplicationRules() throws ConsoleException {
        WinMemMetadataObject.getCurrentObject();
        HashSet<MemApplicationMetadataEvent> uniqueAppEvents = new HashSet<MemApplicationMetadataEvent>();
        for (Map.Entry<String, MemAttributeHolder> entry : memAttributeHolderMap.entrySet()) {
            Set<MemApplicationMetadataEvent> namePathSet = entry.getValue().getMemApplicationsSet();
            if (namePathSet == null) continue;
            uniqueAppEvents.addAll(namePathSet);
        }
        memApplicationRules.clear();
        for (MemApplicationMetadataEvent memApplicationMetadataEvent : uniqueAppEvents) {
            MemApplicationMetadataEvent memApplicationMetadatEvent = new MemApplicationMetadataEvent();
            memApplicationMetadatEvent.setName(memApplicationMetadataEvent.getName());
            memApplicationMetadatEvent.setPath(memApplicationMetadataEvent.getPath());
            memApplicationMetadatEvent.setEnabled(true);
            memApplicationRules.add(memApplicationMetadatEvent);
        }
        return memApplicationRules;
    }

    public static Vector<TableRow> getApplicationRule(String protectionTechniqueSignature) throws ConsoleException {
        WinMemMetadataObject.getCurrentObject();
        Vector<TableRow> memApplicationRuleForProtection = new Vector<TableRow>();
        if (memAttributeHolderMap.get(protectionTechniqueSignature) != null) {
            for (MemApplicationMetadataEvent entry : memAttributeHolderMap.get(protectionTechniqueSignature).getMemApplicationsSet()) {
                MemApplicationPerProtectionMetadataEvent memApplicationPerProtectionMetadataEvent = new MemApplicationPerProtectionMetadataEvent();
                memApplicationPerProtectionMetadataEvent.setName(entry.getName());
                memApplicationPerProtectionMetadataEvent.setPath(entry.getPath());
                String defaultAction = null;
                String action = memAttributeHolderMap.get(protectionTechniqueSignature).getDefaultAction().toString();
                boolean logAction = memAttributeHolderMap.get(protectionTechniqueSignature).isLogAction();
                defaultAction = WinMemMetadataObject.mapGlobalActions(action, logAction);
                memApplicationPerProtectionMetadataEvent.setDefaultAction(defaultAction);
                memApplicationRuleForProtection.add(memApplicationPerProtectionMetadataEvent);
            }
        }
        return memApplicationRuleForProtection;
    }

    public static String getTechniqueName(String signatureId) {
        if (memAttributeHolderMap.get(signatureId) != null) {
            return memAttributeHolderMap.get(signatureId).getEngineSubType();
        }
        return null;
    }

    private static String mapGlobalActions(String defaultAction, boolean logAction) throws ConsoleException {
        if (defaultAction.equalsIgnoreCase(Action.BLOCK.toString()) && logAction) {
            return "Yes";
        }
        if (defaultAction.equalsIgnoreCase(Action.ALLOW.toString()) && !logAction) {
            return "No";
        }
        if (defaultAction.equalsIgnoreCase(Action.ALLOW.toString()) && logAction) {
            return "Log";
        }
        throw new ConsoleException(0x16010000);
    }

    public static PEPThreatRule createPepThreatRule(String techniqueSignature) {
        if (!memAttributeHolderMap.isEmpty() && memAttributeHolderMap.get(techniqueSignature) != null) {
            PEPThreatRule pepThreatRule = new PEPThreatRule();
            pepThreatRule.setTechniqueName(memAttributeHolderMap.get(techniqueSignature).getEngineSubType());
            pepThreatRule.setSignatureId(memAttributeHolderMap.get(techniqueSignature).getSignatureId());
            return pepThreatRule;
        }
        return null;
    }

    public static ArrayList<MemProtectionTechniquesMetadata> getMemProtectionTechniques() throws ConsoleException {
        WinMemMetadataObject.getCurrentObject();
        MemProtectionTechniquesMetadata memProtectionTechniquesMetadata = null;
        for (Map.Entry<String, MemAttributeHolder> entry : memAttributeHolderMap.entrySet()) {
            String techniqueName = entry.getValue().getEngineSubType();
            String techniqueAction = entry.getValue().getDefaultAction().toString();
            String signatuerId = entry.getValue().getSignatureId();
            boolean logAction = entry.getValue().isLogAction();
            String defaultAction = null;
            try {
                memProtectionTechniquesMetadata = new MemProtectionTechniquesMetadata();
                defaultAction = WinMemMetadataObject.mapGlobalActions(techniqueAction, logAction);
                memProtectionTechniquesMetadata.setName(techniqueName);
                memProtectionTechniquesMetadata.setSignatuerId(signatuerId);
                memProtectionTechniquesMetadata.setDefaultAction(defaultAction);
            }
            catch (ConsoleException consoleException) {
                ConsoleLogger.log("WinMemsMetadataObject>>getMemProtectionTechniques Exception occured while mapping actions " + consoleException.getMessage());
                LoggerUtilities.logException((Throwable)consoleException);
                continue;
            }
            memProtectionTechniues.add(memProtectionTechniquesMetadata);
        }
        return memProtectionTechniues;
    }

    private void msg(String method, String msg) {
        ConsoleLogger.log("WinMemsMetadataObject>>" + method + ">" + msg);
    }

    public static WinMemMetadataObject getCurrentObject() throws ConsoleException {
        if (curMetadata == null) {
            curMetadata = new WinMemMetadataObject();
        }
        return curMetadata;
    }

    public Map<String, MemAttributeHolder> getPepRules(InputStream in) throws IOException, SAXException {
        this.msg("getPepRules", "enter");
        Document doc = XMLHelper.parse((InputStream)in);
        Element root = doc.getDocumentElement();
        System.out.println(doc.toString());
        ArrayList issueList = XMLHelper.getChildElementByName((Element)root, (String)"Issue");
        HashMap<String, MemAttributeHolder> techniqueMap = new HashMap<String, MemAttributeHolder>();
        for (Element issue : issueList) {
            ArrayList allElemt = XMLHelper.getChildElementByName((Element)issue, (String)"Event");
            Iterator it = allElemt.iterator();
            while (it.hasNext()) {
                Element engineType;
                MemAttributeHolder memAttributeHolder = new MemAttributeHolder();
                Element eventElement = (Element)it.next();
                String eventId = eventElement.getAttribute("ID");
                ArrayList engineTypeElementList = XMLHelper.getChildElementByName((Element)eventElement, (String)"EngineType");
                if (engineTypeElementList == null || engineTypeElementList.size() == 0 || engineTypeElementList.size() > 1 || !(engineType = (Element)engineTypeElementList.get(0)).getTextContent().equalsIgnoreCase("PEP")) continue;
                HashSet<MemApplicationMetadataEvent> appEvents = new HashSet<MemApplicationMetadataEvent>();
                ArrayList elementEventTypeList = XMLHelper.getChildElementByName((Element)eventElement, (String)"EngineSubType");
                if (elementEventTypeList == null || elementEventTypeList.size() <= 0) continue;
                String engineSubType = ((Element)elementEventTypeList.get(0)).getTextContent();
                memAttributeHolder.setSignatureId(eventId);
                memAttributeHolder.setEngineSubType(engineSubType);
                ArrayList responseElementList = XMLHelper.getChildElementByName((Element)eventElement, (String)"Response");
                Action action = null;
                boolean logAction = false;
                if (responseElementList != null && ((Element)responseElementList.get(0)).getAttribute("Action") != null) {
                    action = ((Element)responseElementList.get(0)).getAttribute("Action").equalsIgnoreCase("Allow") ? Action.ALLOW : Action.BLOCK;
                }
                if (responseElementList != null && ((Element)responseElementList.get(0)).getAttribute("Log") != null && ((Element)responseElementList.get(0)).getAttribute("Log").equals("1")) {
                    logAction = true;
                }
                if (Action.ALLOW.equals((Object)action) && !logAction) continue;
                memAttributeHolder.setDefaultAction(action);
                memAttributeHolder.setLogAction(logAction);
                ArrayList processesElementList = XMLHelper.getChildElementByName((Element)eventElement, (String)"Processes");
                if (processesElementList != null && processesElementList.size() > 0) {
                    Element processesElement = (Element)processesElementList.get(0);
                    ArrayList processElementList = XMLHelper.getChildElementByName((Element)processesElement, (String)"Process");
                    for (Element process : processElementList) {
                        MemApplicationMetadataEvent memApplicationMetadataEvent = new MemApplicationMetadataEvent();
                        memApplicationMetadataEvent.setName(process.getAttribute("Name"));
                        memApplicationMetadataEvent.setPath(process.getAttribute("Path"));
                        appEvents.add(memApplicationMetadataEvent);
                    }
                    memAttributeHolder.setMemApplicationsSet(appEvents);
                }
                techniqueMap.put(memAttributeHolder.getSignatureId(), memAttributeHolder);
            }
        }
        return techniqueMap;
    }

    private static void clearPepRules() {
        memApplicationRules = new HashSet<MemApplicationMetadataEvent>();
    }

    private void initializePepData() throws ConsoleException {
        this.msg("initializePepData", "enter");
        InputStream inputStream = null;
        InputStream idsMetadataFileInputStream = null;
        ByteArrayInputStream allDataInputStream = null;
        try {
            LuDownloadedContent content = IdsLuHandler.getLatestSepmMetadataContent();
            if (content != null) {
                this.msg("initializePepData", "has LU content");
                this.msg("initializePepData", "and it is IPS content");
                ObjReference ref = content.getOptObjReference();
                if (ref == null) {
                    this.msg("initializePepData", "full is not present so throw exception object not found");
                    throw new ConsoleException(0x16010000);
                }
                PhysicalFile phyFile = DataobjectManager.getInstance().getPhysicalFile(ref.getTargetId());
                ObjReference objectReference = phyFile.getObjReference();
                inputStream = GUIManager.getFile(objectReference.getTargetId());
                allDataInputStream = PolicyUtil.convertBackendInputStream(inputStream);
                IOUtilities.closeInputStream((InputStream)inputStream);
                inputStream = null;
                if (allDataInputStream != null) {
                    String fileName = this.getPepFileName(content);
                    idsMetadataFileInputStream = PolicyUtil.getMetadataFile(allDataInputStream, fileName);
                    if (idsMetadataFileInputStream != null) {
                        WinMemMetadataObject.clearMap();
                        this.msg("initializePepData", "got metadata.xml");
                        memAttributeHolderMap = this.getPepRules(idsMetadataFileInputStream);
                        IOUtilities.closeInputStream((InputStream)idsMetadataFileInputStream);
                        idsMetadataFileInputStream = null;
                    } else {
                        this.msg("initializePepData", "metadata.xml was null");
                    }
                    IOUtilities.closeInputStream((InputStream)allDataInputStream);
                    allDataInputStream = null;
                }
            }
        }
        catch (IOException | SAXException exception) {
            LoggerUtilities.logException((Throwable)exception);
            throw new ConsoleException(exception);
        }
        finally {
            IOUtilities.closeInputStream(idsMetadataFileInputStream);
            IOUtilities.closeInputStream(allDataInputStream);
            IOUtilities.closeInputStream(inputStream);
        }
    }

    static {
        memApplicationRules = new HashSet<MemApplicationMetadataEvent>();
        memProtectionTechniues = new ArrayList();
        memAttributeHolderMap = new HashMap<String, MemAttributeHolder>();
        processedSequencesIds = new HashSet<String>();
    }

    static class MemAttributeHolder {
        String engineSubType;
        String signatureId;
        Action defaultAction;
        boolean logAction;
        Set<MemApplicationMetadataEvent> memApplicationsSet = new HashSet<MemApplicationMetadataEvent>();
        Map<String, String> protectionTechniques = new HashMap<String, String>();

        MemAttributeHolder() {
        }

        public String getEngineSubType() {
            return this.engineSubType;
        }

        public void setEngineSubType(String engineSubType) {
            this.engineSubType = engineSubType;
        }

        public String getSignatureId() {
            return this.signatureId;
        }

        public void setSignatureId(String signatureId) {
            this.signatureId = signatureId;
        }

        public Action getDefaultAction() {
            return this.defaultAction;
        }

        public void setDefaultAction(Action defaultAction) {
            this.defaultAction = defaultAction;
        }

        public boolean isLogAction() {
            return this.logAction;
        }

        public void setLogAction(boolean logAction) {
            this.logAction = logAction;
        }

        public Map<String, String> getProtectionTechniques() {
            return this.protectionTechniques;
        }

        public void setProtectionTechniques(Map<String, String> protectionTechniques) {
            this.protectionTechniques = protectionTechniques;
        }

        public Set<MemApplicationMetadataEvent> getMemApplicationsSet() {
            return this.memApplicationsSet;
        }

        public void setMemApplicationsSet(Set<MemApplicationMetadataEvent> memApplicationsSet) {
            this.memApplicationsSet = memApplicationsSet;
        }
    }

    static enum Action {
        ALLOW,
        BLOCK;

    }
}

