/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.mem;

import com.sygate.scm.common.configobject.schema.CustomRuleList;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.PEPException;
import com.sygate.scm.common.configobject.schema.PEPExceptionList;
import com.sygate.scm.common.configobject.schema.PEPThreatRule;
import com.sygate.scm.common.configobject.schema.PEPThreatRuleList;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.mem.MEMPolicyPanel;
import com.sygate.scm.console.ui.policy.mem.MEMProtectionTechniques;
import com.sygate.scm.console.ui.policy.mem.logicobject.MemApplicationPerProtectionMetadataEvent;
import com.sygate.scm.console.ui.policy.mem.logicobject.WinMemMetadataObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.ui.util.renderer.GrayedComboBoxTableCellRenderer;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MemProtectionTechniqueAppPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SortableTableModel applicationRulesModel;
    private JPanel messagePanel = null;
    private JPanel centerPanel = null;
    private ExceptionTable exceptionTable;
    private MEMProtectionTechniques memProtectionTechniques = null;
    private Map<String, HashSet<MemApplicationPerProtectionMetadataEvent>> uiProtectionApplicationsMap = new HashMap<String, HashSet<MemApplicationPerProtectionMetadataEvent>>();
    private String currentTechniqueSignature = null;
    protected MemPolicyObject memPolicyObject;
    static final float[] TABLE_COLUMN_WIDTH = new float[]{0.2f, 0.6f, 0.2f};
    static final String[] TABLE_COLUMN_NAME = new String[]{Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.name"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.path"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.protected")};
    static final int ACTION_COLUMN_INDEX = 2;

    public MemProtectionTechniqueAppPanel(MEMProtectionTechniques memProtectionTechniques) {
        this.memProtectionTechniques = memProtectionTechniques;
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new VerticalFlowLayout(true, true));
        this.add((Component)this.getMessagePanel(), "North");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messagePanel = new JPanel();
            JLabel descText = new JLabel();
            this.messagePanel.add((Component)descText, "North");
        }
        return this.messagePanel;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new VerticalFlowLayout());
            JScrollPane scroll = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scroll, (JTable)this.getApplicationRulesTable());
            scroll.setOpaque(false);
            scroll.setPreferredSize(new Dimension(400, 300));
            this.centerPanel.add(scroll);
        }
        return this.centerPanel;
    }

    protected void refreshTechniqueDescription(String techniqueSignature) {
        String techniqueName = this.memProtectionTechniques.getTechniqueName(techniqueSignature);
        if (techniqueName == null) {
            techniqueName = techniqueSignature;
        }
        JLabel desc = (JLabel)this.getMessagePanel().getComponent(0);
        if (this.uiProtectionApplicationsMap.get(techniqueSignature) == null || this.uiProtectionApplicationsMap.get(techniqueSignature).isEmpty()) {
            desc.setText(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.mem.mem", "MemProtectionTechniqueAppPanel.noapp.desc"), techniqueName));
        } else {
            desc.setText(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.mem.mem", "MemProtectionTechniqueAppPanel.desc"), techniqueName));
        }
    }

    protected void refresh(String techniqueSignature) {
        this.refreshTechniqueDescription(techniqueSignature);
        this.getApplicationRulesModel().fireTableDataChanged();
    }

    protected JTable getApplicationRulesTable() {
        if (this.exceptionTable == null) {
            this.exceptionTable = new ExceptionTable(this.getApplicationRulesModel());
            this.getApplicationRulesModel().addMouseListenerToHeaderInTable((JTable)((Object)this.exceptionTable));
            TableColumn column = this.exceptionTable.getColumnModel().getColumn(2);
            column.setCellEditor(new DefaultCellEditor(new JComboBox()));
            column.setCellRenderer(new GrayedComboBoxTableCellRenderer());
            UIUtilities.setTableColumnWidth((JTable)((Object)this.exceptionTable), TABLE_COLUMN_WIDTH, (int)this.exceptionTable.getPreferredScrollableViewportSize().getWidth());
            this.exceptionTable.setSelectionMode(2);
            this.exceptionTable.setAutoResizeMode(4);
        }
        this.exceptionTable.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "none");
        return this.exceptionTable;
    }

    public SortableTableModel getApplicationRulesModel() {
        if (this.applicationRulesModel == null) {
            this.applicationRulesModel = new SortableTableModel(false){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    MemApplicationPerProtectionMetadataEvent event = (MemApplicationPerProtectionMetadataEvent)MemProtectionTechniqueAppPanel.this.getApplicationRulesModel().getRow(row);
                    return column == 2 && !MemProtectionTechniqueAppPanel.this.memPolicyObject.isExclusiveEdit() && MemProtectionTechniqueAppPanel.this.memProtectionTechniques.isGlobalActionAllowsEdit() && MemProtectionTechniqueAppPanel.this.memProtectionTechniques.isApplicationEditable(event.getName(), event.getPath()) && event.isCustom() == false && MEMPolicyPanel.getEnableMemCheckBoxStatus() != false && !CloudUtil.isCloudMemPolicyInUse();
                }

                @Override
                public void setValueAt(Object value, int row, int column) {
                    MemApplicationPerProtectionMetadataEvent event = (MemApplicationPerProtectionMetadataEvent)MemProtectionTechniqueAppPanel.this.getApplicationRulesModel().getRow(row);
                    String val = (String)value;
                    switch (column) {
                        case 2: {
                            if (val.equals("Yes")) {
                                event.setSelectedAction("Yes");
                                MemProtectionTechniqueAppPanel.this.uiProtectionApplicationsMap.get(MemProtectionTechniqueAppPanel.this.currentTechniqueSignature).add(event);
                                break;
                            }
                            if (val.equals("No")) {
                                event.setSelectedAction("No");
                                MemProtectionTechniqueAppPanel.this.uiProtectionApplicationsMap.get(MemProtectionTechniqueAppPanel.this.currentTechniqueSignature).add(event);
                                break;
                            }
                            if (val.equals("Log")) {
                                event.setSelectedAction("Log");
                                MemProtectionTechniqueAppPanel.this.uiProtectionApplicationsMap.get(MemProtectionTechniqueAppPanel.this.currentTechniqueSignature).add(event);
                                break;
                            }
                            event.setSelectedAction("Default");
                            MemProtectionTechniqueAppPanel.this.uiProtectionApplicationsMap.get(MemProtectionTechniqueAppPanel.this.currentTechniqueSignature).add(event);
                            break;
                        }
                    }
                    MemProtectionTechniqueAppPanel.this.getApplicationRulesModel().fireTableRowsUpdated(row, column);
                }
            };
            this.applicationRulesModel.setColumnNames(TABLE_COLUMN_NAME);
        }
        return this.applicationRulesModel;
    }

    public Vector<TableRow> appendCustomRules(CustomRuleList customRuleList, Vector<TableRow> memProtectionAppRules, String techniqueSignature) throws ConsoleException {
        if (customRuleList == null || memProtectionAppRules == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < customRuleList.getPEPExceptionCount(); ++i) {
            PEPException ex = customRuleList.getPEPException(i);
            PEPThreatRuleList pepThreatRuleList = ex.getOptPEPThreatRuleList();
            if (pepThreatRuleList == null) continue;
            for (int k = 0; k < pepThreatRuleList.getPEPThreatRuleCount(); ++k) {
                PEPThreatRule pepThreatRule = pepThreatRuleList.getPEPThreatRule(k);
                if (!pepThreatRule.getSignatureId().equals(techniqueSignature)) continue;
                MemApplicationPerProtectionMetadataEvent event = new MemApplicationPerProtectionMetadataEvent();
                event.setName(ex.getOptName());
                event.setPath(ex.getOptPath());
                String selectedAction = this.getSelectedEventAction(pepThreatRule);
                event.creatCustomApplicationComboBox(selectedAction);
                event.setActionForCustomApps(selectedAction);
                event.setCustom(Boolean.TRUE);
                memProtectionAppRules.add(event);
            }
        }
        return memProtectionAppRules;
    }

    public MemPolicy updatePolicy(MemPolicy memPolicy) {
        this.saveExceptions(memPolicy);
        return memPolicy;
    }

    private MemPolicy saveExceptions(MemPolicy memPolicy) {
        if (memPolicy == null || this.uiProtectionApplicationsMap == null) {
            throw new IllegalArgumentException();
        }
        if (!this.uiProtectionApplicationsMap.isEmpty()) {
            memPolicy = MemProtectionTechniqueAppPanel.cleanUpPolicyPepApplicationExceptions(memPolicy);
            for (Map.Entry<String, HashSet<MemApplicationPerProtectionMetadataEvent>> entry : this.uiProtectionApplicationsMap.entrySet()) {
                String techniqueSignature = entry.getKey();
                PEPExceptionList pepExceptionList = memPolicy.getOptPEPExceptionList();
                for (MemApplicationPerProtectionMetadataEvent memApplicationPerProtectionMetadataEvent : entry.getValue()) {
                    int indexInAppList;
                    String appName = memApplicationPerProtectionMetadataEvent.getName();
                    String appPath = memApplicationPerProtectionMetadataEvent.getPath();
                    String action = memApplicationPerProtectionMetadataEvent.getSelectedAction();
                    if (action == null || "Default".equals(action)) continue;
                    if (pepExceptionList == null) {
                        pepExceptionList = new PEPExceptionList();
                    }
                    PEPException pepException = null;
                    PEPThreatRuleList pepThreatRuleList = null;
                    PEPThreatRule pepThreatRule = WinMemMetadataObject.createPepThreatRule(techniqueSignature);
                    if (pepThreatRule == null) {
                        PEPThreatRule tempPepThreatRule = this.memProtectionTechniques.getPepThreatRule(techniqueSignature);
                        pepThreatRule = new PEPThreatRule();
                        pepThreatRule.setTechniqueName(tempPepThreatRule.getTechniqueName());
                        pepThreatRule.setSignatureId(tempPepThreatRule.getSignatureId());
                        pepThreatRule.setOptAction(tempPepThreatRule.getOptAction());
                        pepThreatRule.setOptLogAction(tempPepThreatRule.getDefLogAction());
                        pepThreatRule.setOptEnabledState(tempPepThreatRule.getOptEnabledState());
                    }
                    if ((indexInAppList = MemProtectionTechniqueAppPanel.getIndexOfException(pepExceptionList, appName, appPath)) == -1) {
                        pepException = new PEPException();
                        pepThreatRuleList = new PEPThreatRuleList();
                    } else {
                        pepException = pepExceptionList.getPEPException(indexInAppList);
                        pepThreatRuleList = pepException.getOptPEPThreatRuleList() != null ? pepException.getOptPEPThreatRuleList() : new PEPThreatRuleList();
                    }
                    pepException.setOptName(appName);
                    pepException.setOptPath(appPath);
                    if ("Yes".equals(action)) {
                        pepThreatRule.setOptAction(PEPThreatRule.BLOCK);
                        pepThreatRule.setOptLogAction(PEPThreatRule.ENABLE);
                        pepThreatRule.setOptEnabledState(Boolean.TRUE);
                    } else if ("No".equals(action)) {
                        pepThreatRule.setOptAction(PEPThreatRule.ALLOW);
                        pepThreatRule.setOptLogAction(PEPThreatRule.DISABLE);
                        pepThreatRule.setOptEnabledState(Boolean.FALSE);
                    } else if ("Log".equals(action)) {
                        pepThreatRule.setOptAction(PEPThreatRule.ALLOW);
                        pepThreatRule.setOptLogAction(PEPThreatRule.ENABLE);
                        pepThreatRule.setOptEnabledState(Boolean.TRUE);
                    }
                    pepThreatRuleList.addPEPThreatRule(pepThreatRule);
                    pepException.setOptPEPThreatRuleList(pepThreatRuleList);
                    if (indexInAppList == -1) {
                        pepExceptionList.addPEPException(pepException);
                    }
                    memPolicy.setOptPEPExceptionList(pepExceptionList);
                }
            }
        }
        return memPolicy;
    }

    private static int getIndexOfException(PEPExceptionList pepExceptionList, String appName, String appPath) {
        for (int i = 0; i < pepExceptionList.getPEPExceptionCount(); ++i) {
            if (!appName.equals(pepExceptionList.getPEPException(i).getOptName()) || !appPath.equals(pepExceptionList.getPEPException(i).getOptPath()) || pepExceptionList.getPEPException(i).getOptPEPThreatRuleList() == null) continue;
            return i;
        }
        return -1;
    }

    private static MemPolicy cleanUpPolicyPepApplicationExceptions(MemPolicy memPolicy) {
        int i;
        if (memPolicy.getOptPEPExceptionList() == null) {
            return memPolicy;
        }
        ArrayList<PEPException> memApplicationList = new ArrayList<PEPException>();
        ArrayList<PEPThreatRule> memThreatRule = new ArrayList<PEPThreatRule>();
        PEPExceptionList pepExceptionList = memPolicy.getOptPEPExceptionList();
        for (i = 0; i < pepExceptionList.getPEPExceptionCount(); ++i) {
            int j;
            PEPThreatRuleList pepThreatRuleList = pepExceptionList.getPEPException(i).getOptPEPThreatRuleList();
            if (pepThreatRuleList == null) continue;
            for (j = 0; j < pepThreatRuleList.getPEPThreatRuleCount(); ++j) {
                memThreatRule.add(pepThreatRuleList.getPEPThreatRule(j));
            }
            for (j = 0; j < memThreatRule.size(); ++j) {
                pepThreatRuleList.removePEPThreatRule((PEPThreatRule)memThreatRule.get(i));
            }
            memApplicationList.add(pepExceptionList.getPEPException(i));
        }
        for (i = 0; i < memApplicationList.size(); ++i) {
            pepExceptionList.removePEPException((PEPException)memApplicationList.get(i));
        }
        return memPolicy;
    }

    private String getSelectedEventAction(PEPThreatRule pepThreatRule) throws ConsoleException {
        String action = "";
        if (!pepThreatRule.getOptEnabledState().booleanValue()) {
            action = "No";
        } else if (pepThreatRule.getOptEnabledState().booleanValue()) {
            if (PEPThreatRule.BLOCK.equals(pepThreatRule.getOptAction()) && PEPThreatRule.ENABLE.equals(pepThreatRule.getOptLogAction())) {
                action = "Yes";
            } else if (PEPThreatRule.ALLOW.equals(pepThreatRule.getOptAction()) && PEPThreatRule.ENABLE.equals(pepThreatRule.getOptLogAction())) {
                action = "Log";
            }
        } else {
            throw new ConsoleException("Not able to map the pepthreat application actions properly!");
        }
        return action;
    }

    private Vector<TableRow> getAppListFromDatabase(MemPolicyObject memPolicyObj, String techniqueSignautre) throws ConsoleException {
        Vector<TableRow> dbMemProtectionAppRules = new Vector<TableRow>();
        if (memPolicyObj != null) {
            PEPExceptionList pepExceptionList = memPolicyObj.getMemPolicy().getOptPEPExceptionList();
            if (pepExceptionList == null) {
                pepExceptionList = new PEPExceptionList();
            }
            HashSet<String> uniqueNames = new HashSet<String>();
            for (int i = 0; i < pepExceptionList.getPEPExceptionCount(); ++i) {
                PEPException ex = pepExceptionList.getPEPException(i);
                PEPThreatRuleList pepThreatRuleList = ex.getOptPEPThreatRuleList();
                if (pepThreatRuleList == null) continue;
                for (int k = 0; k < pepThreatRuleList.getPEPThreatRuleCount(); ++k) {
                    PEPThreatRule pepThreatRule = pepThreatRuleList.getPEPThreatRule(k);
                    if (!pepThreatRule.getSignatureId().equals(techniqueSignautre) || uniqueNames.contains(ex.getOptPath())) continue;
                    MemApplicationPerProtectionMetadataEvent event = new MemApplicationPerProtectionMetadataEvent();
                    event.setName(ex.getOptName());
                    event.setPath(ex.getOptPath());
                    String selectedAction = this.getSelectedEventAction(pepThreatRule);
                    event.setSelectedAction(selectedAction);
                    dbMemProtectionAppRules.add(event);
                    uniqueNames.add(event.getName());
                }
            }
        }
        return dbMemProtectionAppRules;
    }

    private Vector<TableRow> mergeAppLists(Vector<TableRow> dbAppList, Vector<TableRow> defAppList, String signatureId) {
        MemApplicationPerProtectionMetadataEvent row;
        Vector<TableRow> mergeApplicationList = new Vector<TableRow>();
        Iterator<TableRow> defRowIterator = defAppList.iterator();
        boolean noLogActionForThisTechnique = this.memProtectionTechniques.getNoLogSignatureIds().contains(signatureId);
        block0: while (defRowIterator.hasNext()) {
            TableRow defTableRow = defRowIterator.next();
            Iterator<TableRow> dbRowIterator = dbAppList.iterator();
            while (dbRowIterator.hasNext()) {
                TableRow dbTableRow = dbRowIterator.next();
                if (!defTableRow.getValueAt(0).equals(dbTableRow.getValueAt(0)) || !defTableRow.getValueAt(1).equals(dbTableRow.getValueAt(1))) continue;
                MemApplicationPerProtectionMetadataEvent row2 = new MemApplicationPerProtectionMetadataEvent();
                row2.setName((String)dbTableRow.getValueAt(0));
                row2.setPath((String)dbTableRow.getValueAt(1));
                row2.setDefaultAction((String)defTableRow.getValueAt(3));
                if (noLogActionForThisTechnique) {
                    row2.createApplicationActionCombo(false);
                } else {
                    row2.createApplicationActionCombo(true);
                }
                row2.setSelectedAction((String)dbTableRow.getValueAt(2));
                dbRowIterator.remove();
                defRowIterator.remove();
                mergeApplicationList.add(row2);
                continue block0;
            }
        }
        if (!defAppList.isEmpty()) {
            for (TableRow defTableRow : defAppList) {
                row = new MemApplicationPerProtectionMetadataEvent();
                row.setName((String)defTableRow.getValueAt(0));
                row.setPath((String)defTableRow.getValueAt(1));
                row.setDefaultAction((String)defTableRow.getValueAt(3));
                if (noLogActionForThisTechnique) {
                    row.createApplicationActionCombo(false);
                } else {
                    row.createApplicationActionCombo(true);
                }
                row.setSelectedAction("Default");
                mergeApplicationList.add(row);
            }
        }
        if (!dbAppList.isEmpty()) {
            for (TableRow tableRow : dbAppList) {
                row = new MemApplicationPerProtectionMetadataEvent();
                row.setName((String)tableRow.getValueAt(0));
                row.setPath((String)tableRow.getValueAt(1));
                row.setDefaultAction(null);
                if (noLogActionForThisTechnique) {
                    row.createApplicationActionCombo(false);
                } else {
                    row.createApplicationActionCombo(true);
                }
                row.setSelectedAction((String)tableRow.getValueAt(2));
                mergeApplicationList.add(row);
            }
        }
        return mergeApplicationList;
    }

    private Vector<TableRow> getAppListFromContent(String techniqueSignature) {
        Vector<TableRow> appList = new Vector();
        try {
            appList = WinMemMetadataObject.getApplicationRule(techniqueSignature);
        }
        catch (ConsoleException consoleException) {
            ConsoleLogger.log("MemProtectionAppRulesPanel>> getAppListFromContent> MEM content for application is missing!");
        }
        return appList;
    }

    public void initializeMemApplicationMap(MemPolicyObject memPolicyObj, Set<String> techniqueSignatures) throws ConsoleException {
        this.memPolicyObject = memPolicyObj;
        if (memPolicyObj != null) {
            for (String signatureId : techniqueSignatures) {
                Vector<TableRow> memProtectionAppRules = this.mergeAppLists(this.getAppListFromDatabase(memPolicyObj, signatureId), this.getAppListFromContent(signatureId), signatureId);
                this.populateUiProtectionApplicationsMap(memProtectionAppRules, signatureId);
            }
        } else {
            ConsoleLogger.log("MemApplicationRulesPanel>>initializeMemApplicationtionMap> MEM Policy was null!");
        }
    }

    public void setObject(MemPolicyObject memPolicyObj, String techniqueSignature) throws ConsoleException {
        this.currentTechniqueSignature = techniqueSignature;
        this.memPolicyObject = memPolicyObj;
        Vector<TableRow> memProtectionAppRules = new Vector<TableRow>();
        if (memPolicyObj != null) {
            HashSet<MemApplicationPerProtectionMetadataEvent> applicationMap = this.uiProtectionApplicationsMap.get(techniqueSignature);
            if (applicationMap != null && !applicationMap.isEmpty()) {
                for (MemApplicationPerProtectionMetadataEvent tableRow : applicationMap) {
                    memProtectionAppRules.add(tableRow);
                }
            }
            MemPolicy memPolicy = memPolicyObj.getMemPolicy();
            boolean enableAdvanced = Utility.getBooleanValue((Boolean)memPolicy.getOptEnableAdvanced(), (Boolean)memPolicy.getDefEnableAdvanced());
            CustomRuleList customRuleList = memPolicy.getOptCustomRuleList();
            if (enableAdvanced && customRuleList != null) {
                memProtectionAppRules = this.appendCustomRules(customRuleList, memProtectionAppRules, techniqueSignature);
            }
        } else {
            ConsoleLogger.log("MemApplicationRulesPanel>>setObject> MEM Policy was null!");
        }
        this.getApplicationRulesTable().removeEditor();
        TableColumn column = this.getApplicationRulesTable().getColumnModel().getColumn(2);
        column.setCellEditor(new DefaultCellEditor(new JComboBox()));
        column.setCellRenderer(new GrayedComboBoxTableCellRenderer());
        this.getApplicationRulesModel().setDataVector(memProtectionAppRules);
        this.refreshTechniqueDescription(this.currentTechniqueSignature);
    }

    public void populateUiProtectionApplicationsMap(Vector<TableRow> memProtectionAppRules, String techniqueSignature) {
        HashSet<MemApplicationPerProtectionMetadataEvent> uiApplicationActionMap = new HashSet<MemApplicationPerProtectionMetadataEvent>();
        if (this.uiProtectionApplicationsMap.get(techniqueSignature) == null) {
            this.uiProtectionApplicationsMap.put(techniqueSignature, uiApplicationActionMap);
        }
        for (int j = 0; j < memProtectionAppRules.size(); ++j) {
            TableRow row = memProtectionAppRules.get(j);
            MemApplicationPerProtectionMetadataEvent event = (MemApplicationPerProtectionMetadataEvent)row;
            if (event.isCustom().booleanValue() || this.uiProtectionApplicationsMap.get(techniqueSignature).contains(event)) continue;
            uiApplicationActionMap.add(event);
        }
    }

    private class ExceptionTable
    extends StripesTable {
        private static final long serialVersionUID = 1L;

        public ExceptionTable(TableModel tableModel) {
            super(tableModel);
        }

        public TableCellEditor getCellEditor(int row, int column) {
            this.setRowSelectionInterval(row, row);
            TableCellEditor editor = null;
            MemApplicationPerProtectionMetadataEvent event = (MemApplicationPerProtectionMetadataEvent)MemProtectionTechniqueAppPanel.this.getApplicationRulesModel().getRow(row);
            switch (column) {
                case 2: {
                    editor = new DefaultCellEditor(event.getComboForGivenRow());
                    break;
                }
                default: {
                    editor = this.getDefaultEditor(this.getColumnClass(column));
                }
            }
            return editor;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int row = this.rowAtPoint(point);
            int column = this.columnAtPoint(point);
            MemApplicationPerProtectionMetadataEvent event = (MemApplicationPerProtectionMetadataEvent)MemProtectionTechniqueAppPanel.this.getApplicationRulesModel().getRow(row);
            if (column == 2) {
                if (MemProtectionTechniqueAppPanel.this.memPolicyObject.isExclusiveEdit()) {
                    return Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isExclusiveEdit");
                }
                if (CloudUtil.isCloudMemPolicyInUse()) {
                    return Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.managedByCloud");
                }
                if (!MEMPolicyPanel.getEnableMemCheckBoxStatus().booleanValue()) {
                    return Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isMemDisabled");
                }
                if (!MemProtectionTechniqueAppPanel.this.memProtectionTechniques.isGlobalActionAllowsEdit()) {
                    return Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isGlobalActionAllowsEdit");
                }
                if (!MemProtectionTechniqueAppPanel.this.memProtectionTechniques.isApplicationEditable(event.getName(), event.getPath())) {
                    return Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isApplicationEditable");
                }
                if (event.isCustom().booleanValue()) {
                    return Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isCustom");
                }
            }
            return null;
        }
    }
}

