/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.mem;

import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.mem.MEMPolicyPanel;
import com.sygate.scm.console.ui.policy.mem.MEMPolicyTabPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;

public class MemPolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_WIDTH_BUFFER = 150;
    private MEMPolicyPanel memPolicyPanel;
    private static final MessageResourcesFile MSG_DIALOG = new MessageResourcesFile("com.sygate.scm.console.ui.policy.mem.mem");
    private MemPolicyObject memPolicyObject;
    private Map<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();

    public MemPolicyDialog(AbstractUIObject pool) {
        this(pool, false);
    }

    public MemPolicyDialog(String name, GroupPolicyObject gpObj, Boolean ... isLocal) {
        super(169, name, gpObj, MSG_DIALOG.getString("MemPolicyDialog.title"), false, isLocal);
    }

    public MemPolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(169, pool, MSG_DIALOG.getString("MemPolicyDialog.title"), isCheckPolicyEnforcement, false);
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getMEMPanel()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.mem.mem", "MemPolicyDialog.title"));
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        this.makeWider(150);
        MEMPolicyTabPanel panel = new MEMPolicyTabPanel(this, "<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.mem.mem", "MemPolicy") + "</html>", "firewall_policy_32.png");
        panel.putClientProperty("cssClass", "fwPolicyDialogPanel");
        return panel;
    }

    private MEMPolicyPanel getMEMPanel() {
        if (this.memPolicyPanel == null) {
            this.memPolicyPanel = new MEMPolicyPanel();
        }
        return this.memPolicyPanel;
    }

    @Override
    protected void commit() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.memPolicyObject.setName(this.getOverviewPanel().getPolicyName());
        this.memPolicyObject.setDesc(this.getOverviewPanel().getPolicyDesc());
        this.memPolicyObject.setEnabled(this.getOverviewPanel().isPolicyEnabled());
        this.memPolicyPanel.updatePolicy();
        this.setCursor(Cursor.getDefaultCursor());
        if (LicenseObject.getInstance().isSBProduct()) {
            PolicyHelper.refreshSerialNumber();
        }
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject schema) {
        MemPolicy policy = (MemPolicy)schema;
        this.memPolicyObject = new MemPolicyObject((TopLevelObject)policy);
        this.setValue();
        this.memPolicyPanel.setValue(this.memPolicyObject);
        if (this.memPolicyObject.isExclusiveEdit() || CloudUtil.isCloudMemPolicyInUse()) {
            this.getOverviewPanel().setReadOnly();
            this.jBOk.setEnabled(false);
            UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.jBCancel);
        }
        return this.memPolicyObject;
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        String newName;
        this.setNewPolicy(true);
        MemPolicy policy = this.createMemPolicy();
        this.memPolicyObject = new MemPolicyObject((TopLevelObject)policy);
        if (this.memPolicyObject.getName() != null && (newName = PolicyHandler.adjustName(this.memPolicyObject.getName(), pool.getAllName(), 512)) != null) {
            this.memPolicyObject.setName(newName);
        }
        this.memPolicyObject.addNewObj((TopLevelObject)policy);
        this.memPolicyObject.addNewObj(this.newObjList);
        this.newObjList.clear();
        this.setValue();
        this.memPolicyPanel.setValue(this.memPolicyObject);
        return this.memPolicyObject;
    }

    private MemPolicy createMemPolicy() {
        MemPolicy memPolicy = null;
        try {
            memPolicy = PolicyHandler.getDefaultMemPolicy(this.newObjList);
            if (memPolicy == null) {
                memPolicy = new MemPolicy();
                String gUidString = new GUIDGenerator().getGUIDString();
                memPolicy.setId(gUidString);
                MetadataAttributes metadataAtrribute = new MetadataAttributes();
                memPolicy.setMetadataAttributes(metadataAtrribute);
                memPolicy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
            }
        }
        catch (Exception exception) {
            LoggerUtilities.logException((Throwable)exception);
            JOptionPane.showMessageDialog(Manager.getFrame(), exception.getMessage(), MemPolicyDialog.getString("MemPolicyDialog.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return memPolicy;
    }

    private void setValue() {
        this.getOverviewPanel().setObject(this.memPolicyObject);
        this.getOverviewPanel().setPolicyEnabled(this.memPolicyObject.getEnabled());
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.mem.mem", key);
    }
}

