/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.mem;

import com.sygate.scm.common.configobject.schema.CustomRuleList;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.PEPException;
import com.sygate.scm.common.configobject.schema.PEPExceptionList;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.mem.MEMPolicyPanel;
import com.sygate.scm.console.ui.policy.mem.MEMProtectionTechniques;
import com.sygate.scm.console.ui.policy.mem.logicobject.MemApplicationMetadataEvent;
import com.sygate.scm.console.ui.policy.mem.logicobject.WinMemMetadataObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class MemApplicationRulesPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JPanel topPanel;
    private JPanel centerPanel;
    protected MemPolicyObject memPolicyObject;
    private Vector<MemApplicationMetadataEvent> memApplicationRules = null;
    private SortableTableModel applicationRulesModel;
    private JTable exceptionTable;
    private MEMProtectionTechniques memProtectionTechniques = null;
    static final float[] TABLE_COLUMN_WIDTH = new float[]{0.1f, 0.3f, 0.6f};
    static final String[] TABLE_COLUMN_NAME = new String[]{Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.protected"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.name"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.path")};

    public MemApplicationRulesPanel() {
        this.initialize();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return null;
    }

    public void setMemProtectionTechniques(MEMProtectionTechniques memProtectionTechniques) {
        this.memProtectionTechniques = memProtectionTechniques;
    }

    protected void initialize() {
        JPanel exceptionPanel = new JPanel();
        this.setLayout(new VerticalFlowLayout());
        exceptionPanel.setLayout(new GridBagLayout());
        this.add(exceptionPanel);
        exceptionPanel.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 0));
        exceptionPanel.add((Component)this.getTopPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        exceptionPanel.add((Component)this.getCenterPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        exceptionPanel.add(Box.createGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel getTopPanel() {
        if (this.topPanel == null) {
            String strPolicyTitle = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.title");
            String strPolicyDesc = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.desc");
            this.topPanel = new AvTemplatePane(strPolicyTitle, strPolicyDesc, false);
        }
        return this.topPanel;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new VerticalFlowLayout());
            JScrollPane scroll = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scroll, (JTable)this.getApplicationRulesTable());
            scroll.setOpaque(false);
            scroll.setPreferredSize(new Dimension(400, 350));
            this.centerPanel.add(scroll);
        }
        return this.centerPanel;
    }

    protected JTable getApplicationRulesTable() {
        if (this.exceptionTable == null) {
            this.exceptionTable = new StripesTable(this.getApplicationRulesModel()){
                private static final long serialVersionUID = 1L;

                public String getToolTipText(MouseEvent mouseEvent) {
                    int column = this.columnAtPoint(mouseEvent.getPoint());
                    int row = this.rowAtPoint(mouseEvent.getPoint());
                    if (column == 0) {
                        MemApplicationMetadataEvent event = (MemApplicationMetadataEvent)MemApplicationRulesPanel.this.getApplicationRulesModel().getRow(row);
                        if (MemApplicationRulesPanel.this.memPolicyObject.isExclusiveEdit()) {
                            return Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isExclusiveEdit");
                        }
                        if (CloudUtil.isCloudMemPolicyInUse()) {
                            return Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.managedByCloud");
                        }
                        if (!MEMPolicyPanel.getEnableMemCheckBoxStatus().booleanValue()) {
                            return Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isMemDisabled");
                        }
                        if (event.isCustom().booleanValue()) {
                            return Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isCustom");
                        }
                    }
                    return null;
                }
            };
            this.getApplicationRulesModel().addMouseListenerToHeaderInTable(this.exceptionTable);
            UIUtilities.setTableColumnWidth(this.exceptionTable, TABLE_COLUMN_WIDTH, (int)this.exceptionTable.getPreferredScrollableViewportSize().getWidth());
            this.exceptionTable.setSelectionMode(2);
            this.exceptionTable.setAutoResizeMode(4);
        }
        this.exceptionTable.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "none");
        return this.exceptionTable;
    }

    public void updatePolicy() {
        MemPolicy memPolicy = this.memPolicyObject.getMemPolicy();
        MemApplicationRulesPanel.saveExceptions(memPolicy, this.memApplicationRules);
    }

    public static MemPolicy saveExceptions(MemPolicy memPolicy, Vector<MemApplicationMetadataEvent> rules) {
        if (memPolicy == null || rules == null) {
            throw new IllegalArgumentException();
        }
        int disabledRulesCount = MemApplicationRulesPanel.getDisabledRuleCount(rules);
        if (disabledRulesCount == 0) {
            return MemApplicationRulesPanel.cleanUpPolicyPepExceptions(memPolicy);
        }
        if (memPolicy.getOptPEPExceptionList() == null) {
            memPolicy.setOptPEPExceptionList(new PEPExceptionList());
        }
        memPolicy = MemApplicationRulesPanel.cleanUpPolicyPepExceptions(memPolicy);
        List<PEPException> memApplicationList = MemApplicationRulesPanel.getPepExceptionsFromRules(rules);
        for (int i = 0; i < memApplicationList.size(); ++i) {
            memPolicy.getOptPEPExceptionList().addPEPException(memApplicationList.get(i));
        }
        return memPolicy;
    }

    private static List<PEPException> getPepExceptionsFromRules(Vector<MemApplicationMetadataEvent> rules) {
        ArrayList<PEPException> memApplicationList = new ArrayList<PEPException>();
        for (int i = 0; i < rules.size(); ++i) {
            MemApplicationMetadataEvent memApplicationMetadataEvent = rules.get(i);
            if (memApplicationMetadataEvent.isEnabled().booleanValue() || memApplicationMetadataEvent.isCustom().booleanValue()) continue;
            PEPException pepEx = new PEPException();
            pepEx.setOptName(memApplicationMetadataEvent.getName());
            pepEx.setOptPath(memApplicationMetadataEvent.getPath());
            memApplicationList.add(pepEx);
        }
        return memApplicationList;
    }

    private static MemPolicy cleanUpPolicyPepExceptions(MemPolicy memPolicy) {
        int i;
        if (memPolicy.getOptPEPExceptionList() == null) {
            return memPolicy;
        }
        ArrayList<PEPException> memApplicationList = new ArrayList<PEPException>();
        PEPExceptionList pepExceptionList = memPolicy.getOptPEPExceptionList();
        for (i = 0; i < pepExceptionList.getPEPExceptionCount(); ++i) {
            if (pepExceptionList.getPEPException(i).getOptPEPThreatRuleList() != null) continue;
            memApplicationList.add(pepExceptionList.getPEPException(i));
        }
        for (i = 0; i < memApplicationList.size(); ++i) {
            pepExceptionList.removePEPException((PEPException)memApplicationList.get(i));
        }
        return memPolicy;
    }

    private static int getDisabledRuleCount(Vector<MemApplicationMetadataEvent> rules) {
        int count = 0;
        for (int i = 0; i < rules.size(); ++i) {
            MemApplicationMetadataEvent memApplicationMetadataEvent = rules.get(i);
            if (memApplicationMetadataEvent.isEnabled().booleanValue()) continue;
            ++count;
        }
        return count;
    }

    private Set<MemApplicationMetadataEvent> getMemApplicationsFromDatabase(MemPolicyObject memPolicyObj) {
        HashSet<MemApplicationMetadataEvent> dbMemApplicationsRules = new HashSet<MemApplicationMetadataEvent>();
        PEPExceptionList pepExceptionList = memPolicyObj.getMemPolicy().getOptPEPExceptionList();
        if (pepExceptionList != null) {
            for (int i = 0; i < pepExceptionList.getPEPExceptionCount(); ++i) {
                PEPException ex = pepExceptionList.getPEPException(i);
                if (ex.getOptPEPThreatRuleList() != null && ex.getOptPEPThreatRuleList().getPEPThreatRuleCount() != 0) continue;
                MemApplicationMetadataEvent event = new MemApplicationMetadataEvent();
                event.setEnabled(Boolean.FALSE);
                event.setName(ex.getOptName());
                event.setPath(ex.getOptPath());
                event.setCustom(Boolean.FALSE);
                dbMemApplicationsRules.add(event);
            }
        }
        return dbMemApplicationsRules;
    }

    private Set<MemApplicationMetadataEvent> getMemApplicationsFromContent() {
        HashSet<MemApplicationMetadataEvent> appList = new HashSet();
        try {
            appList = WinMemMetadataObject.getMemApplicationRules();
        }
        catch (ConsoleException consoleException) {
            ConsoleLogger.log("MemApplicationRulesPanel>> getAppListFromContent> MEM content for applications are  missing!");
        }
        return appList;
    }

    private Vector<MemApplicationMetadataEvent> mergeAppLists(Set<MemApplicationMetadataEvent> dbAppList, Set<MemApplicationMetadataEvent> defAppList) {
        HashSet<MemApplicationMetadataEvent> mergeApplicationSet = new HashSet<MemApplicationMetadataEvent>();
        for (MemApplicationMetadataEvent dbTableRow : dbAppList) {
            mergeApplicationSet.add(dbTableRow);
        }
        for (MemApplicationMetadataEvent defTableRow : defAppList) {
            if (mergeApplicationSet.contains(defTableRow)) continue;
            mergeApplicationSet.add(defTableRow);
        }
        return new Vector<MemApplicationMetadataEvent>(mergeApplicationSet);
    }

    public void setObject(MemPolicyObject memPolicyObj) throws ConsoleException {
        this.memPolicyObject = memPolicyObj;
        if (memPolicyObj != null) {
            MemPolicy memPolicy = memPolicyObj.getMemPolicy();
            this.memApplicationRules = this.mergeAppLists(this.getMemApplicationsFromDatabase(memPolicyObj), this.getMemApplicationsFromContent());
            boolean enableAdvanced = Utility.getBooleanValue((Boolean)memPolicy.getOptEnableAdvanced(), (Boolean)memPolicy.getDefEnableAdvanced());
            CustomRuleList customRuleList = memPolicy.getOptCustomRuleList();
            if (enableAdvanced && customRuleList != null) {
                this.memApplicationRules = MemApplicationRulesPanel.appendCustomRules(customRuleList, this.memApplicationRules);
            }
        } else {
            ConsoleLogger.log("MemApplicationRulesPanel>>setObject> MEM Policy was null!");
        }
        this.getApplicationRulesModel().setDataVector(new Vector<TableRow>(this.memApplicationRules));
    }

    protected SortableTableModel getApplicationRulesModel() {
        if (this.applicationRulesModel == null) {
            this.applicationRulesModel = new SortableTableModel(false){
                private static final long serialVersionUID = -4151459433427962374L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    MemApplicationMetadataEvent event = (MemApplicationMetadataEvent)MemApplicationRulesPanel.this.getApplicationRulesModel().getRow(row);
                    return column == 0 && !MemApplicationRulesPanel.this.memPolicyObject.isExclusiveEdit() && event.isCustom() == false && MEMPolicyPanel.getEnableMemCheckBoxStatus() != false && !CloudUtil.isCloudMemPolicyInUse();
                }

                @Override
                public void setValueAt(Object value, int row, int column) {
                    MemApplicationMetadataEvent event = (MemApplicationMetadataEvent)MemApplicationRulesPanel.this.getApplicationRulesModel().getRow(row);
                    switch (column) {
                        case 0: {
                            event.setEnabled((Boolean)value);
                            break;
                        }
                    }
                    if (MemApplicationRulesPanel.this.memProtectionTechniques != null && MemApplicationRulesPanel.this.memProtectionTechniques.getProtectionTechniqueAppPanel().getApplicationRulesTable().getCellEditor() != null) {
                        MemApplicationRulesPanel.this.memProtectionTechniques.getProtectionTechniqueAppPanel().getApplicationRulesTable().getCellEditor().stopCellEditing();
                    }
                    MemApplicationRulesPanel.this.getApplicationRulesModel().fireTableRowsUpdated(row, column);
                }
            };
            this.applicationRulesModel.setColumnNames(TABLE_COLUMN_NAME);
        }
        return this.applicationRulesModel;
    }

    public static Vector<TableRow> applyPepExceptions(PEPExceptionList exceptions, Vector<TableRow> memApplicationRules) {
        if (exceptions == null || memApplicationRules == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < exceptions.getPEPExceptionCount(); ++i) {
            PEPException ex = exceptions.getPEPException(i);
            if (ex.getOptPEPThreatRuleList() != null && ex.getOptPEPThreatRuleList().getPEPThreatRuleCount() != 0) continue;
            for (int j = 0; j < memApplicationRules.size(); ++j) {
                TableRow row = memApplicationRules.get(j);
                MemApplicationMetadataEvent event = (MemApplicationMetadataEvent)row;
                if (!event.getName().equalsIgnoreCase(ex.getOptName()) || !event.getPath().equalsIgnoreCase(ex.getOptPath())) continue;
                event.setEnabled(Boolean.FALSE);
                memApplicationRules.set(j, event);
            }
        }
        return memApplicationRules;
    }

    public static Vector<MemApplicationMetadataEvent> appendCustomRules(CustomRuleList customRuleList, Vector<MemApplicationMetadataEvent> memApplicationRules) {
        if (customRuleList == null || memApplicationRules == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < customRuleList.getPEPExceptionCount(); ++i) {
            PEPException ex = customRuleList.getPEPException(i);
            if (ex.getOptPEPThreatRuleList() != null && ex.getOptPEPThreatRuleList().getPEPThreatRuleCount() != 0) continue;
            MemApplicationMetadataEvent event = new MemApplicationMetadataEvent();
            event.setName(ex.getOptName());
            event.setPath(ex.getOptPath());
            event.setEnabled(Boolean.TRUE);
            event.setCustom(Boolean.TRUE);
            memApplicationRules.addElement(event);
        }
        return memApplicationRules;
    }

    public boolean isEmpty() {
        return this.memApplicationRules == null || this.memApplicationRules.size() == 0;
    }

    public Vector<MemApplicationMetadataEvent> getMemApplicationRules() {
        return this.memApplicationRules;
    }
}

