/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.mem;

import com.sygate.scm.common.configobject.schema.CustomRuleList;
import com.sygate.scm.common.configobject.schema.LuDownloadedContent;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.PEPExceptionList;
import com.sygate.scm.common.configobject.schema.PEPThreatRule;
import com.sygate.scm.common.configobject.schema.PEPThreatRuleList;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.ids.handler.IdsLuHandler;
import com.sygate.scm.console.ui.policy.mem.MEMPolicyPanel;
import com.sygate.scm.console.ui.policy.mem.MemApplicationRulesPanel;
import com.sygate.scm.console.ui.policy.mem.MemProtectionTechniqueAppPanel;
import com.sygate.scm.console.ui.policy.mem.logicobject.MemApplicationMetadataEvent;
import com.sygate.scm.console.ui.policy.mem.logicobject.MemProtectionTechniquesMetadata;
import com.sygate.scm.console.ui.policy.mem.logicobject.WinMemMetadataObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.ui.util.renderer.MemActionsCustomListCellRenderer;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MEMProtectionTechniques
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JComboBox<String> techniquesCombo;
    protected transient ItemListener techniquesActionListner;
    protected transient ItemListener globalActionListner;
    protected transient ItemListener globalAuditModeActionListner;
    private MemProtectionTechniqueAppPanel memProtectionTechniqueAppPanel = null;
    private transient MemPolicyObject memPolicyObject;
    private MemApplicationRulesPanel memApplicationRulesPanel;
    JLabel lbProtectionTech = new JLabel(MEMProtectionTechniques.getString("MemTechniquesPanel.memMitigationTechniquesLable"));
    JLabel lbGlobalActions = new JLabel(MEMProtectionTechniques.getString("MemTechniquesPanel.GloballyProtected"));
    private boolean isActionsAvailableFromDefs = true;
    private transient Map<String, CustomComboActions> uiProtectionActionMap = null;
    private Map<String, PEPThreatRule> pepThreatRuleMetadataMap = null;
    JComboBox<String> globalActionsCombo = new JComboBox();
    private String currentTechniqueSignature = null;
    private boolean globalActionAllowsEdit = true;
    private final Set<String> noLogSignatureIds = new HashSet<String>(Arrays.asList("61003", "61004", "61006", "61007"));
    private final JCheckBox globalAuditModeOverrideCheckBox = new JCheckBox(MEMProtectionTechniques.getString("MEMSettingsPanel.checkbox.globalAuditMode"));
    private String memExclusiveEditToolTipMsg = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isExclusiveEdit");
    private String memManagedByCloudToolTipMsg = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.managedByCloud");

    public MEMProtectionTechniques(MemApplicationRulesPanel memApplicationRulesPanel) {
        this.uiProtectionActionMap = new TreeMap<String, CustomComboActions>();
        this.memApplicationRulesPanel = memApplicationRulesPanel;
        this.initSelection();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_gem_settings";
    }

    public Set<String> getNoLogSignatureIds() {
        return this.noLogSignatureIds;
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.mem.mem", key);
    }

    private AvTemplatePane getMessagePane(String desc) {
        AvTemplatePane protectionTechniquesPane = new AvTemplatePane(null, desc, false);
        return protectionTechniquesPane;
    }

    private void initializeTechniquePanel() {
        if (!this.uiProtectionActionMap.isEmpty()) {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbConstraint = new GridBagConstraints();
            gbConstraint.anchor = 23;
            this.techniquesCombo = new JComboBox<String>(this.uiProtectionActionMap.keySet().toArray(new String[this.uiProtectionActionMap.keySet().size()]));
            if (this.techniquesCombo != null) {
                if (this.memPolicyObject.isExclusiveEdit()) {
                    this.techniquesCombo.setEnabled(false);
                    this.techniquesCombo.setToolTipText(this.memExclusiveEditToolTipMsg);
                } else if (CloudUtil.isCloudMemPolicyInUse()) {
                    this.techniquesCombo.setEnabled(false);
                    this.techniquesCombo.setToolTipText(this.memManagedByCloudToolTipMsg);
                } else if (!MEMPolicyPanel.getEnableMemCheckBoxStatus().booleanValue()) {
                    this.techniquesCombo.setEnabled(false);
                    this.techniquesCombo.setToolTipText(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isMemDisabled"));
                }
            }
            this.currentTechniqueSignature = this.techniquesCombo.getItemAt(0);
            String selectedAction = this.uiProtectionActionMap.get(this.currentTechniqueSignature).getSelectedAction();
            List<String> actions = this.createGlobalActionComboList(this.currentTechniqueSignature);
            for (int i = 0; i < actions.size(); ++i) {
                this.globalActionsCombo.addItem(actions.get(i));
            }
            this.globalActionsCombo.setSelectedItem(selectedAction);
            this.addComponent(panel, this.globalAuditModeOverrideCheckBox, gbConstraint, 1, 3, 4, 0.5, 13, new Insets(5, 5, 0, 0));
            this.addComponent(panel, this.lbProtectionTech, gbConstraint, 1, 5, 2, 0.5, 13, new Insets(10, 25, 0, 0));
            this.addComponent(panel, this.techniquesCombo, gbConstraint, 3, 5, 2, 0.5, 17, new Insets(5, 5, 0, 0));
            this.addComponent(panel, this.lbGlobalActions, gbConstraint, 1, 6, 2, 1.0, 13, new Insets(10, 25, 0, 0));
            this.addComponent(panel, this.globalActionsCombo, gbConstraint, 3, 6, 2, 1.0, 17, new Insets(5, 5, 0, 0));
            JPanel exceptionPanel = new JPanel();
            exceptionPanel.setLayout(new GridBagLayout());
            exceptionPanel.add((Component)this.getProtectionTechniqueAppPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            String desc = MEMProtectionTechniques.getString("MemTechniquesPanel.description");
            AvTemplatePane protectionTechniquesPane = this.getMessagePane(desc);
            protectionTechniquesPane.add(panel);
            exceptionPanel.add((Component)protectionTechniquesPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add(exceptionPanel);
            this.updateApplicationActions();
            this.initActions();
        }
    }

    private void initSelection() {
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 0));
    }

    protected MemProtectionTechniqueAppPanel getProtectionTechniqueAppPanel() {
        if (this.memProtectionTechniqueAppPanel == null) {
            this.memProtectionTechniqueAppPanel = new MemProtectionTechniqueAppPanel(this);
        }
        return this.memProtectionTechniqueAppPanel;
    }

    private void updateProtectionAppActions(String action) {
        if (this.memProtectionTechniqueAppPanel != null) {
            if (this.memPolicyObject.isExclusiveEdit()) {
                this.globalActionsCombo.setToolTipText(this.memExclusiveEditToolTipMsg);
            } else if (CloudUtil.isCloudMemPolicyInUse()) {
                this.globalActionsCombo.setToolTipText(this.memManagedByCloudToolTipMsg);
            } else {
                this.globalActionAllowsEdit = (action == null || "Default".equals(action)) && !this.globalAuditModeOverrideCheckBox.isSelected();
                if (!MEMPolicyPanel.getEnableMemCheckBoxStatus().booleanValue()) {
                    this.globalActionsCombo.setEnabled(false);
                    this.globalActionsCombo.setToolTipText(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isMemDisabled"));
                } else if (this.globalAuditModeOverrideCheckBox.isSelected() && !this.noLogSignatureIds.contains(this.currentTechniqueSignature)) {
                    this.globalActionsCombo.setEnabled(false);
                    this.globalActionsCombo.setToolTipText(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isGlobalAuditModeActionAllowsEdit"));
                } else {
                    this.globalActionsCombo.setEnabled(true);
                    this.globalActionsCombo.setToolTipText("");
                }
            }
            if (this.memProtectionTechniqueAppPanel.getApplicationRulesTable().getCellEditor() != null) {
                this.memProtectionTechniqueAppPanel.getApplicationRulesTable().getCellEditor().stopCellEditing();
            }
            if (this.memPolicyObject.isExclusiveEdit() || CloudUtil.isCloudMemPolicyInUse()) {
                this.globalActionsCombo.setEnabled(false);
                this.globalAuditModeOverrideCheckBox.setEnabled(false);
            }
            SortableTableModel tableModel = this.memProtectionTechniqueAppPanel.getApplicationRulesModel();
            tableModel.fireTableDataChanged();
        }
    }

    public boolean isGlobalActionAllowsEdit() {
        return this.globalActionAllowsEdit;
    }

    public PEPThreatRule getPepThreatRule(String techniqueSignature) {
        if (this.pepThreatRuleMetadataMap != null) {
            return this.pepThreatRuleMetadataMap.get(techniqueSignature);
        }
        return null;
    }

    private Map<String, CustomComboActions> mergeProtectionTechniques(Map<String, CustomComboActions> techniquesMapFromContent, Map<String, CustomComboActions> techniquesMapFromDatabase) {
        HashSet<String> techniqueSignatureSet = new HashSet<String>();
        techniqueSignatureSet.addAll(techniquesMapFromDatabase.keySet());
        for (String key : techniquesMapFromContent.keySet()) {
            techniqueSignatureSet.add(key);
        }
        for (String techniqueSignature : techniqueSignatureSet) {
            if (techniquesMapFromDatabase.get(techniqueSignature) != null) {
                if (techniquesMapFromContent.get(techniqueSignature) != null) {
                    String actionPresentInDatabase = techniquesMapFromDatabase.get(techniqueSignature).getSelectedAction();
                    String defaultActionFromContent = techniquesMapFromContent.get(techniqueSignature).getDefaultAction();
                    CustomComboActions techniqueActionCombo = techniquesMapFromContent.get(techniqueSignature);
                    if (actionPresentInDatabase == null) {
                        actionPresentInDatabase = "Default";
                    }
                    techniqueActionCombo.setSelectedAction(actionPresentInDatabase);
                    techniqueActionCombo.setDefaultAction(defaultActionFromContent);
                    this.uiProtectionActionMap.put(techniqueSignature, techniqueActionCombo);
                    continue;
                }
                CustomComboActions techniqueActionCombo = techniquesMapFromDatabase.get(techniqueSignature);
                if (techniqueActionCombo.getSelectedAction() == null) {
                    techniqueActionCombo.setSelectedAction("Default");
                }
                this.uiProtectionActionMap.put(techniqueSignature, techniqueActionCombo);
                continue;
            }
            if (techniquesMapFromContent.get(techniqueSignature) == null) continue;
            this.uiProtectionActionMap.put(techniqueSignature, techniquesMapFromContent.get(techniqueSignature));
        }
        if (!this.uiProtectionActionMap.containsKey("61001")) {
            String selectedAction = "Yes";
            Boolean javaEnable = Utility.getBooleanValue((Boolean)this.memPolicyObject.getMemPolicy().getOptJavaSecurityManagerProtectionEnable(), (Boolean)this.memPolicyObject.getMemPolicy().getDefJavaSecurityManagerProtectionEnable());
            if (!javaEnable.booleanValue()) {
                selectedAction = "No";
            }
            CustomComboActions customComboActions = new CustomComboActions(selectedAction, null);
            this.uiProtectionActionMap.put("61001", customComboActions);
        }
        return this.uiProtectionActionMap;
    }

    public void setObject(MemPolicyObject memPolicyObj) throws ConsoleException {
        this.memPolicyObject = memPolicyObj;
        Map<String, CustomComboActions> protectionTechniquesFromContent = this.getProtectionTechniquesFromContent();
        Map<String, CustomComboActions> protectionTechniquesFromDatabase = this.getProtectionTechniquesFromDatabase();
        this.uiProtectionActionMap = this.mergeProtectionTechniques(protectionTechniquesFromContent, protectionTechniquesFromDatabase);
        this.initializeTechniquePanel();
        this.getProtectionTechniqueAppPanel().initializeMemApplicationMap(memPolicyObj, this.uiProtectionActionMap.keySet());
        if (this.currentTechniqueSignature != null) {
            this.getProtectionTechniqueAppPanel().setObject(memPolicyObj, this.currentTechniqueSignature);
        }
        MemPolicy memPolicy = memPolicyObj.getMemPolicy();
        boolean globalAuditModeOverride = Utility.getBooleanValue((Boolean)memPolicy.getOptGlobalAuditModeOverride(), (Boolean)memPolicy.getDefGlobalAuditModeOverride());
        this.globalAuditModeOverrideCheckBox.removeItemListener(this.globalAuditModeActionListner);
        this.globalAuditModeOverrideCheckBox.setSelected(globalAuditModeOverride);
        this.globalAuditModeOverrideCheckBox.addItemListener(this.globalAuditModeActionListner);
        if (this.memPolicyObject.isExclusiveEdit() || CloudUtil.isCloudMemPolicyInUse()) {
            this.globalActionsCombo.setEnabled(false);
            this.globalAuditModeOverrideCheckBox.setEnabled(false);
        }
        this.updateApplicationActions();
    }

    private String getSelectedAction(boolean state, int action, int logAction) throws ConsoleException {
        if (Boolean.FALSE.equals(state)) {
            return "No";
        }
        String selectedAction = "";
        if (PEPThreatRule.BLOCK.equals(action) && PEPThreatRule.ENABLE.equals(logAction)) {
            selectedAction = "Yes";
        } else if (PEPThreatRule.ALLOW.equals(action) && PEPThreatRule.DISABLE.equals(logAction)) {
            selectedAction = "No";
        } else if (PEPThreatRule.ALLOW.equals(action) && PEPThreatRule.ENABLE.equals(logAction)) {
            selectedAction = "Log";
        } else {
            throw new ConsoleException("Not able to map the mem policy protection action correctly.");
        }
        return selectedAction;
    }

    public void updatePolicy() {
        MemPolicy memPolicy = this.memPolicyObject.getMemPolicy();
        this.saveExceptions(memPolicy);
        this.getProtectionTechniqueAppPanel().updatePolicy(memPolicy);
    }

    public MemPolicy saveExceptions(MemPolicy memPolicy) {
        if (memPolicy == null || this.uiProtectionActionMap == null) {
            throw new IllegalArgumentException();
        }
        memPolicy.setOptGlobalAuditModeOverride(Boolean.valueOf(this.globalAuditModeOverrideCheckBox.isSelected()));
        if (!this.uiProtectionActionMap.isEmpty()) {
            if (this.uiProtectionActionMap.get("61001") != null && "No".equalsIgnoreCase(this.uiProtectionActionMap.get("61001").getSelectedAction())) {
                memPolicy.setOptJavaSecurityManagerProtectionEnable(Boolean.FALSE);
            } else {
                memPolicy.setOptJavaSecurityManagerProtectionEnable(Boolean.TRUE);
            }
            memPolicy = this.cleanUpPolicyPepThreatRules(memPolicy);
            PEPThreatRuleList pepThreatRuleList = null;
            for (Map.Entry<String, CustomComboActions> entry : this.uiProtectionActionMap.entrySet()) {
                String techniqueSignature = entry.getKey();
                String currentAction = entry.getValue().getSelectedAction();
                if (techniqueSignature == null || currentAction == null || "Default".equals(currentAction)) continue;
                pepThreatRuleList = memPolicy.getOptPEPThreatRuleList() != null ? memPolicy.getOptPEPThreatRuleList() : new PEPThreatRuleList();
                PEPThreatRule pepThreatRule = WinMemMetadataObject.createPepThreatRule(techniqueSignature);
                if (pepThreatRule == null && this.pepThreatRuleMetadataMap != null) {
                    if ("61001".equals(techniqueSignature) && "Log".equalsIgnoreCase(this.uiProtectionActionMap.get("61001").getSelectedAction())) {
                        pepThreatRule = new PEPThreatRule();
                        pepThreatRule.setTechniqueName("SecurityMan");
                        pepThreatRule.setSignatureId("61001");
                    } else {
                        PEPThreatRule tempPepThreatRule = this.pepThreatRuleMetadataMap.get(techniqueSignature);
                        if (tempPepThreatRule != null) {
                            pepThreatRule = new PEPThreatRule();
                            pepThreatRule.setTechniqueName(tempPepThreatRule.getTechniqueName());
                            pepThreatRule.setSignatureId(tempPepThreatRule.getSignatureId());
                            pepThreatRule.setOptAction(tempPepThreatRule.getOptAction());
                            pepThreatRule.setOptLogAction(tempPepThreatRule.getDefLogAction());
                            pepThreatRule.setOptEnabledState(tempPepThreatRule.getOptEnabledState());
                        }
                    }
                }
                if (pepThreatRule == null) continue;
                if (currentAction.equals("Yes")) {
                    pepThreatRule.setOptAction(PEPThreatRule.BLOCK);
                    pepThreatRule.setOptLogAction(PEPThreatRule.ENABLE);
                    pepThreatRule.setOptEnabledState(Boolean.TRUE);
                } else if (currentAction.equals("No")) {
                    pepThreatRule.setOptAction(PEPThreatRule.ALLOW);
                    pepThreatRule.setOptLogAction(PEPThreatRule.DISABLE);
                    pepThreatRule.setOptEnabledState(Boolean.FALSE);
                } else {
                    pepThreatRule.setOptAction(PEPThreatRule.ALLOW);
                    pepThreatRule.setOptLogAction(PEPThreatRule.ENABLE);
                    pepThreatRule.setOptEnabledState(Boolean.TRUE);
                }
                pepThreatRuleList.addPEPThreatRule(pepThreatRule);
                memPolicy.setOptPEPThreatRuleList(pepThreatRuleList);
            }
        }
        return memPolicy;
    }

    private MemPolicy cleanUpPolicyPepThreatRules(MemPolicy memPolicy) {
        if (memPolicy.getOptPEPThreatRuleList() == null) {
            return memPolicy;
        }
        ArrayList<PEPThreatRule> memThreatList = new ArrayList<PEPThreatRule>();
        PEPThreatRuleList memThreatRuleList = memPolicy.getOptPEPThreatRuleList();
        for (int i = 0; i < memThreatRuleList.getPEPThreatRuleCount(); ++i) {
            memThreatList.add(memThreatRuleList.getPEPThreatRule(i));
        }
        for (int j = 0; j < memThreatList.size(); ++j) {
            memThreatRuleList.removePEPThreatRule((PEPThreatRule)memThreatList.get(j));
        }
        return memPolicy;
    }

    private int getSelectedItemIndex(String action) {
        if ("61001".equals(this.currentTechniqueSignature)) {
            if (action.equals("Yes")) {
                return 0;
            }
            if (action.equals("No")) {
                return 1;
            }
            if (action.equals("Log")) {
                return 2;
            }
        }
        if (action.equals("Default")) {
            return 0;
        }
        if (action.equals("Yes")) {
            return 1;
        }
        if (action.equals("No")) {
            return 2;
        }
        if (action.equals("Log") && !this.noLogSignatureIds.contains(this.currentTechniqueSignature)) {
            return 3;
        }
        return 0;
    }

    private void setSelectedAction(String techniqueSignature) {
        if (this.uiProtectionActionMap.get(techniqueSignature) != null) {
            this.globalActionsCombo.removeItemListener(this.globalActionListner);
            this.globalActionsCombo.removeAllItems();
            String selectedAction = this.uiProtectionActionMap.get(techniqueSignature).getSelectedAction();
            List<String> actions = this.createGlobalActionComboList(techniqueSignature);
            for (int i = 0; i < actions.size(); ++i) {
                this.globalActionsCombo.addItem(actions.get(i));
            }
            int index = this.getSelectedItemIndex(selectedAction);
            this.globalActionsCombo.setSelectedIndex(index);
            String defaultAction = this.uiProtectionActionMap.get(techniqueSignature).getDefaultAction();
            MemActionsCustomListCellRenderer memActionsCustomListCellRenderer = new MemActionsCustomListCellRenderer(defaultAction);
            this.globalActionsCombo.setRenderer(memActionsCustomListCellRenderer);
            this.globalActionsCombo.addItemListener(this.globalActionListner);
            this.globalActionsCombo.repaint();
        }
    }

    private void addComponent(Container container, Component comp, GridBagConstraints gbConstraint, int xpos, int ypos, int width, double weightX, int fill, Insets inset) {
        if (gbConstraint == null) {
            gbConstraint = new GridBagConstraints();
        }
        gbConstraint.gridx = xpos;
        gbConstraint.gridy = ypos;
        gbConstraint.gridwidth = width;
        gbConstraint.weightx = weightX;
        gbConstraint.fill = fill;
        gbConstraint.insets = inset == null ? new Insets(0, 0, 0, 0) : inset;
        container.add(comp, gbConstraint);
    }

    private List<String> createGlobalActionComboList(String techniqueSignature) {
        ArrayList<String> actions = new ArrayList<String>();
        actions.add("Default");
        actions.add("Yes");
        actions.add("No");
        if (!this.noLogSignatureIds.contains(techniqueSignature)) {
            actions.add("Log");
        }
        if ("61001".equals(techniqueSignature)) {
            actions.remove("Default");
        }
        return actions;
    }

    private Map<String, CustomComboActions> getProtectionTechniquesFromContent() {
        HashMap<String, CustomComboActions> techniquesMapFromDefs;
        block8: {
            techniquesMapFromDefs = new HashMap<String, CustomComboActions>();
            try {
                ArrayList<MemProtectionTechniquesMetadata> protectionTechniques = WinMemMetadataObject.getMemProtectionTechniques();
                if (null != protectionTechniques && protectionTechniques.size() > 0) {
                    for (int i = 0; i < protectionTechniques.size(); ++i) {
                        MemProtectionTechniquesMetadata metadata = protectionTechniques.get(i);
                        String selectedAction = "Default";
                        CustomComboActions customComboActions = new CustomComboActions(selectedAction, metadata.getDefaultAction());
                        techniquesMapFromDefs.put(metadata.getSignatuerId(), customComboActions);
                    }
                    break block8;
                }
                LuDownloadedContent sepmMedataContent = null;
                try {
                    sepmMedataContent = IdsLuHandler.getLatestSepmMetadataContent();
                }
                catch (ConsoleException e) {
                    ConsoleLogger.log("MEMProtectionTechniques>> getProtectionTechniquesFromContent>Cannot retrieve the latest SEPM metadata content.");
                }
                if (sepmMedataContent == null) {
                    this.isActionsAvailableFromDefs = false;
                }
            }
            catch (ConsoleException consoleException) {
                this.isActionsAvailableFromDefs = false;
            }
        }
        if (!this.isActionsAvailableFromDefs) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MEMProtectionTechniques.getString("MemTechniquesPanel.noTechniques"), MEMProtectionTechniques.getString("MemTechniquesPanel.warning"), 2);
        }
        return techniquesMapFromDefs;
    }

    private Map<String, CustomComboActions> getProtectionTechniquesFromDatabase() {
        HashMap<String, CustomComboActions> techniquesMapFromDatabase;
        block11: {
            techniquesMapFromDatabase = new HashMap<String, CustomComboActions>();
            try {
                if (this.memPolicyObject != null) {
                    CustomRuleList pepCustomRuleList;
                    PEPExceptionList pepExceptionList;
                    MemPolicy memPolicy = this.memPolicyObject.getMemPolicy();
                    this.pepThreatRuleMetadataMap = new HashMap<String, PEPThreatRule>();
                    PEPThreatRuleList pepThreatRuleList = memPolicy.getOptPEPThreatRuleList();
                    if (pepThreatRuleList != null) {
                        for (int i = 0; i < pepThreatRuleList.getPEPThreatRuleCount(); ++i) {
                            this.pepThreatRuleMetadataMap.put(pepThreatRuleList.getPEPThreatRule(i).getSignatureId(), pepThreatRuleList.getPEPThreatRule(i));
                            String selectedAction = this.getSelectedAction(Utility.getBooleanValue((Boolean)pepThreatRuleList.getPEPThreatRule(i).getOptEnabledState(), (Boolean)pepThreatRuleList.getPEPThreatRule(i).getDefEnabledState()), pepThreatRuleList.getPEPThreatRule(i).getOptAction(), pepThreatRuleList.getPEPThreatRule(i).getOptLogAction());
                            CustomComboActions customComboActions = new CustomComboActions(selectedAction, null);
                            techniquesMapFromDatabase.put(pepThreatRuleList.getPEPThreatRule(i).getSignatureId(), customComboActions);
                        }
                    }
                    if ((pepExceptionList = memPolicy.getOptPEPExceptionList()) != null) {
                        for (int i = 0; i < pepExceptionList.getPEPExceptionCount(); ++i) {
                            pepThreatRuleList = pepExceptionList.getPEPException(i).getOptPEPThreatRuleList();
                            if (pepThreatRuleList == null || pepThreatRuleList.getPEPThreatRuleCount() <= 0) continue;
                            for (int j = 0; j < pepThreatRuleList.getPEPThreatRuleCount(); ++j) {
                                if (techniquesMapFromDatabase.containsKey(pepThreatRuleList.getPEPThreatRule(j).getSignatureId())) continue;
                                this.pepThreatRuleMetadataMap.put(pepThreatRuleList.getPEPThreatRule(j).getSignatureId(), pepThreatRuleList.getPEPThreatRule(j));
                                CustomComboActions customComboActions = new CustomComboActions(null, null);
                                techniquesMapFromDatabase.put(pepThreatRuleList.getPEPThreatRule(j).getSignatureId(), customComboActions);
                            }
                        }
                    }
                    if ((pepCustomRuleList = memPolicy.getOptCustomRuleList()) != null) {
                        for (int i = 0; i < pepCustomRuleList.getPEPExceptionCount(); ++i) {
                            pepThreatRuleList = pepCustomRuleList.getPEPException(i).getOptPEPThreatRuleList();
                            if (pepThreatRuleList == null || pepThreatRuleList.getPEPThreatRuleCount() <= 0) continue;
                            for (int j = 0; j < pepThreatRuleList.getPEPThreatRuleCount(); ++j) {
                                if (techniquesMapFromDatabase.containsKey(pepThreatRuleList.getPEPThreatRule(j).getSignatureId())) continue;
                                this.pepThreatRuleMetadataMap.put(pepThreatRuleList.getPEPThreatRule(j).getSignatureId(), pepThreatRuleList.getPEPThreatRule(j));
                                CustomComboActions customComboActions = new CustomComboActions(null, null);
                                techniquesMapFromDatabase.put(pepThreatRuleList.getPEPThreatRule(j).getSignatureId(), customComboActions);
                            }
                        }
                    }
                }
            }
            catch (ConsoleException consoleException) {
                LoggerUtilities.logException((Throwable)consoleException);
                JOptionPane.showMessageDialog(Manager.getFrame(), MEMProtectionTechniques.getString("MemPolicyDialog.Cannot_Load_Data"));
                if (!consoleException.needRelogin()) break block11;
                Manager.getFrame().showLoginPanel();
            }
        }
        return techniquesMapFromDatabase;
    }

    private void updateApplicationActions() {
        if (this.currentTechniqueSignature != null && this.uiProtectionActionMap.get(this.currentTechniqueSignature) != null) {
            this.updateProtectionAppActions(this.uiProtectionActionMap.get(this.currentTechniqueSignature).getSelectedAction());
        }
    }

    public String getTechniqueName(String signatureId) {
        String techniqueName = WinMemMetadataObject.getTechniqueName(signatureId);
        if (techniqueName == null) {
            if (this.pepThreatRuleMetadataMap != null && this.pepThreatRuleMetadataMap.get(signatureId) != null) {
                techniqueName = this.pepThreatRuleMetadataMap.get(signatureId).getTechniqueName();
            }
            if ("61001".equals(signatureId)) {
                techniqueName = "Java Security Manager";
            }
        }
        return techniqueName;
    }

    private void initActions() {
        if (this.techniquesActionListner == null) {
            this.techniquesActionListner = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        try {
                            MEMProtectionTechniques.this.currentTechniqueSignature = itemEvent.getItem().toString();
                            MEMProtectionTechniques.this.setSelectedAction(MEMProtectionTechniques.this.currentTechniqueSignature);
                            MEMProtectionTechniques.this.memProtectionTechniqueAppPanel.setObject(MEMProtectionTechniques.this.memPolicyObject, MEMProtectionTechniques.this.currentTechniqueSignature);
                            MEMProtectionTechniques.this.memProtectionTechniqueAppPanel.refresh(MEMProtectionTechniques.this.currentTechniqueSignature);
                            MEMProtectionTechniques.this.updateApplicationActions();
                        }
                        catch (ConsoleException e1) {
                            ConsoleLogger.log("Something went wrong with application list for " + itemEvent.getItem().toString());
                        }
                    }
                }
            };
        }
        if (this.techniquesCombo != null) {
            this.techniquesCombo.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (value != null) {
                        String strValue = value.toString();
                        String techniqueName = MEMProtectionTechniques.this.getTechniqueName(value.toString());
                        try {
                            String translatedTechniqueName;
                            String string = translatedTechniqueName = techniqueName != null ? MessageResources.getResourceBundle((String)"com.sygate.scm.console.ui.policy.mem.mem").getString("MemProtectionTechnique." + techniqueName.replaceAll("\\s+", "")) : MessageResources.getResourceBundle((String)"com.sygate.scm.console.ui.policy.mem.mem").getString("MemProtectionTechnique." + strValue.replaceAll("\\s+", ""));
                            if (techniqueName != null) {
                                this.setText(translatedTechniqueName + " (" + strValue + ")");
                            } else {
                                this.setText(translatedTechniqueName);
                            }
                        }
                        catch (MissingResourceException missingResourceException) {
                            ConsoleLogger.log("MEM protection technique - Resource for key :" + strValue + " is not found.");
                            String lable = techniqueName != null ? techniqueName + " (" + strValue + ")" : strValue;
                            this.setText(lable);
                        }
                    }
                    return this;
                }
            });
            this.techniquesCombo.addItemListener(this.techniquesActionListner);
        }
        if (this.globalActionListner == null) {
            this.globalActionListner = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        String action = itemEvent.getItem().toString();
                        MEMProtectionTechniques.this.uiProtectionActionMap.put(MEMProtectionTechniques.this.currentTechniqueSignature, new CustomComboActions(action, MEMProtectionTechniques.this.uiProtectionActionMap.get(MEMProtectionTechniques.this.currentTechniqueSignature).getDefaultAction()));
                        MEMProtectionTechniques.this.updateProtectionAppActions(action);
                    }
                }
            };
        }
        if (this.globalAuditModeActionListner == null) {
            this.globalAuditModeActionListner = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (MEMProtectionTechniques.this.globalAuditModeOverrideCheckBox.isSelected()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(Manager.getFrame(), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemTechniquesPanel.globalAudit.confirmation.msg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.information"), 1);
                            }
                        });
                        if (!MEMPolicyPanel.getEnableMemCheckBoxStatus().booleanValue()) {
                            MEMProtectionTechniques.this.globalActionsCombo.setEnabled(false);
                            MEMProtectionTechniques.this.globalActionsCombo.setToolTipText(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isMemDisabled"));
                        } else {
                            MEMProtectionTechniques.this.globalActionsCombo.setEnabled(false);
                            MEMProtectionTechniques.this.globalActionsCombo.setToolTipText(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isGlobalAuditModeActionAllowsEdit"));
                        }
                        MEMProtectionTechniques.this.updateProtectionAppActions("Log");
                    } else {
                        MEMProtectionTechniques.this.updateApplicationActions();
                    }
                }
            };
        }
        if (this.globalActionsCombo != null) {
            String defaultAction = this.uiProtectionActionMap.get(this.currentTechniqueSignature).getDefaultAction();
            MemActionsCustomListCellRenderer memActionsCustomListCellRenderer = new MemActionsCustomListCellRenderer(defaultAction);
            this.globalActionsCombo.setRenderer(memActionsCustomListCellRenderer);
            this.globalActionsCombo.addItemListener(this.globalActionListner);
        }
        this.globalAuditModeOverrideCheckBox.addItemListener(this.globalAuditModeActionListner);
    }

    public boolean isApplicationEditable(String appName, String appPath) {
        Vector<MemApplicationMetadataEvent> memApplicationRules = this.memApplicationRulesPanel.getMemApplicationRules();
        if (memApplicationRules != null) {
            for (int j = 0; j < memApplicationRules.size(); ++j) {
                TableRow row = memApplicationRules.get(j);
                MemApplicationMetadataEvent event = (MemApplicationMetadataEvent)row;
                if (!appName.equalsIgnoreCase(event.getName()) || !appPath.equalsIgnoreCase(event.getPath())) continue;
                return event.isEnabled();
            }
        }
        return true;
    }

    public JCheckBox getGlobalAuditModeOverrideCheckBox() {
        return this.globalAuditModeOverrideCheckBox;
    }

    public JComboBox<String> getTechniquesCombo() {
        return this.techniquesCombo;
    }

    public void setTechniquesCombo(JComboBox<String> techniquesCombo) {
        this.techniquesCombo = techniquesCombo;
    }

    public static class CustomComboActions {
        String selectedAction;
        private String defaultAction;

        public String getSelectedAction() {
            return this.selectedAction;
        }

        public void setSelectedAction(String selectedAction) {
            this.selectedAction = selectedAction;
        }

        public String getDefaultAction() {
            return this.defaultAction;
        }

        public void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        public CustomComboActions(String selectedAction, String defaultAction) {
            this.selectedAction = selectedAction;
            this.defaultAction = defaultAction;
        }
    }
}

