/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.mem;

import com.sygate.scm.common.configobject.schema.LuDownloadedContent;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.ids.handler.IdsLuHandler;
import com.sygate.scm.console.ui.policy.mem.MEMProtectionTechniques;
import com.sygate.scm.console.ui.policy.mem.MemApplicationRulesPanel;
import com.sygate.scm.console.ui.policy.mem.logicobject.WinMemMetadataObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MEMPolicyPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String MEM_DESC = MEMPolicyPanel.getString("MEMSettingsPanel.MEMDescription");
    private JTabbedPane tabbedPane;
    private MEMProtectionTechniques memProtectionTechniques;
    private transient MemPolicyObject memPolicyObject;
    private final LockCheckBox lockEnableMem = new LockCheckBox(Boolean.FALSE);
    private static final JCheckBox checkBox = new JCheckBox(MEMPolicyPanel.getString("MEMSettingsPanel.checkbox.MEMEnable"));
    private MemApplicationRulesPanel memApplicationRulesPanel;
    private transient ItemListener enableMemlistener = null;
    private MEMProtectionTechniques memProtTech = this.getProtectionTechniquesPanel();
    private JCheckBox globalMode = this.memProtTech.getGlobalAuditModeOverrideCheckBox();
    private JComboBox<String> proTechCombo = this.memProtTech.getTechniquesCombo();
    private JComboBox<String> globalActnsCombo;
    private String memExclusiveEditToolTipMsg;
    private String memManagedByCloudToolTipMsg;

    public MEMPolicyPanel() {
        this.globalActnsCombo = this.memProtTech.globalActionsCombo;
        this.memExclusiveEditToolTipMsg = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isExclusiveEdit");
        this.memManagedByCloudToolTipMsg = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.managedByCloud");
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.add(this.getInnerPanel());
        this.add((Component)this.getTabbedPanel(), "Center");
        this.initListeners();
    }

    private void initListeners() {
        if (this.enableMemlistener == null) {
            this.enableMemlistener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    JCheckBox checkB = (JCheckBox)event.getSource();
                    boolean selected = checkB.isSelected();
                    MEMProtectionTechniques memProtTech = MEMPolicyPanel.this.getProtectionTechniquesPanel();
                    JCheckBox globalMode = memProtTech.getGlobalAuditModeOverrideCheckBox();
                    JComboBox<String> proTechCombo = memProtTech.getTechniquesCombo();
                    JComboBox<String> globalActnsCombo = memProtTech.globalActionsCombo;
                    String memDisableToolTipMsg = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isMemDisabled");
                    if (!selected) {
                        if (globalMode != null) {
                            globalMode.setEnabled(false);
                            globalMode.setToolTipText(memDisableToolTipMsg);
                        }
                        if (proTechCombo != null) {
                            proTechCombo.setEnabled(false);
                            proTechCombo.setToolTipText(memDisableToolTipMsg);
                        }
                        if (globalActnsCombo != null) {
                            globalActnsCombo.setEnabled(false);
                            globalActnsCombo.setToolTipText(memDisableToolTipMsg);
                        }
                    } else {
                        if (globalMode != null) {
                            globalMode.setEnabled(true);
                            globalMode.setToolTipText("");
                        }
                        if (proTechCombo != null) {
                            proTechCombo.setEnabled(true);
                            proTechCombo.setToolTipText("");
                        }
                        if (globalActnsCombo != null) {
                            if (!globalMode.isSelected()) {
                                globalActnsCombo.setEnabled(true);
                                globalActnsCombo.setToolTipText("");
                            } else {
                                globalActnsCombo.setEnabled(false);
                                globalActnsCombo.setToolTipText(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemApplicationRulesPanel.tooltip.isGlobalAuditModeActionAllowsEdit"));
                            }
                        }
                    }
                }
            };
        }
        checkBox.addItemListener(this.enableMemlistener);
    }

    private JTabbedPane getTabbedPanel() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.addTab(MEMPolicyPanel.getString("MemTechniquesPanel.memProtectionTechniques"), this.getProtectionTechniquesPanel());
        this.tabbedPane.addTab(MEMPolicyPanel.getString("MemTechniquesPanel.memApplicationCoverage"), this.getMemApplicationRulesPanel());
        return this.tabbedPane;
    }

    private MEMProtectionTechniques getProtectionTechniquesPanel() {
        if (this.memProtectionTechniques == null) {
            this.memProtectionTechniques = new MEMProtectionTechniques(this.getMemApplicationRulesPanel());
            this.getMemApplicationRulesPanel().setMemProtectionTechniques(this.memProtectionTechniques);
        }
        return this.memProtectionTechniques;
    }

    private JPanel getInnerPanel() {
        String strMemHelpText = MEMPolicyPanel.getString("MEMSettingsPanel.MEMHelpText");
        HtmlEnabledJLabel labelMemHelp = new HtmlEnabledJLabel(strMemHelpText, true);
        labelMemHelp.setIcon((Icon)ConsoleMain.whatsThisIcon);
        labelMemHelp.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                HelpUtil.showHelpOrErrDlg("sesm_policies_dialog_gem_settings_whatis_gem");
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        int gridy = 0;
        panel.add((Component)new AvTemplatePane(MEMPolicyPanel.getString("MEMSettingsPanel.title.MEMExploitProtection"), MEM_DESC, false), new GridBagConstraints(0, gridy, 5, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.lockEnableMem.setSelectedIcon(AvConstants.lockIcon);
        panel.add((Component)this.lockEnableMem, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)checkBox, new GridBagConstraints(1, gridy, 5, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)labelMemHelp, new GridBagConstraints(0, gridy, 5, 1, 0.0, 0.0, 23, 17, new Insets(20, 350, 0, 0), 0, 0));
        return panel;
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.mem.mem", key);
    }

    private MemApplicationRulesPanel getMemApplicationRulesPanel() {
        if (this.memApplicationRulesPanel == null) {
            this.memApplicationRulesPanel = new MemApplicationRulesPanel();
            this.memApplicationRulesPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentException) {
                    LuDownloadedContent sepmMedataContent = null;
                    try {
                        sepmMedataContent = IdsLuHandler.getLatestSepmMetadataContent();
                    }
                    catch (ConsoleException e) {
                        ConsoleLogger.log("MEMPolicyPanel>> getMemApplicationRulesPanel>Cannot retrieve the latest SEPM metadata content.");
                    }
                    if (sepmMedataContent == null) {
                        UIUtilities.showWarningDialog(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.mem.mem", "MemPolicyDialog.RulesListEmpty"));
                    }
                }
            });
        }
        return this.memApplicationRulesPanel;
    }

    protected void updatePolicy() {
        MemPolicy memPolicy;
        if (this.memPolicyObject != null && (memPolicy = this.memPolicyObject.getMemPolicy()) != null) {
            memPolicy.setOptLocked(Boolean.valueOf(this.lockEnableMem.isSelected()));
            memPolicy.setOptEnableBasicProtection(Boolean.valueOf(checkBox.isSelected()));
        }
        this.getMemApplicationRulesPanel().updatePolicy();
        this.getProtectionTechniquesPanel().updatePolicy();
    }

    public void setValue(MemPolicyObject memPolicyObject) {
        block10: {
            try {
                WinMemMetadataObject.refreshNewInstance();
                IdsLuHandler.refreshLatestContent();
                this.memPolicyObject = memPolicyObject;
                MemPolicy memPolicy = memPolicyObject.getMemPolicy();
                this.lockEnableMem.setSelected(false);
                checkBox.setSelected(true);
                if (memPolicy != null) {
                    Boolean locked = memPolicy.getOptLocked();
                    if (locked == null) {
                        locked = memPolicy.getDefLocked();
                    }
                    this.lockEnableMem.setSelected(locked);
                    Boolean enabled = memPolicy.getOptEnableBasicProtection();
                    if (enabled == null) {
                        enabled = memPolicy.getDefEnableBasicProtection();
                    }
                    checkBox.setSelected(enabled);
                }
                if (memPolicyObject.isExclusiveEdit()) {
                    this.lockEnableMem.setEnabled(false);
                    checkBox.setEnabled(false);
                    this.lockEnableMem.setToolTipText(null);
                    checkBox.setToolTipText(this.memExclusiveEditToolTipMsg);
                    this.globalMode.setToolTipText(this.memExclusiveEditToolTipMsg);
                    if (this.proTechCombo != null) {
                        this.proTechCombo.setToolTipText(this.memExclusiveEditToolTipMsg);
                    }
                    this.globalActnsCombo.setToolTipText(this.memExclusiveEditToolTipMsg);
                } else if (CloudUtil.isCloudMemPolicyInUse()) {
                    this.lockEnableMem.setEnabled(false);
                    checkBox.setEnabled(false);
                    this.lockEnableMem.setToolTipText(null);
                    checkBox.setToolTipText(this.memManagedByCloudToolTipMsg);
                    this.globalMode.setToolTipText(this.memManagedByCloudToolTipMsg);
                    if (this.proTechCombo != null) {
                        this.proTechCombo.setToolTipText(this.memManagedByCloudToolTipMsg);
                    }
                    this.globalActnsCombo.setToolTipText(this.memManagedByCloudToolTipMsg);
                }
                this.getMemApplicationRulesPanel().setObject(memPolicyObject);
                this.getProtectionTechniquesPanel().setObject(memPolicyObject);
            }
            catch (ConsoleException consoleException) {
                LoggerUtilities.logException((Throwable)consoleException);
                JOptionPane.showMessageDialog(Manager.getFrame(), MEMPolicyPanel.getString("MemPolicyDialog.Cannot_Load_Data"));
                if (!consoleException.needRelogin()) break block10;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_gem_settings";
    }

    public static Boolean getEnableMemCheckBoxStatus() {
        return checkBox.isSelected();
    }
}

