/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu.logiobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.LuHttpsProxy;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.util.Utility;

public class LuHttpsProxyObject
extends AbstractUIObject {
    protected LuHttpsProxy proxy;

    public LuHttpsProxyObject(LuHttpsProxy proxy) {
        this.proxy = proxy;
    }

    public boolean isNoProxy() {
        return this.proxy.getMode().equals(LuHttpsProxy.NONE);
    }

    public boolean isSystemProxy() {
        return this.proxy.getMode().equals(LuHttpsProxy.SYSTEM);
    }

    public boolean isCustomProxy() {
        return this.proxy.getMode().equals(LuHttpsProxy.CUSTOM);
    }

    public boolean isNtlmAuthentication() {
        if (this.proxy.getOptAuthenticationType() == null) {
            return LuHttpsProxy.NTLM.equals(this.proxy.getDefAuthenticationType());
        }
        return this.proxy.getOptAuthenticationType().equals(LuHttpsProxy.NTLM);
    }

    public String getNtlmUserName() {
        String name = this.proxy.getOptNtlmUserName();
        return name == null ? "" : name;
    }

    public String getNtlmPassword() {
        String psw = this.proxy.getOptNtlmPassword();
        return psw == null ? "" : psw;
    }

    public String getNtlmDomainName() {
        String domain = this.proxy.getOptNtlmDomainName();
        return domain == null ? "" : domain;
    }

    public void setAuthenticationType(Integer authenticationType) {
        this.proxy.setOptAuthenticationType(authenticationType);
    }

    public void setNtlmUserName(String ntlmUserName) {
        if (!ntlmUserName.equals(this.getNtlmUserName())) {
            this.proxy.setOptNtlmUserName(ntlmUserName);
        }
    }

    public void setNtlmPassword(String ntlmPassword) {
        if (!ntlmPassword.equals(this.getNtlmPassword())) {
            this.proxy.setOptNtlmPassword(ntlmPassword);
        }
    }

    public void setNtlmDomainName(String ntlmDomainName) {
        if (!ntlmDomainName.equals(this.getNtlmDomainName())) {
            this.proxy.setOptNtlmDomainName(ntlmDomainName);
        }
    }

    public String getHost() {
        return this.proxy.getOptHost();
    }

    public String getPort() {
        return this.proxy.getOptPort();
    }

    public boolean isAuthenticated() {
        return Utility.getBooleanValue((Boolean)this.proxy.getOptRequireAuthentication(), (Boolean)this.proxy.getDefRequireAuthentication());
    }

    public String getUserName() {
        String name = this.proxy.getOptUserName();
        return name == null ? "" : name;
    }

    public String getPassword() {
        String psw = this.proxy.getOptPassword();
        return psw == null ? "" : psw;
    }

    public void setMode(Integer mode) {
        this.proxy.setMode(mode);
    }

    public void setHost(String host) {
        if (!host.equals(this.getHost())) {
            this.proxy.setOptHost(host);
        }
    }

    public void setPort(String port) {
        if (!port.equals(this.getPort())) {
            this.proxy.setOptPort(port);
        }
    }

    public void setAuthentication(boolean isAuth) {
        Boolean auth = isAuth == this.proxy.getDefRequireAuthentication() ? null : Boolean.valueOf(isAuth);
        this.proxy.setOptRequireAuthentication(auth);
    }

    public void setUserName(String userName) {
        if (!userName.equals(this.getUserName())) {
            this.proxy.setOptUserName(userName);
        }
    }

    public void setPassword(String password) {
        if (!password.equals(this.getPassword())) {
            this.proxy.setOptPassword(password);
        }
    }

    public void setOptLockHttpsProxyMode(boolean lockMode) {
        this.proxy.setOptLockMode(Boolean.valueOf(lockMode));
    }

    public boolean getOptLockHttpsProxyMode() {
        return this.proxy.getOptLockMode() == null ? this.proxy.getDefLockMode() : this.proxy.getOptLockMode();
    }

    public LuHttpsProxy getSchemaObject() {
        return this.proxy;
    }

    public void setSchemaObject(ConfigObject proxy) {
        this.proxy = (LuHttpsProxy)proxy;
    }
}

