/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu.logiobject;

import com.sygate.scm.common.configobject.schema.LUAvDefinitionCheck;
import com.sygate.scm.common.configobject.schema.LUChannelFailoverMode;
import com.sygate.scm.common.configobject.schema.LUScheduleAdditionalOptions;
import com.sygate.scm.common.configobject.schema.LuDownloadRandomness;
import com.sygate.scm.common.configobject.schema.LuDownloadSchedule;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.util.Utility;

public class LuDownloadScheduleObject
extends AbstractUIObject {
    protected static final int MINUTE = 60;
    private static final int RETRY_MINUTES = 60;
    private static final int RETRY_HOURS = 24;
    private static final int RETRY_DAYS = 7;
    private static final int RANDOMIZE_HOURS = 12;
    private static final int RANDOMIZE_DAYS = 3;
    private static final int LU_ADDITIONAL_OPTIONS_HOURS = 24;
    private static final int LU_ADDITIONAL_OPTIONS_DAYS = 31;
    private static final int LU_ADDITIONAL_OPTIONS_MINUTES = 60;
    protected LuDownloadSchedule schedule;

    public LuDownloadScheduleObject(LuDownloadSchedule schedule) {
        this.schedule = schedule;
    }

    public boolean getEnabled() {
        Boolean enabled = this.schedule.getOptEnabled();
        return enabled == null ? this.schedule.getDefEnabled().booleanValue() : enabled.booleanValue();
    }

    public Integer getFrequency() {
        Integer freq = this.schedule.getOptFrequency();
        return freq == null ? this.schedule.getDefFrequency() : freq;
    }

    public Integer getFrequencyInterval() {
        Integer interval = this.schedule.getOptFrequencyInterval();
        interval = interval == null ? this.schedule.getDefFrequencyInterval() : interval;
        return interval / 60;
    }

    public long getStartTime() {
        Long time = this.schedule.getOptStartTime();
        return time == null ? 0L : time;
    }

    public int getDayOfWeek() {
        Integer day = this.schedule.getOptDayOfWeek();
        day = day == null ? LuDownloadSchedule.SUNDAY : day;
        return day;
    }

    public boolean isAllowRetry() {
        Boolean allowRetry = this.schedule.getOptAllowRetry();
        return allowRetry == null ? this.schedule.getDefAllowRetry().booleanValue() : allowRetry.booleanValue();
    }

    public int getRetryWindow() {
        Integer value = this.schedule.getOptRetryWindow();
        if (value == null) {
            return this.getRetryMinimumValue();
        }
        Integer freq = this.getFrequency();
        int retry = value;
        if (freq.equals(LuDownloadSchedule.WEEKLY)) {
            retry = retry / 24 / 60;
        } else if (freq.equals(LuDownloadSchedule.DAILY) || freq.equals(LuDownloadSchedule.HOURLY) && this.getFrequencyInterval() != 1) {
            retry /= 60;
        }
        int maximum = this.getRetryMaximumValue(this.getFrequency(), this.getFrequencyInterval());
        return retry < maximum ? retry : maximum;
    }

    public boolean isRandomness() {
        LuDownloadRandomness random = this.schedule.getOptLuDownloadRandomness();
        return random == null ? new LuDownloadRandomness().getDefEnabled() : Utility.getBooleanValue((Boolean)random.getOptEnabled(), (Boolean)random.getDefEnabled());
    }

    private LUScheduleAdditionalOptions getLUScheduleAdditionalOptions() {
        LUScheduleAdditionalOptions additionalOption = this.schedule.getOptLUScheduleAdditionalOptions();
        if (additionalOption == null) {
            additionalOption = new LUScheduleAdditionalOptions();
        }
        return additionalOption;
    }

    private LUAvDefinitionCheck getLUAvDefinitionCheck() {
        LUAvDefinitionCheck avDefinitionCheck = this.getLUScheduleAdditionalOptions().getOptLUAvDefinitionCheck();
        if (avDefinitionCheck == null) {
            avDefinitionCheck = new LUAvDefinitionCheck();
        }
        return avDefinitionCheck;
    }

    private LUChannelFailoverMode getLUChannelFailoverMode() {
        LUChannelFailoverMode clientDisconnectCheck = this.getLUScheduleAdditionalOptions().getOptLUChannelFailoverMode();
        if (clientDisconnectCheck == null) {
            clientDisconnectCheck = new LUChannelFailoverMode();
        }
        return clientDisconnectCheck;
    }

    public boolean isAvDefOlderThan() {
        return Utility.getBooleanValue((Boolean)this.getLUAvDefinitionCheck().getOptEnabled(), (Boolean)this.getLUAvDefinitionCheck().getDefEnabled());
    }

    public Integer getAvDefinitionAge() {
        return this.getLUAvDefinitionCheck().getOptAvDefinitionAge() == null ? this.getLUAvDefinitionCheck().getDefAvDefinitionAge() : this.getLUAvDefinitionCheck().getOptAvDefinitionAge();
    }

    public Integer getAvDefinitionFrequency() {
        return this.getLUAvDefinitionCheck().getOptFrequency() == null ? this.getLUAvDefinitionCheck().getDefFrequency() : this.getLUAvDefinitionCheck().getOptFrequency();
    }

    public Integer getDisconnectDuration() {
        return this.getLUChannelFailoverMode().getOptDisconnectDuration() == null ? this.getLUChannelFailoverMode().getDefDisconnectDuration() : this.getLUChannelFailoverMode().getOptDisconnectDuration();
    }

    public Integer getLUChannelFailoverModeFrequency() {
        return this.getLUChannelFailoverMode().getOptFrequency() == null ? this.getLUChannelFailoverMode().getDefFrequency() : this.getLUChannelFailoverMode().getOptFrequency();
    }

    public boolean isLUChannelFailoverMode() {
        return Utility.getBooleanValue((Boolean)this.getLUChannelFailoverMode().getOptEnabled(), (Boolean)this.getLUChannelFailoverMode().getDefEnabled());
    }

    public boolean isIdleDetection() {
        return this.schedule.getOptIdleDetection() == null ? this.schedule.getDefIdleDetection() : this.schedule.getOptIdleDetection();
    }

    public int getRandomizeTime() {
        int maximum = this.getRandomizeMaximumTime(this.getFrequency(), this.getFrequencyInterval());
        LuDownloadRandomness random = this.schedule.getOptLuDownloadRandomness();
        if (random == null) {
            return maximum;
        }
        Integer time = random.getOptRandomizeTime();
        if (time == null) {
            return maximum;
        }
        Integer freq = this.getFrequency();
        int rTime = time;
        if (freq.equals(LuDownloadSchedule.WEEKLY)) {
            rTime = rTime / 24 / 60;
        } else if (freq.equals(LuDownloadSchedule.DAILY) || freq.equals(LuDownloadSchedule.HOURLY) && this.getFrequencyInterval() != 1) {
            rTime /= 60;
        }
        return rTime < maximum ? rTime : maximum;
    }

    public void setEnabled(boolean enabled) {
        this.schedule.setOptEnabled(Boolean.valueOf(enabled));
    }

    public void setFrequency(Integer value) {
        this.schedule.setOptFrequency(value);
    }

    public void setFrequencyInterval(Integer value) {
        this.schedule.setOptFrequencyInterval(Integer.valueOf(value * 60));
    }

    public void setStartTime(long startTime) {
        this.schedule.setOptStartTime(Long.valueOf(startTime));
    }

    public void setDayOfWeek(int value) {
        switch (value) {
            case 0: {
                this.schedule.setOptDayOfWeek(LuDownloadSchedule.SUNDAY);
                break;
            }
            case 1: {
                this.schedule.setOptDayOfWeek(LuDownloadSchedule.MONDAY);
                break;
            }
            case 2: {
                this.schedule.setOptDayOfWeek(LuDownloadSchedule.TUESDAY);
                break;
            }
            case 3: {
                this.schedule.setOptDayOfWeek(LuDownloadSchedule.WEDNESDAY);
                break;
            }
            case 4: {
                this.schedule.setOptDayOfWeek(LuDownloadSchedule.THURSDAY);
                break;
            }
            case 5: {
                this.schedule.setOptDayOfWeek(LuDownloadSchedule.FRIDAY);
                break;
            }
            default: {
                this.schedule.setOptDayOfWeek(LuDownloadSchedule.SATURDA);
            }
        }
    }

    public void setAllowRetry(boolean value) {
        this.schedule.setOptAllowRetry(Boolean.valueOf(value));
    }

    public void setRetryWindow(Integer value, Integer freq, int hour) {
        int retry = value;
        if (freq.equals(LuDownloadSchedule.WEEKLY)) {
            retry = retry * 24 * 60;
        } else if (freq.equals(LuDownloadSchedule.DAILY) || freq.equals(LuDownloadSchedule.HOURLY) && hour != 1) {
            retry *= 60;
        }
        this.schedule.setOptRetryWindow(Integer.valueOf(retry));
    }

    public void setRandomness(boolean isRandom) {
        LuDownloadRandomness random = this.schedule.getOptLuDownloadRandomness();
        if (random == null) {
            random = new LuDownloadRandomness();
            this.schedule.setOptLuDownloadRandomness(random);
        }
        random.setOptEnabled(Boolean.valueOf(isRandom));
    }

    public void setAvDefOlderThan(boolean isAvDefOlderThan) {
        LUAvDefinitionCheck avDefinitionCheck;
        LUScheduleAdditionalOptions additionalOption = this.getLUScheduleAdditionalOptions();
        if (this.schedule.getOptLUScheduleAdditionalOptions() == null) {
            this.schedule.setOptLUScheduleAdditionalOptions(additionalOption);
        }
        if ((avDefinitionCheck = additionalOption.getOptLUAvDefinitionCheck()) == null) {
            avDefinitionCheck = new LUAvDefinitionCheck();
            additionalOption.setOptLUAvDefinitionCheck(avDefinitionCheck);
        }
        avDefinitionCheck.setOptEnabled(Boolean.valueOf(isAvDefOlderThan));
    }

    public void setAvDefinitionAge(Integer AvDefinitionAge) {
        LUAvDefinitionCheck avDefinitionCheck;
        LUScheduleAdditionalOptions additionalOption = this.getLUScheduleAdditionalOptions();
        if (this.schedule.getOptLUScheduleAdditionalOptions() == null) {
            this.schedule.setOptLUScheduleAdditionalOptions(additionalOption);
        }
        if ((avDefinitionCheck = additionalOption.getOptLUAvDefinitionCheck()) == null) {
            avDefinitionCheck = new LUAvDefinitionCheck();
            additionalOption.setOptLUAvDefinitionCheck(avDefinitionCheck);
        }
        avDefinitionCheck.setOptAvDefinitionAge(AvDefinitionAge);
    }

    public void setAvDefFrequency(Integer avDefFrequency) {
        LUAvDefinitionCheck avDefinitionCheck;
        LUScheduleAdditionalOptions additionalOption = this.getLUScheduleAdditionalOptions();
        if (this.schedule.getOptLUScheduleAdditionalOptions() == null) {
            this.schedule.setOptLUScheduleAdditionalOptions(additionalOption);
        }
        if ((avDefinitionCheck = additionalOption.getOptLUAvDefinitionCheck()) == null) {
            avDefinitionCheck = new LUAvDefinitionCheck();
            additionalOption.setOptLUAvDefinitionCheck(avDefinitionCheck);
        }
        avDefinitionCheck.setOptFrequency(avDefFrequency);
    }

    public void setDisconnectDuration(Integer disconnectDuration) {
        LUChannelFailoverMode clientDisconnectCheck;
        LUScheduleAdditionalOptions additionalOption = this.getLUScheduleAdditionalOptions();
        if (this.schedule.getOptLUScheduleAdditionalOptions() == null) {
            this.schedule.setOptLUScheduleAdditionalOptions(additionalOption);
        }
        if ((clientDisconnectCheck = additionalOption.getOptLUChannelFailoverMode()) == null) {
            clientDisconnectCheck = new LUChannelFailoverMode();
            additionalOption.setOptLUChannelFailoverMode(clientDisconnectCheck);
        }
        clientDisconnectCheck.setOptDisconnectDuration(disconnectDuration);
    }

    public void setDisconnectedFrequency(Integer disconnectedFrequency) {
        LUChannelFailoverMode clientDisconnectCheck;
        LUScheduleAdditionalOptions additionalOption = this.getLUScheduleAdditionalOptions();
        if (this.schedule.getOptLUScheduleAdditionalOptions() == null) {
            this.schedule.setOptLUScheduleAdditionalOptions(additionalOption);
        }
        if ((clientDisconnectCheck = additionalOption.getOptLUChannelFailoverMode()) == null) {
            clientDisconnectCheck = new LUChannelFailoverMode();
            additionalOption.setOptLUChannelFailoverMode(clientDisconnectCheck);
        }
        clientDisconnectCheck.setOptFrequency(disconnectedFrequency);
    }

    public void setLUChannelFailoverMode(boolean isLUChannelFailoverMode) {
        LUChannelFailoverMode clientDisconnectCheck;
        LUScheduleAdditionalOptions additionalOption = this.getLUScheduleAdditionalOptions();
        if (this.schedule.getOptLUScheduleAdditionalOptions() == null) {
            this.schedule.setOptLUScheduleAdditionalOptions(additionalOption);
        }
        if ((clientDisconnectCheck = additionalOption.getOptLUChannelFailoverMode()) == null) {
            clientDisconnectCheck = new LUChannelFailoverMode();
            additionalOption.setOptLUChannelFailoverMode(clientDisconnectCheck);
        }
        clientDisconnectCheck.setOptEnabled(Boolean.valueOf(isLUChannelFailoverMode));
    }

    public void setRandomizeTime(Integer time, Integer freq, int hour) {
        LuDownloadRandomness random = this.schedule.getOptLuDownloadRandomness();
        if (random == null) {
            random = new LuDownloadRandomness();
            this.schedule.setOptLuDownloadRandomness(random);
        }
        int retry = time;
        if (freq.equals(LuDownloadSchedule.WEEKLY)) {
            retry = retry * 24 * 60;
        } else if (freq.equals(LuDownloadSchedule.DAILY) || freq.equals(LuDownloadSchedule.HOURLY) && hour != 1) {
            retry *= 60;
        }
        random.setOptRandomizeTime(Integer.valueOf(retry));
    }

    public void setIdleDetection(boolean enabled) {
        this.schedule.setOptIdleDetection(Boolean.valueOf(enabled));
    }

    public int getRetryMinimumValue() {
        return 1;
    }

    public int getRetryMaximumValue(Integer freq, int hour) {
        if (freq.equals(LuDownloadSchedule.WEEKLY)) {
            return 7;
        }
        if (freq.equals(LuDownloadSchedule.DAILY)) {
            return 24;
        }
        if (freq.equals(LuDownloadSchedule.CONTINUOUS) || freq.equals(LuDownloadSchedule.HOURLY) && hour == 1) {
            return 60;
        }
        return hour;
    }

    public int getAvDefMaximumValue(Integer freq, int duration) {
        if (freq.equals(LUAvDefinitionCheck.HOURS)) {
            return 24;
        }
        if (freq.equals(LUAvDefinitionCheck.DAYS)) {
            return 31;
        }
        return duration;
    }

    public int getDisConnectedForMaximumValue(Integer freq, int duration) {
        if (freq.equals(LUChannelFailoverMode.HOURS)) {
            return 24;
        }
        if (freq.equals(LUChannelFailoverMode.MINUTES)) {
            return 60;
        }
        return duration;
    }

    public int getAdditionalOptionMinimumValue() {
        return 1;
    }

    public int getRandomizeMinimumTime() {
        return 1;
    }

    public int getRandomizeMaximumTime(Integer freq, int hour) {
        if (freq.equals(LuDownloadSchedule.WEEKLY)) {
            return 3;
        }
        if (freq.equals(LuDownloadSchedule.DAILY)) {
            return 12;
        }
        if (freq.equals(LuDownloadSchedule.CONTINUOUS) || freq.equals(LuDownloadSchedule.HOURLY) && hour == 1) {
            return 60;
        }
        return hour / 2;
    }
}

