/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu.logiobject;

import com.sygate.scm.common.configobject.schema.LuClientRegistration;
import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.configobject.schema.LuDownloadedContent;
import com.sygate.scm.common.configobject.schema.LuRegistration;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.RevisionObject;
import com.sygate.scm.console.logicobject.SEPMDateObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.lu.LuUtility;

public class LuDownloadContentObject
extends AbstractUIObject
implements TableRow {
    private boolean isEnabled;
    protected LuRegistration reg;
    protected LuDownloadedContent content;
    private LuClientRegistration clientReg;
    protected LuContentCategory category = null;
    public static final int DISPLAY_NAME = 0;
    public static final int REVISION_COLUMN = 1;

    public LuDownloadContentObject(LuRegistration reg, LuDownloadedContent content) {
        this.reg = reg;
        this.clientReg = reg.getOptLuClientRegistration();
        this.content = content;
    }

    public LuDownloadContentObject(LuRegistration reg, LuDownloadedContent content, LuContentCategory category) {
        this.reg = reg;
        this.clientReg = reg.getOptLuClientRegistration();
        this.content = content;
        this.category = category;
    }

    @Override
    public Object getValueAt(int index) {
        if (this.clientReg == null) {
            return null;
        }
        switch (index) {
            case 0: {
                return LuUtility.getLocalizedString(this.reg.getLocalizedStrings()).getOptDisplayName();
            }
            case 1: {
                if (this.category != null && this.category.getName().equals("SECURITY_FIX")) {
                    return new RevisionObject(this.content.getSequenceNum(), true);
                }
                return RevisionObject.fromSequenceNumber(this.content.getSequenceNum());
            }
        }
        return new SEPMDateObject(this.content.getT());
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        if (this.clientReg == null) {
            return null;
        }
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return RevisionObject.class;
            }
        }
        return SEPMDateObject.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 0: {
                this.isEnabled = !this.isEnabled;
                break;
            }
            case 1: {
                this.content.setSequenceNum((String)value);
                break;
            }
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public String getClientMoniker() {
        if (this.clientReg != null) {
            return this.clientReg.getMoniker();
        }
        return null;
    }

    public String getSequenceNum() {
        return this.content.getSequenceNum();
    }

    public void setSequenceNum(String sequenceNum) {
        this.content.setSequenceNum(sequenceNum);
    }

    public String getEngineNum() {
        return this.content.getOptEngineNum();
    }

    public LuDownloadedContent getContent() {
        return this.content;
    }
}

