/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu.logiobject;

import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.schema.CentralLuServer;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.configobject.schema.LuFtpProxy;
import com.sygate.scm.common.configobject.schema.LuHttpProxy;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.CentralLuServerObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuFtpProxyObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuHttpProxyObject;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class LuContentSourceInfoObject
extends AbstractUIObject {
    protected LuContentSourceInfo sourceInfo;
    private LuHttpProxyObject httpProxyObj;
    private LuFtpProxyObject ftpProxyObj;

    public LuContentSourceInfoObject(LuContentSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        this.httpProxyObj = new LuHttpProxyObject(this.getLuHttpProxy());
        this.ftpProxyObj = new LuFtpProxyObject(this.getLuFtpProxy());
    }

    public LuContentSourceInfoObject() {
        this.sourceInfo = this.getSourceInfo();
        this.httpProxyObj = new LuHttpProxyObject(this.getLuHttpProxy());
        this.ftpProxyObj = new LuFtpProxyObject(this.getLuFtpProxy());
    }

    protected LuHttpProxy getLuHttpProxy() {
        LuHttpProxy http = this.sourceInfo.getOptLuHttpProxy();
        if (http == null) {
            http = new LuHttpProxy();
            http.setMode(LuHttpProxy.SYSTEM);
            this.sourceInfo.setOptLuHttpProxy(http);
        }
        return http;
    }

    protected LuFtpProxy getLuFtpProxy() {
        LuFtpProxy ftp = this.sourceInfo.getOptLuFtpProxy();
        if (ftp == null) {
            ftp = new LuFtpProxy();
            ftp.setMode(LuFtpProxy.SYSTEM);
            this.sourceInfo.setOptLuFtpProxy(ftp);
        }
        return ftp;
    }

    private LuContentSourceInfo getSourceInfo() {
        LuContentSourceInfo sInfo = new LuContentSourceInfo();
        return sInfo;
    }

    public LuContentSourceInfo getSchemaObject() {
        return this.sourceInfo;
    }

    public boolean isUseManagementServer() {
        return Utility.getBooleanValue((Boolean)this.sourceInfo.getOptUseManagementServer(), (Boolean)this.sourceInfo.getDefUseManagementServer());
    }

    public boolean isUseLiveUpdateServer() {
        return Utility.getBooleanValue((Boolean)this.sourceInfo.getOptUseLiveUpdateServer(), (Boolean)this.sourceInfo.getDefUseLiveUpdateServer());
    }

    public boolean isUseSymantecServerType() {
        Integer serverType = this.sourceInfo.getOptLiveUpdateServerType();
        return serverType == null || serverType.intValue() == LuContentSourceInfo.SYMANTEC.intValue();
    }

    public Integer getLiveUpdateServerType() {
        Integer serverType = this.sourceInfo.getOptLiveUpdateServerType();
        if (serverType == null) {
            serverType = LuContentSourceInfo.SYMANTEC;
        }
        return serverType;
    }

    public boolean isUseMasterClient() {
        return Utility.getBooleanValue((Boolean)this.sourceInfo.getOptUseMasterClient(), (Boolean)this.sourceInfo.getDefUseMasterClient());
    }

    public String getMasterClientHost() {
        String host = this.sourceInfo.getOptMasterClientHost();
        return host == null ? "" : host;
    }

    public String getMasterClientPort() {
        String port = this.sourceInfo.getOptMasterClientPort();
        return port == null ? "2967" : port;
    }

    public Vector<CentralLuServerObject> getCentralServers() {
        Vector<CentralLuServerObject> servers = new Vector<CentralLuServerObject>();
        for (int i = 0; i < this.sourceInfo.getCentralLuServerCount(); ++i) {
            servers.add(new CentralLuServerObject(this.sourceInfo.getCentralLuServer(i)));
        }
        return servers;
    }

    public LuHttpProxyObject getHttpProxyObject() {
        return this.httpProxyObj;
    }

    public LuFtpProxyObject getFtpProxyObject() {
        return this.ftpProxyObj;
    }

    public void setUseManagementServer(boolean isUse) {
        Boolean use = this.sourceInfo.getDefUseManagementServer() == isUse ? null : Boolean.valueOf(isUse);
        this.sourceInfo.setOptUseManagementServer(use);
    }

    public void setUseLiveUpdateServer(boolean isUse) {
        Boolean use = this.sourceInfo.getDefUseLiveUpdateServer() == isUse ? null : Boolean.valueOf(isUse);
        this.sourceInfo.setOptUseLiveUpdateServer(use);
    }

    public void setUseMasterClient(boolean isUse) {
        Boolean use = this.sourceInfo.getDefUseMasterClient() == isUse ? null : Boolean.valueOf(isUse);
        this.sourceInfo.setOptUseMasterClient(use);
    }

    public void setMasterClientHost(String host) {
        if (!host.equals(this.getMasterClientHost())) {
            this.sourceInfo.setOptMasterClientHost(host);
        }
    }

    public void setEnabled3rdPartyManagement(boolean enable) {
        this.sourceInfo.setOptEnabled3rdPartyManagement(Boolean.valueOf(enable));
    }

    public boolean getEnabled3rdPartyManagement() {
        return Utility.getBooleanValue((Boolean)this.sourceInfo.getOptEnabled3rdPartyManagement(), (Boolean)this.sourceInfo.getDefEnabled3rdPartyManagement());
    }

    public void setMasterClientPort(String port) {
        if (!port.equals(this.sourceInfo.getOptMasterClientPort())) {
            this.sourceInfo.setOptMasterClientPort(port);
        }
    }

    public boolean getOptStaticGupSelected() {
        Boolean selected = this.sourceInfo.getOptStaticGupSelected();
        if (selected == null) {
            selected = this.sourceInfo.getDefStaticGupSelected();
        }
        return selected;
    }

    public void setOptStaticGupSelected(boolean selected) {
        this.sourceInfo.setOptStaticGupSelected(Boolean.valueOf(selected));
    }

    public boolean getOptDynamicGupSelected() {
        Boolean selected = this.sourceInfo.getOptDynamicGupSelected();
        if (selected == null) {
            selected = this.sourceInfo.getDefDynamicGupSelected();
        }
        return selected;
    }

    public void setOptDymanicGupSelected(boolean selected) {
        this.sourceInfo.setOptDynamicGupSelected(Boolean.valueOf(selected));
    }

    public boolean getOptExplicitGupSelected() {
        Boolean selected = this.sourceInfo.getOptExplicitGupSelected();
        if (selected == null) {
            selected = this.sourceInfo.getDefExplicitGupSelected();
        }
        return selected;
    }

    public void setOptExplicitGupSelected(boolean selected) {
        this.sourceInfo.setOptExplicitGupSelected(Boolean.valueOf(selected));
    }

    public int getMasterClientBypassTime() {
        Long bypassTime = this.sourceInfo.getOptMasterClientBypassTime();
        if (bypassTime == null) {
            bypassTime = this.sourceInfo.getDefMasterClientBypassTime();
        }
        return bypassTime.intValue();
    }

    public void setMasterClientBypassTime(long bypassTime) {
        if (!Long.valueOf(bypassTime).equals(this.sourceInfo.getOptMasterClientBypassTime())) {
            this.sourceInfo.setOptMasterClientBypassTime(Long.valueOf(bypassTime));
        }
    }

    public int getDefMasterClientBypassTime() {
        return this.sourceInfo.getDefMasterClientBypassTime().intValue();
    }

    public int getMasterClientThrottling() {
        Integer throttling = this.sourceInfo.getOptMasterClientThrottling();
        if (throttling == null) {
            throttling = this.sourceInfo.getDefMasterClientThrottling();
        }
        return throttling;
    }

    public void setMasterClientThrottling(int throttling) {
        if (!Integer.valueOf(throttling).equals(this.sourceInfo.getOptMasterClientThrottling())) {
            this.sourceInfo.setOptMasterClientThrottling(Integer.valueOf(throttling));
        }
    }

    public int getDefMasterClientThrottling() {
        return this.sourceInfo.getDefMasterClientThrottling();
    }

    public int getClientThrottling() {
        Integer throttling = this.sourceInfo.getOptClientThrottling();
        if (throttling == null) {
            throttling = this.sourceInfo.getDefClientThrottling();
        }
        return throttling;
    }

    public void setClientThrottling(int throttling) {
        if (!Integer.valueOf(throttling).equals(this.sourceInfo.getOptClientThrottling())) {
            this.sourceInfo.setOptClientThrottling(Integer.valueOf(throttling));
        }
    }

    public int getDefClientThrottling() {
        return this.sourceInfo.getDefClientThrottling();
    }

    public int getMasterClientMaxDiskCache() {
        Integer maxDiskCache = this.sourceInfo.getOptMasterClientMaxDiskCache();
        if (maxDiskCache == null) {
            maxDiskCache = this.sourceInfo.getDefMasterClientMaxDiskCache();
        }
        return maxDiskCache;
    }

    public void setMasterClientMaxDiskCache(int maxDiskCache) {
        if (!Integer.valueOf(maxDiskCache).equals(this.sourceInfo.getOptMasterClientMaxDiskCache())) {
            this.sourceInfo.setOptMasterClientMaxDiskCache(Integer.valueOf(maxDiskCache));
        }
    }

    public long getMasterClientDeleteUnusedContentsTime() {
        Long unUsedContentsTime = this.sourceInfo.getOptMasterClientDeleteUnusedContentsTime();
        if (unUsedContentsTime == null) {
            unUsedContentsTime = this.sourceInfo.getDefMasterClientDeleteUnusedContentsTime();
        }
        return unUsedContentsTime;
    }

    public void setMasterClientDeleteUnusedContentsTime(long unUsedContentsTime) {
        if (!Long.valueOf(unUsedContentsTime).equals(this.sourceInfo.getOptMasterClientDeleteUnusedContentsTime())) {
            this.sourceInfo.setOptMasterClientDeleteUnusedContentsTime(Long.valueOf(unUsedContentsTime));
        }
    }

    public int getMasterClientThreadCount() {
        Integer threadCount = this.sourceInfo.getOptMasterClientThreadCount();
        if (threadCount == null) {
            threadCount = this.sourceInfo.getDefMasterClientThreadCount();
        }
        return threadCount;
    }

    public void setMasterClientThreadCount(int threadCount) {
        if (!Integer.valueOf(threadCount).equals(this.sourceInfo.getOptMasterClientThreadCount())) {
            this.sourceInfo.setOptMasterClientThreadCount(Integer.valueOf(threadCount));
        }
    }

    public void setLiveUpdateServerType(Integer type) {
        this.sourceInfo.setOptLiveUpdateServerType(type);
    }

    public void setCentralLuServers(Vector<CentralLuServerObject> luServers) {
        CentralLuServer newServer;
        int i = this.sourceInfo.getCentralLuServerCount();
        while (--i >= 0) {
            CentralLuServer oldServer = this.sourceInfo.getCentralLuServer(i);
            newServer = this.getCentralLuServer(luServers, oldServer);
            if (newServer == null) {
                this.sourceInfo.removeCentralLuServer(oldServer);
                continue;
            }
            this.mergeCentralLuServer(oldServer, newServer);
        }
        ArrayList<CentralLuServer> oldServers = new ArrayList<CentralLuServer>();
        int i2 = this.sourceInfo.getCentralLuServerCount();
        while (--i2 >= 0) {
            CentralLuServer oldServer = this.sourceInfo.getCentralLuServer(i2);
            oldServers.add(oldServer);
            this.sourceInfo.removeCentralLuServer(oldServer);
            this.sourceInfo.removeObsoleteItem(new ObsoleteItem(oldServer.getI()));
        }
        for (i2 = 0; i2 < luServers.size(); ++i2) {
            newServer = luServers.get(i2).getSchemaObject();
            CentralLuServer oldServer = this.getCentralLuServer(oldServers, newServer);
            this.sourceInfo.addCentralLuServer(oldServer != null ? oldServer : newServer);
        }
    }

    private void mergeCentralLuServer(CentralLuServer oldServer, CentralLuServer newServer) {
        if (!StringUtilities.isEqual((String)oldServer.getName(), (String)newServer.getName())) {
            oldServer.setName(newServer.getName());
        }
        if (!StringUtilities.isEqual((String)oldServer.getOptDescription(), (String)newServer.getOptDescription())) {
            oldServer.setOptDescription(newServer.getOptDescription());
        }
        if (!oldServer.getProtocol().equals(newServer.getProtocol())) {
            oldServer.setProtocol(newServer.getProtocol());
        }
        if (!StringUtilities.isEqual((String)oldServer.getURL(), (String)newServer.getURL())) {
            oldServer.setURL(newServer.getURL());
        }
        if (!StringUtilities.isEqual((String)oldServer.getOptUserName(), (String)newServer.getOptUserName())) {
            oldServer.setOptUserName(newServer.getOptUserName());
        }
        if (!StringUtilities.isEqual((String)oldServer.getOptPassword(), (String)newServer.getOptPassword())) {
            oldServer.setOptPassword(newServer.getOptPassword());
        }
    }

    private CentralLuServer getCentralLuServer(List<? extends Object> luServers, CentralLuServer cls) {
        String _i = cls.getI();
        for (int i = 0; i < luServers.size(); ++i) {
            Object item = luServers.get(i);
            CentralLuServer server = null;
            server = item instanceof CentralLuServerObject ? ((CentralLuServerObject)luServers.get(i)).getSchemaObject() : (CentralLuServer)item;
            if (!_i.equals(server.getI())) continue;
            return server;
        }
        return null;
    }

    public Boolean getLegacySupport() {
        return this.sourceInfo.getOptLegacyLuaSupport() != null ? this.sourceInfo.getOptLegacyLuaSupport() : this.sourceInfo.getDefLegacyLuaSupport();
    }

    public void setLegacySupport(Boolean legacySupport) {
        this.sourceInfo.setOptLegacyLuaSupport(legacySupport);
    }

    public int getFTPMode() {
        return this.sourceInfo.getOptFTPMode() != null ? this.sourceInfo.getOptFTPMode() : this.sourceInfo.getDefFTPMode();
    }

    public boolean getHttpsTrusted() {
        Boolean trusted = this.sourceInfo.getOptHttpsTrusted();
        if (trusted == null) {
            trusted = this.sourceInfo.getDefHttpsTrusted();
        }
        return trusted;
    }

    public void setFTPMode(int ftpMode) {
        this.sourceInfo.setOptFTPMode(Integer.valueOf(ftpMode));
    }

    public void setHttpsTrusted(boolean trusted) {
        this.sourceInfo.setOptHttpsTrusted(Boolean.valueOf(trusted));
    }
}

