/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu.logiobject;

import com.sygate.scm.common.configobject.schema.ContentVersionInfo;
import com.sygate.scm.common.configobject.schema.LuAppliedContent;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.util.List;

public class LuAppliedContentObject
extends AbstractUIObject {
    private LuAppliedContent luContent;

    public LuAppliedContentObject(LuAppliedContent luContent) {
        this.luContent = luContent;
    }

    public void removeAllContents() {
        int i = this.luContent.getContentVersionInfoCount();
        while (--i >= 0) {
            this.luContent.removeContentVersionInfo(this.luContent.getContentVersionInfo(i));
        }
    }

    public void addContent(String moniker, String sequenceNum) {
        ContentVersionInfo info = new ContentVersionInfo();
        info.setMoniker(moniker);
        info.setSequenceNum(sequenceNum);
        this.luContent.addContentVersionInfo(info);
    }

    public void updateContent(String moniker, String sequenceNum) {
        boolean bExist = false;
        ContentVersionInfo info = new ContentVersionInfo();
        for (int i = 0; i < this.luContent.getContentVersionInfoCount(); ++i) {
            info = this.luContent.getContentVersionInfo(i);
            if (!moniker.equalsIgnoreCase(info.getMoniker())) continue;
            bExist = true;
            break;
        }
        if (bExist) {
            if (StringUtilities.isEmpty((String)sequenceNum)) {
                this.luContent.removeContentVersionInfo(info);
            } else if (!sequenceNum.equalsIgnoreCase(info.getSequenceNum())) {
                info.setSequenceNum(sequenceNum);
            }
        } else {
            info = new ContentVersionInfo();
            info.setMoniker(moniker);
            info.setSequenceNum(sequenceNum);
            this.luContent.addContentVersionInfo(info);
        }
    }

    public boolean removeContent(String moniker) {
        for (int i = 0; i < this.luContent.getContentVersionInfoCount(); ++i) {
            ContentVersionInfo info = this.luContent.getContentVersionInfo(i);
            if (!moniker.equalsIgnoreCase(info.getMoniker())) continue;
            this.luContent.removeContentVersionInfo(info);
            return true;
        }
        return false;
    }

    public void removeInvalidContents() {
        int i = this.luContent.getContentVersionInfoCount();
        while (--i >= 0) {
            ContentVersionInfo info = this.luContent.getContentVersionInfo(i);
            if (!StringUtilities.isEmpty((String)info.getSequenceNum())) continue;
            this.luContent.removeContentVersionInfo(info);
        }
        i = this.luContent.getObsoleteItemCount();
        while (--i >= 0) {
            this.luContent.removeObsoleteItem(this.luContent.getObsoleteItem(i));
        }
    }

    public boolean verify() {
        this.removeInvalidContents();
        return true;
    }

    public LuAppliedContent getSchemaObject() {
        return this.luContent;
    }

    public boolean isEnabled() {
        return Utility.getBooleanValue((Boolean)this.luContent.getOptEnabled(), (Boolean)this.luContent.getDefEnabled());
    }

    public boolean isUseLastestVersion() {
        Integer type = this.luContent.getOptVersionSelectionType();
        return type == null || type.equals(LuAppliedContent.LATEST);
    }

    public boolean isUseNamedVersion() {
        Integer type = this.luContent.getOptVersionSelectionType();
        return type != null && type.equals(LuAppliedContent.NAMEDVERSION);
    }

    public boolean isUseEngineVersion() {
        Integer type = this.luContent.getOptVersionSelectionType();
        return type != null && type.equals(LuAppliedContent.ENGINEVERSION);
    }

    public void setEnabled(boolean isEnabled) {
        Boolean isenable;
        Boolean bl = isenable = isEnabled == this.luContent.getDefEnabled() ? null : Boolean.valueOf(isEnabled);
        if (isenable == null && !this.isEnabled() || isenable != null && isenable.booleanValue() != this.isEnabled()) {
            this.luContent.setOptEnabled(isenable);
        }
    }

    public void setVersionSelectionType(Integer selectionType) {
        if (selectionType != this.luContent.getOptVersionSelectionType()) {
            this.luContent.setOptVersionSelectionType(selectionType);
            if (LuAppliedContent.LATEST.equals(selectionType)) {
                this.removeAllContents();
            } else {
                List<String> monikers = LuUtility.getAllClientMonikersForLuContentPolicyForEachCategory(this.getCategoryType());
                for (String moniker : monikers) {
                    String seq = this.getLatestVersionForMoniker(selectionType, moniker);
                    ContentVersionInfo cvi = LuUtility.getContentVersionInfo(moniker, this);
                    if (cvi != null) {
                        cvi.setSequenceNum(seq);
                        continue;
                    }
                    this.addContent(moniker, seq);
                }
            }
        }
    }

    public int getAllContentsCount() {
        return this.luContent.getContentVersionInfoCount();
    }

    public ContentVersionInfo getContentVersionInfo(int index) {
        return this.luContent.getContentVersionInfo(index);
    }

    public String getContentMoniker(int index) {
        ContentVersionInfo info = this.luContent.getContentVersionInfo(index);
        return info.getMoniker();
    }

    public String getContentSequence(int index) {
        ContentVersionInfo info = this.luContent.getContentVersionInfo(index);
        return info.getSequenceNum();
    }

    public String getCategoryType() {
        return this.luContent.getContentCategory();
    }

    private String getLatestVersionForMoniker(Integer versionSelectionType, String moniker) {
        String version = null;
        if (LuAppliedContent.NAMEDVERSION.equals(versionSelectionType)) {
            version = LuUtility.getLatestAvailableContentSeqForMoniker(moniker);
        } else if (LuAppliedContent.ENGINEVERSION.equals(versionSelectionType)) {
            version = LuUtility.getLatestAvailableContentEngineForMoniker(moniker);
        }
        return StringUtilities.isEmpty((String)version) ? "" : version;
    }
}

