/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu.logiobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.LinuxLuPolicy;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.configobject.schema.LuDownloadSchedule;
import com.sygate.scm.common.configobject.schema.LuGeneralConfig;
import com.sygate.scm.common.configobject.schema.LuPolicy;
import com.sygate.scm.common.configobject.schema.MacLuPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuContentSourceInfoObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuDownloadScheduleObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuGeneralConfigObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.MacLuContentSourceInfoObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.MacLuDownloadScheduleObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.Utility;

public class LiveUpdateObject
extends PolicyIntObjectBase {
    private LuContentSourceInfoObject sourceInfoObj;
    private LuDownloadScheduleObject scheduleObj;
    private LuGeneralConfigObject generalConfig;
    private MacLuPolicy macLuPolicy;
    private MacLuContentSourceInfoObject macSourceInfoObj;
    private MacLuDownloadScheduleObject macScheduleObj;
    private LinuxLuPolicy linuxLuPolicy;
    private LuContentSourceInfoObject linuxSourceInfoObj;
    private LuDownloadScheduleObject linuxScheduleObj;
    private LuGeneralConfigObject linuxGeneralConfig;

    public LiveUpdateObject() {
    }

    public LiveUpdateObject(PolicyIntObjectBase policyObject) {
        super(policyObject);
    }

    public LiveUpdateObject(TopLevelObject luPolicy) {
        super(luPolicy);
        this.initialize();
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof LuPolicy)) {
            throw new ConsoleException(302645248, 32);
        }
        return new LiveUpdateObject(policyObj);
    }

    private void initialize() {
        this.sourceInfoObj = new LuContentSourceInfoObject(this.getLuContentSourceInfo());
        this.scheduleObj = new LuDownloadScheduleObject(this.getLuDownloadSchedule());
        this.generalConfig = new LuGeneralConfigObject(this.getLuGeneralConfig());
        this.macLuPolicy = this.getMacLuPolicy();
        this.macSourceInfoObj = new MacLuContentSourceInfoObject(this.getMacLuContentSourceInfo());
        this.macScheduleObj = new MacLuDownloadScheduleObject(this.getMacLuDownloadSchedule());
        this.linuxLuPolicy = this.getLinuxLuPolicy();
        this.linuxSourceInfoObj = new LuContentSourceInfoObject(this.getLinuxLuContentSourceInfo());
        this.linuxScheduleObj = new LuDownloadScheduleObject(this.getLinuxLuDownloadSchedule());
        this.linuxGeneralConfig = new LuGeneralConfigObject(this.getLinuxLuGeneralConfig());
    }

    private LuContentSourceInfo getLuContentSourceInfo() {
        LuContentSourceInfo sourceInfo = ((LuPolicy)this.policy).getOptLuContentSourceInfo();
        if (sourceInfo == null) {
            sourceInfo = new LuContentSourceInfo();
            ((LuPolicy)this.policy).setOptLuContentSourceInfo(sourceInfo);
        }
        return sourceInfo;
    }

    private LuDownloadSchedule getLuDownloadSchedule() {
        LuDownloadSchedule schedule = ((LuPolicy)this.policy).getOptLuDownloadSchedule();
        if (schedule == null) {
            schedule = new LuDownloadSchedule();
            schedule.setOptAllowRetry(Boolean.valueOf(true));
            ((LuPolicy)this.policy).setOptLuDownloadSchedule(schedule);
        }
        return schedule;
    }

    private LuGeneralConfig getLuGeneralConfig() {
        LuGeneralConfig config = ((LuPolicy)this.policy).getOptLuGeneralConfig();
        if (config == null) {
            config = new LuGeneralConfig();
            ((LuPolicy)this.policy).setOptLuGeneralConfig(config);
        }
        return config;
    }

    private MacLuPolicy getMacLuPolicy() {
        MacLuPolicy config = ((LuPolicy)this.policy).getOptMacLuPolicy();
        if (config == null) {
            config = new MacLuPolicy();
            ((LuPolicy)this.policy).setOptMacLuPolicy(config);
        }
        return config;
    }

    private LuGeneralConfig getMacLuGeneralConfig() {
        LuGeneralConfig config = this.macLuPolicy.getOptLuGeneralConfig();
        if (config == null) {
            config = new LuGeneralConfig();
            this.macLuPolicy.setOptLuGeneralConfig(config);
        }
        return config;
    }

    private LuContentSourceInfo getMacLuContentSourceInfo() {
        LuContentSourceInfo config = this.macLuPolicy.getOptLuContentSourceInfo();
        if (config == null) {
            config = new LuContentSourceInfo();
            this.macLuPolicy.setOptLuContentSourceInfo(config);
        }
        return config;
    }

    private LuDownloadSchedule getMacLuDownloadSchedule() {
        LuDownloadSchedule config = this.macLuPolicy.getOptLuDownloadSchedule();
        if (config == null) {
            config = new LuDownloadSchedule();
            this.macLuPolicy.setOptLuDownloadSchedule(config);
        }
        return config;
    }

    private LinuxLuPolicy getLinuxLuPolicy() {
        LinuxLuPolicy config = ((LuPolicy)this.policy).getOptLinuxLuPolicy();
        if (config == null) {
            config = new LinuxLuPolicy();
            ((LuPolicy)this.policy).setOptLinuxLuPolicy(config);
        }
        return config;
    }

    private LuGeneralConfig getLinuxLuGeneralConfig() {
        LuGeneralConfig config = this.linuxLuPolicy.getOptLuGeneralConfig();
        if (config == null) {
            config = new LuGeneralConfig();
            this.linuxLuPolicy.setOptLuGeneralConfig(config);
        }
        return config;
    }

    private LuContentSourceInfo getLinuxLuContentSourceInfo() {
        LuContentSourceInfo config = this.linuxLuPolicy.getOptLuContentSourceInfo();
        if (config == null) {
            config = new LuContentSourceInfo();
            this.linuxLuPolicy.setOptLuContentSourceInfo(config);
        }
        return config;
    }

    private LuDownloadSchedule getLinuxLuDownloadSchedule() {
        LuDownloadSchedule config = this.linuxLuPolicy.getOptLuDownloadSchedule();
        if (config == null) {
            config = new LuDownloadSchedule();
            this.linuxLuPolicy.setOptLuDownloadSchedule(config);
        }
        return config;
    }

    @Override
    public boolean getEnabled() {
        return Utility.getBooleanValue((Boolean)((LuPolicy)this.policy).getOptEnable(), (Boolean)((LuPolicy)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ((LuPolicy)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String getCreator() {
        return ((LuPolicy)this.policy).getOptCreator();
    }

    @Override
    public void setCreator(String creator) {
        ((LuPolicy)this.policy).setOptCreator(creator);
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LiveUpdateObject.luPolicyDescription");
    }

    @Override
    public String getTargetType() {
        return "LuPolicy";
    }

    @Override
    public String getTargetName() {
        return "LuPolicyApplied";
    }

    @Override
    public String getRefTargetName() {
        return "SuspendedLuPolicyLink";
    }

    @Override
    public int getItemType() {
        return 144;
    }

    @Override
    public String getLocalReferenceName() {
        return "LocalLuPolicy";
    }

    public void setDescription(String newValue) {
        ((LuPolicy)this.policy).setOptDescription(newValue);
    }

    public LuContentSourceInfoObject getLuContentSourceInfoObject() {
        return this.sourceInfoObj;
    }

    public LuDownloadScheduleObject getLuDownloadScheduleObject() {
        return this.scheduleObj;
    }

    public LuGeneralConfigObject getLuGeneralConfigObject() {
        return this.generalConfig;
    }

    public MacLuContentSourceInfoObject getMacLuContentSourceInfoObject() {
        return this.macSourceInfoObj;
    }

    public MacLuDownloadScheduleObject getMacLuDownloadScheduleObject() {
        return this.macScheduleObj;
    }

    public LuGeneralConfigObject getLinuxLuGeneralConfigObject() {
        return this.linuxGeneralConfig;
    }

    public LuContentSourceInfoObject getLinuxLuContentSourceInfoObject() {
        return this.linuxSourceInfoObj;
    }

    public LuDownloadScheduleObject getLinuxLuDownloadScheduleObject() {
        return this.linuxScheduleObj;
    }
}

