/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu.logiobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ContentVersionInfo;
import com.sygate.scm.common.configobject.schema.LuAppliedContent;
import com.sygate.scm.common.configobject.schema.LuContentPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuAppliedContentObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.Utility;
import java.util.List;
import java.util.Vector;

public class LiveUpdateContentObject
extends PolicyIntObjectBase {
    public LiveUpdateContentObject(TopLevelObject luPolicy) {
        super(luPolicy);
    }

    public void clearLuAppliedContent() {
        int i = ((LuContentPolicy)this.policy).getLuAppliedContentCount();
        while (--i >= 0) {
            ((LuContentPolicy)this.policy).removeLuAppliedContent(((LuContentPolicy)this.policy).getLuAppliedContent(i));
        }
    }

    public void addLuAppliedContent(List<List<LuAppliedContentObject>> contentsList) {
        for (int i = 0; i < contentsList.size(); ++i) {
            List<LuAppliedContentObject> contents = contentsList.get(i);
            for (int j = 0; j < contents.size(); ++j) {
                LuAppliedContentObject contentObj = contents.get(j);
                ((LuContentPolicy)this.policy).addLuAppliedContent(contentObj.getSchemaObject());
            }
        }
    }

    public void updLuAppliedContent(List<List<LuAppliedContentObject>> contentsList) {
        LuContentPolicy luContentPolicy = (LuContentPolicy)this.policy;
        for (int k = 0; k < luContentPolicy.getLuAppliedContentCount(); ++k) {
            LuAppliedContent exAppliedContent = luContentPolicy.getLuAppliedContent(k);
            String category = exAppliedContent.getContentCategory();
            boolean bExisted = false;
            LuAppliedContent appliedContent = null;
            for (int i = 0; i < contentsList.size(); ++i) {
                List<LuAppliedContentObject> contents = contentsList.get(i);
                for (int j = 0; j < contents.size(); ++j) {
                    LuAppliedContentObject contentObj = contents.get(j);
                    appliedContent = contentObj.getSchemaObject();
                    if (!category.equalsIgnoreCase(appliedContent.getContentCategory())) continue;
                    bExisted = true;
                    break;
                }
                if (bExisted) break;
            }
            if (bExisted) {
                boolean bModified = false;
                if (exAppliedContent.getT() != appliedContent.getT() || exAppliedContent.getContentVersionInfoCount() != appliedContent.getContentVersionInfoCount()) {
                    bModified = true;
                }
                if (!bModified) {
                    for (int i = 0; i < exAppliedContent.getContentVersionInfoCount(); ++i) {
                        ContentVersionInfo exInfo = exAppliedContent.getContentVersionInfo(i);
                        String moniker = exInfo.getMoniker();
                        for (int j = 0; j < appliedContent.getContentVersionInfoCount(); ++j) {
                            if (!moniker.equalsIgnoreCase(appliedContent.getContentVersionInfo(j).getMoniker()) || exInfo.getT() == appliedContent.getContentVersionInfo(j).getT()) continue;
                            bModified = true;
                            break;
                        }
                        if (bModified) break;
                    }
                }
                if (!bModified) continue;
                luContentPolicy.setLuAppliedContent(k, appliedContent);
                continue;
            }
            if (bExisted || appliedContent == null) continue;
            appliedContent = luContentPolicy.getLuAppliedContent(k);
            luContentPolicy.removeLuAppliedContent(appliedContent);
        }
        for (int i = 0; i < contentsList.size(); ++i) {
            List<LuAppliedContentObject> contents = contentsList.get(i);
            for (int j = 0; j < contents.size(); ++j) {
                LuAppliedContentObject contentObj = contents.get(j);
                String category = contentObj.getSchemaObject().getContentCategory();
                boolean bExisted = false;
                LuAppliedContent appliedContent = null;
                for (int k = 0; k < luContentPolicy.getLuAppliedContentCount(); ++k) {
                    appliedContent = luContentPolicy.getLuAppliedContent(k);
                    if (!category.equalsIgnoreCase(appliedContent.getContentCategory())) continue;
                    bExisted = true;
                    break;
                }
                if (bExisted || appliedContent == null) continue;
                appliedContent = contentObj.getSchemaObject();
                luContentPolicy.addLuAppliedContent(appliedContent);
            }
        }
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof LuContentPolicy)) {
            throw new ConsoleException(302645248, 32);
        }
        return new LiveUpdateContentObject(policyObj);
    }

    @Override
    public boolean getEnabled() {
        return Utility.getBooleanValue((Boolean)((LuContentPolicy)this.policy).getOptEnable(), (Boolean)((LuContentPolicy)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ((LuContentPolicy)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String getCreator() {
        return ((LuContentPolicy)this.policy).getOptCreator();
    }

    @Override
    public void setCreator(String creator) {
        ((LuContentPolicy)this.policy).setOptCreator(creator);
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LiveUpdateContentObject.luContentPolicyDescription");
    }

    @Override
    public String getTargetType() {
        return "LuContentPolicy";
    }

    @Override
    public String getTargetName() {
        return "LuContentPolicyApplied";
    }

    @Override
    public String getRefTargetName() {
        return "SuspendedLuContentPolicyLink";
    }

    @Override
    public int getItemType() {
        return 148;
    }

    @Override
    public String getLocalReferenceName() {
        return "";
    }

    public LuAppliedContentObject getAppliedContent(String categoryName) {
        Vector contents = ((LuContentPolicy)this.policy).getLuAppliedContent();
        for (int i = 0; i < contents.size(); ++i) {
            LuAppliedContent content = (LuAppliedContent)contents.get(i);
            if (!content.getContentCategory().equals(categoryName)) continue;
            return new LuAppliedContentObject(content);
        }
        return null;
    }

    public void setDescription(String newValue) {
        ((LuContentPolicy)this.policy).setOptDescription(newValue);
    }
}

