/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu.logiobject;

import com.sygate.scm.common.configobject.schema.LegacyMoniker;
import com.sygate.scm.common.configobject.schema.LocalizedStrings;
import com.sygate.scm.common.configobject.schema.LuClientRegistration;
import com.sygate.scm.common.configobject.schema.LuRegistration;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import java.util.Vector;

public class ContentVersionInfoTableRow
extends AbstractUIObject
implements TableRow {
    public static final int NAME_COLUMN = 0;
    public static final int REVISION_COLUMN = 1;
    private LuClientRegistration luClientRegistration;
    private LuRegistration luRegistration;
    private boolean legacyMonikersExists = false;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private String selectedSeqNumber;

    public ContentVersionInfoTableRow(LuClientRegistration luClientReg) {
        this.luRegistration = (LuRegistration)luClientReg.getParent();
        this.luClientRegistration = luClientReg;
    }

    @Override
    public Object getValueAt(int index) {
        if (this.luClientRegistration == null) {
            return null;
        }
        switch (index) {
            case 0: {
                return LuUtility.getLocalizedString(this.luRegistration.getLocalizedStrings()).getOptDisplayName();
            }
            case 1: {
                if (!this.isEmpty(this.selectedSeqNumber)) {
                    return this.selectedSeqNumber;
                }
                return MSGRES.getString(LU, "NamedVersionDialog.table.none");
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        if (this.luClientRegistration == null) {
            return null;
        }
        switch (index) {
            case 0: {
                return LocalizedStrings.class;
            }
            case 1: {
                if (!this.isEmpty(this.selectedSeqNumber)) {
                    return String.class;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 0: {
                break;
            }
            case 1: {
                this.selectedSeqNumber = (String)value;
                break;
            }
        }
    }

    public String getClientMoniker() {
        return this.luClientRegistration.getMoniker();
    }

    public String getSequenceNum() {
        return this.selectedSeqNumber;
    }

    private boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    public boolean hasSequenceNumber() {
        return !this.isEmpty(this.selectedSeqNumber);
    }

    public void setSequenceNum(String sequenceNum) {
        this.selectedSeqNumber = sequenceNum;
    }

    public boolean isLegacyMonikersExists() {
        return this.legacyMonikersExists;
    }

    public void setLegacyMonikersExists(boolean legacyMonikersExists) {
        this.legacyMonikersExists = legacyMonikersExists;
    }

    public Vector<LegacyMoniker> getLegacyMonikers() {
        return this.luClientRegistration.getLegacyMoniker();
    }
}

