/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.ContentVersionInfo;
import com.sygate.scm.common.configobject.schema.LuClientRegistration;
import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.configobject.schema.LuRegistration;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.policy.lu.logiobject.ContentVersionInfoTableRow;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuAppliedContentObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class VersionDialog
extends DialogBase {
    private static final long serialVersionUID = -9001216670469193287L;
    protected static final MessageResources MSGRES = MessageResources.getInstance();
    protected static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private static final float[] COL_SIZE = new float[]{0.7f, 0.3f};
    protected SortableTableModel tableModel;
    private JTable jTTable = null;
    protected LuAppliedContentObject appliedContentObject;
    protected LuContentCategory luCategory;
    protected RevisionTableCellEditor revisionTableCellEditor = new RevisionTableCellEditor();
    HashMap<String, String> seqNumMap = new HashMap();

    public VersionDialog(LuContentCategory luCategory) {
        super(Manager.getFrame(), "", true);
        this.luCategory = luCategory;
        this.setTitle(this.createTitle());
        this.initialize();
        UIUtilities.resizeColumns(this.jTTable, COL_SIZE, (float)this.jTTable.getSize().getWidth());
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.jTTable.setEnabled(false);
            this.resetOKButton(false);
        }
        UiUtilities.centerComponent((Component)this);
    }

    public LuAppliedContentObject setObject(LuAppliedContentObject nvObj) {
        this.appliedContentObject = nvObj;
        this.updatePanel();
        return nvObj;
    }

    public LuAppliedContentObject getLuAppliedContentObject() {
        return this.appliedContentObject;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    protected boolean isValidate() {
        return true;
    }

    protected Comparator<String> getVersionComparator() {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int i2;
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (StringUtilities.isEmpty((String)s1)) {
                    return -1;
                }
                if (StringUtilities.isEmpty((String)s2)) {
                    return 1;
                }
                int i1 = Integer.parseInt(s1, 10);
                return i1 == (i2 = Integer.parseInt(s2, 10)) ? 0 : (i1 > i2 ? -1 : 1);
            }
        };
        return comparator;
    }

    @Override
    protected abstract void commit();

    protected abstract String createTitle();

    protected abstract String[] createTableColumnNames();

    protected abstract JPanel createDescriptionPanel();

    protected abstract List<String> getAvailableVersions(String var1);

    protected abstract String getDisplaySequenceNum(String var1);

    protected abstract boolean isCorrectVersionType();

    protected abstract boolean canAddtoTableModel(String var1);

    private void initialize() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.getVersionChoosePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
    }

    private JPanel getVersionChoosePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 25, 10, 25));
        panel.add((Component)this.createDescriptionPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTable)this.createVersionTable());
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 20, 5, 20), 0, 0));
        return panel;
    }

    private JTable createVersionTable() {
        this.tableModel = new SortableTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 1 ? true : super.isCellEditable(row, col);
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                ContentVersionInfoTableRow tableRow = (ContentVersionInfoTableRow)this.getRow(row);
                tableRow.setValueAt(VersionDialog.this.seqNumMap.get(value), this.convertToRowIndex(column));
                this.fireTableRowsUpdated(row, row);
            }
        };
        this.tableModel.setColumnNames(this.createTableColumnNames());
        Vector data = (Vector)Cast.cast(this.getContentVersionInfoTableData(this.luCategory));
        this.tableModel.setDataVector(data);
        this.tableModel.sortTable(0, true);
        if (data.size() == 0) {
            this.jBOk.setEnabled(false);
        }
        this.jTTable = new StripesTable(this.tableModel);
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> this.jTTable.setRowHeight(20));
        this.tableModel.addMouseListenerToHeaderInTable(this.jTTable);
        this.jTTable.getColumnModel().getColumn(1).setCellRenderer(new RevisionTableCellEditor());
        this.jTTable.getColumnModel().getColumn(1).setCellEditor(new RevisionTableCellEditor());
        this.jTTable.getColumnModel().getColumn(0).setCellRenderer(new RevisionTableCellEditor());
        Dimension size = this.jTTable.getPreferredScrollableViewportSize();
        this.jTTable.setPreferredScrollableViewportSize(new Dimension(size.width, (this.jTTable.getRowHeight() + this.jTTable.getRowMargin()) * 5 * 2));
        this.jTTable.getSelectionModel().setSelectionMode(0);
        return this.jTTable;
    }

    private Vector<ContentVersionInfoTableRow> getContentVersionInfoTableData(LuContentCategory luCategoryParam) {
        HashMap<String, String> legacydata = this.getLegacyMonikers(luCategoryParam);
        Vector<ContentVersionInfoTableRow> data = new Vector<ContentVersionInfoTableRow>();
        for (int i = 0; i < luCategoryParam.getLuRegistrationCount(); ++i) {
            String moniker;
            LuRegistration luReg = luCategoryParam.getLuRegistration(i);
            Boolean obsoleted = Utility.getBooleanValue((Boolean)luReg.getOptObsolete(), (Boolean)luReg.getDefObsolete());
            if (obsoleted.booleanValue() || luReg.getOptLuClientRegistration() == null) continue;
            LuClientRegistration luClientReg = luReg.getOptLuClientRegistration();
            String groupMoniker = luReg.getLuServerRegistration().getOptGroupMoniker();
            String hubMoniker = luReg.getLuServerRegistration().getOptHubMoniker();
            if (groupMoniker != null && hubMoniker == null || legacydata.containsKey(moniker = luClientReg.getMoniker()) || !this.canAddtoTableModel(moniker)) continue;
            data.add(new ContentVersionInfoTableRow(luClientReg));
        }
        return data;
    }

    private HashMap<String, String> getLegacyMonikers(LuContentCategory luCategoryParam) {
        HashMap<String, String> legacydata = new HashMap<String, String>();
        for (int i = 0; i < luCategoryParam.getLuRegistrationCount(); ++i) {
            LuClientRegistration luClientReg;
            LuRegistration luReg = luCategoryParam.getLuRegistration(i);
            Boolean obsoleted = Utility.getBooleanValue((Boolean)luReg.getOptObsolete(), (Boolean)luReg.getDefObsolete());
            if (obsoleted.booleanValue() || luReg.getOptLuClientRegistration() == null || (luClientReg = luReg.getOptLuClientRegistration()).getLegacyMonikerCount() <= 0) continue;
            for (int j = 0; j < luClientReg.getLegacyMonikerCount(); ++j) {
                legacydata.put(luClientReg.getLegacyMoniker(j).getMoniker(), luClientReg.getMoniker());
            }
        }
        return legacydata;
    }

    private void updatePanel() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            ContentVersionInfoTableRow obj = (ContentVersionInfoTableRow)this.tableModel.getRow(i);
            String seqNum = this.getSequenceNum(obj.getClientMoniker());
            if (seqNum == null) continue;
            obj.setSequenceNum(seqNum);
        }
    }

    private String getSequenceNum(String moniker) {
        ContentVersionInfo cvi = LuUtility.getContentVersionInfo(moniker, this.appliedContentObject);
        return cvi == null ? "" : cvi.getSequenceNum();
    }

    private class RevisionTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JComboBox<String> jComboBox = new JComboBox();
        private JLabel nameLabel = new JLabel();
        private JLabel revisionLabel = new JLabel();
        Vector<String> revisions;

        public RevisionTableCellEditor() {
            PopupMenuListener pml = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    RevisionTableCellEditor.this.stopCellEditing();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
            this.jComboBox.addPopupMenuListener(pml);
            this.jComboBox.setBorder(null);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String sequenceNum;
            ContentVersionInfoTableRow cviTableRow = (ContentVersionInfoTableRow)VersionDialog.this.tableModel.getRow(row);
            String moniker = cviTableRow.getClientMoniker();
            List<String> allSeqList = VersionDialog.this.getAvailableVersions(moniker);
            this.revisions = new Vector();
            for (String seqNum : allSeqList) {
                String displaySeqNum = VersionDialog.this.getDisplaySequenceNum(seqNum);
                this.revisions.add(displaySeqNum);
                VersionDialog.this.seqNumMap.put(displaySeqNum, seqNum);
            }
            if (VersionDialog.this.isCorrectVersionType() && !StringUtilities.isEmpty((String)(sequenceNum = VersionDialog.this.getSequenceNum(moniker))) && !allSeqList.contains(sequenceNum)) {
                String displaySeqNum = VersionDialog.this.getDisplaySequenceNum(sequenceNum);
                this.revisions.add(displaySeqNum);
                VersionDialog.this.seqNumMap.put(displaySeqNum, sequenceNum);
            }
            int fontStyle = 0;
            switch (column) {
                case 1: {
                    if (this.revisions.size() > 0) {
                        this.jComboBox.setModel(new DefaultComboBoxModel<String>(this.revisions));
                        if (value != null) {
                            this.jComboBox.setSelectedItem(VersionDialog.this.getDisplaySequenceNum((String)value));
                        } else {
                            this.jComboBox.setSelectedIndex(0);
                        }
                        cviTableRow.setSequenceNum(VersionDialog.this.seqNumMap.get(this.jComboBox.getSelectedItem()));
                        return this.jComboBox;
                    }
                    this.revisionLabel.setText(MSGRES.getString(VersionDialog.LU, "NamedVersionDialog.table.none"));
                    this.revisionLabel.setFont(this.revisionLabel.getFont().deriveFont(fontStyle));
                    return this.revisionLabel;
                }
                case 0: {
                    String seqNum;
                    this.nameLabel.setOpaque(true);
                    this.nameLabel.setText((String)value);
                    if (this.revisions.size() == 0) {
                        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(fontStyle));
                    }
                    if ((seqNum = cviTableRow.getSequenceNum()) != null && !allSeqList.contains(seqNum)) {
                        this.nameLabel.setBackground(Color.LIGHT_GRAY);
                    } else {
                        this.nameLabel.setBackground(table.getBackground());
                    }
                    return this.nameLabel;
                }
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.revisions.isEmpty()) {
                return null;
            }
            return this.jComboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

