/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LUAvDefinitionCheck;
import com.sygate.scm.common.configobject.schema.LUChannelFailoverMode;
import com.sygate.scm.common.configobject.schema.LuDownloadSchedule;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.UseLiveUpdateServerListener;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuDownloadScheduleObject;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SchedulePanel
extends JPanel
implements ContentSensitiveHelpPage,
UseLiveUpdateServerListener {
    private static final long serialVersionUID = 3994707517755992411L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private int platformType = 1;
    private static final String[] DAY = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.sunday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.monday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.tuesday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.wednesday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.thursday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.friday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.saturday")};
    private JRadioButton jRBContinuous = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.continuous"));
    private JRadioButton jRBHourly = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.hourlyFrequency"));
    private JRadioButton jRBDaily = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.daily"));
    private JRadioButton jRBWeekly = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.weekly"));
    private JSpinner jSpnHour = new JSpinner(new SpinnerNumberModel(1, 1, 23, 1));
    private TimeSpinner1 timeSpinner;
    private boolean hasHour;
    private boolean hasMinute;
    private boolean hasSecond;
    private boolean hasAmpm;
    private String hourPattern;
    private JComboBox<String> jCmbDay = new JComboBox<String>(DAY);
    private JCheckBox jChkRetry = new JCheckBox();
    private JSpinner jSpnRetry = new JSpinner(new SpinnerNumberModel(1, 1, 300, 1));
    private JCheckBox jChkRandomize = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.checkbox.randMin"));
    private JSpinner jSpnRandom = new JSpinner(new SpinnerNumberModel(1, 1, 300, 1));
    private JCheckBox jChkEnabled = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.checkbox.enabled"));
    private JLabel jLblAt = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.label.at"));
    private JLabel jLblEvery = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.label.every"));
    private JLabel jLblHourly = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.label.hourlyFrequency"));
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private JCheckBox jChkIdleDetection = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.checkbox.idleDetection"));
    private JCheckBox jChkAvDefOlderThan = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.checkbox.additionalOptions.defOlderthan"));
    private JCheckBox jChkDisconnectedFor = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.checkbox.additionalOptions.disconnectedFor"));
    private JRadioButton jRBDefinationOlderThanDays = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.days"));
    private JRadioButton jRBDefinationOlderThanHours = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.hours"));
    private JRadioButton jRBDisconnectedForMinutes = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.minutes"));
    private JRadioButton jRBDisconnectedForHours = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.hours"));
    private static final int AV_DEFINITION_DEFAULT_VALUE = 2;
    private static final int CLIENT_DISCONNECTED_FOR_DEFAULT_VALUE = 8;
    private JSpinner jSpnDefOlderThan = new JSpinner(new SpinnerNumberModel(2, 1, 31, 1));
    private JSpinner jSpnDisconnectedFor = new JSpinner(new SpinnerNumberModel(8, 1, 11, 1));
    private boolean userSetSelected;
    private LuDownloadScheduleObject scheduleObj;

    public static String[] getDay() {
        return (String[])DAY.clone();
    }

    public static String getDayByIndex(int index) {
        int day_count = DAY.length;
        if (index < 0 || index > day_count - 1) {
            return null;
        }
        return DAY[index];
    }

    public SchedulePanel(int platformType) {
        this.platformType = platformType;
        this.timeSpinner = new TimeSpinner1(this.timePattern);
        if (this.timePattern.indexOf("h") != -1) {
            this.hourPattern = "h";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("H") != -1) {
            this.hourPattern = "H";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("k") != -1) {
            this.hourPattern = "k";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("K") != -1) {
            this.hourPattern = "K";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("m") != -1) {
            this.hasMinute = true;
        }
        if (this.timePattern.indexOf("s") != -1) {
            this.hasSecond = true;
        }
        if (this.timePattern.indexOf("a") != -1) {
            this.hasAmpm = true;
        }
        this.initialize();
    }

    public void save() {
        boolean enabled = true;
        if (1 == this.platformType) {
            enabled = this.jChkEnabled.isSelected();
        }
        this.scheduleObj.setEnabled(enabled);
        Integer freq = this.getFrequency();
        Integer hour = (Integer)this.jSpnHour.getValue();
        this.scheduleObj.setFrequency(freq);
        this.scheduleObj.setFrequencyInterval(hour);
        int hr = 0;
        int minute = 0;
        int second = 0;
        int ampm = -1;
        if (this.hasHour) {
            hr = this.timeSpinner.getHour();
            if (this.hasAmpm) {
                ampm = this.timeSpinner.getAmpm();
            }
            hr = Utility.convertHourTo_H_Pattern((int)hr, (String)this.hourPattern, (int)ampm);
        }
        if (this.hasMinute) {
            minute = this.timeSpinner.getMinute();
        }
        if (this.hasSecond) {
            second = this.timeSpinner.getSecond();
        }
        long startTime = (long)hr * 3600L + (long)(minute * 60) + (long)second;
        this.scheduleObj.setStartTime(startTime);
        this.scheduleObj.setDayOfWeek((this.jCmbDay.getSelectedIndex() + Utility.getCalendarInstance().getFirstDayOfWeek() - 1) % 7);
        this.scheduleObj.setAllowRetry(this.jChkRetry.isSelected());
        this.scheduleObj.setRetryWindow((Integer)this.jSpnRetry.getValue(), freq, hour);
        this.scheduleObj.setRandomness(this.jChkRandomize.isSelected());
        this.scheduleObj.setRandomizeTime((Integer)this.jSpnRandom.getValue(), freq, hour);
        this.scheduleObj.setIdleDetection(this.jChkIdleDetection.isSelected());
        this.scheduleObj.setAvDefOlderThan(this.jChkAvDefOlderThan.isSelected());
        this.scheduleObj.setLUChannelFailoverMode(this.jChkDisconnectedFor.isSelected());
        this.scheduleObj.setAvDefinitionAge((Integer)this.jSpnDefOlderThan.getValue());
        this.scheduleObj.setDisconnectDuration((Integer)this.jSpnDisconnectedFor.getValue());
        this.scheduleObj.setAvDefFrequency(this.getAvDefFrequency());
        this.scheduleObj.setDisconnectedFrequency(this.getDisconnectedFrequency());
    }

    public void updateRetryWindowState(boolean state) {
        this.jChkRetry.setEnabled(state);
        this.jSpnRetry.setEnabled(state);
    }

    private void initialize() {
        this.setLayout(new VerticalFlowLayout(0, 0));
        String[] day = new String[7];
        int iFirstDay = Utility.getCalendarInstance().getFirstDayOfWeek() - 1;
        for (int i = 0; i < 7; ++i) {
            day[i] = DAY[(iFirstDay + i) % 7];
        }
        this.jCmbDay = new JComboBox<String>(day);
        this.add(this.getEnablePanel());
        this.add(this.getFrequencePanel());
        this.add(this.getRetryIntervalPanel());
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.add(this.getRandomizationPanel());
            if (1 == this.platformType) {
                this.add(this.getIdleDetectionPanel());
                this.add(this.getAdditionalOptionPanel());
            }
        }
        if (1 == this.platformType) {
            this.jChkEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SchedulePanel.this.userSetSelected = SchedulePanel.this.jChkEnabled.isSelected();
                    SchedulePanel.this.frequencyChanged(true);
                }
            });
        }
        UIUtilities.enableOnlyValidEdits(this.jSpnHour);
        UIUtilities.enableOnlyValidEdits(this.jSpnRandom);
        UIUtilities.enableOnlyValidEdits(this.jSpnRetry);
        UIUtilities.enableOnlyValidEdits(this.jSpnDefOlderThan);
        UIUtilities.enableOnlyValidEdits(this.jSpnDisconnectedFor);
        Dimension orginal = this.getPreferredSize();
        this.setPreferredSize(new Dimension(orginal.width, orginal.height - 55));
    }

    private JPanel getEnablePanel() {
        JPanel enablePanel = new JPanel(new BorderLayout());
        String enableDescKey = "SchedulePanel.label.enableDesc";
        if (3 == this.platformType) {
            enableDescKey = "SchedulePanel.label.enableDescLinux";
        }
        if (LicenseObject.getInstance().isSBProduct()) {
            enableDescKey = "SchedulePanel.label.enableDescforSBE";
        }
        enablePanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "SchedulePanel.label.enable"), MSGRES.getString(LU, enableDescKey), false), "North");
        if (1 == this.platformType) {
            enablePanel.add((Component)this.jChkEnabled, "West");
        }
        enablePanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        return enablePanel;
    }

    private JPanel getFrequencePanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBContinuous);
        group.add(this.jRBHourly);
        group.add(this.jRBDaily);
        group.add(this.jRBWeekly);
        this.jRBContinuous.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SchedulePanel.this.scheduleObj.setFrequency(0);
                SchedulePanel.this.frequencyChanged(true);
            }
        });
        this.jRBHourly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SchedulePanel.this.scheduleObj.setFrequency(1);
                SchedulePanel.this.frequencyChanged(true);
                Integer val = (Integer)SchedulePanel.this.jSpnHour.getValue();
                if (val == 1) {
                    SchedulePanel.this.updateRetryWindowState(false);
                }
            }
        });
        this.jRBDaily.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SchedulePanel.this.scheduleObj.setFrequency(2);
                SchedulePanel.this.frequencyChanged(true);
            }
        });
        this.jRBWeekly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SchedulePanel.this.scheduleObj.setFrequency(3);
                SchedulePanel.this.frequencyChanged(true);
            }
        });
        this.jSpnHour.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SchedulePanel.this.frequencyHourChanged();
                Integer val = (Integer)SchedulePanel.this.jSpnHour.getValue();
                if (val == 1) {
                    SchedulePanel.this.updateRetryWindowState(false);
                }
            }
        });
        Box panel1 = new Box(0);
        panel1.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 20));
        panel1.add(this.jRBContinuous);
        panel1.add(Box.createHorizontalStrut(20));
        panel1.add(this.jRBHourly);
        panel1.add(this.jSpnHour);
        panel1.add(Box.createHorizontalStrut(5));
        panel1.add(this.jLblHourly);
        panel1.add(Box.createHorizontalStrut(20));
        panel1.add(this.jRBDaily);
        panel1.add(Box.createHorizontalStrut(20));
        panel1.add(this.jRBWeekly);
        JPanel wrapPanel1 = new JPanel(new BorderLayout());
        wrapPanel1.add((Component)panel1, "West");
        wrapPanel1.add((Component)this.getTimePanel(), "South");
        JPanel wrapPanel2 = new JPanel(new BorderLayout());
        wrapPanel2.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 0));
        wrapPanel2.add((Component)new AvTemplatePane(MSGRES.getString(LU, "SchedulePanel.label.frequence"), MSGRES.getString(LU, "SchedulePanel.label.frequenceDesc"), false), "North");
        wrapPanel2.add((Component)wrapPanel1, "Center");
        return wrapPanel2;
    }

    private JPanel getTimePanel() {
        this.timeSpinner.setEnabled(true);
        Dimension size = this.jCmbDay.getPreferredSize();
        this.jCmbDay.setPreferredSize(new Dimension(size.width + 10, size.height));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 25, 10, 0));
        panel.add((Component)this.jLblAt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.timeSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.jLblEvery, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 0, 0), 0, 0));
        panel.add(this.jCmbDay, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private JPanel getRetryIntervalPanel() {
        this.jChkRetry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulePanel.this.retryStateChanged();
            }
        });
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            Dimension size = this.jSpnRetry.getPreferredSize();
            this.jSpnRetry.setPreferredSize(new Dimension(37, size.height));
        });
        JPanel panel = new JPanel(new FlowLayout(3, 15, 9));
        panel.add(this.jChkRetry);
        panel.add(this.jSpnRetry);
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "SchedulePanel.label.retryInteval"), MSGRES.getString(LU, "SchedulePanel.label.retryIntevalDesc"), false), "North");
        wrapPanel.add((Component)panel, "Center");
        return wrapPanel;
    }

    private JPanel getRandomizationPanel() {
        this.jChkRandomize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulePanel.this.randomStateChanged();
            }
        });
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            Dimension size = this.jSpnRandom.getPreferredSize();
            this.jSpnRandom.setPreferredSize(new Dimension(37, size.height));
        });
        JPanel panel = new JPanel(new FlowLayout(3, 15, 9));
        panel.add(this.jChkRandomize);
        panel.add(this.jSpnRandom);
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "SchedulePanel.label.randomization"), MSGRES.getString(LU, "SchedulePanel.label.randomizationDesc"), false), "North");
        wrapPanel.add((Component)panel, "South");
        return wrapPanel;
    }

    private JPanel getIdleDetectionPanel() {
        JPanel panel = new JPanel(new FlowLayout(3, 15, 9));
        panel.add(this.jChkIdleDetection);
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "SchedulePanel.label.idleDetection"), null, false), "North");
        wrapPanel.add((Component)panel, "Center");
        return wrapPanel;
    }

    private JPanel getAdditionalOptionPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "SchedulePanel.label.additionalOptions"), MSGRES.getString(LU, "SchedulePanel.label.additionalOptionsDesc"), false), new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 40, 0, 0), 0, 0));
        ButtonGroup groupAvDefOlderThan = new ButtonGroup();
        groupAvDefOlderThan.add(this.jRBDefinationOlderThanHours);
        groupAvDefOlderThan.add(this.jRBDefinationOlderThanDays);
        ButtonGroup groupDisconnectedFor = new ButtonGroup();
        groupDisconnectedFor.add(this.jRBDisconnectedForMinutes);
        groupDisconnectedFor.add(this.jRBDisconnectedForHours);
        panel.add((Component)this.jChkAvDefOlderThan, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 55, 0, 0), 0, 0));
        panel.add((Component)this.jSpnDefOlderThan, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 90, 0, 0), 0, 0));
        panel.add((Component)this.jRBDefinationOlderThanHours, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 20, 0, 0), 0, 0));
        panel.add((Component)this.jRBDefinationOlderThanDays, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)this.jChkDisconnectedFor, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 55, 0, 0), 0, 0));
        panel.add((Component)this.jSpnDisconnectedFor, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 90, 0, 0), 0, 0));
        panel.add((Component)this.jRBDisconnectedForMinutes, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 20, 0, 0), 0, 0));
        panel.add((Component)this.jRBDisconnectedForHours, new GridBagConstraints(3, 4, 1, 1, 0.0, 1.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.jChkAvDefOlderThan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulePanel.this.avDefinitationStateChanged();
            }
        });
        this.jChkDisconnectedFor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulePanel.this.clientDisconnectedForStateChange();
            }
        });
        this.jRBDefinationOlderThanHours.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SchedulePanel.this.frequencyChanged(true);
            }
        });
        this.jRBDefinationOlderThanDays.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SchedulePanel.this.frequencyChanged(true);
            }
        });
        this.jRBDisconnectedForHours.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SchedulePanel.this.frequencyChanged(true);
            }
        });
        this.jRBDisconnectedForMinutes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SchedulePanel.this.frequencyChanged(true);
            }
        });
        this.jSpnDefOlderThan.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SchedulePanel.this.aVDefOlderThanValueChanged();
            }
        });
        this.jSpnDisconnectedFor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SchedulePanel.this.clientDisconnectedForValueChanged();
            }
        });
        return panel;
    }

    private boolean isScheduleEnabled() {
        boolean enabled = true;
        if (1 == this.platformType) {
            enabled = this.jChkEnabled.isEnabled() ? this.jChkEnabled.isSelected() : false;
        }
        return enabled;
    }

    private void frequencyChanged(boolean isUpdateModel) {
        if (isUpdateModel) {
            this.updateRetryModel();
            this.updateRandomizeModel();
            this.updateAvDefModel();
            this.updateDisconnectedForModel();
            this.updateIdleDetection();
        }
        boolean scheduleEnabled = this.isScheduleEnabled();
        this.jRBContinuous.setEnabled(scheduleEnabled);
        this.jRBHourly.setEnabled(scheduleEnabled);
        this.jRBDaily.setEnabled(scheduleEnabled);
        this.jRBWeekly.setEnabled(scheduleEnabled);
        this.jLblHourly.setEnabled(scheduleEnabled);
        this.jSpnHour.setEnabled(this.jRBHourly.isEnabled() && this.jRBHourly.isSelected());
        boolean weekly = this.jRBWeekly.isEnabled() && this.jRBWeekly.isSelected();
        this.jCmbDay.setEnabled(weekly);
        this.jLblEvery.setEnabled(weekly);
        boolean dailyOrWeekly = this.jRBDaily.isEnabled() && this.jRBDaily.isSelected() || weekly;
        this.timeSpinner.setEnabled(dailyOrWeekly);
        this.jLblAt.setEnabled(dailyOrWeekly);
        boolean enableRetry = this.jRBContinuous.isEnabled() && !this.jRBContinuous.isSelected();
        boolean enableRandomize = this.jRBContinuous.isEnabled() && !this.jRBContinuous.isSelected() && this.jRBHourly.isEnabled() && !this.jRBHourly.isSelected();
        this.jChkRetry.setEnabled(enableRetry);
        this.jChkRandomize.setEnabled(enableRandomize);
        if (this.jRBContinuous.isSelected() || this.jRBHourly.isSelected()) {
            this.jChkRandomize.setSelected(false);
        }
        this.retryStateChanged();
        this.randomStateChanged();
        this.avDefinitationStateChanged();
        this.clientDisconnectedForStateChange();
    }

    private void frequencyHourChanged() {
        this.updateRetryModel();
    }

    private void aVDefOlderThanValueChanged() {
        this.updateAvDefModel();
    }

    private void clientDisconnectedForValueChanged() {
        this.updateDisconnectedForModel();
    }

    private void retryStateChanged() {
        this.jSpnRetry.setEnabled(this.jChkRetry.isEnabled() && this.jChkRetry.isSelected());
        UIUtilities.enableOnlyValidEdits(this.jSpnRetry);
    }

    private void randomStateChanged() {
        this.jSpnRandom.setEnabled(this.jChkRandomize.isEnabled());
        UIUtilities.enableOnlyValidEdits(this.jSpnRandom);
    }

    private void avDefinitationStateChanged() {
        boolean isEnabled = this.isScheduleEnabled();
        this.jChkAvDefOlderThan.setEnabled(isEnabled);
        boolean isSelected = this.jChkAvDefOlderThan.isSelected() && isEnabled;
        this.jSpnDefOlderThan.setEnabled(isSelected);
        this.jRBDefinationOlderThanDays.setEnabled(isSelected);
        this.jRBDefinationOlderThanHours.setEnabled(isSelected);
        UIUtilities.enableOnlyValidEdits(this.jSpnDefOlderThan);
    }

    private void clientDisconnectedForStateChange() {
        boolean isEnabled = this.isScheduleEnabled();
        this.jChkDisconnectedFor.setEnabled(isEnabled);
        boolean isSelected = this.jChkDisconnectedFor.isSelected() && isEnabled;
        this.jSpnDisconnectedFor.setEnabled(isSelected);
        this.jRBDisconnectedForHours.setEnabled(isSelected);
        this.jRBDisconnectedForMinutes.setEnabled(isSelected);
        UIUtilities.enableOnlyValidEdits(this.jSpnDisconnectedFor);
    }

    private void updateRetryModel() {
        boolean scheduleEnabled = this.isScheduleEnabled();
        this.jChkRetry.setEnabled(scheduleEnabled);
        this.jSpnRetry.setEnabled(scheduleEnabled);
        Integer freq = this.getFrequency();
        this.jChkRetry.setText(this.getRetryLabel(freq));
        this.jSpnRetry.setModel(this.getRetryModel(freq));
        this.jSpnRetry.setToolTipText(this.getToolTip(freq, this.scheduleObj.getRetryMinimumValue(), this.scheduleObj.getRetryMaximumValue(freq, (Integer)this.jSpnHour.getValue())));
    }

    private void updateIdleDetection() {
        boolean scheduleEnabled = this.isScheduleEnabled();
        this.jChkIdleDetection.setEnabled(scheduleEnabled);
    }

    private void updateAvDefModel() {
        Integer freq = this.getAvDefFrequency();
        this.jSpnDefOlderThan.setModel(this.getAvDefModel(freq));
        this.jSpnDefOlderThan.setToolTipText(this.getAvDefinitionToolTip(freq, this.scheduleObj.getAdditionalOptionMinimumValue(), this.scheduleObj.getAvDefMaximumValue(freq, (Integer)this.jSpnDefOlderThan.getValue())));
    }

    private void updateDisconnectedForModel() {
        Integer freq = this.getDisconnectedFrequency();
        this.jSpnDisconnectedFor.setModel(this.getDisconnectedForModel(freq));
        this.jSpnDisconnectedFor.setToolTipText(this.getDisconnectedForToolTip(freq, this.scheduleObj.getAdditionalOptionMinimumValue(), this.scheduleObj.getDisConnectedForMaximumValue(freq, (Integer)this.jSpnDisconnectedFor.getValue())));
    }

    private void updateRandomizeModel() {
        boolean scheduleEnabled = this.isScheduleEnabled();
        this.jChkRandomize.setEnabled(scheduleEnabled);
        this.jSpnRandom.setEnabled(scheduleEnabled);
        Integer freq = this.getFrequency();
        this.jChkRandomize.setText(this.getRandomizeLabel(freq));
        this.jSpnRandom.setModel(this.getRandomizeModel(freq));
        this.jSpnRandom.setToolTipText(this.getToolTip(freq, this.scheduleObj.getRandomizeMinimumTime(), this.scheduleObj.getRandomizeMaximumTime(freq, (Integer)this.jSpnHour.getValue())));
    }

    private void updatePanel() {
        if (this.scheduleObj == null) {
            LuDownloadSchedule schedule = new LuDownloadSchedule();
            this.scheduleObj = new LuDownloadScheduleObject(schedule);
        }
        Integer frequency = this.scheduleObj.getFrequency();
        Integer hour = this.scheduleObj.getFrequencyInterval();
        if (frequency.equals(LuDownloadSchedule.CONTINUOUS)) {
            this.jRBContinuous.setSelected(true);
        } else if (frequency.equals(LuDownloadSchedule.HOURLY)) {
            this.jRBHourly.setSelected(true);
        } else if (frequency.equals(LuDownloadSchedule.DAILY)) {
            this.jRBDaily.setSelected(true);
        } else if (frequency.equals(LuDownloadSchedule.WEEKLY)) {
            this.jRBWeekly.setSelected(true);
        }
        this.jSpnHour.setValue(hour);
        int hr = 0;
        int minute = 0;
        int second = 0;
        int ampm = 0;
        Long stTime = this.scheduleObj.getStartTime();
        if (stTime != null) {
            int startTime = stTime.intValue();
            int hourOfDay = startTime / 3600;
            if (this.hasAmpm) {
                ampm = Utility.getAmpmFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
            }
            if (this.hasHour) {
                hr = Utility.convertHourFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
            }
            if (this.hasMinute) {
                minute = (startTime - hourOfDay * 3600) / 60;
            }
            if (this.hasSecond) {
                second = startTime - hourOfDay * 3600 - minute * 60;
            }
        }
        this.timeSpinner.setHour(hr);
        this.timeSpinner.setMinute(minute);
        this.timeSpinner.setSecond(second);
        if (this.hasAmpm) {
            this.timeSpinner.setAmpm(ampm);
        }
        this.jCmbDay.setSelectedIndex((this.scheduleObj.getDayOfWeek() - Utility.getCalendarInstance().getFirstDayOfWeek() + 1 + 7) % 7);
        this.jChkRetry.setSelected(this.scheduleObj.isAllowRetry());
        this.jSpnRetry.setValue(this.scheduleObj.getRetryWindow());
        this.jChkRandomize.setSelected(this.scheduleObj.isRandomness());
        this.jSpnRandom.setValue(this.scheduleObj.getRandomizeTime());
        this.jChkIdleDetection.setSelected(this.scheduleObj.isIdleDetection());
        this.jChkAvDefOlderThan.setSelected(this.scheduleObj.isAvDefOlderThan());
        this.jChkDisconnectedFor.setSelected(this.scheduleObj.isLUChannelFailoverMode());
        this.jSpnDefOlderThan.setValue(this.scheduleObj.getAvDefinitionAge());
        this.jSpnDisconnectedFor.setValue(this.scheduleObj.getDisconnectDuration());
        if (LUAvDefinitionCheck.DAYS.equals(this.scheduleObj.getAvDefinitionFrequency())) {
            this.jRBDefinationOlderThanDays.setSelected(true);
        } else {
            this.jRBDefinationOlderThanHours.setSelected(true);
        }
        if (LUChannelFailoverMode.HOURS.equals(this.scheduleObj.getLUChannelFailoverModeFrequency())) {
            this.jRBDisconnectedForHours.setSelected(true);
        } else {
            this.jRBDisconnectedForMinutes.setSelected(true);
        }
        this.frequencyChanged(true);
        if (this.jRBHourly.isSelected() && hour == 1) {
            this.updateRetryWindowState(false);
        }
    }

    private Integer getFrequency() {
        if (this.jRBContinuous.isSelected()) {
            return LuDownloadSchedule.CONTINUOUS;
        }
        if (this.jRBHourly.isSelected()) {
            return LuDownloadSchedule.HOURLY;
        }
        if (this.jRBDaily.isSelected()) {
            return LuDownloadSchedule.DAILY;
        }
        return LuDownloadSchedule.WEEKLY;
    }

    private String getRetryLabel(Integer frequency) {
        if (frequency.equals(LuDownloadSchedule.WEEKLY)) {
            return MSGRES.getString(LU, "SchedulePanel.checkbox.retry.day");
        }
        if (frequency.equals(LuDownloadSchedule.CONTINUOUS) || frequency.equals(LuDownloadSchedule.HOURLY) && (Integer)this.jSpnHour.getValue() == 1) {
            return MSGRES.getString(LU, "SchedulePanel.checkbox.retry.minute");
        }
        return MSGRES.getString(LU, "SchedulePanel.checkbox.retry.hour");
    }

    private SpinnerNumberModel getAvDefModel(Integer frequency) {
        int maximum;
        int curDefAge = (Integer)this.jSpnDefOlderThan.getValue();
        curDefAge = curDefAge > (maximum = this.scheduleObj.getAvDefMaximumValue(frequency, (Integer)this.jSpnDefOlderThan.getValue())) ? maximum : curDefAge;
        return new SpinnerNumberModel(curDefAge, this.scheduleObj.getAdditionalOptionMinimumValue(), maximum, 1);
    }

    private SpinnerNumberModel getDisconnectedForModel(Integer frequency) {
        int maximum;
        int curDisconnectedFor = (Integer)this.jSpnDisconnectedFor.getValue();
        curDisconnectedFor = curDisconnectedFor > (maximum = this.scheduleObj.getDisConnectedForMaximumValue(frequency, (Integer)this.jSpnDisconnectedFor.getValue())) ? maximum : curDisconnectedFor;
        return new SpinnerNumberModel(curDisconnectedFor, this.scheduleObj.getAdditionalOptionMinimumValue(), maximum, 1);
    }

    private String getRandomizeLabel(Integer frequency) {
        if (frequency.equals(LuDownloadSchedule.WEEKLY)) {
            return MSGRES.getString(LU, "SchedulePanel.checkbox.randomize.day");
        }
        if (frequency.equals(LuDownloadSchedule.CONTINUOUS) || frequency.equals(LuDownloadSchedule.HOURLY) && (Integer)this.jSpnHour.getValue() == 1) {
            return MSGRES.getString(LU, "SchedulePanel.checkbox.randomize.minute");
        }
        return MSGRES.getString(LU, "SchedulePanel.checkbox.randomize.hour");
    }

    private SpinnerNumberModel getRandomizeModel(Integer frequency) {
        int maximum;
        int curRandom = (Integer)this.jSpnRandom.getValue();
        curRandom = curRandom > (maximum = this.scheduleObj.getRandomizeMaximumTime(frequency, (Integer)this.jSpnHour.getValue())) ? maximum : curRandom;
        int randomMinimumTime = this.scheduleObj.getRandomizeMinimumTime();
        curRandom = curRandom < randomMinimumTime ? randomMinimumTime : curRandom;
        return new SpinnerNumberModel(curRandom, randomMinimumTime, maximum, 1);
    }

    private String getToolTip(Integer frequency, int minValue, int maxValue) {
        Object[] args = new String[]{String.valueOf(minValue), String.valueOf(maxValue)};
        String tip = MSGRES.getString(LU, "SchedulePanel.tooltip.hour");
        if (frequency.equals(LuDownloadSchedule.WEEKLY)) {
            tip = MSGRES.getString(LU, "SchedulePanel.tooltip.day");
        } else if (frequency.equals(LuDownloadSchedule.CONTINUOUS) || frequency.equals(LuDownloadSchedule.HOURLY) && (Integer)this.jSpnHour.getValue() == 1) {
            tip = MSGRES.getString(LU, "SchedulePanel.tooltip.minute");
        }
        return MessageFormat.format(tip, args);
    }

    public void setObject(LuDownloadScheduleObject scheduleObj) {
        this.scheduleObj = scheduleObj;
        if (1 == this.platformType) {
            this.userSetSelected = scheduleObj.getEnabled();
            this.jChkEnabled.setSelected(this.userSetSelected);
        }
        this.updatePanel();
    }

    public void setReadOnly() {
        if (1 == this.platformType) {
            this.jChkEnabled.setEnabled(false);
        }
        this.jRBContinuous.setEnabled(false);
        this.jRBHourly.setEnabled(false);
        this.jRBDaily.setEnabled(false);
        this.jRBWeekly.setEnabled(false);
        this.jChkRetry.setEnabled(false);
        this.jChkRandomize.setEnabled(false);
        this.jChkIdleDetection.setEnabled(false);
        this.jChkDisconnectedFor.setEnabled(false);
        this.jChkAvDefOlderThan.setEnabled(false);
        this.frequencyChanged(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (3 == this.platformType) {
            return "linux_sesm_policies_dialog_lu_schedule";
        }
        return "sesm_policies_dialog_lu_schedule";
    }

    public SpinnerNumberModel getRetryModel(Integer frequency) {
        int maximum;
        int curRetry = (Integer)this.jSpnRetry.getValue();
        curRetry = curRetry > (maximum = this.scheduleObj.getRetryMaximumValue(frequency, (Integer)this.jSpnHour.getValue())) ? maximum : curRetry;
        int currentMinimum = this.scheduleObj.getRetryMinimumValue();
        curRetry = curRetry < currentMinimum ? currentMinimum : curRetry;
        return new SpinnerNumberModel(curRetry, currentMinimum, maximum, 1);
    }

    private String getDisconnectedForToolTip(Integer frequency, int minValue, int maxValue) {
        Object[] args = new String[]{String.valueOf(minValue), String.valueOf(maxValue)};
        String tip = MSGRES.getString(LU, "SchedulePanel.tooltip.hour");
        if (frequency.equals(LUChannelFailoverMode.MINUTES)) {
            tip = MSGRES.getString(LU, "SchedulePanel.tooltip.minute");
        }
        return MessageFormat.format(tip, args);
    }

    private String getAvDefinitionToolTip(Integer frequency, int minValue, int maxValue) {
        Object[] args = new String[]{String.valueOf(minValue), String.valueOf(maxValue)};
        String tip = MSGRES.getString(LU, "SchedulePanel.tooltip.hour");
        if (frequency.equals(LUAvDefinitionCheck.DAYS)) {
            tip = MSGRES.getString(LU, "SchedulePanel.tooltip.day");
        }
        return MessageFormat.format(tip, args);
    }

    public void setEnableSchedule(boolean enable) {
        if (1 == this.platformType) {
            this.jChkEnabled.setEnabled(enable);
        }
        this.updatePanel();
    }

    @Override
    public void enableAndUseLiveUpdateServerChanged(boolean enableLiveUpdateServer, boolean useLiveUpdateServer) {
        this.setEnableSchedule(enableLiveUpdateServer && useLiveUpdateServer);
    }

    private Integer getAvDefFrequency() {
        if (this.jRBDefinationOlderThanHours.isSelected()) {
            return LUAvDefinitionCheck.HOURS;
        }
        return LUAvDefinitionCheck.DAYS;
    }

    private Integer getDisconnectedFrequency() {
        if (this.jRBDisconnectedForHours.isSelected()) {
            return LUChannelFailoverMode.HOURS;
        }
        return LUChannelFailoverMode.MINUTES;
    }
}

