/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuHttpProxy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.UseLiveUpdateServerListener;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuHttpProxyObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuHttpsProxyObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ProxyServerPanel
extends JPanel
implements ContentSensitiveHelpPage,
UseLiveUpdateServerListener {
    private static final long serialVersionUID = -2238872027758871511L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    protected JRadioButton jRBHttpNo = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.radiobutton.httpNoProxy"));
    protected JRadioButton jRBHttpSystem = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.radiobutton.httpSystemProxy"));
    protected JRadioButton jRBHttpCustom = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.radiobutton.httpCustomProxy"));
    private ButtonGroup httpRadioButtonGroup = new ButtonGroup();
    protected JTextField jTFHttpHost = new JTextField();
    protected JTextField jTFHttpPort = new JTextField(6);
    protected JCheckBox jCBHttpAuth = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.checkbox.httpAuth"));
    protected JTextField jTFHttpUserName = new JTextField();
    protected JPasswordField jPFHttpPassword = new SEPMPasswordField();
    protected JCheckBox jcbHttpNtLanAuth = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.checkbox.httpNtlmAuth"));
    protected JRadioButton jRBHttpsNo = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.radiobutton.httpsNoProxy"));
    protected JRadioButton jRBHttpsSystem = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.radiobutton.httpsSystemProxy"));
    protected JRadioButton jRBHttpsCustom = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.radiobutton.httpsCustomProxy"));
    private ButtonGroup httpsRadioButtonGroup = new ButtonGroup();
    protected JTextField jTFHttpsHost = new JTextField();
    protected JTextField jTFHttpsPort = new JTextField(6);
    protected JCheckBox jCBHttpsAuth = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.checkbox.httpsAuth"));
    protected JTextField jTFHttpsUserName = new JTextField();
    protected JPasswordField jPFHttpsPassword = new SEPMPasswordField();
    protected JCheckBox jcbHttpsNtLanAuth = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.checkbox.httpsNtlmAuth"));
    private JPanel jPHttpCustom;
    private JPanel jPHttpAuth;
    private JPanel jPHttpProxyAddressAndPortNumber;
    private JPanel jPHttpsCustom;
    private JPanel jPHttpsAuth;
    private JPanel jPHttpsProxyAddressAndPortNumber;
    private LuHttpProxyObject httpProxyObj;
    private LuHttpsProxyObject httpsProxyObj;
    private ButtonModel httpRadioButtonSelected;
    private ButtonModel httpsRadioButtonSelected;
    private JCheckBox lockHttpChk;
    private JCheckBox lockHttpsChk;

    public ProxyServerPanel() {
        this.initialize();
    }

    public void setObject(ExternalCommunicationObject extCommObj) {
        this.httpProxyObj = extCommObj.getHttpProxyObject();
        if (this.httpRadioButtonSelected == null) {
            this.httpRadioButtonSelected = this.httpProxyObj != null && this.httpProxyObj.isCustomProxy() ? this.jRBHttpCustom.getModel() : (this.httpProxyObj != null && this.httpProxyObj.isSystemProxy() ? this.jRBHttpSystem.getModel() : this.jRBHttpNo.getModel());
        }
        this.httpsProxyObj = extCommObj.getHttpsProxyObject();
        if (this.httpsRadioButtonSelected == null) {
            this.httpsRadioButtonSelected = this.httpsProxyObj != null && this.httpsProxyObj.isCustomProxy() ? this.jRBHttpsCustom.getModel() : (this.httpsProxyObj != null && this.httpsProxyObj.isSystemProxy() ? this.jRBHttpsSystem.getModel() : this.jRBHttpsNo.getModel());
        }
        this.updatePanel();
    }

    public void save() {
        this.httpProxyObj.setMode(this.getHttpProxyMode());
        this.httpProxyObj.setHost(this.jTFHttpHost.getText().trim());
        this.httpProxyObj.setPort(this.jTFHttpPort.getText().trim());
        this.httpProxyObj.setAuthentication(this.jCBHttpAuth.isSelected());
        this.httpProxyObj.setUserName(this.jTFHttpUserName.getText().trim());
        this.httpProxyObj.setPassword(new String(this.jPFHttpPassword.getPassword()));
        this.httpProxyObj.setOptLockHttpProxyMode(this.lockHttpChk.isSelected());
        this.httpProxyObj.setAuthenticationType(this.jcbHttpNtLanAuth.isSelected() ? LuHttpProxy.NTLM : LuHttpProxy.BASIC);
        this.httpsProxyObj.setMode(this.getHttpsProxyMode());
        this.httpsProxyObj.setHost(this.jTFHttpsHost.getText().trim());
        this.httpsProxyObj.setPort(this.jTFHttpsPort.getText().trim());
        this.httpsProxyObj.setAuthentication(this.jCBHttpsAuth.isSelected());
        this.httpsProxyObj.setUserName(this.jTFHttpsUserName.getText().trim());
        this.httpsProxyObj.setPassword(new String(this.jPFHttpsPassword.getPassword()));
        this.httpsProxyObj.setOptLockHttpsProxyMode(this.lockHttpsChk.isSelected());
        this.httpsProxyObj.setAuthenticationType(this.jcbHttpsNtLanAuth.isSelected() ? LuHttpProxy.NTLM : LuHttpProxy.BASIC);
    }

    public boolean isValidate() {
        Pattern pattern;
        Matcher matcher;
        if (this.jRBHttpCustom.isSelected()) {
            if (this.jTFHttpHost.getText().trim().length() == 0 || !Utility.isValidIPAddressOrHostName((String)this.jTFHttpHost.getText().trim(), (boolean)false)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.msg.pleaseEnterValidServerIPorName"), MSGRES.getString(LU, "ProxyServerPanel.error"), 0);
                return false;
            }
            if (this.jTFHttpPort.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "ProxyServerPanel.httpPortError"), MSGRES.getString(LU, "ProxyServerPanel.error"), 0);
                return false;
            }
        }
        if ((this.jRBHttpCustom.isSelected() || this.jRBHttpSystem.isSelected()) && this.jCBHttpAuth.isSelected()) {
            if (this.jTFHttpUserName.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "ProxyServerPanel.httpUsernameError"), MSGRES.getString(LU, "ProxyServerPanel.error"), 0);
                return false;
            }
            if (this.jTFHttpUserName.getText().contains(":")) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.httpOrHttpsUsernameErrorContainsColon"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (this.jcbHttpNtLanAuth.isSelected() && !(matcher = (pattern = Pattern.compile("^([A-Za-z0-9\\-_]{1}[A-Za-z0-9.\\-_]{0,14})([\\\\]{1})([^\\/\\\\\\[:;|=,+*?<>\\]\"]{1,64})$")).matcher(this.jTFHttpUserName.getText().trim())).find()) {
                this.jTFHttpUserName.requestFocusInWindow();
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.httpDomainnameError"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (this.jPFHttpPassword.getPassword().length == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "ProxyServerPanel.httpPasswordError"), MSGRES.getString(LU, "ProxyServerPanel.error"), 0);
                return false;
            }
        }
        if (this.jRBHttpsCustom.isSelected()) {
            if (this.jTFHttpsHost.getText().trim().length() == 0 || !Utility.isValidIPAddressOrHostName((String)this.jTFHttpsHost.getText().trim(), (boolean)false)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.msg.pleaseEnterValidServerIPorName"), MSGRES.getString(LU, "ProxyServerPanel.error"), 0);
                return false;
            }
            if (this.jTFHttpsPort.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "ProxyServerPanel.httpsPortError"), MSGRES.getString(LU, "ProxyServerPanel.error"), 0);
                return false;
            }
        }
        if ((this.jRBHttpsCustom.isSelected() || this.jRBHttpsSystem.isSelected()) && this.jCBHttpsAuth.isSelected()) {
            if (this.jTFHttpsUserName.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "ProxyServerPanel.httpsUsernameError"), MSGRES.getString(LU, "ProxyServerPanel.error"), 0);
                return false;
            }
            if (this.jTFHttpsUserName.getText().contains(":")) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.httpOrHttpsUsernameErrorContainsColon"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (this.jcbHttpsNtLanAuth.isSelected() && !(matcher = (pattern = Pattern.compile("^([A-Za-z0-9\\-_]{1}[A-Za-z0-9.\\-_]{0,14})([\\\\]{1})([^\\/\\\\\\[:;|=,+*?<>\\]\"]{1,64})$")).matcher(this.jTFHttpsUserName.getText().trim())).find()) {
                this.jTFHttpsUserName.requestFocusInWindow();
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.httpDomainnameError"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (this.jPFHttpsPassword.getPassword().length == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "ProxyServerPanel.httpsPasswordError"), MSGRES.getString(LU, "ProxyServerPanel.error"), 0);
                return false;
            }
        }
        return true;
    }

    public void setReadOnly() {
        this.jRBHttpNo.setEnabled(false);
        this.jRBHttpSystem.setEnabled(false);
        this.jRBHttpCustom.setEnabled(false);
        this.jCBHttpAuth.setEnabled(false);
        this.httpCustomStateChanged();
        this.jRBHttpsNo.setEnabled(false);
        this.jRBHttpsSystem.setEnabled(false);
        this.jRBHttpsCustom.setEnabled(false);
        this.jCBHttpsAuth.setEnabled(false);
        this.httpsCustomStateChanged();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_lu_server_settings_proxy";
    }

    private void initialize() {
        this.setLayout(new VerticalFlowLayout(0, 15));
        this.add(this.getHttpProxyPanel());
        this.add(this.getHttpsProxyPanel());
    }

    private JPanel getHttpProxyPanel() {
        this.httpRadioButtonGroup.add(this.jRBHttpNo);
        this.httpRadioButtonGroup.add(this.jRBHttpSystem);
        this.httpRadioButtonGroup.add(this.jRBHttpCustom);
        this.lockHttpChk = new LockCheckBox(Boolean.FALSE);
        this.lockHttpChk.setSelectedIcon(AvConstants.lockIcon);
        RemeberSelection remeber = new RemeberSelection();
        this.jRBHttpNo.addActionListener(remeber);
        this.jRBHttpSystem.addActionListener(remeber);
        this.jRBHttpCustom.addActionListener(remeber);
        this.jRBHttpNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                ProxyServerPanel.this.jCBHttpAuth.setEnabled(false);
                ProxyServerPanel.this.httpAuthChanged();
            }
        });
        this.jRBHttpSystem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                ProxyServerPanel.this.jCBHttpAuth.setEnabled(true);
                ProxyServerPanel.this.httpAuthChanged();
            }
        });
        this.jRBHttpCustom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                ProxyServerPanel.this.jCBHttpAuth.setEnabled(true);
                ProxyServerPanel.this.httpCustomStateChanged();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.lockHttpChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.jRBHttpNo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        panel.add((Component)this.jRBHttpSystem, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jRBHttpCustom, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.getHttpCustomPanel(), new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        JPanel authPanel = new JPanel(new GridBagLayout());
        authPanel.add((Component)this.jCBHttpAuth, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        authPanel.add((Component)this.getHttpAuthPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 0, 0), 0, 0));
        authPanel.add((Component)this.jcbHttpNtLanAuth, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 60, 0, 0), 0, 0));
        panel.add((Component)authPanel, new GridBagConstraints(1, 4, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jCBHttpAuth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ProxyServerPanel.this.httpAuthChanged();
            }
        });
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "ProxyServerPanel.label.http"), MSGRES.getString(LU, "ProxyServerPanel.label.httpDesc"), false), "North");
        wrapPanel.add((Component)panel, "Center");
        return wrapPanel;
    }

    private JPanel getHttpsProxyPanel() {
        this.httpsRadioButtonGroup.add(this.jRBHttpsNo);
        this.httpsRadioButtonGroup.add(this.jRBHttpsSystem);
        this.httpsRadioButtonGroup.add(this.jRBHttpsCustom);
        this.lockHttpsChk = new LockCheckBox(Boolean.FALSE);
        this.lockHttpsChk.setSelectedIcon(AvConstants.lockIcon);
        RemeberSelection remeber = new RemeberSelection();
        this.jRBHttpsNo.addActionListener(remeber);
        this.jRBHttpsSystem.addActionListener(remeber);
        this.jRBHttpsCustom.addActionListener(remeber);
        this.jRBHttpsNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                ProxyServerPanel.this.jCBHttpsAuth.setEnabled(false);
                ProxyServerPanel.this.httpsAuthChanged();
            }
        });
        this.jRBHttpsSystem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                ProxyServerPanel.this.jCBHttpsAuth.setEnabled(true);
                ProxyServerPanel.this.httpsAuthChanged();
            }
        });
        this.jRBHttpsCustom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                ProxyServerPanel.this.jCBHttpsAuth.setEnabled(true);
                ProxyServerPanel.this.httpsCustomStateChanged();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.lockHttpsChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.jRBHttpsNo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        panel.add((Component)this.jRBHttpsSystem, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jRBHttpsCustom, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.getHttpsCustomPanel(), new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        JPanel authPanel = new JPanel(new GridBagLayout());
        authPanel.add((Component)this.jCBHttpsAuth, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        authPanel.add((Component)this.getHttpsAuthPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 0, 0), 0, 0));
        authPanel.add((Component)this.jcbHttpsNtLanAuth, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 60, 0, 0), 0, 0));
        panel.add((Component)authPanel, new GridBagConstraints(1, 4, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jCBHttpsAuth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ProxyServerPanel.this.httpsAuthChanged();
            }
        });
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "ProxyServerPanel.label.https"), MSGRES.getString(LU, "ProxyServerPanel.label.httpsDesc"), false), "North");
        wrapPanel.add((Component)panel, "Center");
        return wrapPanel;
    }

    private JPanel getHttpCustomPanel() {
        if (this.jPHttpCustom == null) {
            this.jTFHttpPort.setDocument(new NumberPlainDocument(65535L, true));
            this.jPHttpCustom = new JPanel(new GridBagLayout());
            this.jPHttpCustom.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            this.jPHttpCustom.add((Component)this.getHttpProxyDetailsPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        }
        return this.jPHttpCustom;
    }

    private JPanel getHttpsCustomPanel() {
        if (this.jPHttpsCustom == null) {
            this.jTFHttpsPort.setDocument(new NumberPlainDocument(65535L, true));
            this.jPHttpsCustom = new JPanel(new GridBagLayout());
            this.jPHttpsCustom.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            this.jPHttpsCustom.add((Component)this.getHttpsProxyDetailsPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        }
        return this.jPHttpsCustom;
    }

    private JPanel getHttpProxyDetailsPanel() {
        if (this.jPHttpProxyAddressAndPortNumber == null) {
            this.jTFHttpHost.setPreferredSize(new Dimension(180, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jTFHttpHost.setHorizontalAlignment(2);
            this.jPHttpProxyAddressAndPortNumber = new JPanel(new GridBagLayout());
            this.jPHttpProxyAddressAndPortNumber.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.httpHost")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpProxyAddressAndPortNumber.add((Component)this.jTFHttpHost, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpProxyAddressAndPortNumber.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.httpPort")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpProxyAddressAndPortNumber.add((Component)this.jTFHttpPort, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        }
        return this.jPHttpProxyAddressAndPortNumber;
    }

    private JPanel getHttpsProxyDetailsPanel() {
        if (this.jPHttpsProxyAddressAndPortNumber == null) {
            this.jTFHttpsHost.setPreferredSize(new Dimension(180, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jTFHttpsHost.setHorizontalAlignment(2);
            this.jPHttpsProxyAddressAndPortNumber = new JPanel(new GridBagLayout());
            this.jPHttpsProxyAddressAndPortNumber.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.httpsHost")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpsProxyAddressAndPortNumber.add((Component)this.jTFHttpsHost, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpsProxyAddressAndPortNumber.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.httpsPort")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpsProxyAddressAndPortNumber.add((Component)this.jTFHttpsPort, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        }
        return this.jPHttpsProxyAddressAndPortNumber;
    }

    private JPanel getHttpAuthPanel() {
        if (this.jPHttpAuth == null) {
            this.jTFHttpUserName.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jPFHttpPassword.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jPHttpAuth = new JPanel(new GridBagLayout());
            this.jPHttpAuth.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.httpUsername")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPHttpAuth.add((Component)this.jTFHttpUserName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.jPHttpAuth.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.httpPassword")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPHttpAuth.add((Component)this.jPFHttpPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        }
        return this.jPHttpAuth;
    }

    private JPanel getHttpsAuthPanel() {
        if (this.jPHttpsAuth == null) {
            this.jTFHttpsUserName.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jPFHttpsPassword.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jPHttpsAuth = new JPanel(new GridBagLayout());
            this.jPHttpsAuth.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.httpsUsername")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPHttpsAuth.add((Component)this.jTFHttpsUserName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.jPHttpsAuth.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.httpsPassword")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPHttpsAuth.add((Component)this.jPFHttpsPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        }
        return this.jPHttpsAuth;
    }

    private void httpCustomStateChanged() {
        UIUtilities.setContainerStatus(this.getHttpCustomPanel(), this.jRBHttpCustom.isEnabled() && this.jRBHttpCustom.isSelected());
        this.httpAuthChanged();
    }

    private void httpsCustomStateChanged() {
        UIUtilities.setContainerStatus(this.getHttpsCustomPanel(), this.jRBHttpsCustom.isEnabled() && this.jRBHttpsCustom.isSelected());
        this.httpsAuthChanged();
    }

    private void httpAuthChanged() {
        UIUtilities.setContainerStatus(this.getHttpAuthPanel(), this.jCBHttpAuth.isEnabled() && this.jCBHttpAuth.isSelected());
        UIUtilities.setContainerStatus(this.jcbHttpNtLanAuth, this.jCBHttpAuth.isEnabled() && this.jCBHttpAuth.isSelected());
    }

    private void httpsAuthChanged() {
        UIUtilities.setContainerStatus(this.getHttpsAuthPanel(), this.jCBHttpsAuth.isEnabled() && this.jCBHttpsAuth.isSelected());
        UIUtilities.setContainerStatus(this.jcbHttpsNtLanAuth, this.jCBHttpsAuth.isEnabled() && this.jCBHttpsAuth.isSelected());
    }

    private void updatePanel() {
        if (this.httpProxyObj != null) {
            this.jRBHttpNo.setSelected(this.httpProxyObj.isNoProxy());
            this.jRBHttpSystem.setSelected(this.httpProxyObj.isSystemProxy());
            this.jRBHttpCustom.setSelected(this.httpProxyObj.isCustomProxy());
            this.jTFHttpHost.setText(this.httpProxyObj.getHost());
            this.jTFHttpPort.setText(this.httpProxyObj.getPort());
            this.jCBHttpAuth.setSelected(this.httpProxyObj.isAuthenticated());
            this.jTFHttpUserName.setText(this.httpProxyObj.getUserName());
            this.jPFHttpPassword.setText(this.httpProxyObj.getPassword());
            this.jcbHttpNtLanAuth.setSelected(this.httpProxyObj.isNtlmAuthentication());
            this.lockHttpChk.setSelected(this.httpProxyObj.getOptLockHttpProxyMode());
            this.httpCustomStateChanged();
        } else {
            ConsoleLogger.log("ProxyServerPanel.updatePanel(). httpProxyObj is null ");
        }
        if (this.httpsProxyObj != null) {
            this.jRBHttpsNo.setSelected(this.httpsProxyObj.isNoProxy());
            this.jRBHttpsSystem.setSelected(this.httpsProxyObj.isSystemProxy());
            this.jRBHttpsCustom.setSelected(this.httpsProxyObj.isCustomProxy());
            this.jTFHttpsHost.setText(this.httpsProxyObj.getHost());
            this.jTFHttpsPort.setText(this.httpsProxyObj.getPort());
            this.jCBHttpsAuth.setSelected(this.httpsProxyObj.isAuthenticated());
            this.jTFHttpsUserName.setText(this.httpsProxyObj.getUserName());
            this.jPFHttpsPassword.setText(this.httpsProxyObj.getPassword());
            this.jcbHttpsNtLanAuth.setSelected(this.httpsProxyObj.isNtlmAuthentication());
            this.lockHttpsChk.setSelected(this.httpsProxyObj.getOptLockHttpsProxyMode());
            this.httpsCustomStateChanged();
        } else {
            ConsoleLogger.log("ProxyServerPanel.updatePanel(). httpsProxyObj is null ");
        }
    }

    private Integer getHttpProxyMode() {
        if (this.jRBHttpNo.isSelected()) {
            return LuHttpProxy.NONE;
        }
        if (this.jRBHttpSystem.isSelected()) {
            return LuHttpProxy.SYSTEM;
        }
        return LuHttpProxy.CUSTOM;
    }

    private Integer getHttpsProxyMode() {
        if (this.jRBHttpsNo.isSelected()) {
            return LuHttpProxy.NONE;
        }
        if (this.jRBHttpsSystem.isSelected()) {
            return LuHttpProxy.SYSTEM;
        }
        return LuHttpProxy.CUSTOM;
    }

    @Override
    public void enableAndUseLiveUpdateServerChanged(boolean enableLiveUpdateServer, boolean useLiveUpdateServer) {
        this.jRBHttpNo.setEnabled(enableLiveUpdateServer && useLiveUpdateServer);
        this.jRBHttpSystem.setEnabled(enableLiveUpdateServer && useLiveUpdateServer);
        this.jRBHttpCustom.setEnabled(enableLiveUpdateServer && useLiveUpdateServer);
        this.httpCustomStateChanged();
        this.jRBHttpsNo.setEnabled(enableLiveUpdateServer && useLiveUpdateServer);
        this.jRBHttpsSystem.setEnabled(enableLiveUpdateServer && useLiveUpdateServer);
        this.jRBHttpsCustom.setEnabled(enableLiveUpdateServer && useLiveUpdateServer);
        this.httpsCustomStateChanged();
        if (!useLiveUpdateServer) {
            this.jRBHttpSystem.setSelected(true);
            this.jRBHttpsSystem.setSelected(true);
        } else {
            this.setRememberedRadioButtonSelected();
        }
    }

    private void rememberRadioButtonSelected() {
        this.httpRadioButtonSelected = this.httpRadioButtonGroup.getSelection();
        this.httpsRadioButtonSelected = this.httpsRadioButtonGroup.getSelection();
    }

    private void setRememberedRadioButtonSelected() {
        if (this.httpRadioButtonSelected != null) {
            this.httpRadioButtonSelected.setSelected(true);
        }
        if (this.httpsRadioButtonSelected != null) {
            this.httpsRadioButtonSelected.setSelected(true);
        }
    }

    private class RemeberSelection
    implements ActionListener {
        private RemeberSelection() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ProxyServerPanel.this.rememberRadioButtonSelected();
        }
    }
}

