/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuDownloadSchedule;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.UseLiveUpdateServerListener;
import com.sygate.scm.console.ui.policy.lu.logiobject.MacLuDownloadScheduleObject;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MacSchedulePanel
extends JPanel
implements ContentSensitiveHelpPage,
UseLiveUpdateServerListener {
    private static final long serialVersionUID = -379650543178832106L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    static final String[] DAY = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.sunday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.monday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.tuesday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.wednesday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.thursday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.friday"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.day.saturday")};
    private JRadioButton jRBContinuous = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.continuous"));
    private JRadioButton jRBHourly = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.hourlyFrequency"));
    private JRadioButton jRBDaily = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.daily"));
    private JRadioButton jRBWeekly = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.radiobutton.weekly"));
    private JSpinner jSpnHour = new JSpinner(new SpinnerNumberModel(1, 1, 23, 1));
    private TimeSpinner1 timeSpinner;
    private boolean hasHour;
    private boolean hasMinute;
    private boolean hasSecond;
    private boolean hasAmpm;
    private String hourPattern;
    private JComboBox<String> jCmbDay = new JComboBox<String>(DAY);
    private JCheckBox jChkRandomize = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.checkbox.randMin"));
    private JSpinner jSpnRandom = new JSpinner(new SpinnerNumberModel(1, 1, 300, 1));
    private JLabel jLblAt = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.label.at"));
    private JLabel jLblEvery = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.label.every"));
    private JLabel jLblHourly = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "SchedulePanel.label.hourlyFrequency"));
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private MacLuDownloadScheduleObject scheduleObj;

    public MacSchedulePanel() {
        this.timeSpinner = new TimeSpinner1(this.timePattern);
        if (this.timePattern.indexOf("h") != -1) {
            this.hourPattern = "h";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("H") != -1) {
            this.hourPattern = "H";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("k") != -1) {
            this.hourPattern = "k";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("K") != -1) {
            this.hourPattern = "K";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("m") != -1) {
            this.hasMinute = true;
        }
        if (this.timePattern.indexOf("s") != -1) {
            this.hasSecond = true;
        }
        if (this.timePattern.indexOf("a") != -1) {
            this.hasAmpm = true;
        }
        this.initialize();
    }

    public void save() {
        Integer freq = this.getFrequency();
        Integer hour = (Integer)this.jSpnHour.getValue();
        this.scheduleObj.setEnabled(true);
        this.scheduleObj.setFrequency(freq);
        if (LuDownloadSchedule.HOURLY.intValue() == freq.intValue()) {
            this.scheduleObj.setFrequencyInterval(hour);
        }
        if (LuDownloadSchedule.DAILY.intValue() == freq.intValue() || LuDownloadSchedule.WEEKLY.intValue() == freq.intValue()) {
            int hr = 0;
            int minute = 0;
            int second = 0;
            int ampm = -1;
            if (this.hasHour) {
                hr = this.timeSpinner.getHour();
                if (this.hasAmpm) {
                    ampm = this.timeSpinner.getAmpm();
                }
                hr = Utility.convertHourTo_H_Pattern((int)hr, (String)this.hourPattern, (int)ampm);
            }
            if (this.hasMinute) {
                minute = this.timeSpinner.getMinute();
            }
            if (this.hasSecond) {
                second = this.timeSpinner.getSecond();
            }
            long startTime = (long)hr * 3600L + (long)(minute * 60) + (long)second;
            this.scheduleObj.setStartTime(startTime);
        }
        if (LuDownloadSchedule.WEEKLY.intValue() == freq.intValue()) {
            this.scheduleObj.setDayOfWeek((this.jCmbDay.getSelectedIndex() + Calendar.getInstance().getFirstDayOfWeek() - 1) % 7);
        }
        if (LuDownloadSchedule.DAILY.intValue() == freq.intValue() || LuDownloadSchedule.WEEKLY.intValue() == freq.intValue()) {
            this.scheduleObj.setRandomness(this.jChkRandomize.isSelected());
            this.scheduleObj.setRandomizeTime((Integer)this.jSpnRandom.getValue(), freq, hour);
        }
    }

    private void initialize() {
        this.setLayout(new VerticalFlowLayout(0, 0));
        String[] day = new String[7];
        int iFirstDay = Calendar.getInstance().getFirstDayOfWeek() - 1;
        for (int i = 0; i < 7; ++i) {
            day[i] = DAY[(iFirstDay + i) % 7];
        }
        this.jCmbDay = new JComboBox<String>(day);
        this.add(this.getEnablePanel());
        this.add(this.getFrequencePanel());
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.add(this.getRandomizationPanel());
        }
        UIUtilities.enableOnlyValidEdits(this.jSpnHour);
    }

    private JPanel getEnablePanel() {
        JPanel enablePanel = new JPanel(new BorderLayout());
        enablePanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "SchedulePanel.label.enable"), MSGRES.getString(LU, "MacSchedulePanel.label.enableDesc"), false), "North");
        enablePanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        return enablePanel;
    }

    private JPanel getFrequencePanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBContinuous);
        group.add(this.jRBHourly);
        group.add(this.jRBDaily);
        group.add(this.jRBWeekly);
        this.jRBContinuous.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MacSchedulePanel.this.frequencyChanged(true, e);
            }
        });
        this.jRBHourly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MacSchedulePanel.this.frequencyChanged(true, e);
            }
        });
        this.jRBDaily.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MacSchedulePanel.this.frequencyChanged(true, e);
            }
        });
        this.jRBWeekly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MacSchedulePanel.this.frequencyChanged(true, e);
            }
        });
        this.jSpnHour.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        Box panel1 = new Box(0);
        panel1.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 20));
        panel1.add(this.jRBContinuous);
        panel1.add(Box.createHorizontalStrut(20));
        panel1.add(this.jRBHourly);
        panel1.add(this.jSpnHour);
        panel1.add(Box.createHorizontalStrut(5));
        panel1.add(this.jLblHourly);
        panel1.add(Box.createHorizontalStrut(20));
        panel1.add(this.jRBDaily);
        panel1.add(Box.createHorizontalStrut(20));
        panel1.add(this.jRBWeekly);
        JPanel wrapPanel1 = new JPanel(new BorderLayout());
        wrapPanel1.add((Component)panel1, "West");
        wrapPanel1.add((Component)this.getTimePanel(), "South");
        JPanel wrapPanel2 = new JPanel(new BorderLayout());
        wrapPanel2.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 0));
        wrapPanel2.add((Component)new AvTemplatePane(MSGRES.getString(LU, "SchedulePanel.label.frequence"), MSGRES.getString(LU, "SchedulePanel.label.frequenceDesc"), false), "North");
        wrapPanel2.add((Component)wrapPanel1, "Center");
        return wrapPanel2;
    }

    private JPanel getTimePanel() {
        this.timeSpinner.setEnabled(true);
        Dimension size = this.jCmbDay.getPreferredSize();
        this.jCmbDay.setPreferredSize(new Dimension(size.width + 10, size.height));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(20, 25, 0, 25));
        panel.add((Component)this.jLblAt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.timeSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.jLblEvery, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 0, 0), 0, 0));
        panel.add(this.jCmbDay, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private JPanel getRandomizationPanel() {
        this.jChkRandomize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacSchedulePanel.this.randomStateChanged();
            }
        });
        JPanel panel = new JPanel(new FlowLayout(3, 15, 10));
        panel.add(this.jChkRandomize);
        panel.add(this.jSpnRandom);
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(15, 40, 0, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "SchedulePanel.label.randomization"), MSGRES.getString(LU, "SchedulePanel.label.randomizationDesc"), false), "North");
        wrapPanel.add((Component)panel, "South");
        return wrapPanel;
    }

    private void frequencyChanged(boolean isUpdateModel, ItemEvent e) {
        if (e != null && e.getStateChange() == 2) {
            return;
        }
        if (isUpdateModel) {
            this.updateRandomizeModel();
        }
        boolean scheduleEnabled = true;
        this.jRBContinuous.setEnabled(scheduleEnabled);
        this.jRBHourly.setEnabled(scheduleEnabled);
        this.jRBDaily.setEnabled(scheduleEnabled);
        this.jRBWeekly.setEnabled(scheduleEnabled);
        this.jLblHourly.setEnabled(scheduleEnabled);
        this.jSpnHour.setEnabled(this.jRBHourly.isEnabled() && this.jRBHourly.isSelected());
        boolean weekly = this.jRBWeekly.isEnabled() && this.jRBWeekly.isSelected();
        this.jCmbDay.setEnabled(weekly);
        this.jLblEvery.setEnabled(weekly);
        boolean dailyOrWeekly = this.jRBDaily.isEnabled() && this.jRBDaily.isSelected() || weekly;
        this.timeSpinner.setEnabled(dailyOrWeekly);
        this.jLblAt.setEnabled(dailyOrWeekly);
        boolean enableRandomize = this.jRBContinuous.isEnabled() && !this.jRBContinuous.isSelected() && this.jRBHourly.isEnabled() && !this.jRBHourly.isSelected();
        this.jChkRandomize.setEnabled(enableRandomize);
        if (this.jRBContinuous.isSelected() || this.jRBHourly.isSelected()) {
            this.jChkRandomize.setSelected(false);
        }
        this.randomStateChanged();
    }

    private void randomStateChanged() {
        this.jSpnRandom.setEnabled(this.jChkRandomize.isEnabled() && this.jChkRandomize.isSelected());
        UIUtilities.enableOnlyValidEdits(this.jSpnRandom);
    }

    private void updateRandomizeModel() {
        boolean scheduleEnabled = true;
        this.jChkRandomize.setEnabled(scheduleEnabled);
        this.jSpnRandom.setEnabled(scheduleEnabled);
        Integer freq = this.getFrequency();
        this.jChkRandomize.setText(this.getRandomizeLabel(freq));
        this.jSpnRandom.setModel(this.getRandomizeModel(freq));
        this.jSpnRandom.setToolTipText(this.getToolTip(freq, this.scheduleObj.getRandomizeMinimumTime(), this.scheduleObj.getRandomizeMaximumTime(freq, (Integer)this.jSpnHour.getValue())));
    }

    private void updatePanel() {
        if (this.scheduleObj == null) {
            LuDownloadSchedule schedule = new LuDownloadSchedule();
            this.scheduleObj = new MacLuDownloadScheduleObject(schedule);
        }
        Integer frequency = this.scheduleObj.getFrequency();
        Integer hour = this.scheduleObj.getFrequencyInterval();
        if (frequency.equals(LuDownloadSchedule.CONTINUOUS)) {
            this.jRBContinuous.setSelected(true);
        } else if (frequency.equals(LuDownloadSchedule.HOURLY)) {
            this.jRBHourly.setSelected(true);
        } else if (frequency.equals(LuDownloadSchedule.DAILY)) {
            this.jRBDaily.setSelected(true);
        } else if (frequency.equals(LuDownloadSchedule.WEEKLY)) {
            this.jRBWeekly.setSelected(true);
        }
        this.jSpnHour.setValue(hour);
        int hr = 0;
        int minute = 0;
        int second = 0;
        int ampm = 0;
        Long stTime = this.scheduleObj.getStartTime();
        if (stTime != null) {
            int startTime = stTime.intValue();
            int hourOfDay = startTime / 3600;
            if (this.hasAmpm) {
                ampm = Utility.getAmpmFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
            }
            if (this.hasHour) {
                hr = Utility.convertHourFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
            }
            if (this.hasMinute) {
                minute = (startTime - hourOfDay * 3600) / 60;
            }
            if (this.hasSecond) {
                second = startTime - hourOfDay * 3600 - minute * 60;
            }
        }
        this.timeSpinner.setHour(hr);
        this.timeSpinner.setMinute(minute);
        this.timeSpinner.setSecond(second);
        if (this.hasAmpm) {
            this.timeSpinner.setAmpm(ampm);
        }
        this.jCmbDay.setSelectedIndex((this.scheduleObj.getDayOfWeek() - Calendar.getInstance().getFirstDayOfWeek() + 1 + 7) % 7);
        this.jChkRandomize.setSelected(this.scheduleObj.isRandomness());
        this.jSpnRandom.setValue(this.scheduleObj.getRandomizeTime());
        this.frequencyChanged(true, null);
    }

    private Integer getFrequency() {
        if (this.jRBContinuous.isSelected()) {
            return LuDownloadSchedule.CONTINUOUS;
        }
        if (this.jRBHourly.isSelected()) {
            return LuDownloadSchedule.HOURLY;
        }
        if (this.jRBDaily.isSelected()) {
            return LuDownloadSchedule.DAILY;
        }
        return LuDownloadSchedule.WEEKLY;
    }

    private String getRandomizeLabel(Integer frequency) {
        if (frequency.equals(LuDownloadSchedule.WEEKLY)) {
            return MSGRES.getString(LU, "SchedulePanel.checkbox.randomize.day");
        }
        if (frequency.equals(LuDownloadSchedule.CONTINUOUS) || frequency.equals(LuDownloadSchedule.HOURLY) && (Integer)this.jSpnHour.getValue() == 1) {
            return MSGRES.getString(LU, "SchedulePanel.checkbox.randomize.minute");
        }
        return MSGRES.getString(LU, "SchedulePanel.checkbox.randomize.hour");
    }

    private SpinnerNumberModel getRandomizeModel(Integer frequency) {
        int maximum;
        int curRandom = (Integer)this.jSpnRandom.getValue();
        curRandom = curRandom > (maximum = this.scheduleObj.getRandomizeMaximumTime(frequency, (Integer)this.jSpnHour.getValue())) ? maximum : curRandom;
        return new SpinnerNumberModel(curRandom, this.scheduleObj.getRandomizeMinimumTime(), maximum, 1);
    }

    private String getToolTip(Integer frequency, int minValue, int maxValue) {
        Object[] args = new String[]{String.valueOf(minValue), String.valueOf(maxValue)};
        String tip = MSGRES.getString(LU, "SchedulePanel.tooltip.hour");
        if (frequency.equals(LuDownloadSchedule.WEEKLY)) {
            tip = MSGRES.getString(LU, "SchedulePanel.tooltip.day");
        } else if (frequency.equals(LuDownloadSchedule.CONTINUOUS) || frequency.equals(LuDownloadSchedule.HOURLY) && (Integer)this.jSpnHour.getValue() == 1) {
            tip = MSGRES.getString(LU, "SchedulePanel.tooltip.minute");
        }
        return MessageFormat.format(tip, args);
    }

    public void setObject(MacLuDownloadScheduleObject scheduleObj) {
        this.scheduleObj = scheduleObj;
        this.updatePanel();
    }

    public MacLuDownloadScheduleObject getObject() {
        return this.scheduleObj;
    }

    public void setReadOnly() {
        this.jRBContinuous.setEnabled(false);
        this.jRBHourly.setEnabled(false);
        this.jRBDaily.setEnabled(false);
        this.jRBWeekly.setEnabled(false);
        this.jChkRandomize.setEnabled(false);
        this.frequencyChanged(false, null);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "mac_sesm_policies_dialog_lu_schedule";
    }

    public void setEnableSchedule(boolean enable) {
        this.updatePanel();
    }

    @Override
    public void enableAndUseLiveUpdateServerChanged(boolean enableLiveUpdateServer, boolean useLiveUpdateServer) {
        this.setEnableSchedule(enableLiveUpdateServer && useLiveUpdateServer);
    }
}

