/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuHttpProxy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.logicobject.MacProxySettingsObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.ProxyServerPanel;
import com.sygate.scm.console.ui.policy.lu.UseLiveUpdateServerListener;
import com.sygate.scm.console.ui.policy.lu.logiobject.MacLuHttpProxyObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class MacProxyServerPanel
extends JPanel
implements ContentSensitiveHelpPage,
UseLiveUpdateServerListener {
    private static final long serialVersionUID = -3292015770607530875L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private JRadioButton jRBHttpNo = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.radiobutton.httpNoProxy"));
    private JRadioButton jRBHttpSystem = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "MacProxyServerPanel.radiobutton.httpSystemProxy"));
    private JRadioButton jRBHttpCustom = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.radiobutton.httpCustomProxy"));
    private ButtonGroup httpRadioButtonGroup = new ButtonGroup();
    private JTextField jTFHttpHost = new JTextField();
    private JTextField jTFHttpPort = new JTextField(6);
    private JCheckBox jCBHttpAuth = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "ProxyServerPanel.checkbox.httpAuth"));
    private JTextField jTFUserName = new JTextField();
    private JPasswordField jPFPassword = new SEPMPasswordField();
    private JPanel jPHttpCustom;
    private JPanel jPHttpAuth;
    private JPanel jPHttpProxyAddressAndPortNumber;
    private MacLuHttpProxyObject httpProxyObj;
    private ButtonModel httpRadioButtonSelected;
    private MacProxySettingsObject macProxySettingsObject;

    public MacProxyServerPanel(ProxyServerPanel proxyServerPanel) {
        this.initialize();
    }

    public void setObject(ExternalCommunicationObject extCommObj) {
        this.httpProxyObj = extCommObj.getMacHttpProxyObject();
        this.macProxySettingsObject = extCommObj.getMacProxySettingsObject();
        if (this.httpRadioButtonSelected == null) {
            this.httpRadioButtonSelected = this.httpProxyObj != null && this.httpProxyObj.isCustomProxy() ? this.jRBHttpCustom.getModel() : (this.httpProxyObj != null && this.httpProxyObj.isSystemProxy() ? this.jRBHttpSystem.getModel() : this.jRBHttpNo.getModel());
        }
        this.updatePanel();
    }

    public void save() {
        this.macProxySettingsObject.setCopyWindowsSettings(false);
        this.httpProxyObj.setMode(this.getHttpProxyMode());
        if (this.getHttpProxyMode().equals(LuHttpProxy.CUSTOM)) {
            this.httpProxyObj.setHost(this.jTFHttpHost.getText().trim());
            this.httpProxyObj.setPort(this.jTFHttpPort.getText().trim());
            this.httpProxyObj.setAuthentication(this.jCBHttpAuth.isSelected());
            this.httpProxyObj.setUserName(this.jTFUserName.getText().trim());
            this.httpProxyObj.setPassword(new String(this.jPFPassword.getPassword()));
        } else {
            this.httpProxyObj.setHost("");
            this.httpProxyObj.setPort("");
            this.httpProxyObj.setAuthentication(false);
            this.httpProxyObj.setUserName("");
            this.httpProxyObj.setPassword("");
        }
    }

    public boolean isValidate() {
        if (this.jRBHttpCustom.isSelected()) {
            if (this.jTFHttpHost.getText().trim().length() == 0 || !Utility.isValidIPAddressOrHostName((String)this.jTFHttpHost.getText().trim(), (boolean)false)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.msg.pleaseEnterValidServerIPorName"), MSGRES.getString(LU, "ProxyServerPanel.error"), 0);
                return false;
            }
            if (this.jTFHttpPort.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "MacProxyServerPanel.httpPortError"), MSGRES.getString(LU, "ProxyServerPanel.error"), 0);
                return false;
            }
            if (this.jCBHttpAuth.isSelected() && this.jTFUserName.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "ProxyServerPanel.httpUsernameError"), MSGRES.getString(LU, "ProxyServerPanel.error"), 0);
                return false;
            }
        }
        return true;
    }

    public void setReadOnly() {
        this.jRBHttpNo.setEnabled(false);
        this.jRBHttpSystem.setEnabled(false);
        this.jRBHttpCustom.setEnabled(false);
        this.httpCustomStateChanged();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_lu_server_settings_proxy";
    }

    private void initialize() {
        this.setLayout(new VerticalFlowLayout(0, 15));
        this.add(this.getHttpProxyPanel());
    }

    private JPanel getHttpProxyPanel() {
        this.httpRadioButtonGroup.add(this.jRBHttpNo);
        this.httpRadioButtonGroup.add(this.jRBHttpSystem);
        this.httpRadioButtonGroup.add(this.jRBHttpCustom);
        RemeberSelection remeber = new RemeberSelection();
        this.jRBHttpNo.addActionListener(remeber);
        this.jRBHttpSystem.addActionListener(remeber);
        this.jRBHttpCustom.addActionListener(remeber);
        this.jRBHttpCustom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MacProxyServerPanel.this.httpCustomStateChanged();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jRBHttpNo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 20), 0, 0));
        panel.add((Component)this.jRBHttpSystem, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        panel.add((Component)this.jRBHttpCustom, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0));
        panel.add((Component)this.getHttpCustomPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "MacProxyServerPanel.label.http"), MSGRES.getString(LU, "MacProxyServerPanel.label.httpDesc"), false), "Center");
        wrapPanel.add((Component)panel, "South");
        return wrapPanel;
    }

    private JPanel getHttpCustomPanel() {
        if (this.jPHttpCustom == null) {
            this.jTFHttpPort.setDocument(new NumberPlainDocument(65535L, true));
            this.jCBHttpAuth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacProxyServerPanel.this.httpAuthChanged();
                }
            });
            this.jPHttpCustom = new JPanel(new GridBagLayout());
            this.jPHttpCustom.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(10, 20, 20, 20)));
            this.jPHttpCustom.add((Component)this.getProxyAndAuthPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        }
        return this.jPHttpCustom;
    }

    private JPanel getProxyAndAuthPanel() {
        if (this.jPHttpProxyAddressAndPortNumber == null) {
            this.jTFHttpHost.setPreferredSize(new Dimension(180, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jTFHttpHost.setHorizontalAlignment(2);
            this.jPHttpProxyAddressAndPortNumber = new JPanel(new GridBagLayout());
            this.jPHttpProxyAddressAndPortNumber.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.httpHost")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpProxyAddressAndPortNumber.add((Component)this.jTFHttpHost, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpProxyAddressAndPortNumber.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.port")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpProxyAddressAndPortNumber.add((Component)this.jTFHttpPort, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpProxyAddressAndPortNumber.add((Component)this.jCBHttpAuth, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.jPHttpProxyAddressAndPortNumber.add((Component)this.getHttpAuthPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 0, 0), 0, 0));
        }
        return this.jPHttpProxyAddressAndPortNumber;
    }

    private JPanel getHttpAuthPanel() {
        if (this.jPHttpAuth == null) {
            this.jTFUserName.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jPFPassword.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jPHttpAuth = new JPanel(new GridBagLayout());
            this.jPHttpAuth.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.httpUsername")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPHttpAuth.add((Component)this.jTFUserName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.jPHttpAuth.add((Component)new JLabel(MSGRES.getString(LU, "ProxyServerPanel.label.httpPassword")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPHttpAuth.add((Component)this.jPFPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        }
        return this.jPHttpAuth;
    }

    private void httpCustomStateChanged() {
        UIUtilities.setContainerStatus(this.getHttpCustomPanel(), this.jRBHttpCustom.isEnabled() && this.jRBHttpCustom.isSelected());
        this.httpAuthChanged();
    }

    private void httpAuthChanged() {
        UIUtilities.setContainerStatus(this.getHttpAuthPanel(), this.jCBHttpAuth.isEnabled() && this.jCBHttpAuth.isSelected());
    }

    private void updatePanel() {
        this.jRBHttpNo.setSelected(this.httpProxyObj.isNoProxy());
        this.jRBHttpSystem.setSelected(this.httpProxyObj.isSystemProxy());
        this.jRBHttpCustom.setSelected(this.httpProxyObj.isCustomProxy());
        this.jTFHttpHost.setText(this.httpProxyObj.getHost());
        this.jTFHttpPort.setText(this.httpProxyObj.getPort());
        this.jCBHttpAuth.setSelected(this.httpProxyObj.isAuthenticated());
        this.jTFUserName.setText(this.httpProxyObj.getUserName());
        this.jPFPassword.setText(this.httpProxyObj.getPassword());
        this.httpCustomStateChanged();
    }

    private Integer getHttpProxyMode() {
        if (this.jRBHttpNo.isSelected()) {
            return LuHttpProxy.NONE;
        }
        if (this.jRBHttpSystem.isSelected()) {
            return LuHttpProxy.SYSTEM;
        }
        return LuHttpProxy.CUSTOM;
    }

    @Override
    public void enableAndUseLiveUpdateServerChanged(boolean enableLiveUpdateServer, boolean useLiveUpdateServer) {
        this.jRBHttpNo.setEnabled(enableLiveUpdateServer && useLiveUpdateServer);
        this.jRBHttpSystem.setEnabled(enableLiveUpdateServer && useLiveUpdateServer);
        this.jRBHttpCustom.setEnabled(enableLiveUpdateServer && useLiveUpdateServer);
        this.httpCustomStateChanged();
        if (!useLiveUpdateServer) {
            this.jRBHttpNo.setSelected(true);
        } else {
            this.setRememberedRadioButtonSelected();
        }
    }

    private void rememberRadioButtonSelected() {
        this.httpRadioButtonSelected = this.httpRadioButtonGroup.getSelection();
    }

    private void setRememberedRadioButtonSelected() {
        if (this.httpRadioButtonSelected != null) {
            this.httpRadioButtonSelected.setSelected(true);
        }
    }

    private class RemeberSelection
    implements ActionListener {
        private RemeberSelection() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MacProxyServerPanel.this.rememberRadioButtonSelected();
        }
    }
}

