/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuAppliedContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.DashLine;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuAppliedContentObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class MacLuCategoryPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 5482990450870959057L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private JCheckBox jChkCategory = new JCheckBox();
    private DescriptionTextArea desc = new DescriptionTextArea();
    private JLabel jLNameLabel = new JLabel();
    private JPanel jPNamedVersionError;
    private LuAppliedContentObject contentObj;
    private JCheckBox jChkIPSCategory = new JCheckBox();
    private JLabel jLIPSLabel = new JLabel();
    private DescriptionTextArea ipsDesc = new DescriptionTextArea();
    private LuAppliedContentObject ipsContentObj;

    public MacLuCategoryPanel() {
        this.initialize();
    }

    public void setObject(LiveUpdateContentObject luObj) {
        this.contentObj = luObj.getAppliedContent("MAC_AV_DEFS");
        this.jChkCategory.setSelected(this.contentObj == null || this.contentObj.isEnabled());
        this.updateEnableStatus(this.jChkCategory.isSelected(), false);
        this.ipsContentObj = luObj.getAppliedContent("MAC_IPS");
        this.jChkIPSCategory.setSelected(this.ipsContentObj == null || this.ipsContentObj.isEnabled());
        this.updateEnableStatus(this.jChkIPSCategory.isSelected(), false);
    }

    public LuAppliedContentObject getAVObject() {
        return this.contentObj;
    }

    public LuAppliedContentObject getIPSObject() {
        return this.ipsContentObj;
    }

    public void setReadOnly() {
        this.updateEnableStatus(false, true);
    }

    public void setReadOnly(boolean enable) {
        this.setReadOnly();
        this.jLNameLabel.setEnabled(enable);
        this.desc.setEnabled(enable);
        this.jLIPSLabel.setEnabled(enable);
        this.ipsDesc.setEnabled(enable);
    }

    public boolean getSelected() {
        return this.jChkCategory.isSelected();
    }

    public void setSelected(boolean b) {
        this.jChkCategory.setSelected(b);
    }

    public List<LuAppliedContentObject> save() {
        LuAppliedContent content;
        ArrayList<LuAppliedContentObject> macContent = new ArrayList<LuAppliedContentObject>();
        if (this.contentObj == null) {
            content = new LuAppliedContent();
            content.setContentCategory("MAC_AV_DEFS");
            this.contentObj = new LuAppliedContentObject(content);
        }
        this.contentObj.setEnabled(this.jChkCategory.isSelected());
        this.contentObj.verify();
        macContent.add(this.contentObj);
        if (this.ipsContentObj == null) {
            content = new LuAppliedContent();
            content.setContentCategory("MAC_IPS");
            this.ipsContentObj = new LuAppliedContentObject(content);
        }
        this.ipsContentObj.setEnabled(this.jChkIPSCategory.isSelected());
        macContent.add(this.ipsContentObj);
        return macContent;
    }

    private void initialize() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.createDescriptionPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 10, 20), 0, 0));
        this.jPNamedVersionError = this.getNamedVersionErrorPanel();
        LicenseObject licenseObject = LicenseObject.getInstance();
        if (licenseObject.isQualifiedLuContentCategory("AV_DEFS")) {
            panel.add((Component)this.getAVPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 10, 20), 0, 0));
            panel.add((Component)this.getIPSPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 10, 20), 0, 0));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
    }

    private JPanel createDescriptionPanel() {
        String settingsUsage = MSGRES.getString(LU, "MacCategoryGroupPanel.contentPolicyUsage");
        DescriptionTextArea descTextArea = new DescriptionTextArea(settingsUsage);
        descTextArea.setForeground(UIColorUtilities.SOFT_FOREGROUND);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)descTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new DashLine(UIColorUtilities.CONTROL_BACKGROUND), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getAVPanel() {
        this.desc = new DescriptionTextArea(MSGRES.getString(LU, "MacLuCategoryPanel.categoryDesc.label"));
        this.jLNameLabel = new JLabel(MSGRES.getString(LU, "MacLuCategoryPanel.checkbox.label"), 11);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jChkCategory, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLNameLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.desc, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 43, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getIPSPanel() {
        this.ipsDesc = new DescriptionTextArea(MSGRES.getString(LU, "MacLuCategoryPanel.categoryDesc.ips.label"));
        this.jLIPSLabel = new JLabel(MSGRES.getString(LU, "MacLuCategoryPanel.checkbox.ips.label"), 11);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jChkIPSCategory, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLIPSLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.ipsDesc, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 43, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getNamedVersionErrorPanel() {
        JLabel label = new JLabel(MSGRES.getString(LU, "LuCategoryPanel.label.namedVersionError"));
        label.setForeground(Color.red);
        JEditorPane pane = new JEditorPane();
        pane.setOpaque(false);
        pane.setEditable(false);
        pane.setContentType("text/html");
        pane.setText("<html><a href='http://localhost/a.html'>" + HTMLUtilities.img((URL)ConsoleMain.class.getResource("ask.gif")) + "</a></html>");
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    UIUtilities.showErrorDialog(MSGRES.getString(MacLuCategoryPanel.LU, "LuCategoryPanel.error"));
                }
            }
        });
        this.jPNamedVersionError = new JPanel(new FlowLayout(3));
        this.jPNamedVersionError.add(label);
        this.jPNamedVersionError.add(pane);
        return this.jPNamedVersionError;
    }

    private void updateEnableStatus(boolean enable, boolean isCategoryUpdate) {
        if (isCategoryUpdate) {
            this.jChkCategory.setEnabled(enable);
            this.jChkIPSCategory.setEnabled(enable);
        }
        UIUtilities.setContainerStatus(this.jPNamedVersionError, this.jChkCategory.isEnabled() && enable);
        UIUtilities.setContainerStatus(this.jPNamedVersionError, this.jChkIPSCategory.isEnabled() && enable);
    }

    protected boolean isValidate() {
        return true;
    }

    public boolean isActive() {
        return this.jChkCategory.isSelected();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_luc_catetory_group_security";
    }
}

