/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.LuServerPanel;
import com.sygate.scm.console.ui.policy.lu.UseLiveUpdateServerListener;
import com.sygate.scm.console.ui.policy.lu.logiobject.MacLuContentSourceInfoObject;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class MacLiveUpdateServerPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 4329950296351055580L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private JCheckBox jChkLiveUpdateServer = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LiveUpdateServerPanel.checkbox.alternate"));
    private LuServerPanel serverPanel = new LuServerPanel(2);
    private MacLuContentSourceInfoObject sourceInfoObj;
    private ArrayList<UseLiveUpdateServerListener> useLiveUpdateServerListenerList = new ArrayList();

    public MacLiveUpdateServerPanel() {
        this.initialize();
    }

    public void setObject(MacLuContentSourceInfoObject sourceInfoObj) {
        this.sourceInfoObj = sourceInfoObj;
        this.updatePanel();
    }

    public MacLuContentSourceInfoObject getObject() {
        return this.sourceInfoObj;
    }

    public void save() {
        this.sourceInfoObj.setUseManagementServer(false);
        this.sourceInfoObj.setUseLiveUpdateServer(this.jChkLiveUpdateServer.isSelected());
        this.serverPanel.save();
    }

    public boolean isValidate() {
        return this.serverPanel.isValidate();
    }

    public void setReadOnly() {
        this.jChkLiveUpdateServer.setEnabled(false);
        this.serverPanel.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "mac_sesm_policies_dialog_lu_server_settings_live_update";
    }

    private void initialize() {
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.add(this.getSourceServerPanel());
    }

    private JPanel getSourceServerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.serverPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "LiveUpdateServerPanel.label.sourceServer"), MSGRES.getString(LU, "MacLiveUpdateServerPanel.label.sourceServerDesc"), false), "North");
        wrapPanel.add((Component)panel, "Center");
        return wrapPanel;
    }

    private void serverStateChanged() {
        boolean enableLiveUpdateServer = this.jChkLiveUpdateServer.isEnabled();
        boolean useLiveUpdateServer = this.jChkLiveUpdateServer.isSelected();
        boolean enableAndUseLiveUpdateServer = enableLiveUpdateServer && useLiveUpdateServer;
        this.serverPanel.setEnabled(enableAndUseLiveUpdateServer);
        this.fireUseLiveUpdateServerChange(enableLiveUpdateServer, useLiveUpdateServer);
    }

    public void addUseLiveUpdateServerListener(UseLiveUpdateServerListener listener) {
        this.useLiveUpdateServerListenerList.add(listener);
    }

    private void fireUseLiveUpdateServerChange(boolean enableLiveUpdateServer, boolean useLiveUpdateServer) {
        for (UseLiveUpdateServerListener listener : this.useLiveUpdateServerListenerList) {
            listener.enableAndUseLiveUpdateServerChanged(enableLiveUpdateServer, useLiveUpdateServer);
        }
    }

    private void updatePanel() {
        this.jChkLiveUpdateServer.setSelected(this.sourceInfoObj.isUseLiveUpdateServer());
        this.serverPanel.setObject(this.sourceInfoObj);
        this.serverStateChanged();
    }
}

