/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.ContentVersionInfo;
import com.sygate.scm.common.configobject.schema.GlobalObjectPool;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibrary;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibraryPool;
import com.sygate.scm.common.configobject.schema.LocalizedStrings;
import com.sygate.scm.common.configobject.schema.LuCategory;
import com.sygate.scm.common.configobject.schema.LuClientRegistration;
import com.sygate.scm.common.configobject.schema.LuConfig;
import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.configobject.schema.LuContentCategoryGroup;
import com.sygate.scm.common.configobject.schema.LuContentSizeSelection;
import com.sygate.scm.common.configobject.schema.LuContentSizeSelections;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.configobject.schema.LuDownloadedContent;
import com.sygate.scm.common.configobject.schema.LuDownloadedContentArray;
import com.sygate.scm.common.configobject.schema.LuDownloadedContentPool;
import com.sygate.scm.common.configobject.schema.LuPolicy;
import com.sygate.scm.common.configobject.schema.LuRegistration;
import com.sygate.scm.common.configobject.schema.LuServerRegistration;
import com.sygate.scm.common.configobject.schema.LuSesmContentCatalog;
import com.sygate.scm.common.configobject.schema.LuSesmContentCatalogPool;
import com.sygate.scm.common.configobject.schema.LuSupportLanguage;
import com.sygate.scm.common.configobject.schema.LuSupportLanguageList;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.RevisionObject;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuAppliedContentObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuDownloadContentObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuLatestDownloadContentObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.LuHIContentHelper;
import com.sygate.scm.util.LuLocalizedStringUtility;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;

public class LuUtility {
    public static final String CATEGORY_COMPILANCE = "COMPLIANCE";
    public static final String CATEGORY_PRODUCT_UPDATES = "PRODUCT_UPDATES";
    public static final String CATEGORY_SECURITY = "SECURITY";
    public static final String SF_PRODUCT_WIN32 = "SESM AntiVirus Client Security Fix Win32";
    public static final String SF_PRODUCT_WIN64 = "SESM AntiVirus Client Security Fix Win64";

    public static List<LuContentCategoryGroup> getAllLuCategoryGroups(boolean forSite) {
        return LuUtility.getAllLuCategoryGroups(forSite, null);
    }

    public static List<LuContentCategoryGroup> getAllLuCategoryGroups(boolean forSite, String category) {
        ArrayList<LuContentCategoryGroup> groups = new ArrayList<LuContentCategoryGroup>();
        try {
            LuSesmContentCatalog catalog;
            ObjReference objRef;
            LuSesmContentCatalogPool catalogPool;
            DataobjectManager manager = DataobjectManager.getInstance();
            GlobalObjectPool globalPool = manager.getSemConfigRoot().getOptGlobalObjectPool();
            if (globalPool != null && (catalogPool = globalPool.getOptLuSesmContentCatalogPool()) != null && (objRef = catalogPool.getObjReference()) != null && (catalog = manager.getLuSesmContentCatalog(objRef.getTargetId())) != null) {
                for (int i = 0; i < catalog.getLuContentCategoryGroupCount(); ++i) {
                    LuContentCategoryGroup group = catalog.getLuContentCategoryGroup(i);
                    if (LuUtility.isEmptyLuCategoryGroup(group, forSite) || category != null && !category.equals(group.getName())) continue;
                    groups.add(group);
                }
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return groups;
    }

    public static List<LuContentCategoryGroup> getAllLuCategoryGroups() {
        ArrayList<LuContentCategoryGroup> groups = new ArrayList<LuContentCategoryGroup>();
        try {
            LuSesmContentCatalog catalog;
            ObjReference objRef;
            LuSesmContentCatalogPool catalogPool;
            DataobjectManager manager = DataobjectManager.getInstance();
            GlobalObjectPool globalPool = manager.getSemConfigRoot().getOptGlobalObjectPool();
            if (globalPool != null && (catalogPool = globalPool.getOptLuSesmContentCatalogPool()) != null && (objRef = catalogPool.getObjReference()) != null && (catalog = manager.getLuSesmContentCatalog(objRef.getTargetId())) != null) {
                for (int i = 0; i < catalog.getLuContentCategoryGroupCount(); ++i) {
                    LuContentCategoryGroup group = catalog.getLuContentCategoryGroup(i);
                    groups.add(group);
                }
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return groups;
    }

    public static List<LuContentCategory> getAllLuCategories(boolean forSite) {
        return LuUtility.getAllLuCategories(forSite, true);
    }

    public static List<LuContentCategory> getAllLuCategories(boolean forSite, boolean checkQualified) {
        ArrayList<LuContentCategory> categories = new ArrayList<LuContentCategory>();
        List<LuContentCategoryGroup> categoryGroups = LuUtility.getAllLuCategoryGroups(forSite);
        for (int i = 0; i < categoryGroups.size(); ++i) {
            LuContentCategoryGroup categoryGroup = categoryGroups.get(i);
            for (int j = 0; j < categoryGroup.getLuContentCategoryCount(); ++j) {
                LuContentCategory luCategory = categoryGroup.getLuContentCategory(j);
                if (checkQualified) {
                    if (!LuUtility.isQualifiedLuCategory(luCategory, forSite)) continue;
                    categories.add(categoryGroup.getLuContentCategory(j));
                    continue;
                }
                categories.add(categoryGroup.getLuContentCategory(j));
            }
        }
        return categories;
    }

    public static List<LuContentCategory> getAllLuCategories() {
        ArrayList<LuContentCategory> categories = new ArrayList<LuContentCategory>();
        List<LuContentCategoryGroup> categoryGroups = LuUtility.getAllLuCategoryGroups();
        for (int i = 0; i < categoryGroups.size(); ++i) {
            LuContentCategoryGroup categoryGroup = categoryGroups.get(i);
            for (int j = 0; j < categoryGroup.getLuContentCategoryCount(); ++j) {
                categories.add(categoryGroup.getLuContentCategory(j));
            }
        }
        return categories;
    }

    public static List<LuSupportLanguage> getAllLuLanguages() {
        try {
            LuSesmContentCatalog catalog;
            ObjReference objRef;
            LuSesmContentCatalogPool catalogPool;
            DataobjectManager manager = DataobjectManager.getInstance();
            GlobalObjectPool globalPool = manager.getSemConfigRoot().getOptGlobalObjectPool();
            if (globalPool != null && (catalogPool = globalPool.getOptLuSesmContentCatalogPool()) != null && (objRef = catalogPool.getObjReference()) != null && (catalog = manager.getLuSesmContentCatalog(objRef.getTargetId())) != null) {
                LuSupportLanguageList languageList = catalog.getLuSupportLanguageList();
                Vector l = languageList.getLuSupportLanguage();
                return new ArrayList<LuSupportLanguage>(l);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return new ArrayList<LuSupportLanguage>();
    }

    public static LocalizedStrings getLocalizedString(Vector<LocalizedStrings> localStrings) {
        return LuLocalizedStringUtility.getLocalizedString(localStrings);
    }

    public static Vector<LuDownloadContentObject> getDistinctAvailableContent(LuContentCategory luCategory) {
        Vector<LuDownloadContentObject> retValue = new Vector<LuDownloadContentObject>();
        Vector<LuDownloadContentObject> v = LuUtility.getAllAvailableContent(luCategory);
        Iterator<LuDownloadContentObject> i = v.iterator();
        HashSet<String> distinctMonikerSet = new HashSet<String>();
        while (i.hasNext()) {
            LuDownloadContentObject ldco = i.next();
            if (distinctMonikerSet.contains(ldco.getClientMoniker())) continue;
            retValue.add(ldco);
            distinctMonikerSet.add(ldco.getClientMoniker());
        }
        return retValue;
    }

    public static Vector<LuLatestDownloadContentObject> getLatestAvailableContent(LuContentCategory luCategory) {
        Vector<LuLatestDownloadContentObject> retValue = new Vector<LuLatestDownloadContentObject>();
        Vector<LuLatestDownloadContentObject> v = LuUtility.getAllAvailableContentForLatest(luCategory);
        Iterator<LuLatestDownloadContentObject> i = v.iterator();
        HashMap<String, LuLatestDownloadContentObject> monikerContentObjMap = new HashMap<String, LuLatestDownloadContentObject>();
        while (i.hasNext()) {
            String seq;
            long seqNum;
            LuLatestDownloadContentObject ldco = i.next();
            String clientMoniker = ldco.getContent().getOptClientMoniker();
            String moniker = null;
            moniker = clientMoniker != null ? clientMoniker : ldco.getContent().getServerMoniker();
            if (moniker == null) continue;
            if (!monikerContentObjMap.containsKey(moniker)) {
                monikerContentObjMap.put(moniker, ldco);
                continue;
            }
            LuLatestDownloadContentObject ldcoAdded = (LuLatestDownloadContentObject)monikerContentObjMap.get(moniker);
            String seqAdded = ldcoAdded.getSequenceNum();
            long seqNumAdded = Long.parseLong(seqAdded);
            if (seqNumAdded >= (seqNum = Long.parseLong(seq = ldco.getSequenceNum()))) continue;
            monikerContentObjMap.put(moniker, ldco);
        }
        retValue.addAll(monikerContentObjMap.values());
        return retValue;
    }

    public static Vector<LuDownloadContentObject> getAllAvailableContent(LuContentCategory category) {
        return LuUtility.getAllAvailableContent(null, category);
    }

    public static Vector<LuDownloadContentObject> getAllAvailableContent(String moniker, LuContentCategory category) {
        LuDownloadedContentArray contentArray;
        HashMap<String, LuRegistration> registrations = new HashMap<String, LuRegistration>();
        for (int i = 0; i < category.getLuRegistrationCount(); ++i) {
            LuRegistration reg = category.getLuRegistration(i);
            LuClientRegistration clientReg = reg.getOptLuClientRegistration();
            if (clientReg == null) continue;
            registrations.put(clientReg.getMoniker(), reg);
        }
        Vector<LuDownloadContentObject> contents = new Vector<LuDownloadContentObject>();
        if (registrations.size() > 0 && (contentArray = LuUtility.getLuDownloadedContentArray()) != null) {
            for (int i = contentArray.getLuDownloadedContentCount() - 1; i >= 0; --i) {
                LuRegistration reg;
                LuDownloadedContent content = contentArray.getLuDownloadedContent(i);
                if (moniker != null && !moniker.equals(content.getOptClientMoniker()) || (reg = (LuRegistration)registrations.get(content.getOptClientMoniker())) == null) continue;
                LuDownloadContentObject ldco = new LuDownloadContentObject(reg, content, category);
                ldco.setEnabled(true);
                contents.add(ldco);
            }
        }
        return contents;
    }

    public static boolean isNamedVersionAvailable(LuAppliedContentObject contentObj, LuContentCategory category) {
        for (int i = 0; i < contentObj.getAllContentsCount(); ++i) {
            List<String> seqNumList;
            ContentVersionInfo verInfo = contentObj.getContentVersionInfo(i);
            String seqNum = verInfo.getSequenceNum();
            if (StringUtilities.isEmpty((String)seqNum) || (seqNumList = LuUtility.getAllAvailableContentSeqNums(verInfo.getMoniker(), category)).contains(seqNum)) continue;
            return false;
        }
        return true;
    }

    public static List<String> getAllAvailableContentSeqNums(String moniker, LuContentCategory category) {
        Vector<LuDownloadContentObject> contents = LuUtility.getAllAvailableContent(moniker, category);
        ArrayList<String> seqNums = new ArrayList<String>();
        for (int i = 0; i < contents.size(); ++i) {
            seqNums.add(contents.get(i).getSequenceNum());
        }
        return seqNums;
    }

    public static boolean isEngineVersionAvailable(LuAppliedContentObject contentObj, LuContentCategory category) {
        for (int i = 0; i < contentObj.getAllContentsCount(); ++i) {
            List<String> seqNumList;
            ContentVersionInfo verInfo = contentObj.getContentVersionInfo(i);
            String seqNum = verInfo.getSequenceNum();
            if (StringUtilities.isEmpty((String)seqNum) || (seqNumList = LuUtility.getAllAvailableContentEngineVersions(verInfo.getMoniker(), category)).contains(seqNum)) continue;
            return false;
        }
        return true;
    }

    public static List<String> getAllAvailableContentEngineVersions(String moniker, LuContentCategory category) {
        Vector<LuDownloadContentObject> contents = LuUtility.getAllAvailableContent(moniker, category);
        TreeSet<String> engineVersions = new TreeSet<String>();
        for (int i = 0; i < contents.size(); ++i) {
            if (StringUtilities.isEmpty((String)contents.get(i).getEngineNum())) continue;
            engineVersions.add(contents.get(i).getEngineNum());
        }
        return new ArrayList<String>(engineVersions);
    }

    public static Vector<LuLatestDownloadContentObject> getAllAvailableContentForLatest(LuContentCategory category) {
        HashMap<String, LuRegistration> registrations = new HashMap<String, LuRegistration>();
        for (int i = 0; i < category.getLuRegistrationCount(); ++i) {
            LuServerRegistration serverReg;
            LuRegistration reg = category.getLuRegistration(i);
            boolean obsoleted = Utility.getBooleanValue((Boolean)reg.getOptObsolete(), (Boolean)reg.getDefObsolete());
            if (obsoleted) continue;
            LuClientRegistration clientReg = reg.getOptLuClientRegistration();
            if (clientReg != null) {
                registrations.put(clientReg.getMoniker(), reg);
            }
            if ((serverReg = reg.getLuServerRegistration()) == null) continue;
            registrations.put(serverReg.getMoniker(), reg);
        }
        Vector<LuLatestDownloadContentObject> contents = new Vector<LuLatestDownloadContentObject>();
        LuDownloadedContentArray contentArray = LuUtility.getLuDownloadedContentArray();
        if (contentArray != null) {
            for (int i = contentArray.getLuDownloadedContentCount() - 1; i >= 0; --i) {
                LuRegistration serverReg;
                LuDownloadedContent content = contentArray.getLuDownloadedContent(i);
                LuRegistration reg = (LuRegistration)registrations.get(content.getOptClientMoniker());
                if (reg != null) {
                    LuLatestDownloadContentObject ldco = new LuLatestDownloadContentObject(reg, content, false, category);
                    ldco.setEnabled(true);
                    contents.add(ldco);
                    continue;
                }
                String serverMoniker = content.getServerMoniker();
                if (serverMoniker == null || (serverReg = (LuRegistration)registrations.get(serverMoniker)) == null) continue;
                LuLatestDownloadContentObject ldco = new LuLatestDownloadContentObject(serverReg, content, true, category);
                ldco.setEnabled(true);
                contents.add(ldco);
            }
        }
        return contents;
    }

    public static LuDownloadedContentArray getLuDownloadedContentArray() {
        return LuUtility.getLuDownloadedContentArray(false);
    }

    public static LuDownloadedContentArray getLuDownloadedContentArray(boolean forceRefresh) {
        try {
            ObjReference objRef;
            LuDownloadedContentPool contentPool;
            DataobjectManager manager = DataobjectManager.getInstance();
            GlobalObjectPool globalPool = manager.getSemConfigRoot().getOptGlobalObjectPool();
            if (globalPool != null && (contentPool = globalPool.getOptLuDownloadedContentPool()) != null && (objRef = contentPool.getObjReference()) != null) {
                return (LuDownloadedContentArray)manager.getObjectByGUID("LuDownloadedContentArray", objRef.getTargetId(), forceRefresh);
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return null;
    }

    public static LuDownloadedContent getTheLatestHIContent(String platform) throws Exception {
        String clientMoniker = LuUtility.getClientMonikerByPlatform(platform);
        if (StringUtilities.isEmpty((String)clientMoniker)) {
            return null;
        }
        return LuUtility.getHIContentByClientMoniker(clientMoniker);
    }

    private static LuDownloadedContent getHIContentByClientMoniker(String clientMoniker) {
        LuDownloadedContentArray contentArray = LuUtility.getLuDownloadedContentArray();
        LuDownloadedContent latest = null;
        long latestSeq = -1L;
        if (contentArray != null) {
            for (LuDownloadedContent content : contentArray.getLuDownloadedContent()) {
                long seq;
                if (!clientMoniker.equals(content.getOptClientMoniker()) || (seq = Long.parseLong(content.getSequenceNum())) <= latestSeq) continue;
                latest = content;
                latestSeq = seq;
            }
        }
        return latest;
    }

    private static String getClientMonikerByPlatform(String platform) {
        String moniker = null;
        if ("WIN32BIT".equals(platform) || "WIN64BIT".equals(platform)) {
            moniker = "{1AD331AC-DEF8-4f6f-A7B5-7B259423BBCF}";
        } else if ("Mac".equals(platform)) {
            moniker = "{A59DBC4F-23E6-41e0-BD2F-96EC0F2BD7E0}";
        }
        return moniker;
    }

    public static LuContentCategory getLuCategoryForSite(String categoryName) {
        List<LuContentCategory> allCategories = LuUtility.getAllLuCategories(true, false);
        for (int i = 0; i < allCategories.size(); ++i) {
            LuContentCategory category = allCategories.get(i);
            if (!categoryName.equals(category.getName())) continue;
            return category;
        }
        return null;
    }

    public static Vector<LuCategory> getSupportedLuContentTypesForEdit(Vector<LuCategory> luTypes) {
        LicenseObject licObj = LicenseObject.getInstance();
        Vector<LuCategory> supportedTypes = new Vector<LuCategory>();
        if (luTypes != null) {
            int size = luTypes.size();
            for (int index = 0; index < size; ++index) {
                String categoryName = luTypes.get(index).getCategoryName();
                if ("SESM_CONTENT_CATALOG".equals(categoryName) || "SEPM_API".equals(categoryName) || "SEPM_METADATA".equals(categoryName) || !licObj.isQualifiedLuContentCategory(categoryName)) continue;
                supportedTypes.add(luTypes.get(index));
            }
        }
        return supportedTypes;
    }

    private static boolean isEmptyLuCategoryGroup(LuContentCategoryGroup group, boolean forSite) {
        for (int j = 0; j < group.getLuContentCategoryCount(); ++j) {
            if (!LuUtility.isQualifiedLuCategory(group.getLuContentCategory(j), forSite)) continue;
            return false;
        }
        return true;
    }

    private static boolean isQualifiedLuCategory(LuContentCategory luCategory, boolean forSite) {
        return LicenseObject.getInstance().isQualifiedLuContentCategory(luCategory.getName()) && (!forSite && !Utility.getBooleanValue((Boolean)luCategory.getOptServerOnly(), (Boolean)luCategory.getDefServerOnly()) || forSite && !luCategory.getName().equals("SESM_CONTENT_CATALOG") && !luCategory.getName().equals("SEPM_API") && !luCategory.getName().equals("SEPM_METADATA") && !luCategory.getName().equals("RU5_IGNORE_CATEGORY"));
    }

    public static ContentVersionInfo getContentVersionInfo(String clientMoniker, LuAppliedContentObject appliedContentObject) {
        if (appliedContentObject == null || clientMoniker == null) {
            return null;
        }
        for (int i = 0; i < appliedContentObject.getAllContentsCount(); ++i) {
            if (!clientMoniker.equals(appliedContentObject.getContentMoniker(i))) continue;
            return appliedContentObject.getContentVersionInfo(i);
        }
        return null;
    }

    public static boolean isAbleToSetASpecificRevision(LuContentCategoryGroup categoryGroup) {
        if (categoryGroup == null || categoryGroup.getLuContentCategoryCount() == 0) {
            return false;
        }
        for (int i = 0; i < categoryGroup.getLuContentCategoryCount(); ++i) {
            LuContentCategory luCategory = categoryGroup.getLuContentCategory(i);
            if (!Utility.getBooleanValue((Boolean)luCategory.getOptNamedRevisionAllowed(), (Boolean)luCategory.getDefNamedRevisionAllowed())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGroupPolicyUseLiveUpdateServer(GroupObject tempGroup) {
        boolean liveUpdateServerEnabled = false;
        try {
            GroupPolicyObject apObj = PolicyHandler.getGroupPolicyByGroup(tempGroup);
            LocationObject defaultLoc = PolicyHandler.getDefaultLocation(apObj.getAutoLocation().getAutoLocation());
            PolicyInt pInt = defaultLoc.getAppliedPolicyObject().getPolicy(new LiveUpdateObject());
            LuPolicy luPolicy = (LuPolicy)pInt.getSchemaObj();
            if (luPolicy != null) {
                LuContentSourceInfo luConInfo = luPolicy.getOptLuContentSourceInfo();
                if (luConInfo != null) {
                    liveUpdateServerEnabled = luConInfo.getOptUseLiveUpdateServer() == null ? false : luConInfo.getOptUseLiveUpdateServer();
                }
                System.out.println("luPolicy.getOptLuContentSourceInfo() isNull2 " + (luConInfo == null));
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            return false;
        }
        return liveUpdateServerEnabled;
    }

    public static String getDisplaySequenceNum(String seqNum) {
        return RevisionObject.convertSequenceToRevUIFormat(seqNum);
    }

    public static void reRegisterLiveUpdateEntries() throws ConsoleException {
        try {
            GUIManager.publishLuInventory();
        }
        catch (ConsoleException e) {
            System.out.println("SoftwarePackageHandler>> reRegisterLiveUpdateEntries: ConsoleException: " + e.getErrorCodeString());
            throw e;
        }
        catch (Exception ex) {
            System.out.println("SoftwarePackageHandler>> reRegisterLiveUpdateEntries: Exception: " + ex.getMessage());
            throw new ConsoleException(ex);
        }
    }

    public static boolean isLatestHIContentLibrayExisted(String platform) throws ConsoleException {
        LuDownloadedContentArray luContentArray = LuUtility.getLuDownloadedContentArray();
        return LuHIContentHelper.isLatestHIContentLibrayExisted((String)platform, (LuDownloadedContentArray)luContentArray);
    }

    public static boolean is11xHIContentExisted() throws ConsoleException {
        ObjReference ref;
        HiReqTemplateLibraryPool hiPool;
        DataobjectManager manager = DataobjectManager.getInstance();
        GlobalObjectPool globalPool = manager.getSemConfigRoot().getOptGlobalObjectPool();
        if (globalPool != null && (hiPool = globalPool.getOptHiReqTemplateLibraryPool()) != null && hiPool.getObjReferenceCount() > 0 && (ref = hiPool.getObjReference(0)) != null) {
            HiReqTemplateLibrary lib = manager.getHiReqTemplateLibrary(ref.getTargetId());
            return LuHIContentHelper.is11xHIContentExisted((HiReqTemplateLibrary)lib);
        }
        return false;
    }

    public static boolean canApplyHIPolicy() throws ConsoleException {
        return LuUtility.isLatestHIContentLibrayExisted("WIN32BIT") || LuUtility.is11xHIContentExisted() || LuUtility.isLatestHIContentLibrayExisted("Mac");
    }

    public static ArrayList<GroupObject> checkHIContentAvailable(List<GroupObject> selectedGroups, List<SoftwarePackage> selectedPackages) throws Exception {
        if (selectedGroups == null || selectedGroups.size() == 0 || selectedPackages == null || selectedPackages.size() == 0) {
            return null;
        }
        ArrayList<GroupObject> groupsCheck = new ArrayList<GroupObject>();
        LicenseObject licObj = LicenseObject.getInstance();
        if (!licObj.isSBProduct() && (licObj.isSNACOnlyProduct() || licObj.isALLProduct())) {
            for (GroupObject group : selectedGroups) {
                if (!PolicyHandler.isHIPolicyAppliedOnSelectedGroup(group)) continue;
                groupsCheck.add(group);
            }
        }
        if (groupsCheck.size() == 0) {
            return null;
        }
        for (SoftwarePackage sp : selectedPackages) {
            String platform = PackageUtil.getSoftwarePackagePlatformType((SoftwarePackage)sp);
            int version = PackageUtil.getCIPVersion((SoftwarePackage)sp);
            int packageType = sp.getPackageInfo().getType();
            if ("Mac".equalsIgnoreCase(platform) && packageType == 105 || ("LINUXDPKG".equalsIgnoreCase(platform) || "LINUXRPM".equalsIgnoreCase(platform)) && packageType == 105) continue;
            if (1 == version && !LuUtility.isLatestHIContentLibrayExisted(platform) && !LuUtility.is11xHIContentExisted()) {
                return groupsCheck;
            }
            if (2 != version || LuUtility.isLatestHIContentLibrayExisted(platform)) continue;
            return groupsCheck;
        }
        return null;
    }

    private static HashMap<String, String> getLegacyMonikers(LuContentCategory luCategoryParam) {
        HashMap<String, String> legacydata = new HashMap<String, String>();
        for (int i = 0; i < luCategoryParam.getLuRegistrationCount(); ++i) {
            LuRegistration luReg = luCategoryParam.getLuRegistration(i);
            LuClientRegistration luClientReg = luReg.getOptLuClientRegistration();
            if (luClientReg == null || luClientReg.getLegacyMonikerCount() <= 0) continue;
            for (int j = 0; j < luClientReg.getLegacyMonikerCount(); ++j) {
                legacydata.put(luClientReg.getLegacyMoniker(j).getMoniker(), luClientReg.getMoniker());
            }
        }
        return legacydata;
    }

    private static List<String> getAllClientMonikersForLuContentPolicyForEachCategory(LuContentCategory luCategory) {
        HashMap<String, String> legacyMonikers = LuUtility.getLegacyMonikers(luCategory);
        ArrayList<String> clientMonikers = new ArrayList<String>();
        int luRegistrationCount = luCategory.getLuRegistrationCount();
        for (int i = 0; i < luRegistrationCount; ++i) {
            LuRegistration luReg = luCategory.getLuRegistration(i);
            LuClientRegistration luClientReg = luReg.getOptLuClientRegistration();
            if (luClientReg == null) continue;
            String groupMoniker = luReg.getLuServerRegistration().getOptGroupMoniker();
            String hubMoniker = luReg.getLuServerRegistration().getOptHubMoniker();
            if (groupMoniker != null && hubMoniker == null || legacyMonikers.containsKey(luClientReg.getMoniker())) continue;
            clientMonikers.add(luClientReg.getMoniker());
        }
        return clientMonikers;
    }

    public static List<String> getAllClientMonikersForLuContentPolicyForEachCategory(String category) {
        List<LuContentCategoryGroup> categoryGroups = LuUtility.getAllLuCategoryGroups();
        int categoryGroupSize = categoryGroups.size();
        for (int i = 0; i < categoryGroupSize; ++i) {
            LuContentCategoryGroup categoryGroup = categoryGroups.get(i);
            int luContentCategoryCount = categoryGroup.getLuContentCategoryCount();
            for (int j = 0; j < luContentCategoryCount; ++j) {
                if (!categoryGroup.getLuContentCategory(j).getName().equalsIgnoreCase(category)) continue;
                return LuUtility.getAllClientMonikersForLuContentPolicyForEachCategory(categoryGroup.getLuContentCategory(j));
            }
        }
        return new ArrayList<String>(0);
    }

    private static List<String> getAllEngineVersionsForLuContentPolicyForEachCategory(LuContentCategory luCategory) {
        HashMap<String, String> legacyMonikers = LuUtility.getLegacyMonikers(luCategory);
        int luRegistrationCount = luCategory.getLuRegistrationCount();
        for (int i = 0; i < luRegistrationCount; ++i) {
            LuRegistration luReg = luCategory.getLuRegistration(i);
            LuClientRegistration luClientReg = luReg.getOptLuClientRegistration();
            if (luClientReg == null) continue;
            String groupMoniker = luReg.getLuServerRegistration().getOptGroupMoniker();
            String hubMoniker = luReg.getLuServerRegistration().getOptHubMoniker();
            if (groupMoniker != null && hubMoniker == null || legacyMonikers.containsKey(luClientReg.getMoniker())) continue;
            LuUtility.getAllAvailableContentEngineVersions(luClientReg.getMoniker(), luCategory);
        }
        return new ArrayList<String>(0);
    }

    public static List<String> getAllEngineVersionsForLuContentPolicyForEachCategory(String category) {
        List<LuContentCategoryGroup> categoryGroups = LuUtility.getAllLuCategoryGroups();
        int categoryGroupSize = categoryGroups.size();
        for (int i = 0; i < categoryGroupSize; ++i) {
            LuContentCategoryGroup categoryGroup = categoryGroups.get(i);
            int luContentCategoryCount = categoryGroup.getLuContentCategoryCount();
            for (int j = 0; j < luContentCategoryCount; ++j) {
                if (!categoryGroup.getLuContentCategory(j).getName().equalsIgnoreCase(category)) continue;
                return LuUtility.getAllEngineVersionsForLuContentPolicyForEachCategory(categoryGroup.getLuContentCategory(j));
            }
        }
        return new ArrayList<String>(0);
    }

    public static String getLatestAvailableContentSeqForMoniker(String clientMoniker) {
        LuDownloadedContentArray contentArray = LuUtility.getLuDownloadedContentArray();
        long latestSeq = 0L;
        if (contentArray != null) {
            for (int i = contentArray.getLuDownloadedContentCount() - 1; i >= 0; --i) {
                LuDownloadedContent content = contentArray.getLuDownloadedContent(i);
                if (content.getOptClientMoniker() == null || !clientMoniker.equals(content.getOptClientMoniker())) continue;
                try {
                    long seq = Long.parseLong(content.getSequenceNum());
                    if (seq <= latestSeq) continue;
                    latestSeq = seq;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    LoggerUtilities.logException((Throwable)nfe);
                }
            }
        }
        if (latestSeq != 0L) {
            return String.valueOf(latestSeq);
        }
        return null;
    }

    public static String getLatestAvailableContentEngineForMoniker(String clientMoniker) {
        LuDownloadedContentArray contentArray = LuUtility.getLuDownloadedContentArray();
        long latestEngine = 0L;
        if (contentArray != null) {
            for (int i = contentArray.getLuDownloadedContentCount() - 1; i >= 0; --i) {
                LuDownloadedContent content = contentArray.getLuDownloadedContent(i);
                if (content.getOptClientMoniker() == null || !clientMoniker.equals(content.getOptClientMoniker()) || content.getOptEngineNum() == null) continue;
                try {
                    long engine = Long.parseLong(content.getOptEngineNum());
                    if (engine <= latestEngine) continue;
                    latestEngine = engine;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    LoggerUtilities.logException((Throwable)nfe);
                }
            }
        }
        if (latestEngine != 0L) {
            return String.valueOf(latestEngine);
        }
        return null;
    }

    public static LuRegistration getSFContentLuRegistration(String platformType, String version, String language) {
        String product = null;
        switch (platformType) {
            case "WIN32BIT": {
                product = SF_PRODUCT_WIN32;
                break;
            }
            case "WIN64BIT": {
                product = SF_PRODUCT_WIN64;
                break;
            }
            default: {
                return null;
            }
        }
        System.out.println("getSFContentLuRegistration > " + platformType);
        for (LuContentCategory category : LuUtility.getAllLuCategories()) {
            if (!category.getName().equals("SECURITY_FIX")) continue;
            for (int i = 0; i < category.getLuRegistrationCount(); ++i) {
                LuRegistration luReg = category.getLuRegistration(i);
                LuServerRegistration luServerReg = luReg.getLuServerRegistration();
                if (!luServerReg.getProduct().startsWith(product) || !luServerReg.getVersion().equalsIgnoreCase(version) || !luServerReg.getLanguage().equalsIgnoreCase(language)) continue;
                return luReg;
            }
        }
        return null;
    }

    public static LuContentSizeSelection getLuContentSizeSelection(int categoryIndex) {
        try {
            LuConfig luConfig = DataobjectManager.getInstance().getSemSite(Manager.getCurrentSiteId()).getOptLuConfig();
            if (luConfig == null) {
                return null;
            }
            LuContentSizeSelections luContentSizeSelections = luConfig.getOptLuContentSizeSelections();
            if (luContentSizeSelections == null) {
                return null;
            }
            return luContentSizeSelections.getLuContentSizeSelection(categoryIndex);
        }
        catch (ConsoleException ex) {
            System.out.println("getLuContentSizeSelection > " + ex.getMessage());
            return null;
        }
    }
}

