/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.CentralLuServer;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.lu.LUAdvanceServerSettingsDlg;
import com.sygate.scm.console.ui.policy.lu.LiveUpdateServerPanel;
import com.sygate.scm.console.ui.policy.lu.LuServerDialog;
import com.sygate.scm.console.ui.policy.lu.logiobject.CentralLuServerObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuContentSourceInfoObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LuServerPanel
extends JPanel {
    private static final long serialVersionUID = -4076711041924313040L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private JRadioButton jRBDefault = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuServerPanel.radiobutton.default"));
    private JRadioButton jRBSpecified = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuServerPanel.radiobutton.specified"));
    private JRadioButton jRBEarlyAdopter = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuServerPanel.radiobutton.earlyadopter"));
    private JTable jTServer = new StripesTable();
    private static final String[] TABLE_COLUMNS = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuServerPanel.table.name"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuServerPanel.table.address")};
    private JScrollPane scrollPane;
    private JButton jBAdd;
    private JButton jBEdit;
    private JButton jBDelete;
    private JButton jBMoveUp;
    private JButton jBMoveDown;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem addServerMenuItem;
    private JMenuItem editServerMenuItem;
    private JMenuItem deleteServerMenuItem;
    private JMenuItem moveUpServerMenuItem;
    private JMenuItem moveDownServerMenuItem;
    private HtmlEnabledJLabel jLablAdvServerSettings = new HtmlEnabledJLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuServerPanel.label.advanceServerSettings"), true);
    private static final String ADVANCED_SETTINGS_TOOLTIP_TEXT = MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuServerPanel.label.advanceServerSettingsToolTip");
    private LuContentSourceInfoObject sourceInfoObj;
    private boolean isReadOnly;
    private int platformType = 1;
    private boolean isSEPMServer;
    private final JPanel parent;

    public LuServerPanel() {
        this(null, 1, true);
    }

    public LuServerPanel(int platformType) {
        this(null, platformType, false);
    }

    public LuServerPanel(JPanel parent, int platformType) {
        this(parent, platformType, false);
    }

    private LuServerPanel(JPanel parent, int platformType, boolean isSEPMServer) {
        this.parent = parent;
        this.platformType = platformType;
        this.isSEPMServer = isSEPMServer;
        this.initialize();
    }

    public void setObject(LuContentSourceInfoObject sourceInfoObj) {
        this.sourceInfoObj = sourceInfoObj;
        this.updatePanel();
    }

    public void save() {
        Integer type = null;
        if (this.jRBSpecified.isSelected()) {
            type = LuContentSourceInfo.INTERNAL;
        } else if (this.jRBEarlyAdopter.isSelected()) {
            type = LuContentSourceInfo.EAS;
        }
        Integer oldType = this.sourceInfoObj.getSchemaObject().getOptLiveUpdateServerType();
        if (!Utility.isSameObject((Object)type, (Object)oldType)) {
            this.sourceInfoObj.setLiveUpdateServerType(type);
        }
        Vector luServers = (Vector)Cast.cast(((SortableTableModel)this.jTServer.getModel()).getDataVector());
        this.sourceInfoObj.setCentralLuServers(luServers);
    }

    public void adjustServerType(boolean isLuServerSelected) {
        if (!isLuServerSelected && this.jRBEarlyAdopter.isSelected()) {
            this.jRBEarlyAdopter.setSelected(false);
            this.jRBDefault.setSelected(true);
        }
    }

    public boolean isValidate() {
        String errorKey = this.validateCentralLuServers();
        if (null != errorKey) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, errorKey), MSGRES.getString(LU, "LuServerPanel.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.isReadOnly = !enable;
        this.jRBDefault.setEnabled(enable);
        this.jRBEarlyAdopter.setEnabled(enable);
        this.jRBSpecified.setEnabled(enable);
        this.serverStateChanged();
    }

    public boolean isEarlyAdopterSelected() {
        return this.jRBEarlyAdopter.isSelected();
    }

    private String validateCentralLuServers() {
        int i;
        SortableTableModel luServerTableModel = (SortableTableModel)this.jTServer.getModel();
        int count = luServerTableModel.getRowCount();
        for (i = count - 1; i >= 0; --i) {
            CentralLuServerObject obj = (CentralLuServerObject)luServerTableModel.getRow(i);
            if (obj.getName() != null && obj.getName().trim().length() > 0 && obj.getURL() != null && obj.getURL().trim().length() > 0) continue;
            luServerTableModel.removeRow(i);
        }
        if (!this.jRBSpecified.isSelected()) {
            return null;
        }
        count = luServerTableModel.getRowCount();
        if (0 == count) {
            return "LuServerPanel.errorMsg";
        }
        if (this.isSEPMServer) {
            for (i = 0; i < count; ++i) {
                Integer protocol = ((CentralLuServerObject)luServerTableModel.getRow(i)).getProtocol();
                if (!CentralLuServer.FTP.equals(protocol) && !CentralLuServer.LAN.equals(protocol)) continue;
                return "LuServerPanel.errorMsgSepmFtpOrLan";
            }
        }
        if (this.platformType == 3 && count > 10) {
            return "LuServerPanel.errorMsgMaxServerLimitation";
        }
        return null;
    }

    private void addServer() {
        LuServerDialog dlg = new LuServerDialog(null, false, this.platformType, this.isSEPMServer);
        if (dlg.isOk()) {
            int rows = ((SortableTableModel)this.jTServer.getModel()).getRowCount();
            SortableTableModel model = (SortableTableModel)this.jTServer.getModel();
            if (rows != -1) {
                for (int i = 0; i < rows; ++i) {
                    CentralLuServerObject obj = (CentralLuServerObject)model.getRow(i);
                    if (!obj.getName().equals(dlg.getObject().getName())) continue;
                    JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuServerPanel.duplicateErrorMsg"), MSGRES.getString(LU, "LuServerPanel.duplicateErrorTitle"), 0);
                    return;
                }
            }
            ((SortableTableModel)this.jTServer.getModel()).addRow(dlg.getObject());
        }
        dlg.dispose();
    }

    private void editServer() {
        int selRow = this.jTServer.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        SortableTableModel model = (SortableTableModel)this.jTServer.getModel();
        CentralLuServerObject obj = (CentralLuServerObject)model.getRow(selRow);
        LuServerDialog dlg = new LuServerDialog(obj, this.isReadOnly, this.platformType, this.isSEPMServer);
        if (dlg.isOk()) {
            ((SortableTableModel)this.jTServer.getModel()).setRow(selRow, dlg.getObject());
        }
        dlg.dispose();
    }

    private void deleteServer() {
        int row = this.jTServer.getSelectedRow();
        if (row == -1) {
            return;
        }
        int choice = JOptionPane.showConfirmDialog(Manager.getFrame(), MSGRES.getString(LU, "LuServerPanel.delete.removeServer"), MSGRES.getString(LU, "LuServerPanel.delete.confirm"), 0);
        if (choice == 0) {
            ((SortableTableModel)this.jTServer.getModel()).removeRow(row);
        }
    }

    private void moveUpServer() {
        int row = this.jTServer.getSelectedRow();
        if (row == -1) {
            return;
        }
        if (row > 0) {
            ((SortableTableModel)this.jTServer.getModel()).moveRow(row, row, row - 1);
            this.jTServer.setRowSelectionInterval(row - 1, row - 1);
        }
    }

    private void moveDownServer() {
        int row = this.jTServer.getSelectedRow();
        if (row == -1) {
            return;
        }
        int rowCount = ((SortableTableModel)this.jTServer.getModel()).getRowCount();
        if (row < rowCount - 1 && rowCount > 1) {
            ((SortableTableModel)this.jTServer.getModel()).moveRow(row, row, row + 1);
            this.jTServer.setRowSelectionInterval(row + 1, row + 1);
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        int gridy = 0;
        this.add((Component)this.jRBDefault, new GridBagConstraints(0, gridy++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 14, 0, 0), 0, 0));
        if (this.platformType == 1) {
            this.jRBEarlyAdopter.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LuServerPanel.this.earlyAdopterStateChanged();
                }
            });
            this.add((Component)this.jRBEarlyAdopter, new GridBagConstraints(0, gridy++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 14, 0, 0), 0, 0));
        }
        this.jRBSpecified.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LuServerPanel.this.serverStateChanged();
            }
        });
        this.add((Component)this.jRBSpecified, new GridBagConstraints(0, gridy++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 14, 0, 0), 0, 0));
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBDefault);
        group.add(this.jRBEarlyAdopter);
        group.add(this.jRBSpecified);
        this.createServerTable();
        this.scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)this.scrollPane, (JTable)this.jTServer);
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (LuServerPanel.this.jTServer.isEnabled()) {
                    LuServerPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (LuServerPanel.this.jTServer.isEnabled()) {
                    LuServerPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && LuServerPanel.this.jTServer.isEnabled()) {
                    LuServerPanel.this.editServer();
                }
            }
        });
        this.add((Component)this.scrollPane, new GridBagConstraints(0, gridy, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 18, 0, 0), 0, 0));
        JPanel buttonPanel = this.createButtonsAndPopupMenu();
        int panelTopMargin = this.jTServer.getTableHeader().getPreferredSize().height - buttonPanel.getBorder().getBorderInsets((Component)buttonPanel).top;
        this.add((Component)buttonPanel, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 1.0, 10, 3, new Insets(panelTopMargin, 5, 0, 0), 0, 0));
        if (!this.isSEPMServer) {
            JPanel linkPanel = this.createAdvancedSettingsLink();
            this.add((Component)linkPanel, new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 300, 0, 0), 0, 0));
        }
    }

    private JPanel createButtonsAndPopupMenu() {
        AbstractAction addServerAction = new AbstractAction(UIText.get(5)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LuServerPanel.this.addServer();
            }
        };
        this.jBAdd = new JButton(addServerAction);
        this.jBAdd.setText(UIText.get(5));
        this.addServerMenuItem = new JMenuItem(addServerAction);
        AbstractAction editServerAction = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LuServerPanel.this.editServer();
            }
        };
        this.jBEdit = new JButton(editServerAction);
        this.jBEdit.setText(UIText.get(1024));
        this.editServerMenuItem = new JMenuItem(editServerAction);
        AbstractAction deleteServerAction = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LuServerPanel.this.deleteServer();
            }
        };
        this.jBDelete = new JButton(deleteServerAction);
        this.jBDelete.setText(UIText.get(769));
        this.deleteServerMenuItem = new JMenuItem(deleteServerAction);
        AbstractAction moveUpServerAction = new AbstractAction(UIText.get(3075)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LuServerPanel.this.moveUpServer();
            }
        };
        this.jBMoveUp = new JButton(moveUpServerAction);
        this.jBMoveUp.setText(UIText.get(3075));
        this.moveUpServerMenuItem = new JMenuItem(moveUpServerAction);
        AbstractAction moveDownServerAction = new AbstractAction(UIText.get(3074)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LuServerPanel.this.moveDownServer();
            }
        };
        this.jBMoveDown = new JButton(moveDownServerAction);
        this.jBMoveDown.setText(UIText.get(3074));
        this.moveDownServerMenuItem = new JMenuItem(moveDownServerAction);
        JPanel buttonPanel = new JPanel();
        UIUtilities.layoutButtonPanel(buttonPanel, new JButton[]{this.jBAdd, this.jBEdit, this.jBDelete, this.jBMoveUp, this.jBMoveDown}, 1, 1, true);
        this.popup.add(this.addServerMenuItem);
        this.popup.add(this.editServerMenuItem);
        this.popup.add(this.deleteServerMenuItem);
        this.popup.addSeparator();
        this.popup.add(this.moveUpServerMenuItem);
        this.popup.add(this.moveDownServerMenuItem);
        this.addServerMenuItem.setEnabled(false);
        this.editServerMenuItem.setEnabled(false);
        this.deleteServerMenuItem.setEnabled(false);
        this.moveUpServerMenuItem.setEnabled(false);
        this.moveDownServerMenuItem.setEnabled(false);
        return buttonPanel;
    }

    private JTable createServerTable() {
        SortableTableModel serverModel = new SortableTableModel(TABLE_COLUMNS, null);
        this.jTServer.setModel(serverModel);
        serverModel.addMouseListenerToHeaderInTable(this.jTServer);
        Dimension size = this.jTServer.getPreferredScrollableViewportSize();
        this.jTServer.setPreferredScrollableViewportSize(new Dimension((int)((double)size.width * 0.8), (this.jTServer.getRowHeight() + this.jTServer.getRowMargin()) * 5));
        this.jTServer.getSelectionModel().setSelectionMode(0);
        this.jTServer.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LuServerPanel.this.tableSelectionChanged();
            }
        });
        this.jTServer.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (LuServerPanel.this.jTServer.isEnabled()) {
                    LuServerPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (LuServerPanel.this.jTServer.isEnabled()) {
                    LuServerPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && LuServerPanel.this.jTServer.isEnabled()) {
                    LuServerPanel.this.editServer();
                }
            }
        });
        return this.jTServer;
    }

    private JPanel createAdvancedSettingsLink() {
        this.jLablAdvServerSettings.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LUAdvanceServerSettingsDlg advanceServerSettingsDlg;
                if (LuServerPanel.this.jRBSpecified.isEnabled() && (advanceServerSettingsDlg = new LUAdvanceServerSettingsDlg(LuServerPanel.this.sourceInfoObj, LuServerPanel.this.platformType)).isOk()) {
                    LuServerPanel.this.sourceInfoObj = advanceServerSettingsDlg.getLuContentSourceInfoObject();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        this.jLablAdvServerSettings.setToolTipText(ADVANCED_SETTINGS_TOOLTIP_TEXT);
        this.jLablAdvServerSettings.putClientProperty((Object)"mouseEventListener", (Object)"onClick");
        JPanel linkPanel = new JPanel(new FlowLayout(0, 0, 0));
        linkPanel.add((Component)this.jLablAdvServerSettings);
        if (this.platformType == 3) {
            linkPanel.add(Box.createHorizontalStrut(5));
            linkPanel.add(UIUtilities.getDeprecatedOnLinuxLabel(UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP));
        }
        return linkPanel;
    }

    private void serverStateChanged() {
        boolean isEnabled = this.jRBSpecified.isEnabled() && this.jRBSpecified.isSelected();
        boolean isReadonlyEnabled = this.isReadOnly && this.jRBSpecified.isSelected();
        this.jTServer.setEnabled(isEnabled || isReadonlyEnabled);
        this.scrollPane.setEnabled(isEnabled || isReadonlyEnabled);
        this.jBAdd.setEnabled(isEnabled);
        this.addServerMenuItem.setEnabled(isEnabled);
        this.popup.setEnabled(isEnabled);
        this.tableSelectionChanged();
    }

    private void tableSelectionChanged() {
        boolean isSelected = !this.isReadOnly && this.jTServer.isEnabled() && this.jTServer.getSelectedRowCount() > 0;
        boolean isReadonlyEnabled = this.isReadOnly && this.jTServer.isEnabled() && this.jTServer.getSelectedRowCount() > 0;
        this.jBEdit.setEnabled(isSelected || isReadonlyEnabled);
        this.editServerMenuItem.setEnabled(isSelected || isReadonlyEnabled);
        this.jBDelete.setEnabled(isSelected);
        this.deleteServerMenuItem.setEnabled(isSelected);
        this.jBMoveUp.setEnabled(isSelected);
        this.moveUpServerMenuItem.setEnabled(isSelected);
        this.jBMoveDown.setEnabled(isSelected);
        this.moveDownServerMenuItem.setEnabled(isSelected);
        if (this.jTServer.getSelectedRow() <= 0) {
            this.jBMoveUp.setEnabled(false);
            this.moveUpServerMenuItem.setEnabled(false);
        }
        if (this.jTServer.getSelectedRow() == this.jTServer.getRowCount() - 1) {
            this.jBMoveDown.setEnabled(false);
            this.moveDownServerMenuItem.setEnabled(false);
        }
        if (this.jTServer.getRowCount() <= 1) {
            this.jBMoveUp.setEnabled(false);
            this.moveUpServerMenuItem.setEnabled(false);
            this.jBMoveDown.setEnabled(false);
            this.moveDownServerMenuItem.setEnabled(false);
        }
    }

    private void updatePanel() {
        this.jRBDefault.setSelected(this.sourceInfoObj.isUseSymantecServerType());
        this.jRBEarlyAdopter.setSelected(LuContentSourceInfo.EAS.compareTo(this.sourceInfoObj.getLiveUpdateServerType()) == 0);
        this.jRBSpecified.setSelected(LuContentSourceInfo.INTERNAL.compareTo(this.sourceInfoObj.getLiveUpdateServerType()) == 0);
        ((SortableTableModel)this.jTServer.getModel()).setDataVector((Vector)Cast.cast(this.sourceInfoObj.getCentralServers()));
        this.serverStateChanged();
    }

    private void showPopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        int row = this.jTServer.rowAtPoint(p);
        if (row >= 0) {
            this.jTServer.setRowSelectionInterval(row, row);
        }
        this.popup.show(this.jTServer, e.getX(), e.getY());
    }

    private void earlyAdopterStateChanged() {
        if (this.parent instanceof LiveUpdateServerPanel) {
            boolean isEnabled = this.jRBEarlyAdopter.isEnabled() && this.jRBEarlyAdopter.isSelected();
            boolean isReadonlyEnabled = this.isReadOnly && this.jRBEarlyAdopter.isSelected();
            ((LiveUpdateServerPanel)this.parent).updateUseManagementServer(isEnabled || isReadonlyEnabled);
        }
    }
}

