/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.CentralLuServer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.logiobject.CentralLuServerObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LuServerDialog
extends DialogBase {
    private static final long serialVersionUID = -1374498790737333724L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private JTextField jTFServerName = new JTextField("", 30);
    private JTextArea jTADesc = new JTextArea("", 3, 40);
    private JTextField jTFUrlPath = new JTextField();
    private JTextField jTFUserName = new JTextField();
    private JPasswordField jPFPassword = new SEPMPasswordField();
    private CentralLuServerObject luServerObj;
    private Integer protocol;
    private int platformType;
    private boolean isSEPMServer;

    public LuServerDialog(CentralLuServerObject luServerObj, boolean isReadonly, int platformType, boolean isSEPMServer) {
        super(Manager.getFrame(), luServerObj == null ? MSGRES.getString(LU, "LuServerDialog.title.add") : MSGRES.getString(LU, "LuServerDialog.title.edit"), true);
        this.initialize(isReadonly);
        this.platformType = platformType;
        this.isSEPMServer = isSEPMServer;
        this.setObject(luServerObj);
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public CentralLuServerObject getObject() {
        return this.luServerObj;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_servers_dialog_site_properties_lu_edit_server_add";
    }

    @Override
    protected boolean isValidate() {
        String errorKey = this.validateName();
        if (null == errorKey) {
            errorKey = this.validateUrl();
        }
        if (null != errorKey) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, errorKey), MSGRES.getString(LU, "LuServerDialog.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.luServerObj.setName(this.jTFServerName.getText().trim());
        this.luServerObj.setDescription(this.jTADesc.getText().trim());
        this.luServerObj.setURL(this.jTFUrlPath.getText().trim());
        this.luServerObj.setUserName(this.jTFUserName.getText().trim());
        this.luServerObj.setPassword(new String(this.jPFPassword.getPassword()));
        this.luServerObj.setProtocol(this.protocol);
    }

    private void initialize(boolean isReadonly) {
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel serverPanel = this.getServerPanel();
        this.getContentPane().add((Component)serverPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jTADesc.setFocusTraversalKeys(0, null);
        this.jTADesc.setFocusTraversalKeys(1, null);
        if (isReadonly) {
            UIUtilities.setContainerStatus(serverPanel, false);
            this.resetOKButton(false);
        }
    }

    private JPanel getServerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(20, 40, 20, 40));
        panel.add((Component)new JLabel(MSGRES.getString(LU, "LuServerDialog.label.serverName")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
        doc.setValidator(",{}[]()+=#$~^/\\*?<>|:\"", false);
        this.jTFServerName.setDocument(doc);
        panel.add((Component)this.jTFServerName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        RestrictedPlainDocument descDoc = new RestrictedPlainDocument(1000);
        descDoc.setValidator("/<>\"", false);
        this.jTADesc.setDocument(descDoc);
        panel.add((Component)new JLabel(MSGRES.getString(LU, "LuServerDialog.label.description")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        JScrollPane descScrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)descScrollPane, (JTextArea)this.jTADesc);
        descScrollPane.setVerticalScrollBarPolicy(20);
        descScrollPane.setHorizontalScrollBarPolicy(31);
        panel.add((Component)descScrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MSGRES.getString(LU, "LuServerDialog.label.path")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFUrlPath, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MSGRES.getString(LU, "LuServerDialog.label.userName")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        RestrictedPlainDocument userNameDoc = new RestrictedPlainDocument(255);
        userNameDoc.setValidator(",{}[]()+=#$/*?<>|:\"", false);
        this.jTFUserName.setDocument(userNameDoc);
        panel.add((Component)this.jTFUserName, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MSGRES.getString(LU, "LuServerDialog.label.password")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jPFPassword, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(15, 25, 5, 25));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "LuServerDialog.label.title"), MSGRES.getString(LU, "LuServerDialog.label.titleDesc"), false), "North");
        wrapPanel.add((Component)panel, "Center");
        return wrapPanel;
    }

    private void setObject(CentralLuServerObject luServerObj) {
        if (luServerObj == null) {
            luServerObj = new CentralLuServerObject();
        }
        this.luServerObj = luServerObj;
        this.jTFServerName.setText(luServerObj.getName());
        this.jTADesc.setText(luServerObj.getDescription());
        this.jTFUrlPath.setText(luServerObj.getURL());
        this.jTFUserName.setText(luServerObj.getUserName());
        this.jPFPassword.setText(luServerObj.getPassword());
    }

    private String validateName() {
        if (this.jTFServerName.getText().trim().length() == 0) {
            return "LuServerDialog.nameError";
        }
        return null;
    }

    private String validateUrl() {
        String urlPath = this.jTFUrlPath.getText().trim();
        if (urlPath == null || urlPath.length() == 0) {
            return "LuServerDialog.emptyPath";
        }
        boolean isValid = true;
        if (urlPath.startsWith("\\\\") || urlPath.startsWith("//")) {
            this.protocol = CentralLuServer.LAN;
            if (urlPath.length() <= 2) {
                isValid = false;
            }
        } else {
            try {
                URL url = new URL(urlPath);
                String protocolStr = url.getProtocol();
                if (protocolStr == null || protocolStr.trim().length() == 0) {
                    isValid = false;
                } else if (protocolStr.equalsIgnoreCase("HTTP")) {
                    this.protocol = CentralLuServer.HTTP;
                } else if (protocolStr.equalsIgnoreCase("HTTPS")) {
                    this.protocol = CentralLuServer.HTTPS;
                } else if (protocolStr.equalsIgnoreCase("FTP")) {
                    this.protocol = CentralLuServer.FTP;
                } else {
                    isValid = false;
                }
                String host = url.getHost();
                if (host == null || host.trim().length() == 0) {
                    isValid = false;
                }
            }
            catch (MalformedURLException ex) {
                LoggerUtilities.logException((Throwable)ex);
                isValid = false;
            }
        }
        if (this.isSEPMServer) {
            if (!isValid || CentralLuServer.LAN.equals(this.protocol) || CentralLuServer.FTP.equals(this.protocol)) {
                return "LuServerDialog.pathError.SEPM";
            }
        } else if (2 == this.platformType) {
            if (CentralLuServer.LAN.equals(this.protocol)) {
                return "LuServerDialog.pathError.Mac.Unc";
            }
            if (!isValid) {
                return "LuServerDialog.pathError.Mac";
            }
        } else if (!isValid) {
            return "LuServerDialog.pathError";
        }
        return null;
    }
}

