/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.LuPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.ButtonEntry;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.lu.AdvancePanel;
import com.sygate.scm.console.ui.policy.lu.MacSchedulePanel;
import com.sygate.scm.console.ui.policy.lu.MacServerPanel;
import com.sygate.scm.console.ui.policy.lu.SchedulePanel;
import com.sygate.scm.console.ui.policy.lu.ServerPanel;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuContentSourceInfoObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.MacLuContentSourceInfoObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class LuPolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 9005037623775135210L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private SchedulePanel schedulePanel;
    private ServerPanel serverPanel;
    private AdvancePanel advancePanel;
    private MacSchedulePanel macSchedulePanel;
    private MacServerPanel macServerPanel;
    private SchedulePanel linuxSchedulePanel;
    private ServerPanel linuxServerPanel;
    private AdvancePanel linuxAdvancePanel;
    private LiveUpdateObject luObj;
    private Map<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
    private LuPolicy luPolicy;

    public LuPolicyDialog(String name, GroupPolicyObject gpObj, Boolean ... isLocal) {
        super(144, name, gpObj, MSGRES.getString(LU, "LuPolicyDialog.title"), false, isLocal);
        this.pack();
    }

    public LuPolicyDialog(AbstractUIObject pool) {
        this(pool, false);
        this.pack();
    }

    public LuPolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(144, pool, MSGRES.getString(LU, "LuPolicyDialog.title"), isCheckPolicyEnforcement, false);
        this.pack();
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        String newName;
        this.setNewPolicy(true);
        LuPolicy policy = this.createLiveUpdatePolicy();
        this.luObj = new LiveUpdateObject((TopLevelObject)policy);
        if (this.luObj.getName() != null && (newName = PolicyHandler.adjustName(this.luObj.getName(), pool.getAllName(), 255)) != null) {
            this.luObj.setName(newName);
        }
        this.luObj.addNewObj((TopLevelObject)policy);
        this.luObj.addNewObj(this.newObjList);
        this.newObjList.clear();
        this.updatePanel();
        return this.luObj;
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject schema) {
        this.luObj = new LiveUpdateObject(schema);
        this.updatePanel();
        return this.luObj;
    }

    @Override
    protected void commit() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.luObj.setName(this.getOverviewPanel().getPolicyName());
        this.luObj.setDescription(this.getOverviewPanel().getPolicyDesc());
        this.getSchedulePanel().save();
        this.getServerPanel().save();
        this.getAdvancePanel().save();
        this.getMacSchedulePanel().save();
        this.getMacServerPanel().save();
        this.getLinuxSchedulePanel().save();
        this.getLinuxServerPanel().save();
        this.getLinuxAdvancePanel().save();
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    protected boolean isValidate() {
        if (this.isValidName(this.luObj.getSchemaObj(), MSGRES.getString(LU, "LuPolicyDialog.nameIsARequirementFiled"), MSGRES.getString(LU, "LuPolicyDialog.theNameHasBeenUsed"), MSGRES.getString(LU, "LuPolicyDialog.invalidName"))) {
            return this.getServerPanel().isValidate() && this.getMacServerPanel().isValidate() && this.getLinuxServerPanel().isValidate();
        }
        return false;
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        return new LuPolicyTabPanel(this, "<html>" + MSGRES.getString(LU, "LuPolicyDialog.LiveUpdatePolicy") + "</html>", "lu_policy_32.png");
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getSchedulePanel()), "Windows LU Schedule Settings");
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getServerPanel()), "Windows LU Server Settings");
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getAdvancePanel()), "Windows LU Advanced Settings");
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getMacServerPanel()), "Macintosh LU Server Settings");
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getMacSchedulePanel()), "Macintosh LU Schedule Settings");
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getLinuxSchedulePanel()), "Linux LU Schedule Settings");
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getLinuxServerPanel()), "Linux LU Server Settings");
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getLinuxAdvancePanel()), "Linux LU Advanced Settings");
    }

    @Override
    protected Container[] readOnlyContainers() {
        return new Container[]{this.getOverviewPanel(), this.getSchedulePanel(), this.getServerPanel(), this.getAdvancePanel(), this.getMacSchedulePanel(), this.getMacServerPanel(), this.getLinuxSchedulePanel(), this.getLinuxServerPanel(), this.getLinuxAdvancePanel()};
    }

    private SchedulePanel getSchedulePanel() {
        if (this.schedulePanel == null) {
            this.schedulePanel = new SchedulePanel(1);
        }
        return this.schedulePanel;
    }

    private ServerPanel getServerPanel() {
        if (this.serverPanel == null) {
            this.serverPanel = new ServerPanel(this.getSchedulePanel(), this.getAdvancePanel(), 1);
        }
        return this.serverPanel;
    }

    private AdvancePanel getAdvancePanel() {
        if (this.advancePanel == null) {
            this.advancePanel = new AdvancePanel();
        }
        return this.advancePanel;
    }

    private AdvancePanel getLinuxAdvancePanel() {
        if (this.linuxAdvancePanel == null) {
            this.linuxAdvancePanel = new AdvancePanel();
        }
        return this.linuxAdvancePanel;
    }

    private SchedulePanel getLinuxSchedulePanel() {
        if (this.linuxSchedulePanel == null) {
            this.linuxSchedulePanel = new SchedulePanel(3);
        }
        return this.linuxSchedulePanel;
    }

    private ServerPanel getLinuxServerPanel() {
        if (this.linuxServerPanel == null) {
            this.linuxServerPanel = new ServerPanel(this.getLinuxSchedulePanel(), this.getLinuxAdvancePanel(), 3);
        }
        return this.linuxServerPanel;
    }

    private MacSchedulePanel getMacSchedulePanel() {
        if (this.macSchedulePanel == null) {
            this.macSchedulePanel = new MacSchedulePanel();
        }
        return this.macSchedulePanel;
    }

    private MacServerPanel getMacServerPanel() {
        if (this.macServerPanel == null) {
            this.macServerPanel = new MacServerPanel(this.getMacSchedulePanel());
        }
        return this.macServerPanel;
    }

    private void updatePanel() {
        this.getOverviewPanel().setObject(this.luObj);
        SchedulePanel schedulePanel = this.getSchedulePanel();
        schedulePanel.setObject(this.luObj.getLuDownloadScheduleObject());
        LuContentSourceInfoObject cntSource = this.luObj.getLuContentSourceInfoObject();
        schedulePanel.setEnableSchedule(cntSource.isUseLiveUpdateServer());
        this.getServerPanel().setObject(this.luObj.getLuContentSourceInfoObject());
        this.getAdvancePanel().setObject(this.luObj.getLuGeneralConfigObject());
        MacSchedulePanel macSchedulePanel = this.getMacSchedulePanel();
        macSchedulePanel.setObject(this.luObj.getMacLuDownloadScheduleObject());
        MacLuContentSourceInfoObject macCntSource = this.luObj.getMacLuContentSourceInfoObject();
        macSchedulePanel.setEnableSchedule(macCntSource.isUseLiveUpdateServer());
        this.getMacServerPanel().setObject(this.luObj.getMacLuContentSourceInfoObject());
        SchedulePanel linuxSchedulePanel = this.getLinuxSchedulePanel();
        linuxSchedulePanel.setObject(this.luObj.getLinuxLuDownloadScheduleObject());
        LuContentSourceInfoObject linuxCntSource = this.luObj.getLinuxLuContentSourceInfoObject();
        linuxSchedulePanel.setEnableSchedule(linuxCntSource.isUseLiveUpdateServer());
        this.getLinuxServerPanel().setObject(this.luObj.getLinuxLuContentSourceInfoObject());
        this.getLinuxAdvancePanel().setObject(this.luObj.getLinuxLuGeneralConfigObject());
    }

    private LuPolicy createLiveUpdatePolicy() {
        try {
            if (this.luPolicy == null) {
                this.luPolicy = PolicyHandler.getDefaultLiveUpdatePolicy(this.newObjList);
            }
            if (this.luPolicy == null) {
                this.luPolicy = new LuPolicy();
                String GUIDString = new GUIDGenerator().getGUIDString();
                this.luPolicy.setId(GUIDString);
                this.luPolicy.setName(MSGRES.getString(LU, "LuPolicyDialog.luName"));
                this.luPolicy.setOptEnable(Boolean.TRUE);
                MetadataAttributes mAttr = new MetadataAttributes();
                this.luPolicy.setMetadataAttributes(mAttr);
                this.luPolicy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MSGRES.getString(LU, "LuPolicyDialog.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return this.luPolicy;
    }

    private static class LuPolicyTabPanel
    extends PolicyTabPanel {
        private static final long serialVersionUID = 1685567117638325233L;

        public LuPolicyTabPanel(BasePolicyDialog policyDialog, String tabTitle, String iconFile) {
            super(policyDialog, tabTitle, iconFile);
        }

        @Override
        protected ArrayList<ButtonEntry> getButtonList() {
            ArrayList<ButtonEntry> winSubButtonList = new ArrayList<ButtonEntry>();
            ArrayList<ButtonEntry> macSubButtonList = new ArrayList<ButtonEntry>();
            ArrayList<ButtonEntry> linuxSubButtonList = new ArrayList<ButtonEntry>();
            ArrayList<ButtonEntry> buttonList = new ArrayList<ButtonEntry>();
            winSubButtonList.add(new ButtonEntry(MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.tab.server"), null, "Windows LU Server Settings", null));
            winSubButtonList.add(new ButtonEntry(MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.tab.schedule"), null, "Windows LU Schedule Settings", null));
            winSubButtonList.add(new ButtonEntry(MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.tab.advanceSettings"), null, "Windows LU Advanced Settings", null));
            macSubButtonList.add(new ButtonEntry(MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.tab.server"), null, "Macintosh LU Server Settings", MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.mac.tab.server.title")));
            macSubButtonList.add(new ButtonEntry(MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.tab.schedule"), null, "Macintosh LU Schedule Settings", MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.mac.tab.schedule.title")));
            linuxSubButtonList.add(new ButtonEntry(MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.tab.server"), null, "Linux LU Server Settings", MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.linux.tab.server.title")));
            linuxSubButtonList.add(new ButtonEntry(MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.tab.schedule"), null, "Linux LU Schedule Settings", MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.linux.tab.schedule.title")));
            buttonList.add(new ButtonEntry(MessageResources.getInstance().getString(LuPolicyDialog.LU, "LuPolicyDialog.tab.overview"), null, true));
            buttonList.add(new ButtonEntry(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.Windows"), null, winSubButtonList, false, true));
            buttonList.add(new ButtonEntry(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.Mac"), null, macSubButtonList, false, true));
            buttonList.add(new ButtonEntry(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.Linux"), null, linuxSubButtonList, false, true));
            return buttonList;
        }
    }
}

