/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuState;
import com.sygate.scm.common.configobject.schema.SemSiteState;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.DateUtilities;
import java.awt.Component;
import java.text.DateFormat;
import java.text.Format;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class LuNotRunStatusDlg
extends DialogBase {
    private static final long serialVersionUID = 3596072384210898953L;
    private static volatile boolean needOpenLUNotRunStatusDlg = false;
    private static DateFormat fullFormat = DateFormat.getDateTimeInstance(0, 1, Locale.getDefault());
    static MessageResourcesFile myRes = new MessageResourcesFile("com.sygate.scm.console.ui.policy.lu.lu");
    private JPanel topPanel;

    public LuNotRunStatusDlg(JFrame parent, String title, boolean modal) {
        block2: {
            super(parent, title, modal);
            this.topPanel = null;
            this.jBCancel.setVisible(false);
            this.jBHelp.setVisible(false);
            try {
                this.initialize();
                this.pack();
                UiUtilities.centerComponent((Component)this);
            }
            catch (ConsoleException e) {
                ConsoleLogger.log(e);
                if (!e.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
        this.setVisible(false);
    }

    public static boolean isNeedOpenLUNotRunStatusDlg() {
        return needOpenLUNotRunStatusDlg;
    }

    public static void setNeedOpenLUNotRunStatusDlg(boolean needOpenLUNotRunStatusDlg) {
        LuNotRunStatusDlg.needOpenLUNotRunStatusDlg = needOpenLUNotRunStatusDlg;
    }

    @Override
    protected String getOkButtonText() {
        return myRes.getString("LuNotRunStatusDlg.OK");
    }

    private void initialize() throws ConsoleException {
        this.setTitle(myRes.getString("LuNotRunStatusDlg.title"));
        this.getContentPane().add((Component)this.getTopPanel(), "North");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getTopPanel() {
        DataobjectManager data = DataobjectManager.getInstance();
        SemSiteState semSiteState = null;
        try {
            semSiteState = data.getSemSiteState(Manager.getCurrentSiteId());
        }
        catch (ConsoleException ce) {
            ConsoleLogger.log("The semSiteState object is not initiated yet, it needs to wait for Liveupdate task to initiate it.");
        }
        LuState luState = null;
        if (semSiteState != null) {
            luState = semSiteState.getOptLuState();
        }
        boolean isNextTimeReady = true;
        boolean isLastTimeRun = true;
        if (luState == null || luState.getLastUpdateTime() == null || luState.getLastUpdateTime() == 0L) {
            isLastTimeRun = false;
        }
        if (luState == null || luState.getNextStartTime() == null || luState.getNextStartTime() == 0L) {
            isNextTimeReady = false;
        }
        StringBuffer content = new StringBuffer();
        content.append(myRes.getString("LuNotRunStatusDlg.msgformatForLastLUTime")).append("\n");
        if (isLastTimeRun) {
            content.append(DateUtilities.formatDate((long)luState.getLastUpdateTime(), (Format)fullFormat)).append("\n");
        } else {
            content.append(myRes.getString("LuNotRunStatusDlg.msgformatForLastLUNotRun")).append("\n");
        }
        content.append("\n").append(myRes.getString("LuNotRunStatusDlg.msgformatForNextLUTime")).append("\n");
        if (isNextTimeReady) {
            content.append(DateUtilities.formatDate((long)luState.getNextStartTime(), (Format)fullFormat));
        } else {
            content.append(myRes.getString("LuNotRunStatusDlg.msgformatForNextLUTimeNotReady"));
        }
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new VerticalFlowLayout());
        DescriptionTextArea descLabel = new DescriptionTextArea(content.toString());
        this.topPanel.add(descLabel);
        return this.topPanel;
    }
}

