/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuLatestDownloadContentObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;

public class LuLatestDownloadDlg
extends DialogBase {
    private static final long serialVersionUID = 6447454220057465224L;
    private static final int DLG_WIDTH = 700;
    private static final int DLG_HEIGHT = 520;
    private static final String[] TABLE_CULUMNS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LuLatestDownloadDlg.table.type"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LuLatestDownloadDlg.table.revision"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LuLatestDownloadDlg.table.time")};
    private static final String noDownloads = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LuLatestDownloadDlg.noDownloads");
    private static final String close = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LuLatestDownloadDlg.close");
    private AvTemplatePane topPanel = null;
    private JPanel centralPanel = null;
    private SortableTableModel model = new SortableTableModel();
    private JTable jTDownload = new StripesTable();

    public LuLatestDownloadDlg(JFrame parent) {
        super(parent, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LuLatestDownloadDlg.title"), false);
        this.initialize();
        this.setSize(700, 520);
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    protected String getOkButtonText() {
        return close;
    }

    @Override
    protected boolean isCancelButtonShown() {
        return false;
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }

    private void initialize() {
        this.getContentPane().add((Component)this.getTopPanel(), "North");
        this.getContentPane().add((Component)this.getCentralPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    private AvTemplatePane getTopPanel() {
        this.topPanel = new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LuLatestDownloadDlg.subtitle"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LuLatestDownloadDlg.desc"));
        return this.topPanel;
    }

    private JPanel getCentralPanel() {
        this.centralPanel = new JPanel();
        this.centralPanel.setLayout(new BorderLayout());
        this.model.setColumnNames(TABLE_CULUMNS);
        this.jTDownload.setModel(this.model);
        this.model.addMouseListenerToHeaderInTable(this.jTDownload);
        if (this.populateDownloadTable() > 0) {
            JScrollPane sPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)sPane, (JTable)this.createDownloadTable());
            this.centralPanel.add(sPane);
        } else {
            HtmlEnabledJLabel label = new HtmlEnabledJLabel(noDownloads);
            label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.centralPanel.add((Component)label, "North");
        }
        Border topBorder = this.topPanel.getBorder();
        this.centralPanel.setBorder(topBorder);
        return this.centralPanel;
    }

    private JTable createDownloadTable() {
        TableColumn column = this.jTDownload.getColumnModel().getColumn(0);
        JLabel testLabel = new JLabel((String)this.model.getValueAt(0, 0));
        column.setMinWidth(testLabel.getPreferredSize().width);
        column = this.jTDownload.getColumnModel().getColumn(1);
        Object columnValue = this.model.getValueAt(0, 1);
        testLabel = new JLabel(columnValue == null ? "" : columnValue.toString());
        column.setMinWidth(testLabel.getPreferredSize().width);
        column = this.jTDownload.getColumnModel().getColumn(2);
        columnValue = this.model.getValueAt(0, 2);
        testLabel = new JLabel(columnValue == null ? "" : columnValue.toString());
        column.setMinWidth(testLabel.getPreferredSize().width);
        Dimension size = this.jTDownload.getPreferredScrollableViewportSize();
        this.jTDownload.setPreferredScrollableViewportSize(new Dimension((int)((double)size.width * 0.8), (this.jTDownload.getRowHeight() + this.jTDownload.getRowMargin()) * 5));
        this.jTDownload.getSelectionModel().setSelectionMode(0);
        return this.jTDownload;
    }

    private int populateDownloadTable() {
        for (LuContentCategory cat : LuUtility.getAllLuCategories()) {
            for (LuLatestDownloadContentObject contentObject : LuUtility.getLatestAvailableContent(cat)) {
                this.model.addRow(contentObject);
            }
        }
        this.model.sortTable(0, true);
        return this.model.getRowCount();
    }
}

