/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.LuNotRunStatusDlg;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ServerSystemLogMonitor;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;

public class LuDownloadStatusDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static int DLG_WIDTH = 600;
    private static int DLG_HEIGHT = 600;
    private static volatile boolean isOnlyShowLUStatusButtonPressed = false;
    static MessageResourcesFile myRes = new MessageResourcesFile("com.sygate.scm.console.ui.policy.lu.lu");
    private AvTemplatePane topPanel;
    private JPanel centralPanel;
    private JTextArea editorPane;
    private static LuDownloadStatusDlg myDlg = null;
    private static final String PAGE_NAME = "LuDownloadStatusDlg";
    private static final String TITLE = "LuDownloadStatusDlgTitle";

    public static boolean isOnlyShowLUStatusButtonPressed() {
        return isOnlyShowLUStatusButtonPressed;
    }

    public static void setOnlyShowLUStatusButtonPressed(boolean isOnlyShowLUStatusButtonPressed) {
        LuDownloadStatusDlg.isOnlyShowLUStatusButtonPressed = isOnlyShowLUStatusButtonPressed;
    }

    private LuDownloadStatusDlg(JFrame parent) {
        block2: {
            super(parent, myRes.getString("LuDownloadStatusDlg.title"), false, false);
            this.topPanel = null;
            this.centralPanel = null;
            this.editorPane = null;
            try {
                this.initialize();
                this.setSize(DLG_WIDTH, DLG_HEIGHT);
                UiUtilities.centerComponent((Component)this);
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
                if (!e.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    @Override
    protected boolean isOkButtonShown() {
        return false;
    }

    @Override
    protected String getCancelButtonText() {
        return myRes.getString("LuDownloadStatusDlg.Hide");
    }

    private void initialize() throws ConsoleException {
        this.getContentPane().add((Component)this.getTopPanel(), "North");
        this.getContentPane().add((Component)this.getCentralPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                LuDownloadStatusDlg.this.stopData();
            }
        });
        UIUtilities.setName(this.jBOk, PAGE_NAME, UIUtilities.ComponentType.BUTTON, "OK");
        UIUtilities.setName(this.jBCancel, PAGE_NAME, UIUtilities.ComponentType.BUTTON, "CANCEL");
        UIUtilities.setName(this.jBHelp, PAGE_NAME, UIUtilities.ComponentType.BUTTON, "HELP");
    }

    protected void stopData() {
        block2: {
            try {
                ServerSystemLogMonitor.getLuStatusMonitor().setMonitoring(false, this.getEditPane());
                ServerSystemLogMonitor.getLuStatusMonitor().stop();
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
                if (!e.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private void startData() {
        block2: {
            try {
                AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)2);
                ServerSystemLogMonitor.getLuStatusMonitor().start();
                ServerSystemLogMonitor.getLuStatusMonitor().setMonitoring(true, this.getEditPane());
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
                if (!e.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private AvTemplatePane getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new AvTemplatePane(myRes.getString("LuDownloadStatusDlg.subtitle"), myRes.getString("LuDownloadStatusDlg.desc"));
        }
        UIUtilities.setName(this.topPanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, TITLE);
        return this.topPanel;
    }

    private JPanel getCentralPanel() throws ConsoleException {
        if (this.centralPanel == null) {
            this.centralPanel = new JPanel();
            this.centralPanel.setLayout(new BorderLayout());
            JScrollPane sPane = new JScrollPane(this.getEditPane());
            this.centralPanel.add(sPane);
            Border topBorder = this.getTopPanel().getBorder();
            this.centralPanel.setBorder(topBorder);
        }
        return this.centralPanel;
    }

    private JTextArea getEditPane() throws ConsoleException {
        if (this.editorPane == null) {
            this.editorPane = new JTextArea();
            this.editorPane.setEditable(false);
        }
        return this.editorPane;
    }

    public static void showStatus() {
        if (myDlg == null) {
            myDlg = new LuDownloadStatusDlg(Manager.getFrame());
        }
        if (isOnlyShowLUStatusButtonPressed) {
            LuDownloadStatusDlg.showStatusOnly();
        } else if (!myDlg.isVisible()) {
            myDlg.startData();
            myDlg.setVisible(true);
            UiUtilities.setDefaultButton((RootPaneContainer)myDlg, (JButton)LuDownloadStatusDlg.myDlg.jBCancel);
        }
    }

    private static void showStatusOnly() {
        isOnlyShowLUStatusButtonPressed = false;
        if (ServerSystemLogMonitor.getLuStatusMonitor().isLUCurrentlyRunning()) {
            if (!myDlg.isVisible()) {
                myDlg.startData();
                myDlg.setVisible(true);
                UiUtilities.setDefaultButton((RootPaneContainer)myDlg, (JButton)LuDownloadStatusDlg.myDlg.jBCancel);
            }
        } else {
            LuNotRunStatusDlg dlg = new LuNotRunStatusDlg(Manager.getFrame(), "", true);
            if (LuNotRunStatusDlg.isNeedOpenLUNotRunStatusDlg()) {
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    LuNotRunStatusDlg.setNeedOpenLUNotRunStatusDlg(false);
                }
            } else if (!myDlg.isVisible()) {
                myDlg.startData();
                myDlg.setVisible(true);
                UiUtilities.setDefaultButton((RootPaneContainer)myDlg, (JButton)LuDownloadStatusDlg.myDlg.jBCancel);
            }
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_lu_show_status";
    }
}

