/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.CentralLuServer;
import com.sygate.scm.common.configobject.schema.LuCategories;
import com.sygate.scm.common.configobject.schema.LuCategory;
import com.sygate.scm.common.configobject.schema.LuConfig;
import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.configobject.schema.LuSupportLanguage;
import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatform;
import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatforms;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LuSupportLanguageObj;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.PlatformTree;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class LuDownloadNowDlg
extends DialogBase {
    private static final long serialVersionUID = -6421286572941404796L;
    static MessageResourcesFile myRes = new MessageResourcesFile("com.sygate.scm.console.ui.policy.lu.lu");
    private AvTemplatePane topPanel;
    private JPanel centralPanel;
    private JEditorPane editorPane;
    private static final String PAGE_NAME = "LuDownloadNowDlg";
    private static final String TITLE = "LuDownloadNowDlgTitle";

    public LuDownloadNowDlg(JFrame parent, String title, boolean modal) {
        block2: {
            super(parent, title, modal);
            this.topPanel = null;
            this.centralPanel = null;
            this.editorPane = null;
            try {
                this.initialize();
                this.pack();
                UiUtilities.centerComponent((Component)this);
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
                if (!e.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    @Override
    protected String getOkButtonText() {
        return myRes.getString("LuDownloadNowDlg.DownloadNow");
    }

    private void initialize() throws ConsoleException {
        this.setTitle(myRes.getString("LuDownloadNowDlg.title"));
        this.getContentPane().add((Component)this.getTopPanel(), "North");
        this.getContentPane().add((Component)this.getCentralPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        UIUtilities.setName(this.jBOk, PAGE_NAME, UIUtilities.ComponentType.BUTTON, "OK");
        UIUtilities.setName(this.jBCancel, PAGE_NAME, UIUtilities.ComponentType.BUTTON, "CANCEL");
        UIUtilities.setName(this.jBHelp, PAGE_NAME, UIUtilities.ComponentType.BUTTON, "HELP");
    }

    private AvTemplatePane getTopPanel() {
        boolean isSBProduct = LicenseObject.getInstance().isSBProduct();
        if (!isSBProduct) {
            if (this.topPanel == null) {
                this.topPanel = new AvTemplatePane(myRes.getString("LuDownloadNowDlg.subtitle"), myRes.getString("LuDownloadNowDlg.desc"));
                this.topPanel.addParagraph(myRes.getString("LuDownloadNowDlg.secondParagraph"));
            }
        } else if (this.topPanel == null) {
            this.topPanel = new AvTemplatePane(myRes.getString("LuDownloadNowDlg.subtitle"), myRes.getString("LuDownloadNowDlg.desc.sepsb"));
            this.topPanel.addParagraph(myRes.getString("LuDownloadNowDlg.desc.sepsb.secondLine"));
        }
        UIUtilities.setName(this.topPanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, TITLE);
        return this.topPanel;
    }

    private JPanel getCentralPanel() throws ConsoleException {
        boolean isSBProduct = LicenseObject.getInstance().isSBProduct();
        if (this.centralPanel == null) {
            this.centralPanel = new JPanel();
            this.centralPanel.setLayout(new BorderLayout());
            JScrollPane sPane = new JScrollPane(this.getEditPane());
            if (!isSBProduct) {
                this.centralPanel.add(sPane);
            }
            Border topBorder = this.getTopPanel().getBorder();
            this.centralPanel.setBorder(topBorder);
        }
        return this.centralPanel;
    }

    private JEditorPane getEditPane() throws ConsoleException {
        if (this.editorPane == null) {
            this.editorPane = new JEditorPane();
            this.editorPane.setContentType("text/html");
            UiUtilities.setEditorPaneHonorUIDefaults((JEditorPane)this.editorPane, (Boolean)Boolean.TRUE);
            this.editorPane.setText(this.getLiveUpdateStatus());
            this.editorPane.setEditable(false);
        }
        return this.editorPane;
    }

    private String getLiveUpdateStatus() throws ConsoleException {
        String strStylePadding = "style='margin-left:25px'";
        String buff = "<html><body><table border=\"0\" cellspacing=0 cellpadding=0><tr><td nowrap colspan=\"2\"><b>" + myRes.getString("LuDownloadNowDlg.DownloadServer") + "</b></td></tr><tr><td nowrap colspan=\"2\" " + strStylePadding + ">" + this.getServerName() + "</td></tr><tr><td nowrap colspan=\"2\">&nbsp;</td></tr><tr><td nowrap colspan=\"2\"><b>" + myRes.getString("LuDownloadNowDlg.LuServer") + "</b></td></tr>" + this.getLuServerListString() + "<tr><td nowrap colspan=\"2\">&nbsp;</td></tr><tr><td nowrap colspan=\"2\"><b>" + myRes.getString("LuDownloadNowDlg.DownloadPlatform") + "</b></td></tr>" + this.getLuDownloadPlatforms() + "<tr><td nowrap colspan=\"2\">&nbsp;</td></tr><tr><td nowrap colspan=\"2\"><b>" + myRes.getString("LuDownloadNowDlg.DownloadContents") + "</b></td></tr>" + this.getLuDownloadContents() + "<tr><td nowrap colspan=\"2\">&nbsp;</td></tr><tr><td nowrap colspan=\"2\"><b>" + myRes.getString("LuDownloadNowDlg.DownloadContentsLanguage") + "</b></td></tr>" + this.getLuDownloadLanguage() + "</table></body></html>";
        return buff;
    }

    private String getLuDownloadLanguage() throws ConsoleException {
        List<String> downloadedContentList = this.getSupportedLanguageList();
        String noContents = myRes.getString("LuDownloadNowDlg.NoLanguage");
        return this.getHTMLList(downloadedContentList, noContents);
    }

    private List<String> getSupportedLanguageList() throws ConsoleException {
        ArrayList<String> contentList = new ArrayList<String>();
        String siteId = Manager.getCurrentSiteId();
        SemSite site = DataobjectManager.getInstance().getSemSite(siteId);
        LuConfig luConfig = site.getOptLuConfig();
        if (luConfig != null) {
            for (LuSupportLanguage lan : luConfig.getLuSupportLanguage()) {
                LuSupportLanguageObj lanObj = new LuSupportLanguageObj(lan);
                if (contentList.contains(lanObj.toString())) continue;
                contentList.add(lanObj.toString());
            }
        }
        return contentList;
    }

    private String getHTMLList(List<String> content, String noContentExplain) {
        StringBuffer sb = new StringBuffer();
        String strStylePadding = " style='margin-left:25px'";
        int cnt = 0;
        for (String contentName : content) {
            sb.append("</tr><tr><td nowrap colspan=\"2\" " + strStylePadding + ">");
            sb.append(contentName);
            sb.append("</td></tr>");
            ++cnt;
        }
        if (cnt <= 0) {
            sb.append("</tr><tr><td nowrap colspan=\"2\" " + strStylePadding + ">");
            sb.append(noContentExplain);
            sb.append("</td></tr>");
        }
        return sb.toString();
    }

    private String getLuDownloadContents() throws ConsoleException {
        List<String> downloadedContentList = this.getDownloadedContentList();
        String noContents = myRes.getString("LuDownloadNowDlg.NoContents");
        return this.getHTMLList(downloadedContentList, noContents);
    }

    private String getLuDownloadPlatforms() throws ConsoleException {
        List<String> downloadedPlatformList = this.getDownloadedPlatformList();
        String noContents = myRes.getString("LuDownloadNowDlg.NoPlatforms");
        return this.getHTMLList(downloadedPlatformList, noContents);
    }

    private List<String> getDownloadedPlatformList() throws ConsoleException {
        LuSupportedClientPlatforms platforms;
        ArrayList<String> platformList = new ArrayList<String>();
        String siteId = Manager.getCurrentSiteId();
        SemSite site = DataobjectManager.getInstance().getSemSite(siteId);
        LuConfig luConfig = site.getOptLuConfig();
        if (luConfig != null && (platforms = luConfig.getOptLuSupportedClientPlatforms()) != null) {
            Vector vplatform = platforms.getLuSupportedClientPlatform();
            Collections.sort(vplatform, new PlatformTree.PlatformComparator());
            for (LuSupportedClientPlatform platform : vplatform) {
                if ("Linux-ARM64".equalsIgnoreCase(platform.getContent())) continue;
                platformList.add(myRes.getString("LuDownloadNowDlg." + platform.getContent()));
            }
        }
        return platformList;
    }

    protected List<String> getDownloadedContentList() throws ConsoleException {
        LuCategories luCategories;
        ArrayList<String> contentList = new ArrayList<String>();
        String siteId = Manager.getCurrentSiteId();
        SemSite site = DataobjectManager.getInstance().getSemSite(siteId);
        LuConfig luConfig = site.getOptLuConfig();
        if (luConfig != null && (luCategories = luConfig.getOptLuCategories()) != null) {
            for (LuCategory categoryName : luCategories.getLuCategory()) {
                LuContentCategory category = LuUtility.getLuCategoryForSite(categoryName.getCategoryName());
                if (category.getName().equals("DEC_ABI") || category.getName().equals("SYN_APPS") || category.getName().equals("SESM_CONTENT_CATALOG") || category.getName().equals("SEPM_LIVEUPDATE_DATABASE") || category.getName().equals("SEPM_API")) continue;
                Vector localStrings = category.getLocalizedStrings();
                String displayName = LuUtility.getLocalizedString(localStrings).getOptDisplayName();
                if (displayName == null) {
                    displayName = categoryName.getCategoryName();
                }
                contentList.add(displayName);
            }
        }
        return contentList;
    }

    private String getLuServerListString() throws ConsoleException {
        List<String> serverList = this.getLuServerList();
        String noContents = myRes.getString("LuDownloadNowDlg.UserSymantecDefaultLUServer");
        return this.getHTMLList(serverList, noContents);
    }

    private List<String> getLuServerList() throws ConsoleException {
        LuContentSourceInfo sourceInfo;
        ArrayList<String> contentList = new ArrayList<String>();
        String siteId = Manager.getCurrentSiteId();
        SemSite site = DataobjectManager.getInstance().getSemSite(siteId);
        LuConfig luConfig = site.getOptLuConfig();
        if (luConfig != null && (sourceInfo = luConfig.getOptLuContentSourceInfo()) != null) {
            if (LuContentSourceInfo.INTERNAL.equals(sourceInfo.getOptLiveUpdateServerType())) {
                for (CentralLuServer server : sourceInfo.getCentralLuServer()) {
                    contentList.add(server.getName());
                }
            } else if (LuContentSourceInfo.EAS.equals(sourceInfo.getOptLiveUpdateServerType())) {
                contentList.add(myRes.getString("LuDownloadNowDlg.UserSymantecEASLUServer"));
            }
        }
        return contentList;
    }

    private String getServerName() throws ConsoleException {
        String siteId = Manager.getCurrentSiteId();
        SemSite site = DataobjectManager.getInstance().getSemSite(siteId);
        String siteName = site.getName();
        String serverId = Manager.getCurrentServerId();
        ServerArray serverArray = site.getServerArray();
        String serverName = "";
        for (SemServer server : serverArray.getSemServer()) {
            if (!server.getId().equals(serverId)) continue;
            serverName = server.getName();
        }
        String format = myRes.getString("LuDownloadNowDlg.ServerOnSite");
        Object[] data = new Object[]{serverName, siteName};
        return MessageFormat.format(format, data);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_lu_downloadnow";
    }
}

