/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuContentSizeSelection;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIFontUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LuContentSizeSelectionPanel
extends JPanel {
    private static final long serialVersionUID = -4076711041924313040L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private JCheckBox jChkDownloadReducedSDS = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.contentSizeSel.checkbox.DownloadReducedSDS"));
    private JCheckBox jChkDownloadStandardSDS = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.contentSizeSel.checkbox.DownloadStandardSDS"));
    private int avSizeSelection = 0;
    private Vector<LuContentSizeSelection> contentSizeSelections = null;

    public LuContentSizeSelectionPanel(Vector<LuContentSizeSelection> contentSizeSelections) {
        this.contentSizeSelections = this.cloneContentSizeSelections(contentSizeSelections);
        this.initialize();
    }

    @Override
    public void setEnabled(boolean enable) {
        this.jChkDownloadReducedSDS.setEnabled(enable);
        this.jChkDownloadStandardSDS.setEnabled(enable);
    }

    private void initialize() {
        this.add(this.getAVContentSizePanel());
        this.initializeAVSizeSelection();
        this.jChkDownloadReducedSDS.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(final ItemEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (e.getStateChange() == 1) {
                            LuContentSizeSelectionPanel.this.avSizeSelection |= 1;
                        } else if (e.getStateChange() == 2) {
                            LuContentSizeSelectionPanel.this.avSizeSelection &= 0xFFFFFFFE;
                            LuContentSizeSelectionPanel.this.showWarningMessage("SiteLuPanel.contentSizeSel.checkbox.DownloadReducedSDS.Warning", "SiteLuPanel.contentSizeSel.checkbox.DownloadReducedSDS");
                        }
                    }
                });
            }
        });
        this.jChkDownloadStandardSDS.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(final ItemEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (e.getStateChange() == 1) {
                            LuContentSizeSelectionPanel.this.avSizeSelection |= 2;
                        } else if (e.getStateChange() == 2) {
                            LuContentSizeSelectionPanel.this.avSizeSelection &= 0xFFFFFFFD;
                            LuContentSizeSelectionPanel.this.showWarningMessage("SiteLuPanel.contentSizeSel.checkbox.DownloadStandardSDS.Warning", "SiteLuPanel.contentSizeSel.checkbox.DownloadStandardSDS");
                        }
                    }
                });
            }
        });
    }

    private void showWarningMessage(String warning, String dialogTitle) {
        JOptionPane.showMessageDialog(this.getParent(), MSGRES.getString("com.sygate.scm.console.ui.server.dlg.serverdialog", warning), MSGRES.getString("com.sygate.scm.console.ui.server.dlg.serverdialog", dialogTitle), 2);
    }

    private JPanel getAVContentSizePanel() {
        JPanel p = new JPanel(new GridBagLayout());
        JLabel titleLabel = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteLuPanel.label.contentSizeBorderTitle"));
        titleLabel.setFont(UIFontUtilities.BOLD_FONT);
        p.add((Component)titleLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)this.jChkDownloadReducedSDS, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)this.jChkDownloadStandardSDS, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return p;
    }

    private void initializeAVSizeSelection() {
        LuContentSizeSelection avSelection = this.contentSizeSelections.get(0);
        this.avSizeSelection = avSelection.getOptDownloadSize();
        if ((this.avSizeSelection & 1) == 1) {
            this.jChkDownloadReducedSDS.setSelected(true);
        }
        if ((this.avSizeSelection & 2) == 2) {
            this.jChkDownloadStandardSDS.setSelected(true);
        }
    }

    public Vector<LuContentSizeSelection> getContentSizeSelections() {
        this.updateContentSizeSelections();
        return this.cloneContentSizeSelections(this.contentSizeSelections);
    }

    private void updateContentSizeSelections() {
        this.updateAVSizeSelections();
    }

    private void updateAVSizeSelections() {
        LuContentSizeSelection avSelection = this.contentSizeSelections.get(0);
        avSelection.setOptDownloadSize(Integer.valueOf(this.avSizeSelection));
        this.contentSizeSelections.set(0, avSelection);
    }

    private Vector<LuContentSizeSelection> cloneContentSizeSelections(Vector<LuContentSizeSelection> contentSizeSelections) {
        if (contentSizeSelections == null) {
            return null;
        }
        Vector<LuContentSizeSelection> contentSizeSelectionsCopy = new Vector<LuContentSizeSelection>();
        for (LuContentSizeSelection sizeSelection : contentSizeSelections) {
            LuContentSizeSelection sizeSelectionCopy = new LuContentSizeSelection();
            sizeSelectionCopy.setOptCategoryName(sizeSelection.getOptCategoryName());
            sizeSelectionCopy.setOptDownloadSize(sizeSelection.getOptDownloadSize());
            contentSizeSelectionsCopy.add(sizeSelectionCopy);
        }
        return contentSizeSelectionsCopy;
    }
}

