/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuContentPolicy;
import com.sygate.scm.common.configobject.schema.LuContentSelection;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentPolicyPool;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class LuContentPolicySelectDialog
extends DialogBase {
    private static final long serialVersionUID = 2718092549457119821L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private GroupPolicyObject gpObj;
    private JComboBox<ObjInfoObject> jLPolicy;

    public LuContentPolicySelectDialog(GroupPolicyObject gpObj, boolean isReadOnly) {
        super(Manager.getFrame(), "", true);
        this.setTitle(this.createTitle(gpObj));
        this.gpObj = gpObj;
        this.initialize(isReadOnly);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
        this.setResizable(false);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    public String getSelectedId() {
        ObjInfoObject infoObj = (ObjInfoObject)this.jLPolicy.getModel().getSelectedItem();
        if (infoObj == null) {
            return null;
        }
        return infoObj.getId();
    }

    private void initialize(boolean isReadOnly) {
        JLabel policyName = new JLabel(this.getAppliedLuContentPolicyName());
        policyName.setFont(policyName.getFont().deriveFont(1));
        this.getContentPane().setLayout(new GridBagLayout());
        int gridY = 0;
        if (this.gpObj.isInherit() || isReadOnly) {
            this.getContentPane().add((Component)this.getReadOnlyTitlePane(this.gpObj.isInherit()), new GridBagConstraints(0, gridY, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            ++gridY;
        }
        this.getContentPane().add((Component)this.getInnerPanel(isReadOnly), new GridBagConstraints(0, gridY, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, -3, 0, -3), 0, 0));
        this.pack();
        if (isReadOnly) {
            this.jBOk.setEnabled(false);
        }
    }

    private JPanel getInnerPanel(boolean isReadOnly) {
        this.initialContentPolicyList();
        String strSelectedPolicyName = this.getAppliedLuContentPolicyName();
        int selectedIndex = 0;
        for (int i = 0; i < this.jLPolicy.getModel().getSize(); ++i) {
            if (!strSelectedPolicyName.equals(((ObjInfoObject)this.jLPolicy.getModel().getElementAt(i)).getName())) continue;
            selectedIndex = i;
            break;
        }
        this.jLPolicy.setSelectedIndex(selectedIndex);
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.jLPolicy);
        this.jLPolicy.setEnabled(!isReadOnly);
        result.add((Component)this.getLabelsPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 150), 0, 0));
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            result.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 10, 0), 0, 0));
        } else {
            result.add(this.jLPolicy, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 10, 0), 0, 0));
        }
        result.setBorder(BorderFactory.createTitledBorder(null, MSGRES.getString(LU, "LuContentPolicySelectDialog.luContentName")));
        return result;
    }

    private JPanel getLabelsPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(MSGRES.getString(LU, "LuContentPolicySelectDialog.label.choose")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        result.add((Component)p, "West");
        result.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return result;
    }

    private void initialContentPolicyList() {
        try {
            ObjInfoObject[] infoObjs = LiveUpdateContentPolicyPool.getPolicyPool().getInfoObjectList();
            this.jLPolicy = new JComboBox<ObjInfoObject>(infoObjs);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private String createTitle(GroupPolicyObject gpObj) {
        Object[] arg = new Object[]{gpObj.getGroupName()};
        return MessageFormat.format(MSGRES.getString(LU, "LuContentPolicySelectDialog.title"), arg);
    }

    private String getAppliedLuContentPolicyName() {
        LuContentSelection sel = this.gpObj.getLuContentSelection();
        if (sel != null) {
            try {
                LuContentPolicy policy = DataobjectManager.getInstance().getLuContentPolicy(sel.getObjReference().getTargetId());
                return policy.getName();
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return MSGRES.getString(LU, "LuContentPolicySelectDialog.policyName.none");
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_computersnusers_policies_lu_content_policy";
    }

    private JPanel getReadOnlyTitlePane(boolean isInherit) {
        String desc = (isInherit ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theGlobalSettingsAreInherited") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theGroupIsReadOnly")) + " " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.noModificationIsAllowed");
        DescriptionTextArea descArea = new DescriptionTextArea(true);
        descArea.setText(desc);
        descArea.setColumns(30);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(UIColorUtilities.WARNING_BACKGROUND);
        panel.add(descArea);
        descArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }
}

