/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.LuContentCategoryGroup;
import com.sygate.scm.common.configobject.schema.LuContentPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.ButtonEntry;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.lu.CategoryGroupPanel;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.policy.lu.MacLuCategoryPanel;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuAppliedContentObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class LuContentPolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 9048484050853440227L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private List<CategoryGroupPanel> categoryGroupPanels;
    private LiveUpdateContentObject luObj;
    private Map<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
    private LuContentPolicy luPolicy;
    private MacLuCategoryPanel macCategoryPanel;

    public LuContentPolicyDialog(String name, GroupPolicyObject gpObj) {
        super(148, name, gpObj, MSGRES.getString(LU, "LuContentPolicyDialog.title"), false, false);
    }

    public LuContentPolicyDialog(AbstractUIObject pool) {
        this(pool, false);
    }

    public LuContentPolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(148, pool, MSGRES.getString(LU, "LuContentPolicyDialog.title"), isCheckPolicyEnforcement, false);
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        String newName;
        this.setNewPolicy(true);
        LuContentPolicy policy = this.createLiveUpdateContentPolicy();
        this.luObj = new LiveUpdateContentObject((TopLevelObject)policy);
        if (this.luObj.getName() != null && (newName = PolicyHandler.adjustName(this.luObj.getName(), pool.getAllName(), 255)) != null) {
            this.luObj.setName(newName);
        }
        this.luObj.addNewObj((TopLevelObject)policy);
        this.luObj.addNewObj(this.newObjList);
        this.newObjList.clear();
        this.updatePanel();
        return this.luObj;
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject schema) {
        this.luObj = new LiveUpdateContentObject(schema);
        this.updatePanel();
        return this.luObj;
    }

    @Override
    protected void commit() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.luObj.setName(this.getOverviewPanel().getPolicyName());
        this.luObj.setDescription(this.getOverviewPanel().getPolicyDesc());
        ArrayList<List<LuAppliedContentObject>> contents = new ArrayList<List<LuAppliedContentObject>>();
        contents.add(this.getMacCategoryPanel().save());
        for (int i = 0; i < this.getGroupPanelList().size(); ++i) {
            contents.add(this.getGroupPanelList().get(i).save());
        }
        this.luObj.updLuAppliedContent(contents);
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    protected boolean isValidate() {
        for (int i = 0; i < this.getGroupPanelList().size(); ++i) {
            CategoryGroupPanel x = this.getGroupPanelList().get(i);
            if (x.isValidate()) continue;
            return false;
        }
        return this.isValidName(this.luObj.getSchemaObj(), MSGRES.getString(LU, "LuContentPolicyDialog.nameIsARequirementFiled"), MSGRES.getString(LU, "LuContentPolicyDialog.theNameHasBeenUsed"), MSGRES.getString(LU, "LuContentPolicyDialog.invalidName"));
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        return new LuPolicyTabPanel(this, "<html>" + MSGRES.getString(LU, "LuContentPolicyDialog.LiveUpdateContentPolicy") + "</html>", "Properties_32.png");
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        List<LuContentCategoryGroup> luCategoryGroups = LuUtility.getAllLuCategoryGroups(false, "SECURITY");
        for (int i = 0; i < luCategoryGroups.size(); ++i) {
            LuContentCategoryGroup group = luCategoryGroups.get(i);
            CategoryGroupPanel panel = new CategoryGroupPanel(group);
            this.getGroupPanelList().add(panel);
            mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(panel), LuUtility.getLocalizedString(group.getLocalizedStrings()).getOptDisplayName());
        }
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getMacCategoryPanel()), "Macintosh LU Content Security Definitions");
    }

    @Override
    protected Container[] readOnlyContainers() {
        ArrayList<JPanel> result = new ArrayList<JPanel>();
        result.add(this.getOverviewPanel());
        result.addAll(this.getGroupPanelList());
        result.add(this.getMacCategoryPanel());
        return result.toArray(new Container[0]);
    }

    private MacLuCategoryPanel getMacCategoryPanel() {
        if (this.macCategoryPanel == null) {
            this.macCategoryPanel = new MacLuCategoryPanel();
        }
        return this.macCategoryPanel;
    }

    private List<CategoryGroupPanel> getGroupPanelList() {
        if (this.categoryGroupPanels == null) {
            this.categoryGroupPanels = new ArrayList<CategoryGroupPanel>();
        }
        return this.categoryGroupPanels;
    }

    private void updatePanel() {
        this.getOverviewPanel().setObject(this.luObj);
        for (int i = 0; i < this.getGroupPanelList().size(); ++i) {
            this.getGroupPanelList().get(i).setObject(this.luObj);
        }
        this.getMacCategoryPanel().setObject(this.luObj);
    }

    private LuContentPolicy createLiveUpdateContentPolicy() {
        try {
            if (this.luPolicy == null) {
                this.luPolicy = PolicyHandler.getDefaultLiveUpdateContentPolicy(this.newObjList);
            }
            if (this.luPolicy == null) {
                this.luPolicy = new LuContentPolicy();
                this.luPolicy.setId(new GUIDGenerator().getGUIDString());
                this.luPolicy.setName(MSGRES.getString(LU, "LuContentPolicyDialog.luContentName"));
                MetadataAttributes mAttr = new MetadataAttributes();
                this.luPolicy.setMetadataAttributes(mAttr);
                this.luPolicy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MSGRES.getString(LU, "LuPolicyDialog.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return this.luPolicy;
    }

    private static class LuPolicyTabPanel
    extends PolicyTabPanel {
        private static final long serialVersionUID = 1L;

        public LuPolicyTabPanel(BasePolicyDialog policyDialog, String tabTitle, String iconFile) {
            super(policyDialog, tabTitle, iconFile);
        }

        @Override
        protected ArrayList<ButtonEntry> getButtonList() {
            ArrayList<ButtonEntry> winSubButtonList = new ArrayList<ButtonEntry>();
            ArrayList<ButtonEntry> macSubButtonList = new ArrayList<ButtonEntry>();
            ArrayList<ButtonEntry> buttonList = new ArrayList<ButtonEntry>();
            buttonList.add(new ButtonEntry(MSGRES.getString(LuContentPolicyDialog.LU, "LuPolicyDialog.tab.overview"), null, true));
            List<LuContentCategoryGroup> luCategoryGroups = LuUtility.getAllLuCategoryGroups(false);
            for (int i = 0; i < luCategoryGroups.size(); ++i) {
                LuContentCategoryGroup group = luCategoryGroups.get(i);
                if (group.getName().equals("PRODUCT_UPDATES")) continue;
                Vector localizedStrings = group.getLocalizedStrings();
                winSubButtonList.add(new ButtonEntry(LuUtility.getLocalizedString(localizedStrings).getOptDisplayName(), null, LuUtility.getLocalizedString(localizedStrings).getOptDisplayName(), null));
            }
            buttonList.add(new ButtonEntry(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.Windows"), null, winSubButtonList, false, true));
            macSubButtonList.add(new ButtonEntry(MessageResources.getInstance().getString(LuContentPolicyDialog.LU, "LuContentPolicyDialog.tab.SecuritySettings"), null, "Macintosh LU Content Security Definitions", MessageResources.getInstance().getString(LuContentPolicyDialog.LU, "LuContentPolicyDialog.tab.SecuritySettings.title")));
            buttonList.add(new ButtonEntry(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.Mac"), null, macSubButtonList, false, true));
            return buttonList;
        }
    }
}

