/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuFtpProxy;
import com.sygate.scm.common.configobject.schema.LuHttpProxy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuContentSourceInfoObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuFtpProxyObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuHttpProxyObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class LuConfigProxyDlg
extends DialogBase {
    private static final long serialVersionUID = -2238872027758871511L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private JTabbedPane jTabPane = new JTabbedPane();
    protected JRadioButton jRBHttpNo = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuConfigProxyDlg.radiobutton.httpNoProxy"));
    protected JRadioButton jRBHttpSystem = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuConfigProxyDlg.radiobutton.httpSystemProxy"));
    protected JRadioButton jRBHttpCustom = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuConfigProxyDlg.radiobutton.httpCustomProxy"));
    private ButtonGroup httpRadioButtonGroup = new ButtonGroup();
    protected JTextField jTFHttpHost = new JTextField();
    protected JTextField jTFHttpPort = new JTextField(6);
    protected JTextField jTFHttpsPort = new JTextField(6);
    protected JCheckBox jCBHttpAuth = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuConfigProxyDlg.checkbox.httpAuth"));
    protected JCheckBox jCBHttpNtlmAuth = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuConfigProxyDlg.radiobutton.ntlmAuth"));
    protected JTextField jTFUserName = new JTextField();
    protected JPasswordField jPFPassword = new SEPMPasswordField();
    private JRadioButton jRBFtpNo = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuConfigProxyDlg.radiobutton.ftpNoProxy"));
    private JRadioButton jRBFtpSystem = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuConfigProxyDlg.radiobutton.ftpSystemProxy"));
    private JRadioButton jRBFtpCustom = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LuConfigProxyDlg.radiobutton.ftpCustomProxy"));
    private ButtonGroup ftpRadioButtonGroup = new ButtonGroup();
    private JTextField jTFFtpHost = new JTextField();
    private JTextField jTFFtpPort = new JTextField(6);
    private JPanel jPHttpCustom;
    private JPanel jPFtpCustom;
    private JPanel jPHttpAuth;
    private JPanel jPHttpProxyAddressAndPortNumber;
    private JPanel jPHttpPanel;
    private JPanel jPFtpPanel;
    private LuHttpProxyObject httpProxyObj;
    private LuFtpProxyObject ftpProxyObj;
    private ButtonModel httpRadioButtonSelected;
    private ButtonModel ftpRadioButtonSelected;
    private int platformType = 1;

    public LuConfigProxyDlg(LuContentSourceInfoObject sourceInfoObj, boolean isReadonly, int platformType) {
        super(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.label.title"), true);
        this.platformType = platformType;
        this.initialize();
        this.setObject(sourceInfoObj);
        if (isReadonly) {
            UIUtilities.setContainerStatus(this.jTabPane, false);
            this.resetOKButton(false);
        }
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected void commit() {
        String userName = this.jTFUserName.getText().trim();
        String domainName = "";
        if (this.jCBHttpNtlmAuth.isSelected() && userName.indexOf("\\") != -1) {
            domainName = userName.split("\\\\")[0].toString();
            userName = userName.split("\\\\")[1].toString();
        }
        this.httpProxyObj.setMode(this.getHttpProxyMode());
        this.httpProxyObj.setHost(Utility.checkAndAddBrackets((String)this.jTFHttpHost.getText().trim()));
        this.httpProxyObj.setPort(this.jTFHttpPort.getText().trim());
        this.httpProxyObj.setHttpsPort(this.jTFHttpsPort.getText().trim());
        this.httpProxyObj.setAuthentication(this.jCBHttpAuth.isSelected());
        this.httpProxyObj.setAuthenticationType(this.getAuthenticationType());
        this.httpProxyObj.setUserName(userName);
        this.httpProxyObj.setPassword(new String(this.jPFPassword.getPassword()));
        this.httpProxyObj.setNtlmUserName(userName);
        this.httpProxyObj.setNtlmPassword(new String(this.jPFPassword.getPassword()));
        this.httpProxyObj.setNtlmDomainName(domainName);
        this.ftpProxyObj.setMode(this.getFtpProxyMode());
        this.ftpProxyObj.setHost(Utility.checkAndAddBrackets((String)this.jTFFtpHost.getText().trim()));
        this.ftpProxyObj.setPort(this.jTFFtpPort.getText().trim());
    }

    @Override
    protected boolean isValidate() {
        if (this.jRBHttpCustom.isSelected()) {
            if (this.jTFHttpHost.getText().trim().length() == 0) {
                this.jTabPane.setSelectedComponent(this.jPHttpPanel);
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.httpHostError"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (!Utility.isValidIPAddressOrHostName((String)this.jTFHttpHost.getText().trim(), (boolean)false)) {
                this.jTabPane.setSelectedComponent(this.jPHttpPanel);
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.msg.pleaseEnterValidServerIPorName"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (this.platformType == 3 && this.jTFHttpPort.getText().trim().length() == 0) {
                this.jTabPane.setSelectedComponent(this.jPHttpPanel);
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.httpPortErrorLinux"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (this.jTFHttpPort.getText().trim().length() == 0 && this.jTFHttpsPort.getText().trim().length() == 0) {
                this.jTabPane.setSelectedComponent(this.jPHttpPanel);
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.httpPortError"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
        }
        if ((this.jRBHttpSystem.isSelected() || this.jRBHttpCustom.isSelected()) && this.jCBHttpAuth.isSelected()) {
            Pattern pattern;
            Matcher matcher;
            if (this.jTFUserName.getText().trim().length() == 0) {
                this.jTabPane.setSelectedComponent(this.jPHttpPanel);
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.httpOrHttpsUsernameError"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (this.jTFUserName.getText().contains(":")) {
                this.jTabPane.setSelectedComponent(this.jPHttpPanel);
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.httpOrHttpsUsernameErrorContainsColon"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (this.jCBHttpNtlmAuth.isSelected() && !(matcher = (pattern = Pattern.compile("^([A-Za-z0-9\\-_]{1}[A-Za-z0-9.\\-_]{0,14})([\\\\]{1})([^\\/\\\\\\[:;|=,+*?<>\\]\"]{1,64})$")).matcher(this.jTFUserName.getText().trim())).find()) {
                this.jTFUserName.requestFocusInWindow();
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.httpDomainnameError"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (this.jPFPassword.getPassword().length == 0) {
                this.jTabPane.setSelectedComponent(this.jPHttpPanel);
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.httpOrHttpsPasswordError"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
        }
        if (this.jRBFtpCustom.isSelected()) {
            if (this.jTFFtpHost.getText().trim().length() == 0) {
                this.jTabPane.setSelectedComponent(this.jPFtpPanel);
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.ftpHostError"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (!Utility.isValidIPAddressOrHostName((String)this.jTFFtpHost.getText().trim(), (boolean)false)) {
                this.jTabPane.setSelectedComponent(this.jPFtpPanel);
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.msg.pleaseEnterValidServerIPorName"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
            if (this.jTFFtpPort.getText().trim().length() == 0) {
                this.jTabPane.setSelectedComponent(this.jPFtpPanel);
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuConfigProxyDlg.ftpPortError"), MSGRES.getString(LU, "LuConfigProxyDlg.error"), 0);
                return false;
            }
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.jTabPane.getSelectedComponent());
    }

    private void initialize() {
        this.jPHttpPanel = this.getHttpProxyPanel();
        this.jPFtpPanel = this.getFtpProxyPanel();
        if (3 == this.platformType) {
            this.jTabPane.add(MSGRES.getString(LU, "LuConfigProxyDlg.http.title"), this.jPHttpPanel);
        } else {
            this.jTabPane.add(MSGRES.getString(LU, "LuConfigProxyDlg.http.title"), this.jPHttpPanel);
            this.jTabPane.add(MSGRES.getString(LU, "LuConfigProxyDlg.ftp.title"), this.jPFtpPanel);
        }
        RestrictedPlainDocument httpServerNameDoc = new RestrictedPlainDocument(63);
        httpServerNameDoc.setValidator("*~!@#$%^&*()+{}|\"<>?`=\\;',/)", false);
        this.jTFHttpHost.setDocument(httpServerNameDoc);
        RestrictedPlainDocument ftpServerNameDoc = new RestrictedPlainDocument(63);
        ftpServerNameDoc.setValidator("*~!@#$%^&*()+{}|\"<>?`=\\;',/)", false);
        this.jTFFtpHost.setDocument(ftpServerNameDoc);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.jTabPane, "Center");
        contentPane.add((Component)this.getButtonPanel(), "South");
    }

    private void setObject(LuContentSourceInfoObject sourceInfoObj) {
        this.httpProxyObj = sourceInfoObj.getHttpProxyObject();
        this.ftpProxyObj = sourceInfoObj.getFtpProxyObject();
        if (this.httpRadioButtonSelected == null && this.ftpRadioButtonSelected == null) {
            this.httpRadioButtonSelected = this.httpProxyObj != null && this.httpProxyObj.isCustomProxy() ? this.jRBHttpCustom.getModel() : (this.httpProxyObj != null && this.httpProxyObj.isSystemProxy() ? this.jRBHttpSystem.getModel() : this.jRBHttpNo.getModel());
            if (3 == this.platformType && this.httpRadioButtonSelected == this.jRBHttpSystem.getModel()) {
                this.httpRadioButtonSelected = this.jRBHttpNo.getModel();
            }
            this.ftpRadioButtonSelected = this.ftpProxyObj != null && this.ftpProxyObj.isCustomProxy() ? this.jRBFtpCustom.getModel() : (this.ftpProxyObj != null && this.ftpProxyObj.isSystemProxy() ? this.jRBFtpSystem.getModel() : this.jRBFtpNo.getModel());
        }
        this.updatePanel();
    }

    private JPanel getHttpProxyPanel() {
        String title = MSGRES.getString(LU, "LuConfigProxyDlg.label.http");
        if (3 == this.platformType) {
            this.jRBHttpNo = new JRadioButton(MSGRES.getString(LU, "LuConfigProxyDlg.radiobutton.httpNoProxy"));
            this.jRBHttpCustom = new JRadioButton(MSGRES.getString(LU, "LuConfigProxyDlg.radiobutton.httpCustomProxy"));
            title = MSGRES.getString(LU, "LuConfigProxyDlg.label.http");
        }
        this.httpRadioButtonGroup.add(this.jRBHttpNo);
        this.httpRadioButtonGroup.add(this.jRBHttpSystem);
        this.httpRadioButtonGroup.add(this.jRBHttpCustom);
        RemeberSelection remeber = new RemeberSelection();
        this.jRBHttpNo.addActionListener(remeber);
        this.jRBHttpSystem.addActionListener(remeber);
        this.jRBHttpCustom.addActionListener(remeber);
        this.jRBHttpNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                LuConfigProxyDlg.this.jCBHttpAuth.setEnabled(false);
                LuConfigProxyDlg.this.httpAuthChanged();
            }
        });
        this.jRBHttpSystem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                LuConfigProxyDlg.this.jCBHttpAuth.setEnabled(true);
                LuConfigProxyDlg.this.httpAuthChanged();
            }
        });
        this.jRBHttpCustom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                LuConfigProxyDlg.this.jCBHttpAuth.setEnabled(true);
                LuConfigProxyDlg.this.httpCustomStateChanged();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        UiUtilities.setupTitledPanel((JPanel)panel, (String)title);
        panel.add((Component)new JLabel(MSGRES.getString(LU, "LuConfigProxyDlg.label.httpDesc")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 0), 0, 0));
        panel.add((Component)this.jRBHttpNo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        if (3 != this.platformType) {
            panel.add((Component)this.jRBHttpSystem, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        }
        panel.add((Component)this.jRBHttpCustom, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.getHttpCustomPanel(), new GridBagConstraints(1, 4, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        JPanel authPanel = new JPanel(new GridBagLayout());
        authPanel.add((Component)this.jCBHttpAuth, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        authPanel.add((Component)this.getHttpAuthPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 0, 0), 0, 0));
        panel.add((Component)authPanel, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jCBHttpAuth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LuConfigProxyDlg.this.httpAuthChanged();
            }
        });
        String helpToken = 3 == this.platformType ? "linux_sesm_policies_dialog_lu_server_settings_config_proxy_options_http" : "sesm_policies_dialog_lu_server_settings_config_proxy_options_http";
        ContentSensitiveHelpPanel wrapPanel = new ContentSensitiveHelpPanel((LayoutManager)new BorderLayout(), helpToken);
        wrapPanel.add((Component)panel, "North");
        return wrapPanel;
    }

    private JPanel getFtpProxyPanel() {
        this.ftpRadioButtonGroup.add(this.jRBFtpNo);
        this.ftpRadioButtonGroup.add(this.jRBFtpSystem);
        this.ftpRadioButtonGroup.add(this.jRBFtpCustom);
        RemeberSelection remeber = new RemeberSelection();
        this.jRBFtpNo.addActionListener(remeber);
        this.jRBFtpSystem.addActionListener(remeber);
        this.jRBFtpCustom.addActionListener(remeber);
        this.jRBFtpCustom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LuConfigProxyDlg.this.ftpCustomStateChanged();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        UiUtilities.setupTitledPanel((JPanel)panel, (String)MSGRES.getString(LU, "LuConfigProxyDlg.label.ftp"));
        panel.add((Component)new JLabel(MSGRES.getString(LU, "LuConfigProxyDlg.label.ftpDesc")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 0), 0, 0));
        panel.add((Component)this.jRBFtpNo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        panel.add((Component)this.jRBFtpSystem, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jRBFtpCustom, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.getFtpCustomPanel(), new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        ContentSensitiveHelpPanel wrapPanel = new ContentSensitiveHelpPanel((LayoutManager)new BorderLayout(), "sesm_policies_dialog_lu_server_settings_config_proxy_options_ftp");
        wrapPanel.add((Component)panel, "North");
        return wrapPanel;
    }

    private JPanel getHttpCustomPanel() {
        if (this.jPHttpCustom == null) {
            this.jTFHttpPort.setDocument(new NumberPlainDocument(65535L, true));
            this.jTFHttpPort.setHorizontalAlignment(4);
            this.jTFHttpsPort.setDocument(new NumberPlainDocument(65535L, true));
            this.jTFHttpsPort.setHorizontalAlignment(4);
            this.jPHttpCustom = new JPanel(new GridBagLayout());
            this.jPHttpCustom.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
            this.jPHttpCustom.add((Component)this.getProxyDetailsPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        }
        return this.jPHttpCustom;
    }

    private JPanel getFtpCustomPanel() {
        if (this.jPFtpCustom == null) {
            this.jTFFtpPort.setDocument(new NumberPlainDocument(65535L, true));
            this.jTFFtpPort.setHorizontalAlignment(4);
            this.jTFFtpHost.setPreferredSize(new Dimension(180, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jTFFtpHost.setHorizontalAlignment(2);
            this.jPFtpCustom = new JPanel(new GridBagLayout());
            this.jPFtpCustom.setBorder(BorderFactory.createEmptyBorder(5, 20, 10, 10));
            this.jPFtpCustom.add((Component)new JLabel(MSGRES.getString(LU, "LuConfigProxyDlg.label.ftpHost")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPFtpCustom.add((Component)this.jTFFtpHost, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.jPFtpCustom.add((Component)new JLabel(MSGRES.getString(LU, "LuConfigProxyDlg.label.port")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.jPFtpCustom.add((Component)this.jTFFtpPort, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        }
        return this.jPFtpCustom;
    }

    private JPanel getProxyDetailsPanel() {
        if (this.jPHttpProxyAddressAndPortNumber == null) {
            this.jTFHttpHost.setPreferredSize(new Dimension(180, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jTFHttpHost.setHorizontalAlignment(2);
            this.jPHttpProxyAddressAndPortNumber = new JPanel(new GridBagLayout());
            this.jPHttpProxyAddressAndPortNumber.add((Component)new JLabel(MSGRES.getString(LU, "LuConfigProxyDlg.label.httpHost")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpProxyAddressAndPortNumber.add((Component)this.jTFHttpHost, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 5, 0, 0), 0, 0));
            if (3 == this.platformType) {
                this.jPHttpProxyAddressAndPortNumber.add((Component)new JLabel(MSGRES.getString(LU, "LuConfigProxyDlg.label.httpLinuxPort")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
                this.jPHttpProxyAddressAndPortNumber.add((Component)this.jTFHttpPort, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            } else {
                this.jPHttpProxyAddressAndPortNumber.add((Component)new JLabel(MSGRES.getString(LU, "LuConfigProxyDlg.label.httpPort")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
                this.jPHttpProxyAddressAndPortNumber.add((Component)this.jTFHttpPort, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            }
            if (3 != this.platformType) {
                this.jPHttpProxyAddressAndPortNumber.add((Component)new JLabel(MSGRES.getString(LU, "LuConfigProxyDlg.label.httpsPort")), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 15, 0, 0), 0, 0));
                this.jPHttpProxyAddressAndPortNumber.add((Component)this.jTFHttpsPort, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 5, 0, 0), 0, 0));
            }
        }
        return this.jPHttpProxyAddressAndPortNumber;
    }

    private JPanel getHttpAuthPanel() {
        if (this.jPHttpAuth == null) {
            this.jTFUserName.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jPFPassword.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
            this.jPHttpAuth = new JPanel(new GridBagLayout());
            this.jPHttpAuth.add((Component)new JLabel(MSGRES.getString(LU, "LuConfigProxyDlg.label.httpUsername")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpAuth.add((Component)this.jTFUserName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.jPHttpAuth.add((Component)new JLabel(MSGRES.getString(LU, "LuConfigProxyDlg.label.httpPassword")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.jPHttpAuth.add((Component)this.jPFPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
            if (1 == this.platformType) {
                this.jPHttpAuth.add((Component)this.jCBHttpNtlmAuth, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            }
        }
        return this.jPHttpAuth;
    }

    private void httpCustomStateChanged() {
        UIUtilities.setContainerStatus(this.getHttpCustomPanel(), this.jRBHttpCustom.isEnabled() && this.jRBHttpCustom.isSelected());
        this.httpAuthChanged();
    }

    private void ftpCustomStateChanged() {
        UIUtilities.setContainerStatus(this.getFtpCustomPanel(), this.jRBFtpCustom.isEnabled() && this.jRBFtpCustom.isSelected());
    }

    private void httpAuthChanged() {
        UIUtilities.setContainerStatus(this.getHttpAuthPanel(), this.jCBHttpAuth.isEnabled() && this.jCBHttpAuth.isSelected());
    }

    private void updatePanel() {
        if (this.httpProxyObj != null) {
            this.jRBHttpNo.setSelected(this.httpProxyObj.isNoProxy());
            this.jRBHttpSystem.setSelected(this.httpProxyObj.isSystemProxy());
            this.jRBHttpCustom.setSelected(this.httpProxyObj.isCustomProxy());
            if (3 == this.platformType && this.httpProxyObj.isSystemProxy()) {
                this.jRBHttpNo.setSelected(true);
            }
            this.jTFHttpHost.setText(Utility.checkAndRemoveBrackets((String)this.httpProxyObj.getHost()));
            this.jTFHttpPort.setText(this.httpProxyObj.getPort());
            this.jTFHttpsPort.setText(this.httpProxyObj.getHttpsPort());
            this.jCBHttpAuth.setSelected(this.httpProxyObj.isAuthenticated());
            this.jCBHttpNtlmAuth.setSelected(this.httpProxyObj.isNtlmAuthentication());
            if (this.httpProxyObj.isNtlmAuthentication()) {
                this.jTFUserName.setText(this.httpProxyObj.getNtlmDomainName() + "\\" + this.httpProxyObj.getNtlmUserName());
                this.jPFPassword.setText(this.httpProxyObj.getNtlmPassword());
            } else {
                this.jTFUserName.setText(this.httpProxyObj.getUserName());
                this.jPFPassword.setText(this.httpProxyObj.getPassword());
            }
            this.httpCustomStateChanged();
        } else {
            ConsoleLogger.log("LuConfigProxyDlg.updatePanel(). httpProxyObj is null ");
        }
        if (this.ftpProxyObj != null) {
            this.jRBFtpNo.setSelected(this.ftpProxyObj.isNoProxy());
            this.jRBFtpSystem.setSelected(this.ftpProxyObj.isSystemProxy());
            this.jRBFtpCustom.setSelected(this.ftpProxyObj.isCustomProxy());
            this.jTFFtpHost.setText(Utility.checkAndRemoveBrackets((String)this.ftpProxyObj.getHost()));
            this.jTFFtpPort.setText(this.ftpProxyObj.getPort());
            this.ftpCustomStateChanged();
        } else {
            ConsoleLogger.log("LuConfigProxyDlg.updatePanel(). ftpProxyObj is null ");
        }
    }

    private Integer getHttpProxyMode() {
        if (this.jRBHttpNo.isSelected()) {
            return LuHttpProxy.NONE;
        }
        if (this.jRBHttpSystem.isSelected()) {
            return LuHttpProxy.SYSTEM;
        }
        return LuHttpProxy.CUSTOM;
    }

    private Integer getFtpProxyMode() {
        if (this.jRBFtpNo.isSelected()) {
            return LuFtpProxy.NONE;
        }
        if (this.jRBFtpSystem.isSelected()) {
            return LuFtpProxy.SYSTEM;
        }
        return LuFtpProxy.CUSTOM;
    }

    private Integer getAuthenticationType() {
        if (this.jCBHttpNtlmAuth.isSelected()) {
            return LuHttpProxy.NTLM;
        }
        return LuHttpProxy.BASIC;
    }

    private static class ContentSensitiveHelpPanel
    extends JPanel
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 1L;
        private String helpToken;

        public ContentSensitiveHelpPanel(LayoutManager layout, String token) {
            super(layout);
            this.helpToken = token;
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return this.helpToken;
        }
    }

    private class RemeberSelection
    implements ActionListener {
        private RemeberSelection() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LuConfigProxyDlg.this.httpRadioButtonSelected = LuConfigProxyDlg.this.httpRadioButtonGroup.getSelection();
            LuConfigProxyDlg.this.ftpRadioButtonSelected = LuConfigProxyDlg.this.ftpRadioButtonGroup.getSelection();
        }
    }
}

