/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.creamtec.sepm.ajaxswing.support.components.JEditorPane;
import com.sygate.scm.common.configobject.schema.LuAppliedContent;
import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.policy.lu.EngineVersionDialog;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.policy.lu.NamedVersionDialog;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuAppliedContentObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuDownloadContentObject;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class LuCategoryPanel
extends JPanel {
    private static final long serialVersionUID = 1506164724360319277L;
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.lu.lu");
    private final JCheckBox jChkCategory = new JCheckBox();
    private final JRadioButton jRBLatest = new JRadioButton(MSGRES.getString("LuCategoryPanel.radiobutton.latest"));
    private final JRadioButton jRBNamed = new JRadioButton(MSGRES.getString("LuCategoryPanel.radiobutton.named"));
    private final JRadioButton jrbEngine = new JRadioButton(MSGRES.getString("LuCategoryPanel.radiobutton.engine"));
    private final AlwaysEnabledButton jBEdit = new AlwaysEnabledButton(UIText.get(1024));
    private final AlwaysEnabledButton jbEngineEdit = new AlwaysEnabledButton(UIText.get(1024));
    private DescriptionTextArea desc = new DescriptionTextArea();
    private JLabel jLNameLabel = new JLabel();
    private JPanel jPNameVersion;
    private JPanel jPNamedVersionError;
    private JPanel jPEngineVersionError;
    private final LuContentCategory luCategory;
    private LuAppliedContentObject contentObj;
    private final boolean nameOnly;
    private boolean isRevAvailable;
    private boolean isEngineVersionAvailable;

    public LuCategoryPanel(LuContentCategory luCategory) {
        this(luCategory, false);
    }

    public LuCategoryPanel(LuContentCategory luCategory, boolean nameOnly) {
        this.luCategory = luCategory;
        this.nameOnly = nameOnly;
        this.initialize(luCategory);
    }

    public void setObject(LiveUpdateContentObject luObj) {
        this.contentObj = luObj.getAppliedContent(this.luCategory.getName());
        if (this.contentObj != null) {
            this.jChkCategory.setSelected(this.contentObj.isEnabled());
            this.jRBLatest.setSelected(this.contentObj.isUseLastestVersion());
            this.jRBNamed.setSelected(this.contentObj.isUseNamedVersion());
            this.jrbEngine.setSelected(this.contentObj.isUseEngineVersion());
        } else {
            this.jChkCategory.setSelected(false);
            this.jRBLatest.setSelected(false);
            this.jRBNamed.setSelected(false);
            this.jrbEngine.setSelected(false);
        }
        Vector<LuDownloadContentObject> contents = LuUtility.getAllAvailableContent(null, this.luCategory);
        System.out.println("downloadable contents:::" + this.luCategory.getName() + "::" + contents.size());
        if (contents != null && contents.size() > 0) {
            this.isRevAvailable = true;
            this.isEngineVersionAvailable = this.isEngineVersionAvailable(contents);
        }
        this.updateEnableStatus(this.jChkCategory.isSelected(), false);
        this.checkNamedVersion();
    }

    public void setReadOnly() {
        this.updateEnableStatus(false, true);
    }

    public void setReadOnly(boolean enable) {
        this.setReadOnly();
        this.jLNameLabel.setEnabled(enable);
        this.desc.setEnabled(enable);
    }

    public boolean getSelected() {
        return this.jChkCategory.isSelected();
    }

    public void setSelected(boolean b) {
        this.jChkCategory.setSelected(b);
    }

    public String getType() {
        return this.luCategory.getName();
    }

    public String getDisplayName() {
        return LuUtility.getLocalizedString(this.luCategory.getLocalizedStrings()).getOptDisplayName();
    }

    public LuAppliedContentObject save() {
        if (this.contentObj == null) {
            LuAppliedContent content = new LuAppliedContent();
            content.setContentCategory(this.luCategory.getName());
            this.contentObj = new LuAppliedContentObject(content);
            this.contentObj.setVersionSelectionType(LuAppliedContent.LATEST);
        }
        this.contentObj.setEnabled(this.jChkCategory.isSelected());
        this.contentObj.verify();
        return this.contentObj;
    }

    private void initialize(LuContentCategory luCategory) {
        this.jPNameVersion = this.getUsePanel();
        this.jPNamedVersionError = this.getErrorPanel("namedVersionError", "error");
        this.jPEngineVersionError = this.getErrorPanel("engineVersionError", "engineError");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getNamePanel(luCategory), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (!this.nameOnly) {
            this.add((Component)this.jPNameVersion, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private JPanel getNamePanel(LuContentCategory luCategory) {
        this.desc = new DescriptionTextArea(LuUtility.getLocalizedString(luCategory.getLocalizedStrings()).getOptDescription());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jChkCategory, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getCategoryLabel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.desc, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 43, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getUsePanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBLatest);
        group.add(this.jRBNamed);
        group.add(this.jrbEngine);
        this.jChkCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LuCategoryPanel.this.updateEnableStatus(LuCategoryPanel.this.jChkCategory.isSelected(), false);
            }
        });
        this.jRBLatest.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (LuCategoryPanel.this.jRBLatest.isSelected()) {
                    LuCategoryPanel.this.versionInfoChanged(LuAppliedContent.LATEST);
                }
            }
        });
        this.jRBNamed.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (LuCategoryPanel.this.jRBNamed.isSelected()) {
                    LuCategoryPanel.this.versionInfoChanged(LuAppliedContent.NAMEDVERSION);
                }
            }
        });
        this.jrbEngine.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (LuCategoryPanel.this.jrbEngine.isSelected()) {
                    LuCategoryPanel.this.versionInfoChanged(LuAppliedContent.ENGINEVERSION);
                }
            }
        });
        this.jBEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamedVersionDialog dlg = new NamedVersionDialog(LuCategoryPanel.this.luCategory);
                dlg.setObject(LuCategoryPanel.this.contentObj);
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    LuCategoryPanel.this.contentObj = dlg.getLuAppliedContentObject();
                    LuCategoryPanel.this.checkNamedVersion();
                }
                dlg.dispose();
            }
        });
        this.jbEngineEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineVersionDialog dlg = new EngineVersionDialog(LuCategoryPanel.this.luCategory);
                dlg.setObject(LuCategoryPanel.this.contentObj);
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    LuCategoryPanel.this.contentObj = dlg.getLuAppliedContentObject();
                    LuCategoryPanel.this.checkNamedVersion();
                }
                dlg.dispose();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jRBLatest, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 37, 0, 0), 0, 0));
        panel.add((Component)this.jRBNamed, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 0, 0), 0, 0));
        panel.add((Component)this.jBEdit, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.jrbEngine, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 0, 0), 0, 0));
        panel.add((Component)this.jbEngineEdit, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getErrorPanel(String titleI18nKey, final String msgI18nKey) {
        JLabel label = new JLabel(MSGRES.getString("LuCategoryPanel.label." + titleI18nKey));
        label.setForeground(Color.red);
        JEditorPane pane = new JEditorPane();
        pane.setOpaque(false);
        pane.setEditable(false);
        pane.setContentType("text/html");
        pane.setText("<html><a href='http://localhost/a.html'>" + HTMLUtilities.img((URL)ConsoleMain.class.getResource("ask.gif")) + "</a></html>");
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    UIUtilities.showErrorDialog(MSGRES.getString("LuCategoryPanel." + msgI18nKey));
                }
            }
        });
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.add(label);
        panel.add((Component)pane);
        return panel;
    }

    private JLabel getCategoryLabel() {
        this.jLNameLabel = new JLabel(LuUtility.getLocalizedString(this.luCategory.getLocalizedStrings()).getOptDisplayName(), 11);
        return this.jLNameLabel;
    }

    private void versionStateChanged() {
        this.jBEdit.setEnabled(this.jRBNamed.isSelected());
        this.jbEngineEdit.setEnabled(this.jrbEngine.isSelected());
    }

    private void updateEnableStatus(boolean enable, boolean isCategoryUpdate) {
        if (isCategoryUpdate) {
            this.jChkCategory.setEnabled(enable);
        }
        if (this.isRevAvailable) {
            this.jRBLatest.setEnabled(this.jChkCategory.isEnabled() && enable);
            this.jRBNamed.setEnabled(this.jChkCategory.isEnabled() && enable && this.isNamedVersionApplicable(this.contentObj));
            this.jrbEngine.setEnabled(this.jChkCategory.isEnabled() && enable && this.isEngineVersionAvailable);
            this.jBEdit.setEnabled(this.jChkCategory.isSelected() && this.jRBNamed.isSelected());
            this.jbEngineEdit.setEnabled(this.jChkCategory.isSelected() && this.jrbEngine.isSelected());
        } else {
            this.jRBLatest.setEnabled(enable);
            this.jRBNamed.setEnabled(false);
            this.jrbEngine.setEnabled(false);
            this.jBEdit.setEnabled(false);
            this.jbEngineEdit.setEnabled(false);
        }
        UIUtilities.setContainerStatus(this.jPNamedVersionError, this.jChkCategory.isEnabled() && enable);
        UIUtilities.setContainerStatus(this.jPEngineVersionError, this.jChkCategory.isEnabled() && enable);
    }

    private void checkNamedVersion() {
        boolean hasParent;
        boolean bl = hasParent = this.jPNamedVersionError.getParent() != null;
        if (this.jRBNamed.isSelected()) {
            if (LuUtility.isNamedVersionAvailable(this.contentObj, this.luCategory)) {
                if (hasParent) {
                    this.jPNameVersion.remove(this.jPNamedVersionError);
                    this.revalidate();
                }
            } else if (!hasParent) {
                this.jPNameVersion.add((Component)this.jPNamedVersionError, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 45, 0, 0), 0, 0));
                this.revalidate();
            }
        }
        boolean bl2 = hasParent = this.jPEngineVersionError.getParent() != null;
        if (this.jrbEngine.isSelected()) {
            if (LuUtility.isEngineVersionAvailable(this.contentObj, this.luCategory)) {
                if (hasParent) {
                    this.jPNameVersion.remove(this.jPEngineVersionError);
                    this.revalidate();
                }
            } else if (!hasParent) {
                this.jPNameVersion.add((Component)this.jPEngineVersionError, new GridBagConstraints(3, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 45, 0, 0), 0, 0));
                this.revalidate();
            }
        }
    }

    protected boolean isValidate() {
        return !this.jChkCategory.isSelected() || this.jRBLatest.isSelected() || this.contentObj.getSchemaObject().getContentVersionInfoCount() != 0;
    }

    public boolean isActive() {
        return this.jChkCategory.isSelected();
    }

    private void versionInfoChanged(Integer versionSelectionType) {
        if (this.contentObj == null) {
            LuAppliedContent content = new LuAppliedContent();
            content.setContentCategory(this.luCategory.getName());
            this.contentObj = new LuAppliedContentObject(content);
        }
        this.contentObj.setVersionSelectionType(versionSelectionType);
        this.versionStateChanged();
    }

    private boolean isEngineVersionAvailable(Vector<LuDownloadContentObject> contents) {
        for (LuDownloadContentObject content : contents) {
            if (StringUtilities.isEmpty((String)content.getEngineNum())) continue;
            return true;
        }
        return false;
    }

    private boolean isNamedVersionApplicable(LuAppliedContentObject contentObj) {
        return !"EDR".equals(contentObj.getCategoryType()) && !"NTR".equals(contentObj.getCategoryType());
    }
}

