/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.GroupUpdateDlg;
import com.sygate.scm.console.ui.policy.lu.LuConfigProxyDlg;
import com.sygate.scm.console.ui.policy.lu.LuServerPanel;
import com.sygate.scm.console.ui.policy.lu.UseLiveUpdateServerListener;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuContentSourceInfoObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class LiveUpdateServerPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -530134930668792620L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private JCheckBox jChkManagementServer = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LiveUpdateServerPanel.checkbox.default"));
    private JCheckBox jChkLiveUpdateServer = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LiveUpdateServerPanel.checkbox.alternate"));
    private JCheckBox jChkGroupUpdateProvider = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LiveUpdateServerPanel.checkbox.local"));
    private JCheckBox jChk3rdParty = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LiveUpdateServerPanel.checkbox.3rdParty"));
    private LuServerPanel serverPanel = null;
    private JButton jBtnGroupUpdate = new JButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LiveUpdateServerPanel.button.groupUpdateProvider"));
    private JButton jBtnConfigProxy = new JButton(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LiveUpdateServerPanel.button.configProxy"));
    private LuContentSourceInfoObject sourceInfoObj;
    private DescriptionTextArea additionTxtLbl = new DescriptionTextArea(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "LiveUpdateServerPanel.textarea.assignedProvider"));
    private ActionListener advancePanelListener;
    private ArrayList<UseLiveUpdateServerListener> useLiveUpdateServerListenerList = new ArrayList();
    private boolean isReadonly;
    private int platformType = 1;

    public LiveUpdateServerPanel(ActionListener advancePanelListener, int platformType) {
        this.platformType = platformType;
        this.advancePanelListener = advancePanelListener;
        this.initialize();
    }

    public LuServerPanel getServerPanel() {
        if (this.serverPanel == null) {
            this.serverPanel = new LuServerPanel(this, this.platformType);
        }
        return this.serverPanel;
    }

    public void setObject(LuContentSourceInfoObject sourceInfoObj) {
        this.sourceInfoObj = sourceInfoObj;
        this.updatePanel();
    }

    public void save() {
        this.sourceInfoObj.setUseManagementServer(this.jChkManagementServer.isSelected());
        this.sourceInfoObj.setUseLiveUpdateServer(this.jChkLiveUpdateServer.isSelected());
        this.sourceInfoObj.setUseMasterClient(this.jChkGroupUpdateProvider.isSelected());
        this.sourceInfoObj.setEnabled3rdPartyManagement(this.jChk3rdParty.isSelected());
        this.getServerPanel().adjustServerType(this.jChkLiveUpdateServer.isSelected());
        this.getServerPanel().save();
    }

    public boolean isValidate() {
        if (3 != this.platformType && this.jChkGroupUpdateProvider.isSelected() && !this.jChkManagementServer.isSelected()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LiveUpdateServerPanel.error.noDefaultManagementServer"), MSGRES.getString(LU, "LiveUpdateServerPanel.error"), 0);
            return false;
        }
        if (!(this.jChkManagementServer.isSelected() || this.jChkLiveUpdateServer.isSelected() || this.jChkGroupUpdateProvider.isSelected() || this.jChk3rdParty.isSelected())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LiveUpdateServerPanel.error.noContentSource"), MSGRES.getString(LU, "LiveUpdateServerPanel.error"), 0);
            return false;
        }
        return !this.jChkLiveUpdateServer.isSelected() || this.getServerPanel().isValidate();
    }

    public void setReadOnly() {
        this.isReadonly = true;
        this.jChkManagementServer.setEnabled(false);
        this.jChkLiveUpdateServer.setEnabled(false);
        this.jChkGroupUpdateProvider.setEnabled(false);
        this.jChk3rdParty.setEnabled(false);
        this.getServerPanel().setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (3 == this.platformType) {
            return "linux_sesm_policies_dialog_lu_server_settings_live_update";
        }
        return "sesm_policies_dialog_lu_server_settings_live_update";
    }

    public void updateUseManagementServer(boolean isEasEnable) {
        if (isEasEnable) {
            this.jChkManagementServer.setSelected(false);
            this.jChkManagementServer.setEnabled(false);
        } else {
            this.jChkManagementServer.setEnabled(true);
        }
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        if (1 == this.platformType) {
            this.add(this.getSourceServerPanel());
            this.add(this.getNetworkServerPanel());
            this.add(this.get3rdPartyManagementPanel());
        } else if (3 == this.platformType) {
            this.add(this.getSourceLinuxServerPanel());
        }
        this.add(this.getConfigProxyPanel());
    }

    private JPanel getSourceServerPanel() {
        this.jChkLiveUpdateServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveUpdateServerPanel.this.serverStateChanged();
            }
        });
        this.jChkLiveUpdateServer.addActionListener(this.advancePanelListener);
        this.getServerPanel().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(10, 20, 5, 0)));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jChkManagementServer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 20), 0, 0));
        panel.add((Component)this.jChkLiveUpdateServer, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.getServerPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "LiveUpdateServerPanel.label.sourceServer"), MSGRES.getString(LU, "LiveUpdateServerPanel.label.sourceServerDesc"), false), "North");
        wrapPanel.add((Component)panel, "Center");
        return wrapPanel;
    }

    private JPanel getSourceLinuxServerPanel() {
        this.jChkLiveUpdateServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveUpdateServerPanel.this.serverStateChanged();
            }
        });
        this.jChkLiveUpdateServer.addActionListener(this.advancePanelListener);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getServerPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "LiveUpdateServerPanel.label.sourceServer"), MSGRES.getString(LU, "LinuxLiveUpdateServerPanel.label.sourceServerDesc"), false), "North");
        wrapPanel.add((Component)panel, "Center");
        return wrapPanel;
    }

    private JPanel getNetworkServerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.jChkGroupUpdateProvider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveUpdateServerPanel.this.jBtnGroupUpdate.setEnabled(LiveUpdateServerPanel.this.jChkGroupUpdateProvider.isSelected());
            }
        });
        this.jBtnGroupUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupUpdateDlg groupUpdateDlg = new GroupUpdateDlg(LiveUpdateServerPanel.this.sourceInfoObj, LiveUpdateServerPanel.this.isReadonly);
                if (groupUpdateDlg.isOk()) {
                    LiveUpdateServerPanel.this.sourceInfoObj = groupUpdateDlg.getObject();
                }
                LiveUpdateServerPanel.this.updateProviderInfo();
                groupUpdateDlg.dispose();
            }
        });
        this.additionTxtLbl.setWrapStyleWord(true);
        this.additionTxtLbl.setLineWrap(true);
        panel.add((Component)this.jChkGroupUpdateProvider, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.jBtnGroupUpdate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 80, 0, 0), 0, 0));
        panel.add((Component)this.additionTxtLbl, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 50, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 5, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "LiveUpdateServerPanel.label.networkServer"), MSGRES.getString(LU, "LiveUpdateServerPanel.label.networkServerDesc"), false), "North");
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private JPanel get3rdPartyManagementPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setPreferredSize(new Dimension(250, 23));
        panel.add((Component)this.jChk3rdParty, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 5, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "LiveUpdateServerPanel.label.3rdPartyTitle"), MSGRES.getString(LU, "LiveUpdateServerPanel.label.3rdPartyDesc"), false), "North");
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private JPanel getConfigProxyPanel() {
        String title = MSGRES.getString(LU, "LiveUpdateServerPanel.label.configProxyTitle");
        String desc = MSGRES.getString(LU, "LiveUpdateServerPanel.label.configProxyDesc");
        if (3 == this.platformType) {
            desc = MSGRES.getString(LU, "LiveUpdateServerPanel.label.configProxyDescHttpOnly");
        }
        this.jBtnConfigProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LuConfigProxyDlg dlg = new LuConfigProxyDlg(LiveUpdateServerPanel.this.sourceInfoObj, LiveUpdateServerPanel.this.isReadonly, LiveUpdateServerPanel.this.platformType);
                dlg.dispose();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jBtnConfigProxy, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 5, 0));
        wrapPanel.add((Component)new AvTemplatePane(title, desc, false), "North");
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private void serverStateChanged() {
        boolean enableLiveUpdateServer = this.jChkLiveUpdateServer.isEnabled();
        boolean useLiveUpdateServer = this.jChkLiveUpdateServer.isSelected();
        boolean enableAndUseLiveUpdateServer = enableLiveUpdateServer && useLiveUpdateServer;
        this.getServerPanel().setEnabled(enableAndUseLiveUpdateServer);
        this.fireUseLiveUpdateServerChange(enableLiveUpdateServer, useLiveUpdateServer);
        this.jBtnConfigProxy.setEnabled(enableAndUseLiveUpdateServer);
        if (!enableAndUseLiveUpdateServer) {
            this.jChkManagementServer.setEnabled(true);
        } else {
            this.updateUseManagementServer(this.getServerPanel().isEarlyAdopterSelected());
        }
    }

    public void addUseLiveUpdateServerListener(UseLiveUpdateServerListener listener) {
        this.useLiveUpdateServerListenerList.add(listener);
    }

    private void fireUseLiveUpdateServerChange(boolean enableLiveUpdateServer, boolean useLiveUpdateServer) {
        for (UseLiveUpdateServerListener listener : this.useLiveUpdateServerListenerList) {
            listener.enableAndUseLiveUpdateServerChanged(enableLiveUpdateServer, useLiveUpdateServer);
        }
    }

    private void updatePanel() {
        this.jChkManagementServer.setSelected(this.sourceInfoObj.isUseManagementServer());
        this.jChkLiveUpdateServer.setSelected(this.sourceInfoObj.isUseLiveUpdateServer());
        if (3 == this.platformType) {
            this.jChkLiveUpdateServer.setSelected(true);
        }
        this.advancePanelListener.actionPerformed(new ActionEvent(this.jChkLiveUpdateServer, 0, ""));
        this.jChkGroupUpdateProvider.setSelected(this.sourceInfoObj.isUseMasterClient());
        this.jChk3rdParty.setSelected(this.sourceInfoObj.getEnabled3rdPartyManagement());
        this.getServerPanel().setObject(this.sourceInfoObj);
        this.serverStateChanged();
        this.updateProviderInfo();
        this.jBtnGroupUpdate.setEnabled(this.jChkGroupUpdateProvider.isSelected());
    }

    private void updateProviderInfo() {
        String msg = "";
        msg = this.sourceInfoObj.getMasterClientHost() != null && this.sourceInfoObj.getMasterClientHost().length() > 0 || this.sourceInfoObj.getSchemaObject().getOptGupRuleSets() != null ? MSGRES.getString(LU, "LiveUpdateServerPanel.textarea.assignedProvider") : MSGRES.getString(LU, "LiveUpdateServerPanel.textarea.unassignedProvider");
        this.additionTxtLbl.setText(msg);
    }
}

