/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuContentSourceInfoObject;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LUAdvanceServerSettingsDlg
extends DialogBase {
    private static final long serialVersionUID = -523254704574283873L;
    private JPanel jAdvanceSettingContentPane = null;
    JRadioButton jRBFtpActive = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LUAdvanceServerSettingsDlg.radiobutton.active"));
    JRadioButton jRBFtpPassive = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LUAdvanceServerSettingsDlg.radiobutton.passive"));
    JRadioButton jRBHttpsTrusted = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LUAdvanceServerSettingsDlg.radiobutton.httpsTrused"));
    JRadioButton jRBHttpsNonTrusted = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LUAdvanceServerSettingsDlg.radiobutton.httpsNonTrused"));
    private LuContentSourceInfoObject sourceInfoObj;
    private int platformType = 1;

    public LUAdvanceServerSettingsDlg(LuContentSourceInfoObject sourceInfoObj, int platformType) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LUAdvanceServerSettingsDlg.label.title"), true);
        this.platformType = platformType;
        this.setLuContentSourceInfoObject(sourceInfoObj);
        this.initialize(sourceInfoObj);
        UiUtilities.centerComponent((Component)this);
    }

    private void setLuContentSourceInfoObject(LuContentSourceInfoObject sourceInfoObj) {
        if (sourceInfoObj == null) {
            sourceInfoObj = new LuContentSourceInfoObject();
        }
        this.sourceInfoObj = sourceInfoObj;
    }

    private void initialize(LuContentSourceInfoObject sourceInfoObj) {
        BorderLayout borderLayout = new BorderLayout();
        Container cont = this.getContentPane();
        cont.setLayout(borderLayout);
        cont.add((Component)this.getAdvanceSettingContentPane(), "North");
        cont.add((Component)this.getButtonPanel(), "Center");
        this.pack();
        UiUtilities.centerComponent((Component)this);
        ButtonGroup ftpSettings = new ButtonGroup();
        ftpSettings.add(this.jRBFtpActive);
        ftpSettings.add(this.jRBFtpPassive);
        int ftpMode = sourceInfoObj.getFTPMode();
        if (ftpMode == LuContentSourceInfo.ACTIVE) {
            this.jRBFtpActive.setSelected(true);
        } else {
            this.jRBFtpPassive.setSelected(true);
        }
        ButtonGroup httpsSettings = new ButtonGroup();
        httpsSettings.add(this.jRBHttpsTrusted);
        httpsSettings.add(this.jRBHttpsNonTrusted);
        this.jRBHttpsTrusted.setSelected(sourceInfoObj.getHttpsTrusted());
        this.jRBHttpsNonTrusted.setSelected(!sourceInfoObj.getHttpsTrusted());
        this.setVisible(true);
    }

    private JPanel getAdvanceSettingContentPane() {
        if (this.jAdvanceSettingContentPane == null) {
            this.jAdvanceSettingContentPane = new JPanel();
            this.jAdvanceSettingContentPane.setLayout(new BorderLayout());
            this.jAdvanceSettingContentPane.add((Component)this.getFtpPanel(), "Center");
        }
        return this.jAdvanceSettingContentPane;
    }

    private JPanel getFtpPanel() {
        JPanel ftpPanel = new JPanel(new GridBagLayout());
        ftpPanel.add((Component)new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LUAdvanceServerSettingsDlg.label.FTP.title"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LUAdvanceServerSettingsDlg.label.FTP.desc"), false), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
        ftpPanel.add((Component)this.jRBFtpActive, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 30, 0, 0), 0, 0));
        ftpPanel.add((Component)this.jRBFtpPassive, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 30, 0, 0), 0, 0));
        return ftpPanel;
    }

    private JPanel getHttpsPanel() {
        JPanel httpsPanel = new JPanel(new GridBagLayout());
        httpsPanel.add((Component)new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LUAdvanceServerSettingsDlg.label.HTTPS.title"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.lu.lu", "LUAdvanceServerSettingsDlg.label.HTTPS.desc"), false), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
        httpsPanel.add((Component)this.jRBHttpsTrusted, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 30, 0, 0), 0, 0));
        httpsPanel.add((Component)this.jRBHttpsNonTrusted, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 30, 0, 0), 0, 0));
        return httpsPanel;
    }

    public LuContentSourceInfoObject getLuContentSourceInfoObject() {
        return this.sourceInfoObj;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (3 == this.platformType) {
            return "linux_sesm_policies_dialog_lu_server_settings_live_update_advance_server_settings";
        }
        return "sesm_policies_dialog_lu_server_settings_live_update_advance_server_settings";
    }

    @Override
    protected void commit() {
        if (this.jRBFtpActive.isSelected()) {
            this.sourceInfoObj.setFTPMode(LuContentSourceInfo.ACTIVE);
        } else {
            this.sourceInfoObj.setFTPMode(LuContentSourceInfo.PASSIVE);
        }
        this.sourceInfoObj.setHttpsTrusted(this.jRBHttpsTrusted.isSelected());
        this.sourceInfoObj.setLegacySupport(false);
    }
}

