/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.MainFrame;
import com.sygate.scm.console.ui.policy.lu.ConfigureGupMappingDlg;
import com.sygate.scm.console.ui.policy.lu.logiobject.ExplicitGupMappingUIObject;
import com.sygate.scm.console.ui.util.CustomTableModel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GupMappingDlg
extends DialogBase {
    private static final long serialVersionUID = -801401585417611445L;
    private CustomTableModel gupMappingModel;
    private JTable gupMappingTable;
    private JButton addMappingButton;
    private JButton editMappingButton;
    private JButton deleteMappingButton;
    private JButton moveUpMappingButton;
    private JButton moveDownMappingButton;
    private AbstractAction addMappingAction;
    private AbstractAction editMappingAction;
    private AbstractAction deleteMappingAction;
    private AbstractAction moveUpMappingAction;
    private AbstractAction moveDownMappingAction;
    private JMenuItem addMappingMenuItem;
    private JMenuItem editMappingMenuItem;
    private JMenuItem deleteMappingMenuItem;
    private JMenuItem moveUpMappingMenuItem;
    private JMenuItem moveDownMappingMenuItem;
    private JScrollPane scrollPane;
    private JPopupMenu popup = new JPopupMenu();
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String RES_FILE = "com.sygate.scm.console.ui.policy.dialog.policydialog";
    private static final String[] TABLE_TITLE = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.tablecolumn.clientsubnet"), MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.tablecolumn.clientsubnetMask"), MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.tablecolumn.mappingtype"), MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.tablecolumn.mappingvalue"), MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.tablecolumn.mappingport")};
    private static final float[] COL_SIZE = new float[]{1.5f, 1.0f, 0.8f, 0.6f, 0.4f};
    private HashMap<String, String> validationMap = new HashMap();
    private ExplicitGupMappingUIObject[] mappingObjs = null;

    public GupMappingDlg(MainFrame frame, ExplicitGupMappingUIObject[] uiObjs, boolean isReadonly) {
        super(frame, MSGRES.getString(RES_FILE, "GUPMappingDlg.title"), true);
        this.initialize();
        this.updateValues(uiObjs);
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    protected void commit() {
        int rowCount = this.gupMappingModel.getRowCount();
        this.mappingObjs = new ExplicitGupMappingUIObject[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            this.mappingObjs[i] = (ExplicitGupMappingUIObject)this.gupMappingModel.getRow(i);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_explicit_gup_add_list";
    }

    private void initialize() {
        this.addMappingAction = new AbstractAction(UIText.get(5)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GupMappingDlg.this.addMapping();
            }
        };
        this.addMappingButton = new JButton(this.addMappingAction);
        this.addMappingButton.setText(UIText.get(5));
        this.addMappingMenuItem = new JMenuItem(this.addMappingAction);
        this.editMappingAction = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GupMappingDlg.this.editMapping();
            }
        };
        this.editMappingButton = new JButton(this.editMappingAction);
        this.editMappingButton.setText(UIText.get(1024));
        this.editMappingMenuItem = new JMenuItem(this.editMappingAction);
        this.deleteMappingAction = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = UIUtilities.deleteOptionDialog(MSGRES.getString(GupMappingDlg.RES_FILE, "GUPMappingDlg.delete.warning"), MSGRES.getString(GupMappingDlg.RES_FILE, "GUPMappingDlg.warning.title"));
                if (result == 0) {
                    GupMappingDlg.this.deleteMapping();
                }
            }
        };
        this.deleteMappingButton = new JButton(this.deleteMappingAction);
        this.deleteMappingButton.setText(UIText.get(769));
        this.deleteMappingMenuItem = new JMenuItem(this.deleteMappingAction);
        this.moveUpMappingAction = new AbstractAction(UIText.get(3075)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GupMappingDlg.this.moveUpMapping();
            }
        };
        this.moveUpMappingButton = new JButton(this.moveUpMappingAction);
        this.moveUpMappingButton.setText(UIText.get(3075));
        this.moveUpMappingMenuItem = new JMenuItem(this.moveUpMappingAction);
        this.moveDownMappingAction = new AbstractAction(UIText.get(3074)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GupMappingDlg.this.moveDownMapping();
            }
        };
        this.moveDownMappingButton = new JButton(this.moveDownMappingAction);
        this.moveDownMappingButton.setText(UIText.get(3074));
        this.moveDownMappingMenuItem = new JMenuItem(this.moveDownMappingAction);
        this.createMappingable();
        this.gupMappingTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (GupMappingDlg.this.gupMappingTable.isEnabled()) {
                    GupMappingDlg.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (GupMappingDlg.this.gupMappingTable.isEnabled()) {
                    GupMappingDlg.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && GupMappingDlg.this.gupMappingTable.isEnabled()) {
                    GupMappingDlg.this.editMapping();
                }
            }
        });
        this.scrollPane = new JScrollPane(this.gupMappingTable);
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (GupMappingDlg.this.gupMappingTable.isEnabled()) {
                    GupMappingDlg.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (GupMappingDlg.this.gupMappingTable.isEnabled()) {
                    GupMappingDlg.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && GupMappingDlg.this.gupMappingTable.isEnabled()) {
                    GupMappingDlg.this.editMapping();
                }
            }
        });
        this.popup.add(this.addMappingMenuItem);
        this.popup.add(this.editMappingMenuItem);
        this.popup.add(this.deleteMappingMenuItem);
        this.popup.addSeparator();
        this.popup.add(this.moveUpMappingMenuItem);
        this.popup.add(this.moveDownMappingMenuItem);
        this.addMappingMenuItem.setEnabled(true);
        this.editMappingMenuItem.setEnabled(false);
        this.deleteMappingMenuItem.setEnabled(false);
        this.moveUpMappingMenuItem.setEnabled(false);
        this.moveDownMappingMenuItem.setEnabled(false);
        JPanel mappingButtonsPanel = new JPanel();
        UIUtilities.layoutButtonPanel(mappingButtonsPanel, new JButton[]{this.addMappingButton, this.editMappingButton, this.deleteMappingButton, this.moveUpMappingButton, this.moveDownMappingButton}, 1, 1, true);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setLayout(new GridBagLayout());
        CompoundBorder titledBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MSGRES.getString(RES_FILE, "GUPMappingDlg.titleborder.configureexplicitgup")), BorderFactory.createEmptyBorder(5, 10, 10, 0));
        mainPanel.setBorder(titledBorder);
        mainPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 18, 0, 0), 0, 0));
        mainPanel.add((Component)mappingButtonsPanel, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)super.getButtonPanel(), "South");
    }

    private JTable createMappingable() {
        this.gupMappingModel = new CustomTableModel(TABLE_TITLE, null);
        this.gupMappingTable = new StripesTable(false, false);
        this.gupMappingTable.setModel(this.gupMappingModel);
        Dimension size = this.gupMappingTable.getPreferredScrollableViewportSize();
        this.gupMappingTable.setPreferredScrollableViewportSize(new Dimension((int)((double)size.width * 2.0), (this.gupMappingTable.getRowHeight() + this.gupMappingTable.getRowMargin()) * 5));
        this.gupMappingTable.setShowGrid(true);
        UIUtilities.setTableColumnWidth(this.gupMappingTable, COL_SIZE, (int)this.gupMappingTable.getPreferredScrollableViewportSize().getWidth());
        this.gupMappingTable.getSelectionModel().setSelectionMode(0);
        this.gupMappingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GupMappingDlg.this.tableSelectionChanged();
            }
        });
        this.gupMappingTable.setRowSelectionAllowed(true);
        return this.gupMappingTable;
    }

    private void updateValues(ExplicitGupMappingUIObject[] uiObjs) {
        this.validationMap.clear();
        if (uiObjs != null && uiObjs.length > 0) {
            for (int i = 0; i < uiObjs.length; ++i) {
                this.gupMappingModel.addRow(uiObjs[i]);
                this.validationMap.put(uiObjs[i].getKeyFormat(), "");
            }
            this.gupMappingTable.setRowSelectionInterval(0, 0);
        }
        this.tableSelectionChanged();
    }

    private void tableSelectionChanged() {
        boolean isSelected = this.gupMappingTable.isEnabled() && this.gupMappingTable.getSelectedRowCount() > 0;
        this.editMappingButton.setEnabled(isSelected);
        this.editMappingMenuItem.setEnabled(isSelected);
        this.deleteMappingButton.setEnabled(isSelected);
        this.deleteMappingMenuItem.setEnabled(isSelected);
        this.moveUpMappingButton.setEnabled(isSelected);
        this.moveUpMappingMenuItem.setEnabled(isSelected);
        this.moveDownMappingButton.setEnabled(isSelected);
        this.moveDownMappingMenuItem.setEnabled(isSelected);
        if (this.gupMappingTable.getSelectedRow() <= 0) {
            this.moveUpMappingButton.setEnabled(false);
            this.moveUpMappingMenuItem.setEnabled(false);
        }
        if (this.gupMappingTable.getSelectedRow() == this.gupMappingTable.getRowCount() - 1) {
            this.moveDownMappingButton.setEnabled(false);
            this.moveDownMappingMenuItem.setEnabled(false);
        }
        if (this.gupMappingTable.getRowCount() <= 1) {
            this.moveUpMappingButton.setEnabled(false);
            this.moveUpMappingMenuItem.setEnabled(false);
            this.moveDownMappingButton.setEnabled(false);
            this.moveDownMappingMenuItem.setEnabled(false);
        }
    }

    private void deleteMapping() {
        int[] select = this.gupMappingTable.getSelectedRows();
        int finalSelectedRow = -1;
        for (int i = 0; i < select.length; ++i) {
            select[i] = select[i] - i;
            ExplicitGupMappingUIObject uiObj = (ExplicitGupMappingUIObject)this.gupMappingModel.getRow(select[i]);
            this.validationMap.remove(uiObj.getKeyFormat());
            this.gupMappingModel.removeRow(select[i]);
            finalSelectedRow = select[i] - 1;
        }
        int rowCount = this.gupMappingModel.getRowCount();
        if (rowCount > 0) {
            if (finalSelectedRow > -1) {
                this.gupMappingTable.setRowSelectionInterval(finalSelectedRow, finalSelectedRow);
            } else {
                this.gupMappingTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void moveUpMapping() {
        int row = this.gupMappingTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        if (row > 0) {
            ((CustomTableModel)this.gupMappingTable.getModel()).moveRow(row, row, row - 1);
            this.gupMappingTable.setRowSelectionInterval(row - 1, row - 1);
        }
    }

    private void moveDownMapping() {
        int row = this.gupMappingTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        int rowCount = ((CustomTableModel)this.gupMappingTable.getModel()).getRowCount();
        if (row < rowCount - 1 && rowCount > 1) {
            ((CustomTableModel)this.gupMappingTable.getModel()).moveRow(row, row, row + 1);
            this.gupMappingTable.setRowSelectionInterval(row + 1, row + 1);
        }
    }

    private void addMapping() {
        ConfigureGupMappingDlg dlg = new ConfigureGupMappingDlg(Manager.getFrame(), MSGRES.getString(RES_FILE, "GUPMappingDlg.title.addmapping"), true, false, null, this.validationMap);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            ExplicitGupMappingUIObject uiObj = dlg.getObject();
            this.gupMappingModel.addRow(uiObj);
            this.validationMap.put(uiObj.getKeyFormat(), "");
            int lastRow = this.gupMappingModel.getRowCount();
            this.gupMappingTable.setRowSelectionInterval(lastRow - 1, lastRow - 1);
        }
    }

    private void editMapping() {
        int row = this.gupMappingTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        ExplicitGupMappingUIObject uiObj = (ExplicitGupMappingUIObject)this.gupMappingModel.getRow(row);
        this.validationMap.remove(uiObj.getKeyFormat());
        ConfigureGupMappingDlg dlg = new ConfigureGupMappingDlg(Manager.getFrame(), MSGRES.getString(RES_FILE, "GUPMappingDlg.title.editmapping"), true, true, uiObj, this.validationMap);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            uiObj = dlg.getObject();
            this.validationMap.put(uiObj.getKeyFormat(), "");
            this.gupMappingModel.setRow(row, uiObj);
        }
    }

    private void showPopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        int row = this.gupMappingTable.rowAtPoint(p);
        if (row >= 0) {
            this.gupMappingTable.setRowSelectionInterval(row, row);
        }
        this.popup.show(this.gupMappingTable, e.getX(), e.getY());
    }

    protected ExplicitGupMappingUIObject[] getMappingObjects() {
        return this.mappingObjs;
    }
}

